/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.ReadOnlyEntryLogger;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.tools.cli.commands.autorecovery.ListUnderReplicatedCommand;
import org.apache.bookkeeper.tools.cli.commands.autorecovery.LostBookieRecoveryDelayCommand;
import org.apache.bookkeeper.tools.cli.commands.autorecovery.QueryAutoRecoveryStatusCommand;
import org.apache.bookkeeper.tools.cli.commands.autorecovery.ToggleCommand;
import org.apache.bookkeeper.tools.cli.commands.autorecovery.TriggerAuditCommand;
import org.apache.bookkeeper.tools.cli.commands.autorecovery.WhoIsAuditorCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.CheckDBLedgersIndexCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ConvertToDBStorageCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ConvertToInterleavedStorageCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.FlipBookieIdCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.FormatCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.InitCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.LastMarkCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.LedgerCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ListActiveLedgersCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ListFilesOnDiscCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ListLedgersCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.LocalConsistencyCheckCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ReadJournalCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ReadLedgerCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ReadLogCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.ReadLogMetadataCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.RebuildDBLedgerLocationsIndexCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.RebuildDBLedgersIndexCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.RegenerateInterleavedStorageIndexFileCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.SanityTestCommand;
import org.apache.bookkeeper.tools.cli.commands.bookie.UpdateBookieInLedgerCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.DecommissionCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.EndpointInfoCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.InfoCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.InstanceIdCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.ListBookiesCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.MetaFormatCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.NukeExistingClusterCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.RecoverCommand;
import org.apache.bookkeeper.tools.cli.commands.client.DeleteLedgerCommand;
import org.apache.bookkeeper.tools.cli.commands.client.LedgerMetaDataCommand;
import org.apache.bookkeeper.tools.cli.commands.client.SimpleTestCommand;
import org.apache.bookkeeper.tools.cli.commands.cookie.AdminCommand;
import org.apache.bookkeeper.tools.cli.commands.cookie.CreateCookieCommand;
import org.apache.bookkeeper.tools.cli.commands.cookie.DeleteCookieCommand;
import org.apache.bookkeeper.tools.cli.commands.cookie.GenerateCookieCommand;
import org.apache.bookkeeper.tools.cli.commands.cookie.GetCookieCommand;
import org.apache.bookkeeper.tools.cli.commands.cookie.UpdateCookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.util.EntryFormatter;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.bookkeeper.util.Tool;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieShell
implements Tool {
    static final Logger LOG = LoggerFactory.getLogger(BookieShell.class);
    static final String CONF_OPT = "conf";
    static final String ENTRY_FORMATTER_OPT = "entryformat";
    static final String LEDGERID_FORMATTER_OPT = "ledgeridformat";
    static final String CMD_METAFORMAT = "metaformat";
    static final String CMD_INITBOOKIE = "initbookie";
    static final String CMD_INITNEWCLUSTER = "initnewcluster";
    static final String CMD_NUKEEXISTINGCLUSTER = "nukeexistingcluster";
    static final String CMD_BOOKIEFORMAT = "bookieformat";
    static final String CMD_RECOVER = "recover";
    static final String CMD_LEDGER = "ledger";
    static final String CMD_READ_LEDGER_ENTRIES = "readledger";
    static final String CMD_LISTLEDGERS = "listledgers";
    static final String CMD_LEDGERMETADATA = "ledgermetadata";
    static final String CMD_LISTUNDERREPLICATED = "listunderreplicated";
    static final String CMD_WHOISAUDITOR = "whoisauditor";
    static final String CMD_WHATISINSTANCEID = "whatisinstanceid";
    static final String CMD_SIMPLETEST = "simpletest";
    static final String CMD_BOOKIESANITYTEST = "bookiesanity";
    static final String CMD_READLOG = "readlog";
    static final String CMD_READLOGMETADATA = "readlogmetadata";
    static final String CMD_READJOURNAL = "readjournal";
    static final String CMD_LASTMARK = "lastmark";
    static final String CMD_AUTORECOVERY = "autorecovery";
    static final String CMD_LISTBOOKIES = "listbookies";
    static final String CMD_LISTFILESONDISC = "listfilesondisc";
    static final String CMD_UPDATECOOKIE = "updatecookie";
    static final String CMD_UPDATELEDGER = "updateledgers";
    static final String CMD_UPDATE_BOOKIE_IN_LEDGER = "updateBookieInLedger";
    static final String CMD_DELETELEDGER = "deleteledger";
    static final String CMD_BOOKIEINFO = "bookieinfo";
    static final String CMD_ACTIVE_LEDGERS_ON_ENTRY_LOG_FILE = "activeledgers";
    static final String CMD_DECOMMISSIONBOOKIE = "decommissionbookie";
    static final String CMD_ENDPOINTINFO = "endpointinfo";
    static final String CMD_LOSTBOOKIERECOVERYDELAY = "lostbookierecoverydelay";
    static final String CMD_TRIGGERAUDIT = "triggeraudit";
    static final String CMD_FORCEAUDITCHECKS = "forceauditchecks";
    static final String CMD_CONVERT_TO_DB_STORAGE = "convert-to-db-storage";
    static final String CMD_CONVERT_TO_INTERLEAVED_STORAGE = "convert-to-interleaved-storage";
    static final String CMD_REBUILD_DB_LEDGER_LOCATIONS_INDEX = "rebuild-db-ledger-locations-index";
    static final String CMD_REBUILD_DB_LEDGERS_INDEX = "rebuild-db-ledgers-index";
    static final String CMD_CHECK_DB_LEDGERS_INDEX = "check-db-ledgers-index";
    static final String CMD_REGENERATE_INTERLEAVED_STORAGE_INDEX_FILE = "regenerate-interleaved-storage-index-file";
    static final String CMD_QUERY_AUTORECOVERY_STATUS = "queryrecoverystatus";
    static final String CMD_CREATE_COOKIE = "cookie_create";
    static final String CMD_DELETE_COOKIE = "cookie_delete";
    static final String CMD_UPDATE_COOKIE = "cookie_update";
    static final String CMD_GET_COOKIE = "cookie_get";
    static final String CMD_GENERATE_COOKIE = "cookie_generate";
    static final String CMD_HELP = "help";
    static final String CMD_LOCALCONSISTENCYCHECK = "localconsistencycheck";
    final ServerConfiguration bkConf = new ServerConfiguration();
    File[] indexDirectories;
    File[] ledgerDirectories;
    File[] journalDirectories;
    EntryLogger entryLogger = null;
    List<Journal> journals = null;
    EntryFormatter entryFormatter;
    LedgerIdFormatter ledgerIdFormatter;
    int pageSize;
    int entriesPerPage;
    static final int LIST_BATCH_SIZE = 1000;
    final Map<String, Command> commands = new HashMap<String, Command>();

    public BookieShell() {
        this.commands.put(CMD_METAFORMAT, new MetaFormatCmd());
        this.commands.put(CMD_INITBOOKIE, new InitBookieCmd());
        this.commands.put(CMD_INITNEWCLUSTER, new InitNewCluster());
        this.commands.put(CMD_NUKEEXISTINGCLUSTER, new NukeExistingCluster());
        this.commands.put(CMD_BOOKIEFORMAT, new BookieFormatCmd());
        this.commands.put(CMD_RECOVER, new RecoverCmd());
        this.commands.put(CMD_LEDGER, new LedgerCmd());
        this.commands.put(CMD_READ_LEDGER_ENTRIES, new ReadLedgerEntriesCmd());
        this.commands.put(CMD_LISTLEDGERS, new ListLedgersCmd());
        this.commands.put(CMD_ACTIVE_LEDGERS_ON_ENTRY_LOG_FILE, new ListActiveLedgersCmd());
        this.commands.put(CMD_LISTUNDERREPLICATED, new ListUnderreplicatedCmd());
        this.commands.put(CMD_WHOISAUDITOR, new WhoIsAuditorCmd());
        this.commands.put(CMD_WHATISINSTANCEID, new WhatIsInstanceId());
        this.commands.put(CMD_LEDGERMETADATA, new LedgerMetadataCmd());
        this.commands.put(CMD_LOCALCONSISTENCYCHECK, new LocalConsistencyCheck());
        this.commands.put(CMD_SIMPLETEST, new SimpleTestCmd());
        this.commands.put(CMD_BOOKIESANITYTEST, new BookieSanityTestCmd());
        this.commands.put(CMD_READLOG, new ReadLogCmd());
        this.commands.put(CMD_READLOGMETADATA, new ReadLogMetadataCmd());
        this.commands.put(CMD_READJOURNAL, new ReadJournalCmd());
        this.commands.put(CMD_LASTMARK, new LastMarkCmd());
        this.commands.put(CMD_AUTORECOVERY, new AutoRecoveryCmd());
        this.commands.put(CMD_QUERY_AUTORECOVERY_STATUS, new QueryAutoRecoveryStatusCmd());
        this.commands.put(CMD_LISTBOOKIES, new ListBookiesCmd());
        this.commands.put(CMD_LISTFILESONDISC, new ListDiskFilesCmd());
        this.commands.put(CMD_UPDATECOOKIE, new UpdateCookieCmd());
        this.commands.put(CMD_UPDATELEDGER, new UpdateLedgerCmd());
        this.commands.put(CMD_UPDATE_BOOKIE_IN_LEDGER, new UpdateBookieInLedgerCmd());
        this.commands.put(CMD_DELETELEDGER, new DeleteLedgerCmd());
        this.commands.put(CMD_BOOKIEINFO, new BookieInfoCmd());
        this.commands.put(CMD_DECOMMISSIONBOOKIE, new DecommissionBookieCmd());
        this.commands.put(CMD_ENDPOINTINFO, new EndpointInfoCmd());
        this.commands.put(CMD_CONVERT_TO_DB_STORAGE, new ConvertToDbStorageCmd());
        this.commands.put(CMD_CONVERT_TO_INTERLEAVED_STORAGE, new ConvertToInterleavedStorageCmd());
        this.commands.put(CMD_REBUILD_DB_LEDGER_LOCATIONS_INDEX, new RebuildDbLedgerLocationsIndexCmd());
        this.commands.put(CMD_REBUILD_DB_LEDGERS_INDEX, new RebuildDbLedgersIndexCmd());
        this.commands.put(CMD_CHECK_DB_LEDGERS_INDEX, new CheckDbLedgersIndexCmd());
        this.commands.put(CMD_REGENERATE_INTERLEAVED_STORAGE_INDEX_FILE, new RegenerateInterleavedStorageIndexFile());
        this.commands.put(CMD_HELP, new HelpCmd());
        this.commands.put(CMD_LOSTBOOKIERECOVERYDELAY, new LostBookieRecoveryDelayCmd());
        this.commands.put(CMD_TRIGGERAUDIT, new TriggerAuditCmd());
        this.commands.put(CMD_FORCEAUDITCHECKS, new ForceAuditorChecksCmd());
        this.commands.put(CMD_CREATE_COOKIE, new CreateCookieCommand().asShellCommand(CMD_CREATE_COOKIE, this.bkConf));
        this.commands.put(CMD_DELETE_COOKIE, new DeleteCookieCommand().asShellCommand(CMD_DELETE_COOKIE, this.bkConf));
        this.commands.put(CMD_UPDATE_COOKIE, new UpdateCookieCommand().asShellCommand(CMD_UPDATE_COOKIE, this.bkConf));
        this.commands.put(CMD_GET_COOKIE, new GetCookieCommand().asShellCommand(CMD_GET_COOKIE, this.bkConf));
        this.commands.put(CMD_GENERATE_COOKIE, new GenerateCookieCommand().asShellCommand(CMD_GENERATE_COOKIE, this.bkConf));
    }

    public BookieShell(LedgerIdFormatter ledgeridFormatter, EntryFormatter entryFormatter) {
        this.commands.put(CMD_METAFORMAT, new MetaFormatCmd());
        this.commands.put(CMD_INITBOOKIE, new InitBookieCmd());
        this.commands.put(CMD_INITNEWCLUSTER, new InitNewCluster());
        this.commands.put(CMD_NUKEEXISTINGCLUSTER, new NukeExistingCluster());
        this.commands.put(CMD_BOOKIEFORMAT, new BookieFormatCmd());
        this.commands.put(CMD_RECOVER, new RecoverCmd());
        this.commands.put(CMD_LEDGER, new LedgerCmd());
        this.commands.put(CMD_READ_LEDGER_ENTRIES, new ReadLedgerEntriesCmd());
        this.commands.put(CMD_LISTLEDGERS, new ListLedgersCmd());
        this.commands.put(CMD_ACTIVE_LEDGERS_ON_ENTRY_LOG_FILE, new ListActiveLedgersCmd());
        this.commands.put(CMD_LISTUNDERREPLICATED, new ListUnderreplicatedCmd());
        this.commands.put(CMD_WHOISAUDITOR, new WhoIsAuditorCmd());
        this.commands.put(CMD_WHATISINSTANCEID, new WhatIsInstanceId());
        this.commands.put(CMD_LEDGERMETADATA, new LedgerMetadataCmd());
        this.commands.put(CMD_LOCALCONSISTENCYCHECK, new LocalConsistencyCheck());
        this.commands.put(CMD_SIMPLETEST, new SimpleTestCmd());
        this.commands.put(CMD_BOOKIESANITYTEST, new BookieSanityTestCmd());
        this.commands.put(CMD_READLOG, new ReadLogCmd());
        this.commands.put(CMD_READLOGMETADATA, new ReadLogMetadataCmd());
        this.commands.put(CMD_READJOURNAL, new ReadJournalCmd());
        this.commands.put(CMD_LASTMARK, new LastMarkCmd());
        this.commands.put(CMD_AUTORECOVERY, new AutoRecoveryCmd());
        this.commands.put(CMD_QUERY_AUTORECOVERY_STATUS, new QueryAutoRecoveryStatusCmd());
        this.commands.put(CMD_LISTBOOKIES, new ListBookiesCmd());
        this.commands.put(CMD_LISTFILESONDISC, new ListDiskFilesCmd());
        this.commands.put(CMD_UPDATECOOKIE, new UpdateCookieCmd());
        this.commands.put(CMD_UPDATELEDGER, new UpdateLedgerCmd());
        this.commands.put(CMD_UPDATE_BOOKIE_IN_LEDGER, new UpdateBookieInLedgerCmd());
        this.commands.put(CMD_DELETELEDGER, new DeleteLedgerCmd());
        this.commands.put(CMD_BOOKIEINFO, new BookieInfoCmd());
        this.commands.put(CMD_DECOMMISSIONBOOKIE, new DecommissionBookieCmd());
        this.commands.put(CMD_ENDPOINTINFO, new EndpointInfoCmd());
        this.commands.put(CMD_CONVERT_TO_DB_STORAGE, new ConvertToDbStorageCmd());
        this.commands.put(CMD_CONVERT_TO_INTERLEAVED_STORAGE, new ConvertToInterleavedStorageCmd());
        this.commands.put(CMD_REBUILD_DB_LEDGER_LOCATIONS_INDEX, new RebuildDbLedgerLocationsIndexCmd());
        this.commands.put(CMD_REBUILD_DB_LEDGERS_INDEX, new RebuildDbLedgersIndexCmd());
        this.commands.put(CMD_CHECK_DB_LEDGERS_INDEX, new CheckDbLedgersIndexCmd());
        this.commands.put(CMD_REGENERATE_INTERLEAVED_STORAGE_INDEX_FILE, new RegenerateInterleavedStorageIndexFile());
        this.commands.put(CMD_HELP, new HelpCmd());
        this.commands.put(CMD_LOSTBOOKIERECOVERYDELAY, new LostBookieRecoveryDelayCmd());
        this.commands.put(CMD_TRIGGERAUDIT, new TriggerAuditCmd());
        this.commands.put(CMD_FORCEAUDITCHECKS, new ForceAuditorChecksCmd());
        this.commands.put(CMD_CREATE_COOKIE, new CreateCookieCommand().asShellCommand(CMD_CREATE_COOKIE, this.bkConf));
        this.commands.put(CMD_DELETE_COOKIE, new DeleteCookieCommand().asShellCommand(CMD_DELETE_COOKIE, this.bkConf));
        this.commands.put(CMD_UPDATE_COOKIE, new UpdateCookieCommand().asShellCommand(CMD_UPDATE_COOKIE, this.bkConf));
        this.commands.put(CMD_GET_COOKIE, new GetCookieCommand().asShellCommand(CMD_GET_COOKIE, this.bkConf));
        this.commands.put(CMD_GENERATE_COOKIE, new GenerateCookieCommand().asShellCommand(CMD_GENERATE_COOKIE, this.bkConf));
        this.ledgerIdFormatter = ledgeridFormatter;
        this.entryFormatter = entryFormatter;
    }

    void printInfoLine(String s) {
        System.out.println(s);
    }

    void printErrorLine(String s) {
        System.err.println(s);
    }

    void printLedgerMetadata(long ledgerId, LedgerMetadata md, boolean printMeta) {
        System.out.println("ledgerID: " + this.ledgerIdFormatter.formatLedgerId(ledgerId));
        if (printMeta) {
            System.out.println(md.toString());
        }
    }

    @Override
    public void setConf(CompositeConfiguration conf) throws Exception {
        this.bkConf.loadConf(conf);
        this.journalDirectories = BookieImpl.getCurrentDirectories(this.bkConf.getJournalDirs());
        this.ledgerDirectories = BookieImpl.getCurrentDirectories(this.bkConf.getLedgerDirs());
        this.indexDirectories = null == this.bkConf.getIndexDirs() ? this.ledgerDirectories : BookieImpl.getCurrentDirectories(this.bkConf.getIndexDirs());
        this.pageSize = this.bkConf.getPageSize();
        this.entriesPerPage = this.pageSize / 8;
    }

    private void printShellUsage() {
        System.err.println("Usage: bookkeeper shell [-localbookie [<host:port>]] [-ledgeridformat <hex/long/uuid>] [-entryformat <hex/string>] [-conf configuration] <command>");
        System.err.println("where command is one of:");
        ArrayList<String> commandNames = new ArrayList<String>();
        for (Command c : this.commands.values()) {
            commandNames.add("       " + c.description());
        }
        Collections.sort(commandNames);
        for (String s : commandNames) {
            System.err.println(s);
        }
    }

    @VisibleForTesting
    public int execute(String ... args) throws Exception {
        return this.run(args);
    }

    @Override
    public int run(String[] args) throws Exception {
        if (args.length <= 0) {
            this.printShellUsage();
            return -1;
        }
        String cmdName = args[0];
        Command cmd = this.commands.get(cmdName);
        if (null == cmd) {
            System.err.println("ERROR: Unknown command " + cmdName);
            this.printShellUsage();
            return -1;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return cmd.runCmd(newArgs);
    }

    public static List<File> listFilesAndSort(File[] folderNames, String ... extensions) {
        ArrayList<File> completeFilesList = new ArrayList<File>();
        for (int i = 0; i < folderNames.length; ++i) {
            Collection filesCollection = FileUtils.listFiles((File)folderNames[i], (String[])extensions, (boolean)true);
            completeFilesList.addAll(filesCollection);
        }
        Collections.sort(completeFilesList, new FilesTimeComparator());
        return completeFilesList;
    }

    public static void main(String[] argv) throws Exception {
        String val;
        BookieShell shell = new BookieShell();
        Options opts = new Options();
        opts.addOption(CONF_OPT, true, "configuration file");
        opts.addOption(LEDGERID_FORMATTER_OPT, true, "format of ledgerId");
        opts.addOption(ENTRY_FORMATTER_OPT, true, "format of entries");
        BasicParser parser = new BasicParser();
        CommandLine cmdLine = parser.parse(opts, argv, true);
        CompositeConfiguration conf = new CompositeConfiguration();
        if (cmdLine.hasOption(CONF_OPT)) {
            val = cmdLine.getOptionValue(CONF_OPT);
            conf.addConfiguration((Configuration)new PropertiesConfiguration(new File(val).toURI().toURL()));
        }
        shell.setConf(conf);
        if (cmdLine.hasOption(LEDGERID_FORMATTER_OPT)) {
            val = cmdLine.getOptionValue(LEDGERID_FORMATTER_OPT);
            shell.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(val, shell.bkConf);
        } else {
            shell.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(shell.bkConf);
        }
        LOG.debug("Using ledgerIdFormatter {}", shell.ledgerIdFormatter.getClass());
        if (cmdLine.hasOption(ENTRY_FORMATTER_OPT)) {
            val = cmdLine.getOptionValue(ENTRY_FORMATTER_OPT);
            shell.entryFormatter = EntryFormatter.newEntryFormatter(val, shell.bkConf);
        } else {
            shell.entryFormatter = EntryFormatter.newEntryFormatter(shell.bkConf);
        }
        LOG.debug("Using entry formatter {}", shell.entryFormatter.getClass());
        int res = shell.run(cmdLine.getArgs());
        System.exit(res);
    }

    private synchronized void initEntryLogger() throws IOException {
        if (null == this.entryLogger) {
            this.entryLogger = new ReadOnlyEntryLogger(this.bkConf);
        }
    }

    protected void printEntryLogMetadata(long logId) throws IOException {
        LOG.info("Print entryLogMetadata of entrylog {} ({}.log)", (Object)logId, (Object)Long.toHexString(logId));
        this.initEntryLogger();
        EntryLogMetadata entryLogMetadata = this.entryLogger.getEntryLogMetadata(logId);
        entryLogMetadata.getLedgersMap().forEach((ledgerId, size) -> LOG.info("--------- Lid={}, TotalSizeOfEntriesOfLedger={}  ---------", (Object)this.ledgerIdFormatter.formatLedgerId(ledgerId), (Object)size));
    }

    private void formatEntry(LedgerEntry entry, boolean printMsg) {
        long ledgerId = entry.getLedgerId();
        long entryId = entry.getEntryId();
        long entrySize = entry.getLength();
        System.out.println("--------- Lid=" + this.ledgerIdFormatter.formatLedgerId(ledgerId) + ", Eid=" + entryId + ", EntrySize=" + entrySize + " ---------");
        if (printMsg) {
            this.entryFormatter.formatEntry(entry.getEntry());
        }
    }

    private static int getOptionIntValue(CommandLine cmdLine, String option, int defaultVal) {
        if (cmdLine.hasOption(option)) {
            String val = cmdLine.getOptionValue(option);
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                System.err.println("ERROR: invalid value for option " + option + " : " + val);
                return defaultVal;
            }
        }
        return defaultVal;
    }

    private static long getOptionLongValue(CommandLine cmdLine, String option, long defaultVal) {
        if (cmdLine.hasOption(option)) {
            String val = cmdLine.getOptionValue(option);
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                System.err.println("ERROR: invalid value for option " + option + " : " + val);
                return defaultVal;
            }
        }
        return defaultVal;
    }

    private long getOptionLedgerIdValue(CommandLine cmdLine, String option, long defaultVal) {
        if (cmdLine.hasOption(option)) {
            String val = cmdLine.getOptionValue(option);
            try {
                return this.ledgerIdFormatter.readLedgerId(val);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("ERROR: invalid value for option " + option + " : " + val);
                return defaultVal;
            }
        }
        return defaultVal;
    }

    private static boolean getOptionBooleanValue(CommandLine cmdLine, String option, boolean defaultVal) {
        if (cmdLine.hasOption(option)) {
            String val = cmdLine.getOptionValue(option);
            return Boolean.parseBoolean(val);
        }
        return defaultVal;
    }

    private static boolean getOptionalValue(String optValue, String optName) {
        return StringUtils.equals((String)optValue, (String)optName);
    }

    private static class FilesTimeComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FilesTimeComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            Path file1Path = Paths.get(file1.getAbsolutePath(), new String[0]);
            Path file2Path = Paths.get(file2.getAbsolutePath(), new String[0]);
            try {
                BasicFileAttributes file1Attributes = Files.readAttributes(file1Path, BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributes file2Attributes = Files.readAttributes(file2Path, BasicFileAttributes.class, new LinkOption[0]);
                FileTime file1CreationTime = file1Attributes.creationTime();
                FileTime file2CreationTime = file2Attributes.creationTime();
                int compareValue = file1CreationTime.compareTo(file2CreationTime);
                if (compareValue == 0) {
                    FileTime file1LastModifiedTime = file1Attributes.lastModifiedTime();
                    FileTime file2LastModifiedTime = file2Attributes.lastModifiedTime();
                    compareValue = file1LastModifiedTime.compareTo(file2LastModifiedTime);
                }
                return compareValue;
            }
            catch (IOException e) {
                return 0;
            }
        }
    }

    class RegenerateInterleavedStorageIndexFile
    extends MyCommand {
        public RegenerateInterleavedStorageIndexFile() {
            super(BookieShell.CMD_REGENERATE_INTERLEAVED_STORAGE_INDEX_FILE);
            Option ledgerOption = new Option("l", "ledgerIds", true, "Ledger(s) whose index needs to be regenerated. Multiple can be specified, comma separated.");
            ledgerOption.setRequired(true);
            ledgerOption.setValueSeparator(',');
            ledgerOption.setArgs(-2);
            this.opts.addOption(ledgerOption);
            this.opts.addOption("dryRun", false, "Process the entryLogger, but don't write anything.");
            this.opts.addOption("password", true, "The bookie stores the password in the index file, so we need it to regenerate. This must match the value in the ledger metadata.");
            this.opts.addOption("b64password", true, "The password in base64 encoding, for cases where the password is not UTF-8.");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Regenerate an interleaved storage index file, from available entrylogger files.";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_REGENERATE_INTERLEAVED_STORAGE_INDEX_FILE;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            RegenerateInterleavedStorageIndexFileCommand cmd = new RegenerateInterleavedStorageIndexFileCommand();
            RegenerateInterleavedStorageIndexFileCommand.RISIFFlags flags = new RegenerateInterleavedStorageIndexFileCommand.RISIFFlags();
            List<Long> ledgerIds = Arrays.stream(cmdLine.getOptionValues("ledgerIds")).map(id -> Long.parseLong(id)).collect(Collectors.toList());
            boolean dryRun = cmdLine.hasOption("dryRun");
            flags.ledgerIds(ledgerIds);
            if (cmdLine.hasOption("password")) {
                flags.password(cmdLine.getOptionValue("password"));
            } else if (cmdLine.hasOption("b64password")) {
                flags.b64Password(cmdLine.getOptionValue("b64password"));
            }
            flags.dryRun(dryRun);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }
    }

    class CheckDbLedgersIndexCmd
    extends MyCommand {
        public CheckDbLedgersIndexCmd() {
            super(BookieShell.CMD_CHECK_DB_LEDGERS_INDEX);
            this.opts.addOption("v", "verbose", false, "Verbose logging, print the ledger data in the index.");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Check DbLedgerStorage ledgers index by performing a read scan";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_CHECK_DB_LEDGERS_INDEX;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            CheckDBLedgersIndexCommand.CheckLedgersIndexFlags flags = new CheckDBLedgersIndexCommand.CheckLedgersIndexFlags();
            flags.verbose(cmdLine.hasOption("v"));
            CheckDBLedgersIndexCommand cmd = new CheckDBLedgersIndexCommand();
            if (cmd.apply(BookieShell.this.bkConf, flags)) {
                return 0;
            }
            return -1;
        }
    }

    class RebuildDbLedgersIndexCmd
    extends MyCommand {
        public RebuildDbLedgersIndexCmd() {
            super(BookieShell.CMD_REBUILD_DB_LEDGERS_INDEX);
            this.opts.addOption("v", "verbose", false, "Verbose logging, print the ledgers added to the new index");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Rebuild DbLedgerStorage ledgers index by scanning the journal and entry logs (sets all ledgers to fenced)";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_REBUILD_DB_LEDGERS_INDEX;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            RebuildDBLedgersIndexCommand.RebuildLedgersIndexFlags flags = new RebuildDBLedgersIndexCommand.RebuildLedgersIndexFlags();
            flags.verbose(cmdLine.hasOption("v"));
            RebuildDBLedgersIndexCommand cmd = new RebuildDBLedgersIndexCommand();
            if (cmd.apply(BookieShell.this.bkConf, flags)) {
                return 0;
            }
            return -1;
        }
    }

    class RebuildDbLedgerLocationsIndexCmd
    extends MyCommand {
        public RebuildDbLedgerLocationsIndexCmd() {
            super(BookieShell.CMD_REBUILD_DB_LEDGER_LOCATIONS_INDEX);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Rebuild DbLedgerStorage locations index by scanning the entry logs";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_REBUILD_DB_LEDGER_LOCATIONS_INDEX;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            RebuildDBLedgerLocationsIndexCommand cmd = new RebuildDBLedgerLocationsIndexCommand();
            cmd.apply(BookieShell.this.bkConf, new CliFlags());
            return 0;
        }
    }

    class ConvertToInterleavedStorageCmd
    extends MyCommand {
        public ConvertToInterleavedStorageCmd() {
            super(BookieShell.CMD_CONVERT_TO_INTERLEAVED_STORAGE);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Convert bookie indexes from DbLedgerStorage to InterleavedStorage format";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_CONVERT_TO_INTERLEAVED_STORAGE;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            ConvertToInterleavedStorageCommand cmd = new ConvertToInterleavedStorageCommand();
            ConvertToInterleavedStorageCommand.CTISFlags flags = new ConvertToInterleavedStorageCommand.CTISFlags();
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }
    }

    class ConvertToDbStorageCmd
    extends MyCommand {
        public ConvertToDbStorageCmd() {
            super(BookieShell.CMD_CONVERT_TO_DB_STORAGE);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Convert bookie indexes from InterleavedStorage to DbLedgerStorage format";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_CONVERT_TO_DB_STORAGE;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            ConvertToDBStorageCommand cmd = new ConvertToDBStorageCommand();
            ConvertToDBStorageCommand.CTDBFlags flags = new ConvertToDBStorageCommand.CTDBFlags();
            cmd.setLedgerIdFormatter(BookieShell.this.ledgerIdFormatter);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }
    }

    public static interface UpdateLedgerNotifier {
        public void progress(long var1, long var3);
    }

    class EndpointInfoCmd
    extends MyCommand {
        EndpointInfoCmd() {
            super(BookieShell.CMD_ENDPOINTINFO);
            this.opts.addOption("b", "bookieid", true, "Bookie Id");
        }

        @Override
        String getDescription() {
            return "Get info about a remote bookie with a specific bookie address (bookieid)";
        }

        @Override
        String getUsage() {
            return "endpointinfo [-bookieid <bookieaddress>]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            EndpointInfoCommand cmd = new EndpointInfoCommand();
            EndpointInfoCommand.EndpointInfoFlags flags = new EndpointInfoCommand.EndpointInfoFlags();
            String bookieId = cmdLine.getOptionValue("bookieid");
            flags.bookie(bookieId);
            if (StringUtils.isBlank((String)bookieId)) {
                LOG.error("Invalid argument list!");
                this.printUsage();
                return -1;
            }
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }
    }

    class DecommissionBookieCmd
    extends MyCommand {
        DecommissionBookieCmd() {
            super(BookieShell.CMD_DECOMMISSIONBOOKIE);
            this.opts.addOption("bookieid", true, "decommission a remote bookie");
        }

        @Override
        String getDescription() {
            return "Force trigger the Audittask and make sure all the ledgers stored in the decommissioning bookie are replicated and cookie of the decommissioned bookie is deleted from metadata server.";
        }

        @Override
        String getUsage() {
            return "decommissionbookie [-bookieid <bookieaddress>]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            DecommissionCommand cmd = new DecommissionCommand();
            DecommissionCommand.DecommissionFlags flags = new DecommissionCommand.DecommissionFlags();
            String remoteBookieidToDecommission = cmdLine.getOptionValue("bookieid");
            flags.remoteBookieIdToDecommission(remoteBookieidToDecommission);
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }
    }

    class ForceAuditorChecksCmd
    extends MyCommand {
        ForceAuditorChecksCmd() {
            super(BookieShell.CMD_FORCEAUDITCHECKS);
            this.opts.addOption("calc", "checkallledgerscheck", false, "Force checkAllLedgers audit upon next Auditor startup ");
            this.opts.addOption("ppc", "placementpolicycheck", false, "Force placementPolicyCheck audit upon next Auditor startup ");
            this.opts.addOption("rc", "replicascheck", false, "Force replicasCheck audit upon next Auditor startup ");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Reset the last run time of auditor checks (checkallledgerscheck, placementpolicycheck, replicascheck) The current auditor must be REBOOTED after this command is run.";
        }

        @Override
        String getUsage() {
            return "forceauditchecks [-checkallledgerscheck [-placementpolicycheck] [-replicascheck]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean checkAllLedgersCheck = cmdLine.hasOption("calc");
            boolean placementPolicyCheck = cmdLine.hasOption("ppc");
            boolean replicasCheck = cmdLine.hasOption("rc");
            if (!(checkAllLedgersCheck || placementPolicyCheck || replicasCheck)) {
                LOG.error("Command line args must contain atleast one type of check. This was a no-op.");
                return -1;
            }
            MetadataDrivers.runFunctionWithLedgerManagerFactory(BookieShell.this.bkConf, mFactory -> {
                try (LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();){
                    long time = System.currentTimeMillis() - 1814400000L;
                    if (checkAllLedgersCheck) {
                        LOG.info("Resetting CheckAllLedgersCTime to : " + new Timestamp(time));
                        underreplicationManager.setCheckAllLedgersCTime(time);
                    }
                    if (placementPolicyCheck) {
                        LOG.info("Resetting PlacementPolicyCheckCTime to : " + new Timestamp(time));
                        underreplicationManager.setPlacementPolicyCheckCTime(time);
                    }
                    if (replicasCheck) {
                        LOG.info("Resetting ReplicasCheckCTime to : " + new Timestamp(time));
                        underreplicationManager.setReplicasCheckCTime(time);
                    }
                }
                catch (InterruptedException | ReplicationException | KeeperException e) {
                    LOG.error("Exception while trying to reset last run time ", e);
                    return -1;
                }
                return 0;
            });
            return 0;
        }
    }

    class TriggerAuditCmd
    extends MyCommand {
        TriggerAuditCmd() {
            super(BookieShell.CMD_TRIGGERAUDIT);
        }

        @Override
        String getDescription() {
            return "Force trigger the Audit by resetting the lostBookieRecoveryDelay.";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_TRIGGERAUDIT;
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            TriggerAuditCommand cmd = new TriggerAuditCommand();
            cmd.apply(BookieShell.this.bkConf, new CliFlags());
            return 0;
        }
    }

    class BookieInfoCmd
    extends MyCommand {
        BookieInfoCmd() {
            super(BookieShell.CMD_BOOKIEINFO);
        }

        @Override
        String getDescription() {
            return "Retrieve bookie info such as free and total disk space.";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_BOOKIEINFO;
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            InfoCommand cmd = new InfoCommand();
            cmd.apply(BookieShell.this.bkConf, new CliFlags());
            return 0;
        }
    }

    class DeleteLedgerCmd
    extends MyCommand {
        DeleteLedgerCmd() {
            super(BookieShell.CMD_DELETELEDGER);
            this.opts.addOption("l", "ledgerid", true, "Ledger ID");
            this.opts.addOption("f", "force", false, "Whether to force delete the Ledger without prompt..?");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            long lid = BookieShell.this.getOptionLedgerIdValue(cmdLine, "ledgerid", -1L);
            boolean force = cmdLine.hasOption("f");
            DeleteLedgerCommand cmd = new DeleteLedgerCommand(BookieShell.this.ledgerIdFormatter);
            DeleteLedgerCommand.DeleteLedgerFlags flags = new DeleteLedgerCommand.DeleteLedgerFlags().ledgerId(lid).force(force);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }

        @Override
        String getDescription() {
            return "Delete a ledger.";
        }

        @Override
        String getUsage() {
            return "deleteledger -ledgerid <ledgerid> [-force]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class UpdateBookieInLedgerCmd
    extends MyCommand {
        UpdateBookieInLedgerCmd() {
            super(BookieShell.CMD_UPDATE_BOOKIE_IN_LEDGER);
            this.opts.addOption("sb", "srcBookie", true, "Source bookie which needs to be replaced by destination bookie.");
            this.opts.addOption("db", "destBookie", true, "Destination bookie which replaces source bookie.");
            this.opts.addOption("s", "updatespersec", true, "Number of ledgers updating per second (default: 5 per sec)");
            this.opts.addOption("r", "maxOutstandingReads", true, "Max outstanding reads (default: 5 * updatespersec)");
            this.opts.addOption("l", "limit", true, "Maximum number of ledgers to update (default: no limit)");
            this.opts.addOption("v", "verbose", true, "Print status of the ledger updation (default: false)");
            this.opts.addOption("p", "printprogress", true, "Print messages on every configured seconds if verbose turned on (default: 10 secs)");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Replace bookie in ledger metadata. (useful when re-ip of host) replace srcBookie with destBookie. (this may take a long time).";
        }

        @Override
        String getUsage() {
            return "updateBookieInLedger -srcBookie <source bookie> -destBookie <destination bookie> [-updatespersec N] [-maxOutstandingReads N] [-limit N] [-verbose true/false] [-printprogress N]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            long printprogress;
            UpdateBookieInLedgerCommand cmd = new UpdateBookieInLedgerCommand();
            UpdateBookieInLedgerCommand.UpdateBookieInLedgerFlags flags = new UpdateBookieInLedgerCommand.UpdateBookieInLedgerFlags();
            String srcBookie = cmdLine.getOptionValue("srcBookie");
            String destBookie = cmdLine.getOptionValue("destBookie");
            if (StringUtils.isBlank((String)srcBookie) || StringUtils.isBlank((String)destBookie)) {
                LOG.error("Invalid argument list (srcBookie and destBookie must be provided)!");
                this.printUsage();
                return -1;
            }
            if (StringUtils.equals((String)srcBookie, (String)destBookie)) {
                LOG.error("srcBookie and destBookie can't be the same.");
                return -1;
            }
            int rate = BookieShell.getOptionIntValue(cmdLine, "updatespersec", 5);
            int maxOutstandingReads = BookieShell.getOptionIntValue(cmdLine, "maxOutstandingReads", rate * 5);
            int limit = BookieShell.getOptionIntValue(cmdLine, "limit", Integer.MIN_VALUE);
            boolean verbose = BookieShell.getOptionBooleanValue(cmdLine, "verbose", false);
            if (!verbose) {
                if (cmdLine.hasOption("printprogress")) {
                    LOG.warn("Ignoring option 'printprogress', this is applicable when 'verbose' is true");
                }
                printprogress = Integer.MIN_VALUE;
            } else {
                printprogress = BookieShell.getOptionLongValue(cmdLine, "printprogress", 10L);
            }
            flags.srcBookie(srcBookie);
            flags.destBookie(destBookie);
            flags.printProgress(printprogress);
            flags.limit(limit);
            flags.updatePerSec(rate);
            flags.maxOutstandingReads(maxOutstandingReads);
            flags.verbose(verbose);
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }
    }

    class UpdateLedgerCmd
    extends MyCommand {
        UpdateLedgerCmd() {
            super(BookieShell.CMD_UPDATELEDGER);
            this.opts.addOption("b", "bookieId", true, "Bookie Id");
            this.opts.addOption("s", "updatespersec", true, "Number of ledgers updating per second (default: 5 per sec)");
            this.opts.addOption("r", "maxOutstandingReads", true, "Max outstanding reads (default: 5 * updatespersec)");
            this.opts.addOption("l", "limit", true, "Maximum number of ledgers to update (default: no limit)");
            this.opts.addOption("v", "verbose", true, "Print status of the ledger updation (default: false)");
            this.opts.addOption("p", "printprogress", true, "Print messages on every configured seconds if verbose turned on (default: 10 secs)");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Update bookie id in ledgers (this may take a long time).";
        }

        @Override
        String getUsage() {
            return "updateledgers -bookieId <hostname|ip> [-updatespersec N] [-maxOutstandingReads N] [-limit N] [-verbose true/false] [-printprogress N]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            long printprogress;
            FlipBookieIdCommand cmd = new FlipBookieIdCommand();
            FlipBookieIdCommand.FlipBookieIdFlags flags = new FlipBookieIdCommand.FlipBookieIdFlags();
            String bookieId = cmdLine.getOptionValue("bookieId");
            if (StringUtils.isBlank((String)bookieId)) {
                LOG.error("Invalid argument list!");
                this.printUsage();
                return -1;
            }
            if (!StringUtils.equals((String)bookieId, (String)"hostname") && !StringUtils.equals((String)bookieId, (String)"ip")) {
                LOG.error("Invalid option value {} for bookieId, expected hostname/ip", (Object)bookieId);
                this.printUsage();
                return -1;
            }
            boolean useHostName = BookieShell.getOptionalValue(bookieId, "hostname");
            int rate = BookieShell.getOptionIntValue(cmdLine, "updatespersec", 5);
            int maxOutstandingReads = BookieShell.getOptionIntValue(cmdLine, "maxOutstandingReads", rate * 5);
            int limit = BookieShell.getOptionIntValue(cmdLine, "limit", Integer.MIN_VALUE);
            boolean verbose = BookieShell.getOptionBooleanValue(cmdLine, "verbose", false);
            if (!verbose) {
                if (cmdLine.hasOption("printprogress")) {
                    LOG.warn("Ignoring option 'printprogress', this is applicable when 'verbose' is true");
                }
                printprogress = Integer.MIN_VALUE;
            } else {
                printprogress = BookieShell.getOptionLongValue(cmdLine, "printprogress", 10L);
            }
            flags.hostname(useHostName);
            flags.printProgress(printprogress);
            flags.limit(limit);
            flags.updatePerSec(rate);
            flags.maxOutstandingReads(maxOutstandingReads);
            flags.verbose(verbose);
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }
    }

    class UpdateCookieCmd
    extends MyCommand {
        private static final String BOOKIEID = "bookieId";
        private static final String EXPANDSTORAGE = "expandstorage";
        private static final String LIST = "list";
        private static final String DELETE = "delete";
        private static final String HOSTNAME = "hostname";
        private static final String IP = "ip";
        private static final String FORCE = "force";

        UpdateCookieCmd() {
            super(BookieShell.CMD_UPDATECOOKIE);
            this.opts.addOption("b", BOOKIEID, true, "Bookie Id");
            this.opts.addOption("e", EXPANDSTORAGE, false, "Expand Storage");
            this.opts.addOption("l", LIST, false, "List paths of all the cookies present locally and on zookkeeper");
            OptionBuilder.withLongOpt((String)DELETE);
            OptionBuilder.hasOptionalArgs((int)1);
            OptionBuilder.withDescription((String)"Delete cookie both locally and in ZooKeeper");
            Option deleteOption = OptionBuilder.create((String)"d");
            this.opts.addOption(deleteOption);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Command to update cookiebookieId - Update bookie id in cookie\nexpandstorage - Add new empty ledger/index directories. Update the directories info in the conf file before running the command\nlist - list the local cookie files path and ZK cookiePath delete - Delete cookies locally and in zookeeper";
        }

        @Override
        String getUsage() {
            return "updatecookie [-bookieId <hostname|ip>] [-expandstorage] [-list] [-delete <force>]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean result;
            AdminCommand cmd = new AdminCommand();
            AdminCommand.AdminFlags flags = new AdminCommand.AdminFlags();
            Option[] options = cmdLine.getOptions();
            if (options.length != 1) {
                LOG.error("Invalid command!");
                this.printUsage();
                return -1;
            }
            Option thisCommandOption = options[0];
            if (thisCommandOption.getLongOpt().equals(BOOKIEID)) {
                String bookieId = cmdLine.getOptionValue(BOOKIEID);
                if (StringUtils.isBlank((String)bookieId)) {
                    LOG.error("Invalid argument list!");
                    this.printUsage();
                    return -1;
                }
                if (!StringUtils.equals((String)bookieId, (String)HOSTNAME) && !StringUtils.equals((String)bookieId, (String)IP)) {
                    LOG.error("Invalid option value:" + bookieId);
                    this.printUsage();
                    return -1;
                }
                boolean useHostName = BookieShell.getOptionalValue(bookieId, HOSTNAME);
                flags.hostname(useHostName);
                flags.ip(!useHostName);
            }
            flags.expandstorage(thisCommandOption.getLongOpt().equals(EXPANDSTORAGE));
            flags.list(thisCommandOption.getLongOpt().equals(LIST));
            flags.delete(thisCommandOption.getLongOpt().equals(DELETE));
            if (thisCommandOption.getLongOpt().equals(DELETE)) {
                boolean force = false;
                String optionValue = thisCommandOption.getValue();
                if (!StringUtils.isEmpty((String)optionValue) && optionValue.equals(FORCE)) {
                    force = true;
                }
                flags.force(force);
            }
            return (result = cmd.apply(BookieShell.this.bkConf, flags)) ? 0 : -1;
        }
    }

    class WhatIsInstanceId
    extends MyCommand {
        public WhatIsInstanceId() {
            super(BookieShell.CMD_WHATISINSTANCEID);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Print the instanceid of the cluster";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_WHATISINSTANCEID;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            InstanceIdCommand cmd = new InstanceIdCommand();
            cmd.apply(BookieShell.this.bkConf, new CliFlags());
            return 0;
        }
    }

    class WhoIsAuditorCmd
    extends MyCommand {
        public WhoIsAuditorCmd() {
            super(BookieShell.CMD_WHOISAUDITOR);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Print the node which holds the auditor lock.";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_WHOISAUDITOR;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            WhoIsAuditorCommand cmd = new WhoIsAuditorCommand();
            CliFlags flags = new CliFlags();
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }
    }

    class LostBookieRecoveryDelayCmd
    extends MyCommand {
        public LostBookieRecoveryDelayCmd() {
            super(BookieShell.CMD_LOSTBOOKIERECOVERYDELAY);
            this.opts.addOption("g", "get", false, "Get LostBookieRecoveryDelay value (in seconds)");
            this.opts.addOption("s", "set", true, "Set LostBookieRecoveryDelay value (in seconds)");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Setter and Getter for LostBookieRecoveryDelay value (in seconds) in metadata store.";
        }

        @Override
        String getUsage() {
            return "lostbookierecoverydelay [-get|-set <value>]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            LostBookieRecoveryDelayCommand.LBRDFlags flags;
            LostBookieRecoveryDelayCommand cmd;
            boolean result;
            boolean getter = cmdLine.hasOption("g");
            boolean setter = cmdLine.hasOption("s");
            int set = 0;
            if (setter) {
                set = Integer.parseInt(cmdLine.getOptionValue("set"));
            }
            return (result = (cmd = new LostBookieRecoveryDelayCommand()).apply(BookieShell.this.bkConf, flags = new LostBookieRecoveryDelayCommand.LBRDFlags().get(getter).set(set))) ? 0 : 1;
        }
    }

    class QueryAutoRecoveryStatusCmd
    extends MyCommand {
        public QueryAutoRecoveryStatusCmd() {
            super(BookieShell.CMD_QUERY_AUTORECOVERY_STATUS);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Query the autorecovery status";
        }

        @Override
        String getUsage() {
            return "queryautorecoverystatus";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean verbose = cmdLine.hasOption("verbose");
            QueryAutoRecoveryStatusCommand.QFlags flags = new QueryAutoRecoveryStatusCommand.QFlags().verbose(verbose);
            QueryAutoRecoveryStatusCommand cmd = new QueryAutoRecoveryStatusCommand();
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }
    }

    class AutoRecoveryCmd
    extends MyCommand {
        public AutoRecoveryCmd() {
            super(BookieShell.CMD_AUTORECOVERY);
            this.opts.addOption("e", "enable", false, "Enable auto recovery of underreplicated ledgers");
            this.opts.addOption("d", "disable", false, "Disable auto recovery of underreplicated ledgers");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Enable or disable autorecovery in the cluster.";
        }

        @Override
        String getUsage() {
            return "autorecovery [-enable|-disable]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean disable = cmdLine.hasOption("d");
            boolean enable = cmdLine.hasOption("e");
            ToggleCommand.AutoRecoveryFlags flags = new ToggleCommand.AutoRecoveryFlags().enable(enable).status(!disable && !enable);
            ToggleCommand cmd = new ToggleCommand();
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }
    }

    class HelpCmd
    extends MyCommand {
        HelpCmd() {
            super(BookieShell.CMD_HELP);
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            String[] args = cmdLine.getArgs();
            if (args.length == 0) {
                BookieShell.this.printShellUsage();
                return 0;
            }
            String cmdName = args[0];
            Command cmd = BookieShell.this.commands.get(cmdName);
            if (null == cmd) {
                System.err.println("Unknown command " + cmdName);
                BookieShell.this.printShellUsage();
                return -1;
            }
            cmd.printUsage();
            return 0;
        }

        @Override
        String getDescription() {
            return "Describe the usage of this program or its subcommands.";
        }

        @Override
        String getUsage() {
            return "help         [COMMAND]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ListDiskFilesCmd
    extends MyCommand {
        ListDiskFilesCmd() {
            super(BookieShell.CMD_LISTFILESONDISC);
            this.opts.addOption("txn", "journal", false, "Print list of Journal Files");
            this.opts.addOption("log", "entrylog", false, "Print list of EntryLog Files");
            this.opts.addOption("idx", "index", false, "Print list of Index files");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            boolean journal = cmdLine.hasOption("txn");
            boolean entrylog = cmdLine.hasOption("log");
            boolean index = cmdLine.hasOption("idx");
            ListFilesOnDiscCommand.LFODFlags flags = new ListFilesOnDiscCommand.LFODFlags().journal(journal).entrylog(entrylog).index(index);
            ListFilesOnDiscCommand cmd = new ListFilesOnDiscCommand(flags);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }

        @Override
        String getDescription() {
            return "List the files in JournalDirectory/LedgerDirectories/IndexDirectories.";
        }

        @Override
        String getUsage() {
            return "listfilesondisc  [-journal|-entrylog|-index]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ListBookiesCmd
    extends MyCommand {
        ListBookiesCmd() {
            super(BookieShell.CMD_LISTBOOKIES);
            this.opts.addOption("rw", "readwrite", false, "Print readwrite bookies");
            this.opts.addOption("ro", "readonly", false, "Print readonly bookies");
            this.opts.addOption("a", "all", false, "Print all bookies");
            this.opts.addOption("h", "hostnames", false, "Also print hostname of the bookie");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            boolean all;
            boolean readonly;
            int passedCommands = 0;
            boolean readwrite = cmdLine.hasOption("rw");
            if (readwrite) {
                ++passedCommands;
            }
            if (readonly = cmdLine.hasOption("ro")) {
                ++passedCommands;
            }
            if (all = cmdLine.hasOption("a")) {
                ++passedCommands;
            }
            if (passedCommands != 1) {
                LOG.error("One and only one of -readwrite, -readonly and -all must be specified");
                this.printUsage();
                return 1;
            }
            ListBookiesCommand.Flags flags = new ListBookiesCommand.Flags().readwrite(readwrite).readonly(readonly).all(all);
            ListBookiesCommand command = new ListBookiesCommand(flags);
            command.apply(BookieShell.this.bkConf, flags);
            return 0;
        }

        @Override
        String getDescription() {
            return "List the bookies, which are running as either readwrite or readonly mode.";
        }

        @Override
        String getUsage() {
            return "listbookies  [-readwrite|-readonly|-all] [-hostnames]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class LastMarkCmd
    extends MyCommand {
        LastMarkCmd() {
            super(BookieShell.CMD_LASTMARK);
        }

        @Override
        public int runCmd(CommandLine c) throws Exception {
            LastMarkCommand command = new LastMarkCommand();
            command.apply(BookieShell.this.bkConf, new CliFlags());
            return 0;
        }

        @Override
        String getDescription() {
            return "Print last log marker.";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_LASTMARK;
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ReadJournalCmd
    extends MyCommand {
        ReadJournalCmd() {
            super(BookieShell.CMD_READJOURNAL);
            this.opts.addOption("dir", true, "Journal directory (needed if more than one journal configured)");
            this.opts.addOption("m", "msg", false, "Print message body");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            ReadJournalCommand.ReadJournalFlags flags;
            ReadJournalCommand cmd;
            boolean result;
            String[] leftArgs = cmdLine.getArgs();
            if (leftArgs.length <= 0) {
                System.err.println("ERROR: missing journal id or journal file name");
                this.printUsage();
                return -1;
            }
            long journalId = -1L;
            String filename = "";
            try {
                journalId = Long.parseLong(leftArgs[0]);
            }
            catch (NumberFormatException nfe) {
                filename = leftArgs[0];
            }
            boolean printMsg = false;
            if (cmdLine.hasOption("m")) {
                printMsg = true;
            }
            return (result = (cmd = new ReadJournalCommand(BookieShell.this.ledgerIdFormatter, BookieShell.this.entryFormatter)).apply(BookieShell.this.bkConf, flags = new ReadJournalCommand.ReadJournalFlags().msg(printMsg).fileName(filename).journalId(journalId).dir(cmdLine.getOptionValue("dir")))) ? 0 : -1;
        }

        @Override
        String getDescription() {
            return "Scan a journal file and format the entries into readable format.";
        }

        @Override
        String getUsage() {
            return "readjournal [-dir] [-msg] <journal_id | journal_file_name>";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ReadLogMetadataCmd
    extends MyCommand {
        ReadLogMetadataCmd() {
            super(BookieShell.CMD_READLOGMETADATA);
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            ReadLogMetadataCommand cmd = new ReadLogMetadataCommand(BookieShell.this.ledgerIdFormatter);
            ReadLogMetadataCommand.ReadLogMetadataFlags flags = new ReadLogMetadataCommand.ReadLogMetadataFlags();
            String[] leftArgs = cmdLine.getArgs();
            if (leftArgs.length <= 0) {
                LOG.error("ERROR: missing entry log id or entry log file name");
                this.printUsage();
                return -1;
            }
            try {
                long logId = Long.parseLong(leftArgs[0], 16);
                flags.logId(logId);
            }
            catch (NumberFormatException nfe) {
                flags.logFilename(leftArgs[0]);
                flags.logId(-1L);
            }
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }

        @Override
        String getDescription() {
            return "Prints entrylog's metadata";
        }

        @Override
        String getUsage() {
            return "readlogmetadata <entry_log_id | entry_log_file_name>";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ReadLogCmd
    extends MyCommand {
        ReadLogCmd() {
            super(BookieShell.CMD_READLOG);
            this.opts.addOption("m", "msg", false, "Print message body");
            this.opts.addOption("l", "ledgerid", true, "Ledger ID");
            this.opts.addOption("e", "entryid", true, "Entry ID");
            this.opts.addOption("sp", "startpos", true, "Start Position");
            this.opts.addOption("ep", "endpos", true, "End Position");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            String[] leftArgs = cmdLine.getArgs();
            if (leftArgs.length <= 0) {
                System.err.println("ERROR: missing entry log id or entry log file name");
                this.printUsage();
                return -1;
            }
            ReadLogCommand cmd = new ReadLogCommand(BookieShell.this.ledgerIdFormatter, BookieShell.this.entryFormatter);
            ReadLogCommand.ReadLogFlags flags = new ReadLogCommand.ReadLogFlags();
            boolean printMsg = false;
            if (cmdLine.hasOption("m")) {
                printMsg = true;
            }
            try {
                long logId = Long.parseLong(leftArgs[0]);
                flags.entryLogId(logId);
            }
            catch (NumberFormatException nfe) {
                flags.filename(leftArgs[0]);
            }
            long lId = BookieShell.this.getOptionLedgerIdValue(cmdLine, "ledgerid", -1L);
            long eId = BookieShell.getOptionLongValue(cmdLine, "entryid", -1L);
            long startpos = BookieShell.getOptionLongValue(cmdLine, "startpos", -1L);
            long endpos = BookieShell.getOptionLongValue(cmdLine, "endpos", -1L);
            flags.endPos(endpos);
            flags.startPos(startpos);
            flags.entryId(eId);
            flags.ledgerId(lId);
            flags.msg(printMsg);
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }

        @Override
        String getDescription() {
            return "Scan an entry file and format the entries into readable format.";
        }

        @Override
        String getUsage() {
            return "readlog      [-msg] <entry_log_id | entry_log_file_name> [-ledgerid <ledgerid> [-entryid <entryid>]] [-startpos <startEntryLogBytePos> [-endpos <endEntryLogBytePos>]]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class BookieSanityTestCmd
    extends MyCommand {
        BookieSanityTestCmd() {
            super(BookieShell.CMD_BOOKIESANITYTEST);
            this.opts.addOption("e", "entries", true, "Total entries to be added for the test (default 10)");
            this.opts.addOption("t", "timeout", true, "Timeout for write/read operations in seconds (default 1)");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Sanity test for local bookie. Create ledger and write/reads entries on local bookie.";
        }

        @Override
        String getUsage() {
            return "bookiesanity [-entries N] [-timeout N]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            SanityTestCommand command = new SanityTestCommand();
            SanityTestCommand.SanityFlags flags = new SanityTestCommand.SanityFlags();
            boolean result = command.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }
    }

    class SimpleTestCmd
    extends MyCommand {
        SimpleTestCmd() {
            super(BookieShell.CMD_SIMPLETEST);
            this.opts.addOption("e", "ensemble", true, "Ensemble size (default 3)");
            this.opts.addOption("w", "writeQuorum", true, "Write quorum size (default 2)");
            this.opts.addOption("a", "ackQuorum", true, "Ack quorum size (default 2)");
            this.opts.addOption("n", "numEntries", true, "Entries to write (default 1000)");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            int ensemble = BookieShell.getOptionIntValue(cmdLine, "ensemble", 3);
            int writeQuorum = BookieShell.getOptionIntValue(cmdLine, "writeQuorum", 2);
            int ackQuorum = BookieShell.getOptionIntValue(cmdLine, "ackQuorum", 2);
            int numEntries = BookieShell.getOptionIntValue(cmdLine, "numEntries", 1000);
            SimpleTestCommand.Flags flags = new SimpleTestCommand.Flags().ensembleSize(ensemble).writeQuorumSize(writeQuorum).ackQuorumSize(ackQuorum).numEntries(numEntries);
            SimpleTestCommand command = new SimpleTestCommand(flags);
            command.apply(BookieShell.this.bkConf, flags);
            return 0;
        }

        @Override
        String getDescription() {
            return "Simple test to create a ledger and write entries to it.";
        }

        @Override
        String getUsage() {
            return "simpletest   [-ensemble N] [-writeQuorum N] [-ackQuorum N] [-numEntries N]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class LocalConsistencyCheck
    extends MyCommand {
        LocalConsistencyCheck() {
            super(BookieShell.CMD_LOCALCONSISTENCYCHECK);
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            LocalConsistencyCheckCommand cmd = new LocalConsistencyCheckCommand();
            boolean result = cmd.apply(BookieShell.this.bkConf, new CliFlags());
            return result ? 0 : 1;
        }

        @Override
        String getDescription() {
            return "Validate Ledger Storage internal metadata";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_LOCALCONSISTENCYCHECK;
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class LedgerMetadataCmd
    extends MyCommand {
        LedgerMetadataCmd() {
            super(BookieShell.CMD_LEDGERMETADATA);
            this.opts.addOption("l", "ledgerid", true, "Ledger ID");
            this.opts.addOption("dumptofile", true, "Dump metadata for ledger, to a file");
            this.opts.addOption("restorefromfile", true, "Restore metadata for ledger, from a file");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            long ledgerId = BookieShell.this.getOptionLedgerIdValue(cmdLine, "ledgerid", -1L);
            if (ledgerId == -1L) {
                System.err.println("Must specify a ledger id");
                return -1;
            }
            if (cmdLine.hasOption("dumptofile") && cmdLine.hasOption("restorefromefile")) {
                System.err.println("Only one of --dumptofile and --restorefromfile can be specified");
                return -2;
            }
            LedgerMetaDataCommand.LedgerMetadataFlag flag = new LedgerMetaDataCommand.LedgerMetadataFlag();
            flag.ledgerId(ledgerId);
            if (cmdLine.hasOption("dumptofile")) {
                flag.dumpToFile(cmdLine.getOptionValue("dumptofile"));
            }
            if (cmdLine.hasOption("restorefromfile")) {
                flag.restoreFromFile(cmdLine.getOptionValue("restorefromfile"));
            }
            LedgerMetaDataCommand cmd = new LedgerMetaDataCommand(BookieShell.this.ledgerIdFormatter);
            cmd.apply(BookieShell.this.bkConf, flag);
            return 0;
        }

        @Override
        String getDescription() {
            return "Print the metadata for a ledger, or optionally dump to a file.";
        }

        @Override
        String getUsage() {
            return "ledgermetadata -ledgerid <ledgerid> [--dump-to-file FILENAME|--restore-from-file FILENAME]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ListActiveLedgersCmd
    extends MyCommand {
        ListActiveLedgersCmd() {
            super(BookieShell.CMD_ACTIVE_LEDGERS_ON_ENTRY_LOG_FILE);
            this.opts.addOption("l", "logId", true, "Entry log file id");
            this.opts.addOption("t", "timeout", true, "Read timeout(ms)");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            boolean hasTimeout = cmdLine.hasOption("t");
            boolean hasLogId = cmdLine.hasOption("l");
            if (!hasLogId) {
                this.printUsage();
                return -1;
            }
            long logId = Long.parseLong(cmdLine.getOptionValue("l"));
            ListActiveLedgersCommand.ActiveLedgerFlags flags = new ListActiveLedgersCommand.ActiveLedgerFlags();
            flags.logId(logId);
            if (hasTimeout) {
                flags.timeout(Long.parseLong(cmdLine.getOptionValue("t")));
            }
            ListActiveLedgersCommand cmd = new ListActiveLedgersCommand(BookieShell.this.ledgerIdFormatter);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }

        @Override
        String getDescription() {
            return "List all active ledgers on the entry log file.";
        }

        @Override
        String getUsage() {
            return "activeledgers  [-logId <entry log id>] [-timeout <timeout>] [-formatter <ledger id formatter>]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ListLedgersCmd
    extends MyCommand {
        ListLedgersCmd() {
            super(BookieShell.CMD_LISTLEDGERS);
            this.opts.addOption("m", "meta", false, "Print metadata");
            this.opts.addOption("bookieid", true, "List ledgers residing in this bookie");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            boolean printMeta = cmdLine.hasOption("m");
            String bookieidToBePartOfEnsemble = cmdLine.getOptionValue("bookieid");
            ListLedgersCommand.ListLedgersFlags flags = new ListLedgersCommand.ListLedgersFlags().bookieId(bookieidToBePartOfEnsemble).meta(printMeta);
            ListLedgersCommand cmd = new ListLedgersCommand(BookieShell.this.ledgerIdFormatter);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }

        @Override
        String getDescription() {
            return "List all ledgers on the cluster (this may take a long time).";
        }

        @Override
        String getUsage() {
            return "listledgers  [-meta] [-bookieid <bookieaddress>]";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class ListUnderreplicatedCmd
    extends MyCommand {
        public ListUnderreplicatedCmd() {
            super(BookieShell.CMD_LISTUNDERREPLICATED);
            this.opts.addOption("mr", "missingreplica", true, "Bookie Id of missing replica");
            this.opts.addOption("emr", "excludingmissingreplica", true, "Bookie Id of missing replica to ignore");
            this.opts.addOption("pmr", "printmissingreplica", false, "Whether to print missingreplicas list?");
            this.opts.addOption("prw", "printreplicationworkerid", false, "Whether to print replicationworkerid?");
            this.opts.addOption("c", "onlydisplayledgercount", false, "Only display underreplicated ledger count");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "List ledgers marked as underreplicated, with optional options to specify missingreplica (BookieId) and to exclude missingreplica.";
        }

        @Override
        String getUsage() {
            return "listunderreplicated [[-missingreplica <bookieaddress>] [-excludingmissingreplica <bookieaddress>]] [-printmissingreplica] [-printreplicationworkerid]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            String includingBookieId = cmdLine.getOptionValue("missingreplica");
            String excludingBookieId = cmdLine.getOptionValue("excludingmissingreplica");
            boolean printMissingReplica = cmdLine.hasOption("printmissingreplica");
            boolean printReplicationWorkerId = cmdLine.hasOption("printreplicationworkerid");
            boolean onlyDisplayLedgerCount = cmdLine.hasOption("onlydisplayledgercount");
            ListUnderReplicatedCommand.LURFlags flags = new ListUnderReplicatedCommand.LURFlags().missingReplica(includingBookieId).excludingMissingReplica(excludingBookieId).printMissingReplica(printMissingReplica).printReplicationWorkerId(printReplicationWorkerId).onlyDisplayLedgerCount(onlyDisplayLedgerCount);
            ListUnderReplicatedCommand cmd = new ListUnderReplicatedCommand(BookieShell.this.ledgerIdFormatter);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }
    }

    class ReadLedgerEntriesCmd
    extends MyCommand {
        ReadLedgerEntriesCmd() {
            super(BookieShell.CMD_READ_LEDGER_ENTRIES);
            this.opts.addOption("m", "msg", false, "Print message body");
            this.opts.addOption("l", "ledgerid", true, "Ledger ID");
            this.opts.addOption("fe", "firstentryid", true, "First EntryID");
            this.opts.addOption("le", "lastentryid", true, "Last EntryID");
            this.opts.addOption("r", "force-recovery", false, "Ensure the ledger is properly closed before reading");
            this.opts.addOption("b", "bookie", true, "Only read from a specific bookie");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Read a range of entries from a ledger.";
        }

        @Override
        String getUsage() {
            return "readledger  [-bookie <address:port>]  [-msg] -ledgerid <ledgerid> [-firstentryid <firstentryid> [-lastentryid <lastentryid>]] [-force-recovery]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            long ledgerId = BookieShell.this.getOptionLedgerIdValue(cmdLine, "ledgerid", -1L);
            long firstEntry = BookieShell.getOptionLongValue(cmdLine, "firstentryid", 0L);
            long lastEntry = BookieShell.getOptionLongValue(cmdLine, "lastentryid", -1L);
            boolean printMsg = cmdLine.hasOption("m");
            boolean forceRecovery = cmdLine.hasOption("r");
            String bookieAddress = cmdLine.hasOption("b") ? cmdLine.getOptionValue("b") : null;
            ReadLedgerCommand cmd = new ReadLedgerCommand(BookieShell.this.entryFormatter, BookieShell.this.ledgerIdFormatter);
            ReadLedgerCommand.ReadLedgerFlags flags = new ReadLedgerCommand.ReadLedgerFlags();
            flags.bookieAddresss(bookieAddress);
            flags.firstEntryId(firstEntry);
            flags.forceRecovery(forceRecovery);
            flags.lastEntryId(lastEntry);
            flags.ledgerId(ledgerId);
            flags.msg(printMsg);
            cmd.apply(BookieShell.this.bkConf, flags);
            return 0;
        }
    }

    class LedgerCmd
    extends MyCommand {
        LedgerCmd() {
            super(BookieShell.CMD_LEDGER);
            this.opts.addOption("m", "meta", false, "Print meta information");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            LedgerCommand cmd = new LedgerCommand(BookieShell.this.ledgerIdFormatter);
            cmd.setPrint(BookieShell.this::printInfoLine);
            LedgerCommand.LedgerFlags flags = new LedgerCommand.LedgerFlags();
            if (cmdLine.hasOption("m")) {
                flags.meta(true);
            }
            flags.ledgerId(Long.parseLong(cmdLine.getArgs()[0]));
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : 1;
        }

        @Override
        String getDescription() {
            return "Dump ledger index entries into readable format.";
        }

        @Override
        String getUsage() {
            return "ledger       [-m] <ledger_id>";
        }

        @Override
        Options getOptions() {
            return this.opts;
        }
    }

    class RecoverCmd
    extends MyCommand {
        public RecoverCmd() {
            super(BookieShell.CMD_RECOVER);
            this.opts.addOption("q", "query", false, "Query the ledgers that contain given bookies");
            this.opts.addOption("dr", "dryrun", false, "Printing the recovery plan w/o doing actual recovery");
            this.opts.addOption("f", "force", false, "Force recovery without confirmation");
            this.opts.addOption("l", BookieShell.CMD_LEDGER, true, "Recover a specific ledger");
            this.opts.addOption("sk", "skipOpenLedgers", false, "Skip recovering open ledgers");
            this.opts.addOption("d", "deleteCookie", false, "Delete cookie node for the bookie.");
            this.opts.addOption("sku", "skipUnrecoverableLedgers", false, "Skip unrecoverable ledgers.");
            this.opts.addOption("rate", "replicationRate", false, "Replication rate by bytes");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Recover the ledger data for failed bookie.";
        }

        @Override
        String getUsage() {
            return "recover [-deleteCookie] <bookieSrc[,bookieSrc,...]>";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            String[] args = cmdLine.getArgs();
            if (args.length < 1) {
                throw new MissingArgumentException("'bookieSrc' argument required");
            }
            if (args.length > 1) {
                System.err.println("The provided bookie dest " + args[1] + " will be ignored!");
            }
            boolean query = cmdLine.hasOption("q");
            boolean dryrun = cmdLine.hasOption("dr");
            boolean force = cmdLine.hasOption("f");
            boolean skipOpenLedgers = cmdLine.hasOption("sk");
            boolean removeCookies = !dryrun && cmdLine.hasOption("d");
            boolean skipUnrecoverableLedgers = cmdLine.hasOption("sku");
            Long ledgerId = BookieShell.this.getOptionLedgerIdValue(cmdLine, BookieShell.CMD_LEDGER, -1L);
            int replicationRate = BookieShell.getOptionIntValue(cmdLine, "replicationRate", -1);
            RecoverCommand cmd = new RecoverCommand();
            RecoverCommand.RecoverFlags flags = new RecoverCommand.RecoverFlags();
            flags.bookieAddress(args[0]);
            flags.deleteCookie(removeCookies);
            flags.dryRun(dryrun);
            flags.force(force);
            flags.ledger(ledgerId);
            flags.replicateRate(replicationRate);
            flags.skipOpenLedgers(skipOpenLedgers);
            flags.query(query);
            flags.skipUnrecoverableLedgers(skipUnrecoverableLedgers);
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : -1;
        }
    }

    class InitBookieCmd
    extends MyCommand {
        public InitBookieCmd() {
            super(BookieShell.CMD_INITBOOKIE);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Initialize new Bookie";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_INITBOOKIE;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            InitCommand initCommand = new InitCommand();
            ServerConfiguration conf = new ServerConfiguration(BookieShell.this.bkConf);
            boolean result = initCommand.apply(conf, new CliFlags());
            return result ? 0 : 1;
        }
    }

    class BookieFormatCmd
    extends MyCommand {
        public BookieFormatCmd() {
            super(BookieShell.CMD_BOOKIEFORMAT);
            this.opts.addOption("n", "nonInteractive", false, "Whether to confirm if old data exists..?");
            this.opts.addOption("f", "force", false, "If [nonInteractive] is specified, then whether to force delete the old data without prompt..?");
            this.opts.addOption("d", "deleteCookie", false, "Delete its cookie on metadata store");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Format the current server contents.";
        }

        @Override
        String getUsage() {
            return "bookieformat [-nonInteractive] [-force] [-deleteCookie]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean interactive = !cmdLine.hasOption("n");
            boolean force = cmdLine.hasOption("f");
            boolean deletecookie = cmdLine.hasOption("d");
            FormatCommand.Flags flags = new FormatCommand.Flags().nonInteractive(interactive).force(force).deleteCookie(deletecookie);
            FormatCommand command = new FormatCommand(flags);
            boolean result = command.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : 1;
        }
    }

    class NukeExistingCluster
    extends MyCommand {
        NukeExistingCluster() {
            super(BookieShell.CMD_NUKEEXISTINGCLUSTER);
            this.opts.addOption("p", "zkledgersrootpath", true, "zookeeper ledgers rootpath");
            this.opts.addOption("i", "instanceid", true, "instanceid");
            this.opts.addOption("f", "force", false, "If instanceid is not specified, then whether to force nuke the metadata without validating instanceid");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Nuke bookkeeper cluster by deleting metadata";
        }

        @Override
        String getUsage() {
            return "nukeexistingcluster -zkledgersrootpath <zkledgersrootpath> [-instanceid <instanceid> | -force]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean force = cmdLine.hasOption("f");
            String zkledgersrootpath = cmdLine.getOptionValue("zkledgersrootpath");
            String instanceid = cmdLine.getOptionValue("instanceid");
            NukeExistingClusterCommand cmd = new NukeExistingClusterCommand();
            NukeExistingClusterCommand.NukeExistingClusterFlags flags = new NukeExistingClusterCommand.NukeExistingClusterFlags().force(force).zkLedgersRootPath(zkledgersrootpath).instandId(instanceid);
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : 1;
        }
    }

    class InitNewCluster
    extends MyCommand {
        InitNewCluster() {
            super(BookieShell.CMD_INITNEWCLUSTER);
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Initializes a new bookkeeper cluster. If initnewcluster fails then try nuking existing cluster by running nukeexistingcluster before running initnewcluster again";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_INITNEWCLUSTER;
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            org.apache.bookkeeper.tools.cli.commands.bookies.InitCommand initCommand = new org.apache.bookkeeper.tools.cli.commands.bookies.InitCommand();
            boolean result = initCommand.apply(BookieShell.this.bkConf, new CliFlags());
            return result ? 0 : 1;
        }
    }

    class MetaFormatCmd
    extends MyCommand {
        MetaFormatCmd() {
            super(BookieShell.CMD_METAFORMAT);
            this.opts.addOption("n", "nonInteractive", false, "Whether to confirm if old data exists..?");
            this.opts.addOption("f", "force", false, "If [nonInteractive] is specified, then whether to force delete the old data without prompt.");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Format bookkeeper metadata in zookeeper.";
        }

        @Override
        String getUsage() {
            return "metaformat   [-nonInteractive] [-force]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean interactive = !cmdLine.hasOption("n");
            boolean force = cmdLine.hasOption("f");
            MetaFormatCommand cmd = new MetaFormatCommand();
            MetaFormatCommand.MetaFormatFlags flags = new MetaFormatCommand.MetaFormatFlags().interactive(interactive).force(force);
            boolean result = cmd.apply(BookieShell.this.bkConf, flags);
            return result ? 0 : 1;
        }
    }

    abstract class MyCommand
    implements Command {
        String cmdName;
        Options opts;

        abstract Options getOptions();

        abstract String getDescription();

        abstract String getUsage();

        abstract int runCmd(CommandLine var1) throws Exception;

        MyCommand(String cmdName) {
            this.cmdName = cmdName;
            this.opts = this.getOptionsWithHelp();
        }

        @Override
        public String description() {
            return this.getUsage();
        }

        @Override
        public int runCmd(String[] args) throws Exception {
            try {
                BasicParser parser = new BasicParser();
                CommandLine cmdLine = parser.parse(this.getOptions(), args);
                if (cmdLine.hasOption(BookieShell.CMD_HELP)) {
                    this.printUsage();
                    return 0;
                }
                return this.runCmd(cmdLine);
            }
            catch (ParseException e) {
                LOG.error("Error parsing command line arguments : ", (Throwable)e);
                this.printUsage();
                return -1;
            }
        }

        @Override
        public void printUsage() {
            HelpFormatter hf = new HelpFormatter();
            System.err.println(this.cmdName + ": " + this.getDescription());
            hf.printHelp(this.getUsage(), this.getOptions());
        }

        private Options getOptionsWithHelp() {
            Options opts = new Options();
            opts.addOption("h", BookieShell.CMD_HELP, false, "Show the help");
            return opts;
        }
    }

    @InterfaceAudience.Private
    public static interface Command {
        public int runCmd(String[] var1) throws Exception;

        public String description();

        public void printUsage();
    }
}

