/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.http.vertx;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.http.AbstractHttpHandlerFactory;
import org.apache.bookkeeper.http.HttpRouter;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.HttpServiceProvider;
import org.apache.bookkeeper.http.vertx.VertxAbstractHandler;
import org.apache.bookkeeper.http.vertx.VertxHttpHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxHttpServer
implements HttpServer {
    static final Logger LOG = LoggerFactory.getLogger(VertxHttpServer.class);
    private Vertx vertx = Vertx.vertx();
    private boolean isRunning;
    private HttpServiceProvider httpServiceProvider;
    private int listeningPort = -1;

    int getListeningPort() {
        return this.listeningPort;
    }

    public void initialize(HttpServiceProvider httpServiceProvider) {
        this.httpServiceProvider = httpServiceProvider;
    }

    public boolean startServer(final int port) {
        final CompletableFuture future = new CompletableFuture();
        VertxHttpHandlerFactory handlerFactory = new VertxHttpHandlerFactory(this.httpServiceProvider);
        final Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)BodyHandler.create((boolean)false));
        HttpRouter<VertxAbstractHandler> requestRouter = new HttpRouter<VertxAbstractHandler>((AbstractHttpHandlerFactory)handlerFactory){

            public void bindHandler(String endpoint, VertxAbstractHandler handler) {
                router.get(endpoint).handler((Handler)handler);
                router.put(endpoint).handler((Handler)handler);
                router.post(endpoint).handler((Handler)handler);
                router.delete(endpoint).handler((Handler)handler);
            }
        };
        requestRouter.bindAll();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                LOG.info("Starting Vertx HTTP server on port {}", (Object)port);
                this.vertx.createHttpServer().requestHandler((Handler)router).listen(port, future::complete);
            }
        });
        try {
            AsyncResult asyncResult = (AsyncResult)future.get();
            if (asyncResult.succeeded()) {
                LOG.info("Vertx Http server started successfully");
                this.listeningPort = ((io.vertx.core.http.HttpServer)asyncResult.result()).actualPort();
                this.isRunning = true;
                return true;
            }
            LOG.error("Failed to start org.apache.bookkeeper.http server on port {}", (Object)port, (Object)asyncResult.cause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.error("Failed to start org.apache.bookkeeper.http server on port {}", (Object)port, (Object)ie);
        }
        catch (ExecutionException e) {
            LOG.error("Failed to start org.apache.bookkeeper.http server on port {}", (Object)port, (Object)e);
        }
        return false;
    }

    public void stopServer() {
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        try {
            this.httpServiceProvider.close();
        }
        catch (IOException ioe) {
            LOG.error("Error while close httpServiceProvider", (Throwable)ioe);
        }
        this.vertx.close(asyncResult -> {
            this.isRunning = false;
            shutdownLatch.countDown();
            LOG.info("HTTP server is shutdown");
        });
        try {
            shutdownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while shutting down org.apache.bookkeeper.http server");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

