/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.watch.WatchManager;
import org.apache.zookeeper.server.watch.WatcherMode;
import org.apache.zookeeper.server.watch.WatcherModeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecursiveWatchQtyTest {
    private WatchManager watchManager;
    private static final int clientQty = 25;
    private static final int iterations = 1000;

    @Before
    public void setup() {
        this.watchManager = new WatchManager();
    }

    @Test
    public void testRecursiveQty() {
        WatcherModeManager manager = new WatcherModeManager();
        DummyWatcher watcher = new DummyWatcher();
        manager.setWatcherMode((Watcher)watcher, "/a", WatcherMode.DEFAULT_WATCHER_MODE);
        Assert.assertEquals((long)0L, (long)manager.getRecursiveQty());
        manager.setWatcherMode((Watcher)watcher, "/a", WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)1L, (long)manager.getRecursiveQty());
        manager.setWatcherMode((Watcher)watcher, "/a/b", WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)2L, (long)manager.getRecursiveQty());
        manager.setWatcherMode((Watcher)watcher, "/a", WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)2L, (long)manager.getRecursiveQty());
        manager.setWatcherMode((Watcher)watcher, "/a/b", WatcherMode.PERSISTENT);
        Assert.assertEquals((long)1L, (long)manager.getRecursiveQty());
        manager.setWatcherMode((Watcher)watcher, "/a/b", WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)2L, (long)manager.getRecursiveQty());
        manager.setWatcherMode((Watcher)watcher, "/a/b", WatcherMode.DEFAULT_WATCHER_MODE);
        Assert.assertEquals((long)1L, (long)manager.getRecursiveQty());
        manager.setWatcherMode((Watcher)watcher, "/a", WatcherMode.PERSISTENT);
        Assert.assertEquals((long)0L, (long)manager.getRecursiveQty());
    }

    @Test
    public void testAddRemove() {
        DummyWatcher watcher1 = new DummyWatcher();
        DummyWatcher watcher2 = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/b", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)2L, (long)this.watchManager.getRecursiveWatchQty());
        Assert.assertTrue((boolean)this.watchManager.removeWatcher("/a", (Watcher)watcher1));
        Assert.assertTrue((boolean)this.watchManager.removeWatcher("/b", (Watcher)watcher2));
        Assert.assertEquals((long)0L, (long)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testAddRemoveAlt() {
        DummyWatcher watcher1 = new DummyWatcher();
        DummyWatcher watcher2 = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/b", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)2L, (long)this.watchManager.getRecursiveWatchQty());
        this.watchManager.removeWatcher((Watcher)watcher1);
        this.watchManager.removeWatcher((Watcher)watcher2);
        Assert.assertEquals((long)0L, (long)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testDoubleAdd() {
        DummyWatcher watcher = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)1L, (long)this.watchManager.getRecursiveWatchQty());
        this.watchManager.removeWatcher((Watcher)watcher);
        Assert.assertEquals((long)0L, (long)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testSameWatcherMultiPath() {
        DummyWatcher watcher = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/a/b", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/a/b/c", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)3L, (long)this.watchManager.getRecursiveWatchQty());
        Assert.assertTrue((boolean)this.watchManager.removeWatcher("/a/b", (Watcher)watcher));
        Assert.assertEquals((long)2L, (long)this.watchManager.getRecursiveWatchQty());
        this.watchManager.removeWatcher((Watcher)watcher);
        Assert.assertEquals((long)0L, (long)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testChangeType() {
        DummyWatcher watcher = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT);
        Assert.assertEquals((long)0L, (long)this.watchManager.getRecursiveWatchQty());
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        Assert.assertEquals((long)1L, (long)this.watchManager.getRecursiveWatchQty());
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.STANDARD);
        Assert.assertEquals((long)0L, (long)this.watchManager.getRecursiveWatchQty());
        Assert.assertTrue((boolean)this.watchManager.removeWatcher("/a", (Watcher)watcher));
        Assert.assertEquals((long)0L, (long)this.watchManager.getRecursiveWatchQty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecursiveQtyConcurrency() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        WatcherModeManager manager = new WatcherModeManager();
        ExecutorService threadPool = Executors.newFixedThreadPool(25);
        List<Future> tasks = null;
        CountDownLatch completedLatch = new CountDownLatch(25);
        try {
            tasks = IntStream.range(0, 25).mapToObj(__ -> threadPool.submit(() -> this.iterate(manager, completedLatch))).collect(Collectors.toList());
            try {
                completedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            if (tasks != null) {
                tasks.forEach(t -> t.cancel(true));
            }
            threadPool.shutdownNow();
        }
        int expectedRecursiveQty = (int)manager.getWatcherModes().values().stream().filter(mode -> mode == WatcherMode.PERSISTENT_RECURSIVE).count();
        Assert.assertEquals((long)expectedRecursiveQty, (long)manager.getRecursiveQty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterate(WatcherModeManager manager, CountDownLatch completedLatch) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            for (int i = 0; i < 1000; ++i) {
                boolean doSet;
                String path = "/" + random.nextInt(25);
                boolean bl = doSet = random.nextInt(100) > 33;
                if (doSet) {
                    WatcherMode mode = WatcherMode.values()[random.nextInt(WatcherMode.values().length)];
                    manager.setWatcherMode((Watcher)new DummyWatcher(), path, mode);
                } else {
                    manager.removeWatcher((Watcher)new DummyWatcher(), path);
                }
                int sleepMillis = random.nextInt(2);
                if (sleepMillis <= 0) continue;
                try {
                    Thread.sleep(sleepMillis);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            completedLatch.countDown();
        }
    }

    private static class DummyWatcher
    implements Watcher {
        private DummyWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

