/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.BlueThrottle;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueThrottleTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BlueThrottleTest.class);
    private static final int RAPID_TIMEOUT = 10000;
    private QuorumUtil quorumUtil = new QuorumUtil(1);
    private ClientBase.CountdownWatcher[] watchers;
    private ZooKeeper[] zks;

    @Test
    public void testThrottleDisabled() {
        BlueThrottle throttler = new BlueThrottle();
        Assert.assertTrue((String)"Throttle should be disabled by default", (boolean)throttler.checkLimit(1));
    }

    @Test
    public void testThrottleWithoutRefill() {
        BlueThrottle throttler = new BlueThrottle();
        throttler.setMaxTokens(1);
        throttler.setFillTime(2000);
        Assert.assertTrue((String)"First request should be allowed", (boolean)throttler.checkLimit(1));
        Assert.assertFalse((String)"Second request should be denied", (boolean)throttler.checkLimit(1));
    }

    @Test
    public void testThrottleWithRefill() throws InterruptedException {
        BlueThrottle throttler = new BlueThrottle();
        throttler.setMaxTokens(1);
        throttler.setFillTime(500);
        Assert.assertTrue((String)"First request should be allowed", (boolean)throttler.checkLimit(1));
        Assert.assertFalse((String)"Second request should be denied", (boolean)throttler.checkLimit(1));
        Thread.sleep(750L);
        Assert.assertTrue((String)"Third request should be allowed since we've got a new token", (boolean)throttler.checkLimit(1));
    }

    @Test
    public void testThrottleWithoutRandomDropping() throws InterruptedException {
        int i;
        int maxTokens = 5;
        BlueThrottleWithMockRandom throttler = new BlueThrottleWithMockRandom(new MockRandom());
        throttler.setMaxTokens(maxTokens);
        throttler.setFillCount(maxTokens);
        throttler.setFillTime(1000);
        for (i = 0; i < maxTokens; ++i) {
            throttler.checkLimit(1);
        }
        Assert.assertEquals((String)"All tokens should be used up by now", (long)throttler.getMaxTokens(), (long)throttler.getDeficit());
        Thread.sleep(110L);
        throttler.checkLimit(1);
        Assert.assertFalse((String)"Dropping probability should still be zero", (throttler.getDropChance() > 0.0 ? 1 : 0) != 0);
        Thread.sleep(1500L);
        for (i = 0; i < maxTokens; ++i) {
            Assert.assertTrue((String)("The first " + maxTokens + " requests should be allowed"), (boolean)throttler.checkLimit(1));
        }
        for (i = 0; i < maxTokens; ++i) {
            Assert.assertFalse((String)("The latter " + maxTokens + " requests should be denied"), (boolean)throttler.checkLimit(1));
        }
    }

    @Test
    public void testThrottleWithRandomDropping() throws InterruptedException {
        int i;
        int maxTokens = 5;
        BlueThrottleWithMockRandom throttler = new BlueThrottleWithMockRandom(new MockRandom());
        throttler.setMaxTokens(maxTokens);
        throttler.setFillCount(maxTokens);
        throttler.setFillTime(1000);
        throttler.setFreezeTime(100);
        throttler.setDropIncrease(0.5);
        for (int i2 = 0; i2 < maxTokens; ++i2) {
            throttler.checkLimit(1);
        }
        Assert.assertEquals((String)"All tokens should be used up by now", (long)throttler.getMaxTokens(), (long)throttler.getDeficit());
        Thread.sleep(120L);
        throttler.checkLimit(1);
        Assert.assertTrue((String)"Dropping probability should be increased", (throttler.getDropChance() > 0.0 ? 1 : 0) != 0);
        LOG.info("Dropping probability is {}", (Object)throttler.getDropChance());
        Thread.sleep(1100L);
        LOG.info("Bucket is refilled with {} tokens.", (Object)maxTokens);
        int accepted = 0;
        for (i = 0; i < maxTokens; ++i) {
            if (!throttler.checkLimit(1)) continue;
            ++accepted;
        }
        LOG.info("Send {} requests, {} are accepted", (Object)maxTokens, (Object)accepted);
        Assert.assertTrue((String)"The dropping should be distributed", (accepted < maxTokens ? 1 : 0) != 0);
        accepted = 0;
        for (i = 0; i < maxTokens; ++i) {
            if (!throttler.checkLimit(1)) continue;
            ++accepted;
        }
        LOG.info("Send another {} requests, {} are accepted", (Object)maxTokens, (Object)accepted);
        Assert.assertTrue((String)"Later requests should have a chance", (accepted > 0 ? 1 : 0) != 0);
    }

    private int connect(int n) throws Exception {
        String connStr = this.quorumUtil.getConnectionStringForServer(1);
        int connected = 0;
        this.zks = new ZooKeeper[n];
        this.watchers = new ClientBase.CountdownWatcher[n];
        for (int i = 0; i < n; ++i) {
            this.watchers[i] = new ClientBase.CountdownWatcher();
            this.zks[i] = new ZooKeeper(connStr, 3000, (Watcher)this.watchers[i]);
            try {
                this.watchers[i].waitForConnected(10000L);
                ++connected;
                continue;
            }
            catch (TimeoutException e) {
                LOG.info("Connection denied by the throttler due to insufficient tokens");
                break;
            }
        }
        return connected;
    }

    private void shutdownQuorum() throws Exception {
        for (ZooKeeper zk : this.zks) {
            if (zk == null) continue;
            zk.close();
        }
        this.quorumUtil.shutdownAll();
    }

    @Test
    public void testNoThrottling() throws Exception {
        this.quorumUtil.startAll();
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setMaxTokens(0);
        int connected = this.connect(10);
        Assert.assertEquals((long)10L, (long)connected);
        this.shutdownQuorum();
    }

    @Test
    public void testThrottling() throws Exception {
        this.quorumUtil.enableLocalSession(true);
        this.quorumUtil.startAll();
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setMaxTokens(2);
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setFillCount(0);
        int connected = this.connect(3);
        Assert.assertEquals((long)2L, (long)connected);
        this.shutdownQuorum();
        this.quorumUtil.enableLocalSession(false);
        this.quorumUtil.startAll();
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setMaxTokens(2);
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setFillCount(0);
        connected = this.connect(3);
        Assert.assertEquals((long)2L, (long)connected);
        this.shutdownQuorum();
    }

    @Test
    public void testWeighedThrottling() throws Exception {
        BlueThrottle.setConnectionWeightEnabled((boolean)true);
        this.quorumUtil.enableLocalSession(true);
        this.quorumUtil.startAll();
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setMaxTokens(10);
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setFillCount(0);
        int connected = this.connect(11);
        Assert.assertEquals((long)10L, (long)connected);
        this.shutdownQuorum();
        this.quorumUtil.enableLocalSession(false);
        this.quorumUtil.startAll();
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setMaxTokens(10);
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setFillCount(0);
        connected = this.connect(11);
        Assert.assertEquals((long)3L, (long)connected);
        this.shutdownQuorum();
        this.quorumUtil.startAll();
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setMaxTokens(10);
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setFillCount(0);
        connected = this.connect(2);
        Assert.assertEquals((long)2L, (long)connected);
        this.quorumUtil.shutdown(1);
        this.watchers[0].waitForDisconnected(10000L);
        this.watchers[1].waitForDisconnected(10000L);
        this.quorumUtil.restart(1);
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setMaxTokens(3);
        this.quorumUtil.getPeer((int)1).peer.getActiveServer().connThrottle().setFillCount(0);
        int reconnected = 0;
        for (int i = 0; i < 2; ++i) {
            try {
                this.watchers[i].waitForConnected(10000L);
                ++reconnected;
                continue;
            }
            catch (TimeoutException e) {
                LOG.info("One reconnect fails due to insufficient tokens");
            }
        }
        LOG.info("reconnected {}", (Object)reconnected);
        Assert.assertEquals((long)1L, (long)reconnected);
        this.shutdownQuorum();
    }

    class BlueThrottleWithMockRandom
    extends BlueThrottle {
        public BlueThrottleWithMockRandom(MockRandom random) {
            this.rng = random;
            random.throttle = this;
        }
    }

    class MockRandom
    extends Random {
        int flag = 0;
        BlueThrottle throttle;

        MockRandom() {
        }

        @Override
        public double nextDouble() {
            if (this.throttle.getDropChance() > 0.0) {
                this.flag = 1 - this.flag;
                return this.flag;
            }
            return 1.0;
        }
    }
}

