/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.table;

import com.google.common.util.concurrent.RateLimiter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.tools.perf.table.BenchmarkTask;
import org.apache.bookkeeper.tools.perf.table.KeyGenerator;
import org.apache.bookkeeper.tools.perf.table.PerfClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IncrementTask
extends BenchmarkTask {
    private static final Logger log = LoggerFactory.getLogger(IncrementTask.class);
    protected final RateLimiter limiter;
    protected final Semaphore semaphore;
    protected final PerfClient.OpStats writeOpStats;

    IncrementTask(Table<ByteBuf, ByteBuf> table, int tid, long randSeed, long numRecords, long keyRange, PerfClient.Flags flags, KeyGenerator generator, RateLimiter limiter, Semaphore semaphore) {
        super(table, tid, randSeed, numRecords, keyRange, flags, generator);
        this.limiter = limiter;
        this.semaphore = semaphore;
        this.writeOpStats = new PerfClient.OpStats(PerfClient.OP.INC.name());
    }

    @Override
    protected void runTask() throws Exception {
        for (long i = 0L; i < this.numRecords; ++i) {
            if (null != this.semaphore) {
                this.semaphore.acquire();
            }
            if (null != this.limiter) {
                this.limiter.acquire();
            }
            this.incKey(i);
        }
    }

    protected abstract void getKey(ByteBuf var1, long var2, long var4);

    void incKey(long i) {
        ByteBuf keyBuf = PooledByteBufAllocator.DEFAULT.heapBuffer(this.flags.keySize);
        this.getKey(keyBuf, i, this.keyRange);
        keyBuf.writerIndex(keyBuf.readerIndex() + keyBuf.writableBytes());
        long startTime = System.nanoTime();
        this.table.increment((Object)keyBuf, 100L).whenComplete((result, cause) -> {
            if (null != this.semaphore) {
                this.semaphore.release();
            }
            if (null != cause) {
                log.error("Error at increment key/amount", cause);
            } else {
                long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime);
                this.writeOpStats.recordOp(latencyMicros);
            }
            ReferenceCountUtil.safeRelease((Object)keyBuf);
        });
    }

    @Override
    protected void reportStats(long oldTime) {
        this.writeOpStats.reportStats(oldTime);
    }

    @Override
    protected void printAggregatedStats() {
        this.writeOpStats.printAggregatedStats();
    }
}

