/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DummyWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.Commands;
import org.apache.zookeeper.server.quorum.DelayRequestProcessor;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.util.PortForwarder;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ObserverMasterTest
extends QuorumPeerTestBase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(ObserverMasterTest.class);
    private Boolean testObserverMaster;
    private CountDownLatch latch;
    ZooKeeper zk;
    private WatchedEvent lastEvent = null;
    private int CLIENT_PORT_QP1;
    private int CLIENT_PORT_QP2;
    private int CLIENT_PORT_OBS;
    private int OM_PORT;
    private QuorumPeerTestBase.MainThread q1;
    private QuorumPeerTestBase.MainThread q2;
    private QuorumPeerTestBase.MainThread q3;

    public ObserverMasterTest(Boolean testObserverMaster) {
        this.testObserverMaster = testObserverMaster;
    }

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({Boolean.TRUE}, {Boolean.FALSE});
    }

    private PortForwarder setUp(int omProxyPort) throws IOException {
        String extraCfgs;
        ClientBase.setupTestEnv();
        int PORT_QP1 = PortAssignment.unique();
        int PORT_QP2 = PortAssignment.unique();
        int PORT_OBS = PortAssignment.unique();
        int PORT_QP_LE1 = PortAssignment.unique();
        int PORT_QP_LE2 = PortAssignment.unique();
        int PORT_OBS_LE = PortAssignment.unique();
        this.CLIENT_PORT_QP1 = PortAssignment.unique();
        this.CLIENT_PORT_QP2 = PortAssignment.unique();
        this.CLIENT_PORT_OBS = PortAssignment.unique();
        this.OM_PORT = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PORT_QP1 + ":" + PORT_QP_LE1 + ";" + this.CLIENT_PORT_QP1 + "\nserver.2=127.0.0.1:" + PORT_QP2 + ":" + PORT_QP_LE2 + ";" + this.CLIENT_PORT_QP2 + "\nserver.3=127.0.0.1:" + PORT_OBS + ":" + PORT_OBS_LE + ":observer;" + this.CLIENT_PORT_OBS;
        String string = extraCfgs = this.testObserverMaster != false ? String.format("observerMasterPort=%d%n", this.OM_PORT) : "";
        String extraCfgsObs = this.testObserverMaster != false ? String.format("observerMasterPort=%d%n", omProxyPort <= 0 ? this.OM_PORT : omProxyPort) : "";
        PortForwarder forwarder = null;
        if (this.testObserverMaster.booleanValue() && omProxyPort >= 0) {
            forwarder = new PortForwarder(omProxyPort, this.OM_PORT);
        }
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.CLIENT_PORT_QP1, quorumCfgSection, extraCfgs);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.CLIENT_PORT_QP2, quorumCfgSection, extraCfgs);
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.CLIENT_PORT_OBS, quorumCfgSection, extraCfgsObs);
        this.q1.start();
        this.q2.start();
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        return forwarder;
    }

    private void shutdown() throws InterruptedException {
        LOG.info("Shutting down all servers");
        this.zk.close();
        this.q1.shutdown();
        this.q2.shutdown();
        this.q3.shutdown();
        Assert.assertTrue((String)"Waiting for server 1 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Waiting for server 2 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Waiting for server 3 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
    }

    @Test
    public void testLaggingObserverMaster() throws Exception {
        QuorumPeerTestBase.MainThread follower;
        QuorumPeerTestBase.MainThread leader;
        int leaderPort;
        int OM_PROXY_PORT = PortAssignment.unique();
        PortForwarder forwarder = this.setUp(OM_PROXY_PORT);
        if (this.q1.getQuorumPeer().leader != null) {
            leaderPort = this.CLIENT_PORT_QP1;
            leader = this.q1;
            follower = this.q2;
        } else if (this.q2.getQuorumPeer().leader != null) {
            leaderPort = this.CLIENT_PORT_QP2;
            leader = this.q2;
            follower = this.q1;
        } else {
            throw new RuntimeException("No leader");
        }
        this.zk = new ZooKeeper("127.0.0.1:" + leaderPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        for (int i = 0; i < 10; ++i) {
            this.zk.create("/bulk" + i, "initial data of some size".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        this.zk.close();
        this.q3.start();
        Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        this.latch = new CountDownLatch(1);
        this.zk = new ZooKeeper("127.0.0.1:" + leaderPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        Assert.assertEquals((Object)this.zk.getState(), (Object)ZooKeeper.States.CONNECTED);
        this.zk.create("/init", "first".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final long lastLoggedZxid = leader.getQuorumPeer().getLastLoggedZxid();
        this.waitFor("Timeout waiting for observer sync", new ZKTestCase.WaitForCondition(){

            @Override
            public boolean evaluate() {
                return lastLoggedZxid == ObserverMasterTest.this.q3.getQuorumPeer().getLastLoggedZxid();
            }
        }, 30);
        if (forwarder != null) {
            forwarder.shutdown();
        }
        for (int i = 0; i < 10; ++i) {
            this.zk.create("/basic" + i, "second".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        DelayRequestProcessor delayRequestProcessor = null;
        if (this.testObserverMaster.booleanValue()) {
            FollowerZooKeeperServer followerZooKeeperServer = (FollowerZooKeeperServer)follower.getQuorumPeer().getActiveServer();
            delayRequestProcessor = DelayRequestProcessor.injectDelayRequestProcessor(followerZooKeeperServer);
        }
        this.zk.create("/target1", "third".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/target2", "third".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LOG.info("observer zxid {}{} leader zxid {}", new Object[]{Long.toHexString(this.q3.getQuorumPeer().getLastLoggedZxid()), this.testObserverMaster != false ? "" : " observer master zxid " + Long.toHexString(follower.getQuorumPeer().getLastLoggedZxid()), Long.toHexString(leader.getQuorumPeer().getLastLoggedZxid())});
        forwarder = this.testObserverMaster != false ? new PortForwarder(OM_PROXY_PORT, this.OM_PORT) : null;
        Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertNotNull((String)"Leader switched", (Object)leader.getQuorumPeer().leader);
        if (delayRequestProcessor != null) {
            delayRequestProcessor.unblockQueue();
        }
        this.latch = new CountDownLatch(1);
        ZooKeeper obsZk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        this.zk.create("/finalop", "fourth".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)"first", (Object)new String(obsZk.getData("/init", null, null)));
        Assert.assertEquals((Object)"third", (Object)new String(obsZk.getData("/target1", null, null)));
        obsZk.close();
        this.shutdown();
        try {
            if (forwarder != null) {
                forwarder.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testObserver() throws Exception {
        this.latch = new CountDownLatch(2);
        this.setUp(-1);
        this.q3.start();
        Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        if (this.testObserverMaster.booleanValue()) {
            int masterPort = this.q3.getQuorumPeer().observer.getSocket().getPort();
            LOG.info("port {} {}", (Object)masterPort, (Object)this.OM_PORT);
            Assert.assertEquals((String)"observer failed to connect to observer master", (long)masterPort, (long)this.OM_PORT);
        }
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.zk.create("/obstest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(this.zk.getData("/obstest", null, null)), (Object)"test");
        this.zk.sync("/", null, null);
        this.zk.setData("/obstest", "test2".getBytes(), -1);
        this.zk.getChildren("/", false);
        Assert.assertEquals((Object)this.zk.getState(), (Object)ZooKeeper.States.CONNECTED);
        LOG.info("Shutting down server 2");
        this.q2.shutdown();
        Assert.assertTrue((String)"Waiting for server 2 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        LOG.info("Server 2 down");
        this.latch.await();
        Assert.assertNotSame((String)"Client is still connected to non-quorate cluster", (Object)Watcher.Event.KeeperState.SyncConnected, (Object)this.lastEvent.getState());
        LOG.info("Latch returned");
        try {
            Assert.assertNotEquals((String)"Shouldn't get a response when cluster not quorate!", (Object)"test", (Object)new String(this.zk.getData("/obstest", null, null)));
        }
        catch (KeeperException.ConnectionLossException c) {
            LOG.info("Connection loss exception caught - ensemble not quorate (this is expected)");
        }
        this.latch = new CountDownLatch(1);
        LOG.info("Restarting server 2");
        this.q2.start();
        LOG.info("Waiting for server 2 to come up");
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        LOG.info("Server 2 started, waiting for latch");
        this.latch.await();
        Assert.assertTrue((String)("Client didn't reconnect to quorate ensemble (state was" + this.lastEvent.getState() + ")"), (Watcher.Event.KeeperState.SyncConnected == this.lastEvent.getState() || Watcher.Event.KeeperState.Expired == this.lastEvent.getState() ? 1 : 0) != 0);
        LOG.info("perform a revalidation test");
        int leaderProxyPort = PortAssignment.unique();
        int obsProxyPort = PortAssignment.unique();
        int leaderPort = this.q1.getQuorumPeer().leader == null ? this.CLIENT_PORT_QP2 : this.CLIENT_PORT_QP1;
        PortForwarder leaderPF = new PortForwarder(leaderProxyPort, leaderPort);
        this.latch = new CountDownLatch(1);
        ZooKeeper client = new ZooKeeper(String.format("127.0.0.1:%d,127.0.0.1:%d", leaderProxyPort, obsProxyPort), ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        client.create("/revalidtest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertNotNull((String)"Read-after write failed", (Object)client.exists("/revalidtest", null));
        this.latch = new CountDownLatch(2);
        PortForwarder obsPF = new PortForwarder(obsProxyPort, this.CLIENT_PORT_OBS);
        try {
            leaderPF.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.latch.await();
        Assert.assertEquals((Object)new String(client.getData("/revalidtest", null, null)), (Object)"test");
        client.close();
        obsPF.shutdown();
        this.shutdown();
    }

    @Test
    public void testRevalidation() throws Exception {
        this.setUp(-1);
        this.q3.start();
        Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        int leaderProxyPort = PortAssignment.unique();
        int obsProxyPort = PortAssignment.unique();
        int leaderPort = this.q1.getQuorumPeer().leader == null ? this.CLIENT_PORT_QP2 : this.CLIENT_PORT_QP1;
        PortForwarder leaderPF = new PortForwarder(leaderProxyPort, leaderPort);
        this.latch = new CountDownLatch(1);
        this.zk = new ZooKeeper(String.format("127.0.0.1:%d,127.0.0.1:%d", leaderProxyPort, obsProxyPort), ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        this.zk.create("/revalidtest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertNotNull((String)"Read-after write failed", (Object)this.zk.exists("/revalidtest", null));
        this.latch = new CountDownLatch(2);
        PortForwarder obsPF = new PortForwarder(obsProxyPort, this.CLIENT_PORT_OBS);
        try {
            leaderPF.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.latch.await();
        Assert.assertEquals((Object)new String(this.zk.getData("/revalidtest", null, null)), (Object)"test");
        obsPF.shutdown();
        this.shutdown();
    }

    @Test
    public void testInOrderCommits() throws Exception {
        this.setUp(-1);
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, null);
        for (int i = 0; i < 10; ++i) {
            this.zk.create("/bulk" + i, "Initial data of some size".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        this.zk.close();
        this.q3.start();
        Assert.assertTrue((String)"waiting for observer to be up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        this.latch = new CountDownLatch(1);
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        Assert.assertEquals((Object)this.zk.getState(), (Object)ZooKeeper.States.CONNECTED);
        this.zk.create("/init", "first".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final long zxid = this.q1.getQuorumPeer().getLastLoggedZxid();
        this.waitFor("Timeout waiting for observer sync", new ZKTestCase.WaitForCondition(){

            @Override
            public boolean evaluate() {
                return zxid == ObserverMasterTest.this.q3.getQuorumPeer().getLastLoggedZxid();
            }
        }, 30);
        ZooKeeper obsZk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        int followerPort = this.q1.getQuorumPeer().leader == null ? this.CLIENT_PORT_QP1 : this.CLIENT_PORT_QP2;
        ZooKeeper fZk = new ZooKeeper("127.0.0.1:" + followerPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        int numTransactions = 10001;
        CountDownLatch gate = new CountDownLatch(1);
        CountDownLatch oAsyncLatch = new CountDownLatch(10001);
        Thread oAsyncWriteThread = new Thread(new AsyncWriter(obsZk, 10001, true, oAsyncLatch, "/obs", gate));
        CountDownLatch fAsyncLatch = new CountDownLatch(10001);
        Thread fAsyncWriteThread = new Thread(new AsyncWriter(fZk, 10001, true, fAsyncLatch, "/follower", gate));
        LOG.info("ASYNC WRITES");
        oAsyncWriteThread.start();
        fAsyncWriteThread.start();
        gate.countDown();
        oAsyncLatch.await();
        fAsyncLatch.await();
        oAsyncWriteThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (oAsyncWriteThread.isAlive()) {
            LOG.error("asyncWriteThread is still alive");
        }
        fAsyncWriteThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (fAsyncWriteThread.isAlive()) {
            LOG.error("asyncWriteThread is still alive");
        }
        obsZk.close();
        fZk.close();
        this.shutdown();
    }

    @Test
    public void testAdminCommands() throws IOException, MBeanException, InstanceNotFoundException, ReflectionException, InterruptedException, MalformedObjectNameException, AttributeNotFoundException, InvalidAttributeValueException, KeeperException {
        for (ZKMBeanInfo beanInfo : MBeanRegistry.getInstance().getRegisteredBeans()) {
            MBeanRegistry.getInstance().unregister(beanInfo);
        }
        JMXEnv.setUp();
        this.setUp(-1);
        this.q3.start();
        Assert.assertTrue((String)"waiting for observer to be up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.zk.create("/obstest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)new String(this.zk.getData("/obstest", null, null)), (Object)"test");
        Map emptyMap = Collections.emptyMap();
        Map stats = Commands.runCommand((String)"mntr", (ZooKeeperServer)this.q3.getQuorumPeer().getActiveServer(), emptyMap).toMap();
        Assert.assertTrue((String)"observer not emitting observer_master_id", (boolean)stats.containsKey("observer_master_id"));
        if (this.testObserverMaster.booleanValue()) {
            if (this.q1.getQuorumPeer().leader == null) {
                Assert.assertEquals((Object)1, (Object)this.q1.getQuorumPeer().getSynced_observers_metric());
            } else {
                Assert.assertEquals((Object)0, (Object)this.q1.getQuorumPeer().getSynced_observers_metric());
            }
        } else if (this.q1.getQuorumPeer().leader == null) {
            Assert.assertNull((Object)this.q1.getQuorumPeer().getSynced_observers_metric());
        } else {
            Assert.assertEquals((Object)1, (Object)this.q1.getQuorumPeer().getSynced_observers_metric());
        }
        if (this.testObserverMaster.booleanValue()) {
            if (this.q2.getQuorumPeer().leader == null) {
                Assert.assertEquals((Object)1, (Object)this.q2.getQuorumPeer().getSynced_observers_metric());
            } else {
                Assert.assertEquals((Object)0, (Object)this.q2.getQuorumPeer().getSynced_observers_metric());
            }
        } else if (this.q2.getQuorumPeer().leader == null) {
            Assert.assertNull((Object)this.q2.getQuorumPeer().getSynced_observers_metric());
        } else {
            Assert.assertEquals((Object)1, (Object)this.q2.getQuorumPeer().getSynced_observers_metric());
        }
        ObjectName connBean = null;
        for (ObjectName bean : JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null)) {
            if (!bean.getCanonicalName().contains("Learner_Connections") || !bean.getCanonicalName().contains("id:" + this.q3.getQuorumPeer().getId())) continue;
            connBean = bean;
            break;
        }
        Assert.assertNotNull((String)"could not find connection bean", connBean);
        this.latch = new CountDownLatch(1);
        JMXEnv.conn().invoke(connBean, "terminateConnection", new Object[0], null);
        Assert.assertTrue((String)"server failed to disconnect on terminate", (boolean)this.latch.await(ClientBase.CONNECTION_TIMEOUT / 2, TimeUnit.MILLISECONDS));
        Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        String obsBeanName = String.format("org.apache.ZooKeeperService:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Observer", this.q3.getQuorumPeer().getId(), this.q3.getQuorumPeer().getId());
        Set<ObjectName> names = JMXEnv.conn().queryNames(new ObjectName(obsBeanName), null);
        Assert.assertEquals((String)"expecting singular observer bean", (long)1L, (long)names.size());
        ObjectName obsBean = names.iterator().next();
        if (this.testObserverMaster.booleanValue()) {
            long observerMasterId = this.q3.getQuorumPeer().observer.getLearnerMasterId();
            this.latch = new CountDownLatch(1);
            JMXEnv.conn().setAttribute(obsBean, new Attribute("LearnerMaster", Long.toString(3L - observerMasterId)));
            Assert.assertTrue((String)"server failed to disconnect on terminate", (boolean)this.latch.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
            Assert.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        } else {
            long leaderId = this.q1.getQuorumPeer().leader == null ? 2L : 1L;
            try {
                JMXEnv.conn().setAttribute(obsBean, new Attribute("LearnerMaster", Long.toString(3L - leaderId)));
                Assert.fail((String)"should have seen an exception on previous command");
            }
            catch (RuntimeMBeanException e) {
                Assert.assertEquals((String)"mbean failed for the wrong reason", IllegalArgumentException.class, e.getCause().getClass());
            }
        }
        this.shutdown();
        JMXEnv.tearDown();
    }

    private String createServerString(String type, long serverId, int clientPort) {
        return "server." + serverId + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":" + type + ";" + clientPort;
    }

    private void waitServerUp(int clientPort) {
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT));
    }

    private ZooKeeperAdmin createAdmin(int clientPort) throws IOException {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        ZooKeeperAdmin admin = new ZooKeeperAdmin("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        admin.addAuthInfo("digest", "super:test".getBytes());
        return admin;
    }

    public void testDynamicReconfig() throws InterruptedException, IOException, KeeperException {
        if (!this.testObserverMaster.booleanValue()) {
            return;
        }
        ClientBase.setupTestEnv();
        int clientPort1 = PortAssignment.unique();
        int clientPort2 = PortAssignment.unique();
        int omPort1 = PortAssignment.unique();
        int omPort2 = PortAssignment.unique();
        String quorumCfgSection = this.createServerString("participant", 1L, clientPort1) + "\n" + this.createServerString("participant", 2L, clientPort2);
        QuorumPeerTestBase.MainThread s1 = new QuorumPeerTestBase.MainThread(1, clientPort1, quorumCfgSection, String.format("observerMasterPort=%d%n", omPort1));
        QuorumPeerTestBase.MainThread s2 = new QuorumPeerTestBase.MainThread(2, clientPort2, quorumCfgSection, String.format("observerMasterPort=%d%n", omPort2));
        s1.start();
        s2.start();
        this.waitServerUp(clientPort1);
        this.waitServerUp(clientPort2);
        long nonLeaderOMPort = s1.getQuorumPeer().leader == null ? (long)omPort1 : (long)omPort2;
        int observerClientPort = PortAssignment.unique();
        int observerId = 10;
        QuorumPeerTestBase.MainThread observer = new QuorumPeerTestBase.MainThread(observerId, observerClientPort, quorumCfgSection + "\n" + this.createServerString("observer", observerId, observerClientPort), String.format("observerMasterPort=%d%n", nonLeaderOMPort));
        LOG.info("starting observer");
        observer.start();
        this.waitServerUp(observerClientPort);
        LinkedBlockingQueue states = new LinkedBlockingQueue();
        ZooKeeper observerClient = new ZooKeeper("127.0.0.1:" + observerClientPort, ClientBase.CONNECTION_TIMEOUT, event -> {
            try {
                states.put(event.getState());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Watcher.Event.KeeperState state = (Watcher.Event.KeeperState)states.poll(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)state);
        ArrayList<String> newServers = new ArrayList<String>();
        String server = "server.3=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + PortAssignment.unique();
        newServers.add(server);
        ZooKeeperAdmin admin = this.createAdmin(clientPort1);
        ReconfigTest.reconfig(admin, newServers, null, null, -1L);
        ReconfigTest.testServerHasConfig(observerClient, newServers, null);
        state = (Watcher.Event.KeeperState)states.poll(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)state);
        admin.close();
        observerClient.close();
        observer.shutdown();
        s2.shutdown();
        s1.shutdown();
    }

    @Override
    public void process(WatchedEvent event) {
        this.lastEvent = event;
        if (this.latch != null) {
            this.latch.countDown();
        }
        LOG.info("Latch got event :: {}", (Object)event);
    }

    class AsyncWriter
    implements Runnable {
        private final ZooKeeper client;
        private final int numTransactions;
        private final boolean issueSync;
        private final CountDownLatch writerLatch;
        private final String root;
        private final CountDownLatch gate;

        AsyncWriter(ZooKeeper client, int numTransactions, boolean issueSync, CountDownLatch writerLatch, String root, CountDownLatch gate) {
            this.client = client;
            this.numTransactions = numTransactions;
            this.issueSync = issueSync;
            this.writerLatch = writerLatch;
            this.root = root;
            this.gate = gate;
        }

        @Override
        public void run() {
            if (this.gate != null) {
                try {
                    this.gate.await();
                }
                catch (InterruptedException e) {
                    LOG.error("Gate interrupted");
                    return;
                }
            }
            for (int i = 0; i < this.numTransactions; ++i) {
                final boolean pleaseLog = i % 100 == 0;
                this.client.create(this.root + i, "inner thread".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        AsyncWriter.this.writerLatch.countDown();
                        if (pleaseLog) {
                            LOG.info("wrote {}", (Object)path);
                        }
                    }
                }, null);
                if (!pleaseLog) continue;
                LOG.info("async wrote {}{}", (Object)this.root, (Object)i);
                if (!this.issueSync) continue;
                this.client.sync(this.root + "0", null, null);
            }
        }
    }
}

