/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.zookeeper.server.persistence.SnapStream;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SnapStreamTest {
    @After
    public void tearDown() {
        System.clearProperty("zookeeper.snapshot.compression.method");
        SnapStream.setStreamMode((SnapStream.StreamMode)SnapStream.StreamMode.DEFAULT_MODE);
    }

    @Test
    public void testStreamMode() {
        Assert.assertEquals((Object)SnapStream.StreamMode.CHECKED.getName(), (Object)"");
        Assert.assertEquals((Object)SnapStream.StreamMode.CHECKED.getFileExtension(), (Object)"");
        Assert.assertEquals((Object)SnapStream.StreamMode.CHECKED, (Object)SnapStream.StreamMode.fromString((String)"name"));
        Assert.assertEquals((Object)SnapStream.StreamMode.GZIP.getName(), (Object)"gz");
        Assert.assertEquals((Object)SnapStream.StreamMode.GZIP.getFileExtension(), (Object)".gz");
        Assert.assertEquals((Object)SnapStream.StreamMode.GZIP, (Object)SnapStream.StreamMode.fromString((String)"gz"));
        Assert.assertEquals((Object)SnapStream.StreamMode.SNAPPY.getName(), (Object)"snappy");
        Assert.assertEquals((Object)SnapStream.StreamMode.SNAPPY.getFileExtension(), (Object)".snappy");
        Assert.assertEquals((Object)SnapStream.StreamMode.SNAPPY, (Object)SnapStream.StreamMode.fromString((String)"snappy"));
    }

    @Test
    public void testGetStreamMode() {
        Assert.assertEquals((String)"expected to return un-compressed stream", (Object)SnapStream.StreamMode.CHECKED, (Object)SnapStream.getStreamMode((String)"snapshot.180000e3a2"));
        Assert.assertEquals((String)"expected to return snappy stream", (Object)SnapStream.StreamMode.SNAPPY, (Object)SnapStream.getStreamMode((String)"snapshot.180000e3a2.snappy"));
        Assert.assertEquals((String)"expected to return gzip stream", (Object)SnapStream.StreamMode.GZIP, (Object)SnapStream.getStreamMode((String)"snapshot.180000e3a2.gz"));
    }

    @Test
    public void testSerializeDeserializeWithChecked() throws IOException {
        this.testSerializeDeserialize(SnapStream.StreamMode.CHECKED, "");
    }

    @Test
    public void testSerializeDeserializeWithSNAPPY() throws IOException {
        this.testSerializeDeserialize(SnapStream.StreamMode.SNAPPY, ".snappy");
    }

    @Test
    public void testSerializeDeserializeWithGZIP() throws IOException {
        this.testSerializeDeserialize(SnapStream.StreamMode.GZIP, ".gz");
    }

    private void testSerializeDeserialize(SnapStream.StreamMode mode, String fileSuffix) throws IOException {
        this.testSerializeDeserialize(mode, fileSuffix, false);
        this.testSerializeDeserialize(mode, fileSuffix, true);
    }

    private void testSerializeDeserialize(SnapStream.StreamMode mode, String fileSuffix, boolean fsync) throws IOException {
        SnapStream.setStreamMode((SnapStream.StreamMode)mode);
        File tmpDir = ClientBase.createTmpDir();
        File file = new File(tmpDir, "snapshot.180000e3a2" + fileSuffix);
        CheckedOutputStream os = SnapStream.getOutputStream((File)file, (boolean)fsync);
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)os);
        FileHeader header = new FileHeader(FileSnap.SNAP_MAGIC, 2, 1L);
        header.serialize((OutputArchive)oa, "fileheader");
        SnapStream.sealStream((CheckedOutputStream)os, (OutputArchive)oa);
        os.flush();
        os.close();
        Assert.assertTrue((boolean)SnapStream.isValidSnapshot((File)file));
        CheckedInputStream is = SnapStream.getInputStream((File)file);
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)is);
        FileHeader restoredHeader = new FileHeader();
        restoredHeader.deserialize((InputArchive)ia, "fileheader");
        Assert.assertEquals((String)"magic not the same", (Object)restoredHeader, (Object)header);
        SnapStream.checkSealIntegrity((CheckedInputStream)is, (InputArchive)ia);
    }

    private void checkInvalidSnapshot(String filename, boolean fsync) throws IOException {
        SnapStream.setStreamMode((SnapStream.StreamMode)SnapStream.StreamMode.CHECKED);
        File tmpDir = ClientBase.createTmpDir();
        File file = new File(tmpDir, filename);
        CheckedOutputStream os = SnapStream.getOutputStream((File)file, (boolean)fsync);
        ((OutputStream)os).write(1);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        Assert.assertFalse((boolean)SnapStream.isValidSnapshot((File)file));
    }

    private void checkInvalidSnapshot(String filename) throws IOException {
        this.checkInvalidSnapshot(filename, false);
        this.checkInvalidSnapshot(filename, true);
    }

    @Test
    public void testInvalidSnapshot() throws IOException {
        Assert.assertFalse((boolean)SnapStream.isValidSnapshot(null));
        this.checkInvalidSnapshot("snapshot.180000e3a2");
        this.checkInvalidSnapshot("snapshot.180000e3a2.gz");
        this.checkInvalidSnapshot("snapshot.180000e3a2.snappy");
    }
}

