/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.zookeeper;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZooWorker {
    private static final Logger logger = LoggerFactory.getLogger(ZooWorker.class);
    int attempts = 0;
    long startTimeNanos;
    long elapsedTimeMs = 0L;
    final RetryPolicy retryPolicy;
    final OpStatsLogger statsLogger;

    ZooWorker(RetryPolicy retryPolicy, OpStatsLogger statsLogger) {
        this.retryPolicy = retryPolicy;
        this.statsLogger = statsLogger;
        this.startTimeNanos = MathUtils.nowInNano();
    }

    public boolean allowRetry(int rc) {
        this.elapsedTimeMs = MathUtils.elapsedMSec((long)this.startTimeNanos);
        if (!ZooWorker.isRecoverableException(rc)) {
            if (KeeperException.Code.OK.intValue() == rc) {
                this.statsLogger.registerSuccessfulEvent(MathUtils.elapsedMicroSec((long)this.startTimeNanos), TimeUnit.MICROSECONDS);
            } else {
                this.statsLogger.registerFailedEvent(MathUtils.elapsedMicroSec((long)this.startTimeNanos), TimeUnit.MICROSECONDS);
            }
            return false;
        }
        ++this.attempts;
        return this.retryPolicy.allowRetry(this.attempts, this.elapsedTimeMs);
    }

    public long nextRetryWaitTime() {
        return this.retryPolicy.nextRetryWaitTime(this.attempts, this.elapsedTimeMs);
    }

    public static boolean isRecoverableException(int rc) {
        return KeeperException.Code.CONNECTIONLOSS.intValue() == rc || KeeperException.Code.OPERATIONTIMEOUT.intValue() == rc || KeeperException.Code.SESSIONMOVED.intValue() == rc || KeeperException.Code.SESSIONEXPIRED.intValue() == rc;
    }

    public static boolean isRecoverableException(KeeperException exception) {
        return ZooWorker.isRecoverableException(exception.code().intValue());
    }

    public static <T> T syncCallWithRetries(ZooKeeperClient client, ZooCallable<T> proc, RetryPolicy retryPolicy, RateLimiter rateLimiter, OpStatsLogger statsLogger) throws KeeperException, InterruptedException {
        T result = null;
        boolean isDone = false;
        int attempts = 0;
        long startTimeNanos = MathUtils.nowInNano();
        while (!isDone) {
            try {
                if (null != client) {
                    client.waitForConnection();
                }
                logger.debug("Execute {} at {} retry attempt.", proc, (Object)attempts);
                if (null != rateLimiter) {
                    rateLimiter.acquire();
                }
                result = proc.call();
                isDone = true;
                statsLogger.registerSuccessfulEvent(MathUtils.elapsedMicroSec((long)startTimeNanos), TimeUnit.MICROSECONDS);
            }
            catch (KeeperException e) {
                boolean rethrow = true;
                long elapsedTime = MathUtils.elapsedMSec((long)startTimeNanos);
                if ((null != client && ZooWorker.isRecoverableException(e) || null == client) && retryPolicy.allowRetry(++attempts, elapsedTime)) {
                    rethrow = false;
                }
                if (rethrow) {
                    statsLogger.registerFailedEvent(MathUtils.elapsedMicroSec((long)startTimeNanos), TimeUnit.MICROSECONDS);
                    logger.debug("Stopped executing {} after {} attempts.", proc, (Object)attempts);
                    throw e;
                }
                TimeUnit.MILLISECONDS.sleep(retryPolicy.nextRetryWaitTime(attempts, elapsedTime));
            }
        }
        return result;
    }

    static interface ZooCallable<T> {
        public T call() throws InterruptedException, KeeperException;
    }
}

