/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NIOServerCnxnFactoryTest {
    private InetSocketAddress listenAddress;
    private NIOServerCnxnFactory factory;

    @Before
    public void setUp() throws IOException {
        this.listenAddress = new InetSocketAddress(PortAssignment.unique());
        this.factory = new NIOServerCnxnFactory();
        this.factory.configure(this.listenAddress, 100);
    }

    @After
    public void tearDown() {
        if (this.factory != null) {
            this.factory.shutdown();
        }
    }

    @Test(expected=SocketException.class)
    public void testStartupWithoutStart_SocketAlreadyBound() throws IOException {
        ServerSocket ss = new ServerSocket(this.listenAddress.getPort());
    }

    @Test(expected=SocketException.class)
    public void testStartupWithStart_SocketAlreadyBound() throws IOException {
        this.factory.start();
        ServerSocket ss = new ServerSocket(this.listenAddress.getPort());
    }

    @Test
    public void testShutdownWithoutStart_SocketReleased() throws IOException {
        this.factory.shutdown();
        this.factory = null;
        ServerSocket ss = new ServerSocket(this.listenAddress.getPort());
        ss.close();
    }
}

