/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieConnectionPeer;
import org.apache.bookkeeper.sasl.JAASCredentialsContainer;
import org.apache.bookkeeper.sasl.SASLBookieAuthProvider;
import org.apache.bookkeeper.sasl.SaslConstants;
import org.apache.bookkeeper.sasl.TGTRefreshThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLBookieAuthProviderFactory
implements BookieAuthProvider.Factory,
JAASCredentialsContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SASLBookieAuthProviderFactory.class);
    private Pattern allowedIdsPattern;
    private ServerConfiguration serverConfiguration;
    private Subject subject;
    private boolean isKrbTicket;
    private boolean isUsingTicketCache;
    private String principal;
    private String loginContextName;
    private LoginContext login;
    private TGTRefreshThread ticketRefreshThread;

    @Override
    public void init(ServerConfiguration conf) throws IOException {
        this.serverConfiguration = conf;
        String allowedIdsPatternRegExp = conf.getString("saslJaasClientAllowedIds", ".*bookkeeper.*");
        try {
            this.allowedIdsPattern = Pattern.compile(allowedIdsPatternRegExp);
        }
        catch (PatternSyntaxException error) {
            LOG.error("Invalid regular expression " + allowedIdsPatternRegExp, (Throwable)error);
            throw new IOException(error);
        }
        try {
            this.loginContextName = this.serverConfiguration.getString("saslJaasBookieSectionName", "Bookie");
            this.login = this.loginServer();
            this.subject = this.login.getSubject();
            boolean bl = this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
            if (this.isKrbTicket) {
                this.isUsingTicketCache = SaslConstants.isUsingTicketCache(this.loginContextName);
                this.principal = SaslConstants.getPrincipal(this.loginContextName);
                this.ticketRefreshThread = new TGTRefreshThread(this);
                this.ticketRefreshThread.start();
            }
        }
        catch (LoginException | SaslException error) {
            throw new IOException(error);
        }
    }

    @Override
    public BookieAuthProvider newProvider(BookieConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
        return new SASLBookieAuthProvider(addr, completeCb, this.serverConfiguration, this.subject, this.allowedIdsPattern);
    }

    @Override
    public String getPluginName() {
        return "sasl";
    }

    @Override
    public void close() {
        block3: {
            if (this.ticketRefreshThread != null) {
                this.ticketRefreshThread.interrupt();
                try {
                    this.ticketRefreshThread.join(10000L);
                }
                catch (InterruptedException exit) {
                    Thread.currentThread().interrupt();
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("interrupted while waiting for TGT reresh thread to stop", (Throwable)exit);
                }
            }
        }
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public LoginContext getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(LoginContext login) {
        this.login = login;
    }

    @Override
    public boolean isUsingTicketCache() {
        return this.isUsingTicketCache;
    }

    @Override
    public String getPrincipal() {
        return this.principal;
    }

    @Override
    public AbstractConfiguration getConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public String getLoginContextName() {
        return this.loginContextName;
    }

    private LoginContext loginServer() throws SaslException, LoginException {
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(this.loginContextName);
        if (entries == null) {
            LOG.info("JAAS not configured or no " + this.loginContextName + " present in JAAS Configuration file");
            return null;
        }
        LoginContext loginContext = new LoginContext(this.loginContextName, new ClientCallbackHandler(null));
        loginContext.login();
        return loginContext;
    }

    private static class ClientCallbackHandler
    implements CallbackHandler {
        private String password = null;

        public ClientCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    if (this.password == null) continue;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    String authzid;
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (!ac.isAuthorized()) continue;
                    ac.setAuthorizedID(authzid);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
            }
        }
    }
}

