/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;
import org.apache.bookkeeper.bookie.storage.ldb.EntryLocationIndexStats;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.bookkeeper.bookie.storage.ldb.LongPairWrapper;
import org.apache.bookkeeper.bookie.storage.ldb.LongWrapper;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryLocationIndex
implements Closeable {
    private final KeyValueStorage locationsDb;
    private final ConcurrentLongHashSet deletedLedgers = new ConcurrentLongHashSet();
    private final EntryLocationIndexStats stats;
    private static final int DELETE_ENTRIES_BATCH_SIZE = 100000;
    private static final Logger log = LoggerFactory.getLogger(EntryLocationIndex.class);

    public EntryLocationIndex(ServerConfiguration conf, KeyValueStorageFactory storageFactory, String basePath, StatsLogger stats) throws IOException {
        this.locationsDb = storageFactory.newKeyValueStorage(basePath, "locations", KeyValueStorageFactory.DbConfigType.Huge, conf);
        this.stats = new EntryLocationIndexStats(stats, () -> {
            try {
                return this.locationsDb.count();
            }
            catch (IOException e) {
                return -1L;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.locationsDb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLocation(long ledgerId, long entryId) throws IOException {
        LongPairWrapper key = LongPairWrapper.get(ledgerId, entryId);
        LongWrapper value = LongWrapper.get();
        long startTimeNanos = MathUtils.nowInNano();
        boolean operationSuccess = false;
        try {
            if (this.locationsDb.get(key.array, value.array) < 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Entry not found {}@{} in db index", (Object)ledgerId, (Object)entryId);
                }
                long l = 0L;
                return l;
            }
            operationSuccess = true;
            long l = value.getValue();
            return l;
        }
        finally {
            key.recycle();
            value.recycle();
            if (operationSuccess) {
                this.stats.getLookupEntryLocationStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            } else {
                this.stats.getLookupEntryLocationStats().registerFailedEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
            }
        }
    }

    public long getLastEntryInLedger(long ledgerId) throws IOException {
        if (this.deletedLedgers.contains(ledgerId)) {
            return -1L;
        }
        return this.getLastEntryInLedgerInternal(ledgerId);
    }

    private long getLastEntryInLedgerInternal(long ledgerId) throws IOException {
        LongPairWrapper maxEntryId = LongPairWrapper.get(ledgerId, Long.MAX_VALUE);
        Map.Entry<byte[], byte[]> entry = this.locationsDb.getFloor(maxEntryId.array);
        maxEntryId.recycle();
        if (entry == null) {
            throw new Bookie.NoEntryException(ledgerId, -1L);
        }
        long foundLedgerId = ArrayUtil.getLong(entry.getKey(), 0);
        long lastEntryId = ArrayUtil.getLong(entry.getKey(), 8);
        if (foundLedgerId == ledgerId) {
            if (log.isDebugEnabled()) {
                log.debug("Found last page in storage db for ledger {} - last entry: {}", (Object)ledgerId, (Object)lastEntryId);
            }
            return lastEntryId;
        }
        throw new Bookie.NoEntryException(ledgerId, -1L);
    }

    public void addLocation(long ledgerId, long entryId, long location) throws IOException {
        KeyValueStorage.Batch batch = this.locationsDb.newBatch();
        this.addLocation(batch, ledgerId, entryId, location);
        batch.flush();
        batch.close();
    }

    public KeyValueStorage.Batch newBatch() {
        return this.locationsDb.newBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocation(KeyValueStorage.Batch batch, long ledgerId, long entryId, long location) throws IOException {
        LongPairWrapper key = LongPairWrapper.get(ledgerId, entryId);
        LongWrapper value = LongWrapper.get(location);
        if (log.isDebugEnabled()) {
            log.debug("Add location - ledger: {} -- entry: {} -- location: {}", new Object[]{ledgerId, entryId, location});
        }
        try {
            batch.put(key.array, value.array);
        }
        finally {
            key.recycle();
            value.recycle();
        }
    }

    public void updateLocations(Iterable<EntryLocation> newLocations) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Update locations -- {}", (Object)Iterables.size(newLocations));
        }
        KeyValueStorage.Batch batch = this.newBatch();
        for (EntryLocation e : newLocations) {
            if (log.isDebugEnabled()) {
                log.debug("Update location - ledger: {} -- entry: {}", (Object)e.ledger, (Object)e.entry);
            }
            this.addLocation(batch, e.ledger, e.entry, e.location);
        }
        batch.flush();
        batch.close();
    }

    public void delete(long ledgerId) throws IOException {
        this.deletedLedgers.add(ledgerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffsetFromDeletedLedgers() throws IOException {
        LongPairWrapper firstKeyWrapper = LongPairWrapper.get(-1L, -1L);
        LongPairWrapper lastKeyWrapper = LongPairWrapper.get(-1L, -1L);
        Set<Long> ledgersToDelete = this.deletedLedgers.items();
        if (ledgersToDelete.isEmpty()) {
            return;
        }
        log.info("Deleting indexes for ledgers: {}", ledgersToDelete);
        long startTime = System.nanoTime();
        try (KeyValueStorage.Batch batch = this.locationsDb.newBatch();){
            for (long ledgerId : ledgersToDelete) {
                if (log.isDebugEnabled()) {
                    log.debug("Deleting indexes from ledger {}", (Object)ledgerId);
                }
                firstKeyWrapper.set(ledgerId, 0L);
                lastKeyWrapper.set(ledgerId, Long.MAX_VALUE);
                batch.deleteRange(firstKeyWrapper.array, lastKeyWrapper.array);
            }
            batch.flush();
            for (long ledgerId : ledgersToDelete) {
                this.deletedLedgers.remove(ledgerId);
            }
        }
        finally {
            firstKeyWrapper.recycle();
            lastKeyWrapper.recycle();
        }
        log.info("Deleted indexes from {} ledgers in {} seconds", (Object)ledgersToDelete.size(), (Object)((double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) / 1000.0));
    }
}

