/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.io.CompressionUtils;

class EnvelopedEntry {
    public static final byte VERSION_ONE = 1;
    public static final int HEADER_LENGTH = 13;
    static final int VERSION_OFFSET = 0;
    static final int FLAGS_OFFSET = 1;
    static final int DECOMPRESSED_SIZE_OFFSET = 5;
    static final int COMPRESSED_SIZE_OFFSET = 9;
    public static final byte CURRENT_VERSION = 1;
    public static final int COMPRESSION_CODEC_MASK = 3;

    EnvelopedEntry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf fromEnvelopedBuf(ByteBuf src, StatsLogger statsLogger) throws IOException {
        ByteBuf decompressedBuf;
        byte version = src.readByte();
        if (version != 1) {
            throw new IOException(String.format("Version mismatch while reading. Received: %d, Required: %d", version, (byte)1));
        }
        int flags = src.readInt();
        int codecCode = flags & 3;
        int originDataLen = src.readInt();
        int actualDataLen = src.readInt();
        ByteBuf compressedBuf = src.slice(src.readerIndex(), actualDataLen);
        try {
            if (CompressionCodec.Type.NONE.code() == codecCode && originDataLen != actualDataLen) {
                throw new IOException("Inconsistent data length found for a non-compressed entry : compressed = " + originDataLen + ", actual = " + actualDataLen);
            }
            CompressionCodec codec = CompressionUtils.getCompressionCodec((CompressionCodec.Type)CompressionCodec.Type.of((int)codecCode));
            decompressedBuf = codec.decompress(compressedBuf, originDataLen);
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)compressedBuf);
        }
        return decompressedBuf;
    }
}

