/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.cluster;

import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterInitializer;
import org.apache.bookkeeper.tools.common.BKCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitClusterCommand
extends BKCommand<Flags> {
    private static final Logger log = LoggerFactory.getLogger(InitClusterCommand.class);
    private static final String NAME = "init";
    private static final String DESC = "Init a cluster";

    public InitClusterCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withUsage("bkctl cluster init [flags] <service-uri>").build());
    }

    protected boolean acceptServiceUri(ServiceURI serviceURI) {
        return "zk".equals(serviceURI.getServiceName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    protected boolean apply(ServiceURI ignored, CompositeConfiguration conf, BKFlags globalFlags, Flags cmdFlags) {
        Preconditions.checkArgument((!cmdFlags.arguments.isEmpty() ? 1 : 0) != 0, (Object)"No service URI is provided");
        ServiceURI serviceURI = ServiceURI.create((String)((String)cmdFlags.arguments.get(0)));
        if (null != cmdFlags.clusterName) {
            Preconditions.checkArgument((!cmdFlags.clusterName.contains("/") ? 1 : 0) != 0, (Object)("Invalid cluster name : " + cmdFlags.clusterName));
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cmdFlags.ledgersPath) && cmdFlags.ledgersPath.startsWith("/") ? 1 : 0) != 0, (Object)("Invalid ledgers root metadata path : " + cmdFlags.ledgersPath));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cmdFlags.dlogPath) && cmdFlags.dlogPath.startsWith("/") ? 1 : 0) != 0, (Object)("Invalid dlog root metadata path : " + cmdFlags.dlogPath));
        Preconditions.checkArgument((cmdFlags.numStorageContainers > 0 ? 1 : 0) != 0, (Object)"Zero or negative number of storage containers configured");
        String clusterName = null == cmdFlags.clusterName ? "" : cmdFlags.clusterName;
        String ledgersPath = InitClusterCommand.getFullyQualifiedPath(clusterName, cmdFlags.ledgersPath);
        String dlogPath = InitClusterCommand.getFullyQualifiedPath(clusterName, cmdFlags.dlogPath);
        String metadataServiceHosts = StringUtils.join((Object[])serviceURI.getServiceHosts(), (String)",");
        try (CuratorFramework client = CuratorFrameworkFactory.newClient((String)metadataServiceHosts, (RetryPolicy)new BoundedExponentialBackoffRetry(100, 10000, 20));){
            client.start();
            URI uri = serviceURI.getUri();
            URI rootUri = new URI(uri.getScheme(), uri.getAuthority(), "", null, null);
            String ledgersUri = rootUri.toString() + ledgersPath;
            String dlogUri = rootUri.toString() + dlogPath;
            log.info("Initializing cluster {} : \n\tledgers : path = {}, uri = {}\n\tdlog: path = {}, uri = {}\n\tstream storage: path = {}, num_storage_containers = {}", new Object[]{clusterName, ledgersPath, ledgersUri, dlogPath, dlogUri, "/stream", cmdFlags.numStorageContainers});
            this.initializeCluster(client, clusterName);
            this.initLedgersMetadata(ledgersUri);
            this.initDlogMetadata(client, metadataServiceHosts, dlogUri, dlogPath, ledgersPath);
            this.initStreamStorageMetadata(metadataServiceHosts, ledgersUri, cmdFlags.numStorageContainers);
            log.info("Successfully initialized cluster {}", (Object)clusterName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeCluster(CuratorFramework client, String clusterName) throws Exception {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            return;
        }
        String path = "/" + clusterName;
        if (null == client.checkExists().forPath(path)) {
            try {
                client.create().forPath(path);
            }
            catch (KeeperException.NodeExistsException ne) {
                return;
            }
        }
    }

    private void initLedgersMetadata(String ledgersUri) throws Exception {
        MetadataDrivers.runFunctionWithRegistrationManager((ServerConfiguration)((ServerConfiguration)new ServerConfiguration().setMetadataServiceUri(ledgersUri)), rm -> {
            try {
                if (rm.initNewCluster()) {
                    log.info("Successfully initialized ledgers metadata at {}", (Object)ledgersUri);
                }
            }
            catch (Exception e) {
                throw new UncheckedExecutionException("Failed to init ledgers metadata at " + ledgersUri, (Throwable)e);
            }
            return null;
        });
    }

    private void initDlogMetadata(CuratorFramework client, String metadataServiceHosts, String dlogUri, String dlogPath, String ledgersPath) throws Exception {
        block3: {
            BKDLConfig dlogConfig = new BKDLConfig(metadataServiceHosts, ledgersPath);
            DLMetadata dlogMetadata = DLMetadata.create((BKDLConfig)dlogConfig);
            if (null == client.checkExists().forPath(dlogPath)) {
                try {
                    dlogMetadata.create(URI.create(dlogUri));
                }
                catch (ZKException zke) {
                    if (KeeperException.Code.NODEEXISTS.intValue() != zke.getCode()) break block3;
                    return;
                }
            }
        }
    }

    private void initStreamStorageMetadata(String metadataServiceHosts, String ledgersUri, int numStorageContainers) {
        ZkClusterInitializer initializer = new ZkClusterInitializer(metadataServiceHosts);
        if (initializer.initializeCluster(URI.create(ledgersUri), numStorageContainers)) {
            log.info("Successfully initialized stream storage metadata at {}:{}", (Object)metadataServiceHosts, (Object)"/stream");
        }
    }

    private static String getFullyQualifiedPath(String clusterName, String path) {
        clusterName = Strings.isNullOrEmpty((String)clusterName) ? "" : "/" + clusterName;
        return clusterName + path;
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-x", "--cluster-name"}, description="cluster name. this would be used as a root path for storing metadata.")
        private String clusterName = "";
        @Parameter(names={"-l", "--ledgers-path"}, description="root path to store ledgers' metadata")
        private String ledgersPath = "/ledgers";
        @Parameter(names={"-dl", "--dlog-path"}, description="root path to store dlog metadata")
        private String dlogPath = "/distributedlog";
        @Parameter(names={"-n", "--num-storage-containers"}, description="num of storage containers allocated for stream storage")
        private int numStorageContainers = 32;
    }
}

