/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.NettyServerCnxn;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionMetricsTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnectionMetricsTest.class);

    @Test
    public void testRevalidateCount() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        QuorumUtil util = new QuorumUtil(1);
        util.enableLocalSession(false);
        util.startAll();
        int follower1 = (int)util.getFollowerQuorumPeers().get(0).getId();
        int follower2 = (int)util.getFollowerQuorumPeers().get(1).getId();
        LOG.info("connecting to server: {}", (Object)follower1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(util.getConnectionStringForServer(follower1), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        LOG.info("connected");
        zk.updateServerList(util.getConnectionStringForServer(follower2));
        util.shutdown(follower1);
        watcher.waitForDisconnected(ClientBase.CONNECTION_TIMEOUT);
        LOG.info("disconnected");
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        LOG.info("reconnected");
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("connection_revalidate_count"));
        Assert.assertEquals((Object)1L, (Object)values.get("revalidate_count"));
        zk.close();
        util.shutdownAll();
    }

    private NIOServerCnxn createMockNIOCnxn() throws IOException {
        InetSocketAddress socketAddr = new InetSocketAddress(80);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socket.getRemoteSocketAddress()).thenReturn((Object)socketAddr);
        SocketChannel sock = (SocketChannel)Mockito.mock(SocketChannel.class);
        Mockito.when((Object)sock.socket()).thenReturn((Object)socket);
        Mockito.when((Object)sock.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)-1);
        return new MockNIOServerCnxn((ZooKeeperServer)Mockito.mock(ZooKeeperServer.class), sock, null, (NIOServerCnxnFactory)Mockito.mock(NIOServerCnxnFactory.class), null);
    }

    @Test
    public void testNIOConnectionDropCount() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        NIOServerCnxn cnxn = this.createMockNIOCnxn();
        cnxn.doIO((SelectionKey)new FakeSK());
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("connection_drop_count"));
    }

    @Test
    public void testNettyConnectionDropCount() throws Exception {
        InetSocketAddress socketAddr = new InetSocketAddress(80);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)false);
        Mockito.when((Object)channel.remoteAddress()).thenReturn((Object)socketAddr);
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)channel.eventLoop()).thenReturn((Object)eventLoop);
        ServerMetrics.getMetrics().resetAll();
        NettyServerCnxnFactory factory = new NettyServerCnxnFactory();
        NettyServerCnxn cnxn = new NettyServerCnxn(channel, (ZooKeeperServer)Mockito.mock(ZooKeeperServer.class), factory);
        factory.cnxns.add(cnxn);
        cnxn.close();
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("connection_drop_count"));
    }

    @Test
    public void testSessionlessConnectionsExpired() throws Exception {
        NIOServerCnxnFactory factory = new NIOServerCnxnFactory();
        factory.configure(new InetSocketAddress(PortAssignment.unique()), 1000);
        factory.start();
        int timeout = Integer.getInteger("zookeeper.nio.sessionlessCnxnTimeout", 10000);
        ServerMetrics.getMetrics().resetAll();
        factory.touchCnxn(this.createMockNIOCnxn());
        factory.touchCnxn(this.createMockNIOCnxn());
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        for (int sleptTime = 0; values.get("sessionless_connections_expired") == null || sleptTime < 2 * timeout; sleptTime += 100) {
            Thread.sleep(100L);
            values = MetricsUtils.currentServerMetrics();
        }
        Assert.assertEquals((Object)2L, (Object)values.get("sessionless_connections_expired"));
        factory.shutdown();
    }

    @Test
    public void testStaleSessionsExpired() throws Exception {
        int tickTime = 1000;
        SessionTrackerImpl tracker = new SessionTrackerImpl((SessionTracker.SessionExpirer)Mockito.mock(ZooKeeperServer.class), new ConcurrentHashMap(), tickTime, 1L, null);
        tracker.sessionsById.put(1L, Mockito.mock(SessionTrackerImpl.SessionImpl.class));
        tracker.sessionsById.put(2L, Mockito.mock(SessionTrackerImpl.SessionImpl.class));
        tracker.touchSession(1L, tickTime);
        tracker.touchSession(2L, tickTime);
        ServerMetrics.getMetrics().resetAll();
        tracker.start();
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        for (int sleptTime = 0; values.get("stale_sessions_expired") == null || sleptTime < 2 * tickTime; sleptTime += 100) {
            Thread.sleep(100L);
            values = MetricsUtils.currentServerMetrics();
        }
        Assert.assertEquals((Object)2L, (Object)values.get("stale_sessions_expired"));
        tracker.shutdown();
    }

    private static class FakeSK
    extends SelectionKey {
        private int ops = 5;

        private FakeSK() {
        }

        @Override
        public SelectableChannel channel() {
            return null;
        }

        @Override
        public Selector selector() {
            return (Selector)Mockito.mock(Selector.class);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void cancel() {
        }

        @Override
        public int interestOps() {
            return this.ops;
        }

        @Override
        public SelectionKey interestOps(int ops) {
            this.ops = ops;
            return this;
        }

        @Override
        public int readyOps() {
            return this.ops;
        }
    }

    private class MockNIOServerCnxn
    extends NIOServerCnxn {
        public MockNIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory, NIOServerCnxnFactory.SelectorThread selectorThread) throws IOException {
            super(zk, sock, sk, factory, selectorThread);
        }

        protected boolean isSocketOpen() {
            return true;
        }
    }
}

