/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds.trust;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.StringMatcher;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class SdsX509TrustManager
extends X509ExtendedTrustManager
implements X509TrustManager {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_URI_NAME = 6;
    private static final int ALT_IPA_NAME = 7;
    private final X509ExtendedTrustManager delegate;
    private final CertificateValidationContext certContext;

    SdsX509TrustManager(@Nullable CertificateValidationContext certContext, X509ExtendedTrustManager delegate) {
        Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.certContext = certContext;
        this.delegate = delegate;
    }

    private static boolean verifyDnsNameInPattern(String pattern, StringMatcher sanToVerifyMatcher) {
        String sanToVerify = sanToVerifyMatcher.getExact();
        if (sanToVerify == null || sanToVerify.length() == 0 || sanToVerify.startsWith(".") || sanToVerify.endsWith("..")) {
            return false;
        }
        if (pattern == null || pattern.length() == 0 || pattern.startsWith(".") || pattern.endsWith("..")) {
            return false;
        }
        if (!sanToVerify.endsWith(".")) {
            sanToVerify = sanToVerify + '.';
        }
        if (!pattern.endsWith(".")) {
            pattern = pattern + '.';
        }
        if (!(pattern = pattern.toLowerCase(Locale.US)).contains("*")) {
            return sanToVerify.equals(pattern);
        }
        if (!pattern.startsWith("*.") || pattern.indexOf(42, 1) != -1) {
            return false;
        }
        if (sanToVerify.length() < pattern.length()) {
            return false;
        }
        if ("*.".equals(pattern)) {
            return false;
        }
        String suffix = pattern.substring(1);
        if (!sanToVerify.endsWith(suffix)) {
            return false;
        }
        int suffixStartIndexInHostName = sanToVerify.length() - suffix.length();
        return suffixStartIndexInHostName <= 0 || sanToVerify.lastIndexOf(46, suffixStartIndexInHostName - 1) == -1;
    }

    private static boolean verifyDnsNameInSanList(String altNameFromCert, List<StringMatcher> verifySanList) {
        for (StringMatcher verifySan : verifySanList) {
            if (!SdsX509TrustManager.verifyDnsNameInPattern(altNameFromCert, verifySan)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyStringInSanList(String stringFromCert, List<StringMatcher> verifySanList) {
        for (StringMatcher sanToVerify : verifySanList) {
            if (!Ascii.equalsIgnoreCase((CharSequence)sanToVerify.getExact(), (CharSequence)stringFromCert)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyOneSanInList(List<?> entry, List<StringMatcher> verifySanList) throws CertificateParsingException {
        if (entry == null || entry.size() < 2) {
            throw new CertificateParsingException("Invalid SAN entry");
        }
        Integer altNameType = (Integer)entry.get(0);
        if (altNameType == null) {
            throw new CertificateParsingException("Invalid SAN entry: null altNameType");
        }
        String altNameFromCert = (String)entry.get(1);
        switch (altNameType) {
            case 2: {
                return SdsX509TrustManager.verifyDnsNameInSanList(altNameFromCert, verifySanList);
            }
            case 6: 
            case 7: {
                return SdsX509TrustManager.verifyStringInSanList(altNameFromCert, verifySanList);
            }
        }
        throw new CertificateParsingException("Unsupported altNameType: " + altNameType);
    }

    private static void verifySubjectAltNameInLeaf(X509Certificate cert, List<StringMatcher> verifyList) throws CertificateException {
        Collection<List<?>> names = cert.getSubjectAlternativeNames();
        if (names == null || names.isEmpty()) {
            throw new CertificateException("Peer certificate SAN check failed");
        }
        for (List<?> name : names) {
            if (!SdsX509TrustManager.verifyOneSanInList(name, verifyList)) continue;
            return;
        }
        throw new CertificateException("Peer certificate SAN check failed");
    }

    @VisibleForTesting
    void verifySubjectAltNameInChain(X509Certificate[] peerCertChain) throws CertificateException {
        if (this.certContext == null) {
            return;
        }
        List<StringMatcher> verifyList = this.certContext.getMatchSubjectAltNamesList();
        if (verifyList.isEmpty()) {
            return;
        }
        if (peerCertChain == null || peerCertChain.length < 1) {
            throw new CertificateException("Peer certificate(s) missing");
        }
        SdsX509TrustManager.verifySubjectAltNameInLeaf(peerCertChain[0], verifyList);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, sslEngine);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        SSLSocket sslSocket;
        SSLParameters sslParams;
        if (socket instanceof SSLSocket && (sslParams = (sslSocket = (SSLSocket)socket).getSSLParameters()) != null) {
            sslParams.setEndpointIdentificationAlgorithm(null);
            sslSocket.setSSLParameters(sslParams);
        }
        this.delegate.checkServerTrusted(chain, authType, socket);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        SSLParameters sslParams = sslEngine.getSSLParameters();
        if (sslParams != null) {
            sslParams.setEndpointIdentificationAlgorithm(null);
            sslEngine.setSSLParameters(sslParams);
        }
        this.delegate.checkServerTrusted(chain, authType, sslEngine);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

