/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.SnapStream;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.TestUtils;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnDigest;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileTxnSnapLogTest {
    private File tmpDir;
    private File logDir;
    private File snapDir;
    private File logVersionDir;
    private File snapVersionDir;

    @Before
    public void setUp() throws Exception {
        this.tmpDir = ClientBase.createEmptyTestDir();
        this.logDir = new File(this.tmpDir, "logdir");
        this.snapDir = new File(this.tmpDir, "snapdir");
    }

    @After
    public void tearDown() throws Exception {
        if (this.tmpDir != null) {
            TestUtils.deleteFileRecursively(this.tmpDir);
        }
        this.tmpDir = null;
        this.logDir = null;
        this.snapDir = null;
        this.logVersionDir = null;
        this.snapVersionDir = null;
    }

    private File createVersionDir(File parentDir) {
        File versionDir = new File(parentDir, "version-2");
        versionDir.mkdirs();
        return versionDir;
    }

    private void createLogFile(File dir, long zxid) throws IOException {
        File file = new File(dir.getPath() + File.separator + Util.makeLogName((long)zxid));
        file.createNewFile();
    }

    private void createSnapshotFile(File dir, long zxid) throws IOException {
        File file = new File(dir.getPath() + File.separator + Util.makeSnapshotName((long)zxid));
        file.createNewFile();
    }

    private void twoDirSetupWithCorrectFiles() throws IOException {
        this.logVersionDir = this.createVersionDir(this.logDir);
        this.snapVersionDir = this.createVersionDir(this.snapDir);
        this.createLogFile(this.logVersionDir, 1L);
        this.createLogFile(this.logVersionDir, 2L);
        this.createSnapshotFile(this.snapVersionDir, 1L);
        this.createSnapshotFile(this.snapVersionDir, 2L);
    }

    private void singleDirSetupWithCorrectFiles() throws IOException {
        this.logVersionDir = this.createVersionDir(this.logDir);
        this.createLogFile(this.logVersionDir, 1L);
        this.createLogFile(this.logVersionDir, 2L);
        this.createSnapshotFile(this.logVersionDir, 1L);
        this.createSnapshotFile(this.logVersionDir, 2L);
    }

    private FileTxnSnapLog createFileTxnSnapLogWithNoAutoCreateDataDir(File logDir, File snapDir) throws IOException {
        return this.createFileTxnSnapLogWithAutoCreateDataDir(logDir, snapDir, "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileTxnSnapLog createFileTxnSnapLogWithAutoCreateDataDir(File logDir, File snapDir, String autoCreateValue) throws IOException {
        FileTxnSnapLog fileTxnSnapLog;
        String priorAutocreateDirValue = System.getProperty("zookeeper.datadir.autocreate");
        System.setProperty("zookeeper.datadir.autocreate", autoCreateValue);
        try {
            fileTxnSnapLog = new FileTxnSnapLog(logDir, snapDir);
        }
        finally {
            if (priorAutocreateDirValue == null) {
                System.clearProperty("zookeeper.datadir.autocreate");
            } else {
                System.setProperty("zookeeper.datadir.autocreate", priorAutocreateDirValue);
            }
        }
        return fileTxnSnapLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileTxnSnapLog createFileTxnSnapLogWithAutoCreateDB(File logDir, File snapDir, String autoCreateValue) throws IOException {
        FileTxnSnapLog fileTxnSnapLog;
        String priorAutocreateDBValue = System.getProperty("zookeeper.db.autocreate");
        System.setProperty("zookeeper.db.autocreate", autoCreateValue);
        try {
            fileTxnSnapLog = new FileTxnSnapLog(logDir, snapDir);
        }
        finally {
            if (priorAutocreateDBValue == null) {
                System.clearProperty("zookeeper.db.autocreate");
            } else {
                System.setProperty("zookeeper.db.autocreate", priorAutocreateDBValue);
            }
        }
        return fileTxnSnapLog;
    }

    @Test
    public void testWithAutoCreateDataDir() throws IOException {
        Assert.assertFalse((String)"log directory already exists", (boolean)this.logDir.exists());
        Assert.assertFalse((String)"snapshot directory already exists", (boolean)this.snapDir.exists());
        FileTxnSnapLog fileTxnSnapLog = this.createFileTxnSnapLogWithAutoCreateDataDir(this.logDir, this.snapDir, "true");
        Assert.assertTrue((boolean)this.logDir.exists());
        Assert.assertTrue((boolean)this.snapDir.exists());
        Assert.assertTrue((boolean)fileTxnSnapLog.getDataDir().exists());
        Assert.assertTrue((boolean)fileTxnSnapLog.getSnapDir().exists());
    }

    @Test(expected=FileTxnSnapLog.DatadirException.class)
    public void testWithoutAutoCreateDataDir() throws Exception {
        Assert.assertFalse((String)"log directory already exists", (boolean)this.logDir.exists());
        Assert.assertFalse((String)"snapshot directory already exists", (boolean)this.snapDir.exists());
        try {
            this.createFileTxnSnapLogWithAutoCreateDataDir(this.logDir, this.snapDir, "false");
        }
        catch (FileTxnSnapLog.DatadirException e) {
            Assert.assertFalse((boolean)this.logDir.exists());
            Assert.assertFalse((boolean)this.snapDir.exists());
            throw e;
        }
        Assert.fail((String)"Expected exception from FileTxnSnapLog");
    }

    private void attemptAutoCreateDB(File dataDir, File snapDir, Map<Long, Integer> sessions, String autoCreateValue, long expectedValue) throws IOException {
        sessions.clear();
        FileTxnSnapLog fileTxnSnapLog = this.createFileTxnSnapLogWithAutoCreateDB(dataDir, snapDir, autoCreateValue);
        long zxid = fileTxnSnapLog.restore(new DataTree(), sessions, new FileTxnSnapLog.PlayBackListener(){

            public void onTxnLoaded(TxnHeader hdr, Record rec, TxnDigest digest) {
            }
        });
        Assert.assertEquals((String)"unexpected zxid", (long)expectedValue, (long)zxid);
    }

    @Test
    public void testAutoCreateDB() throws IOException {
        Assert.assertTrue((String)"cannot create log directory", (boolean)this.logDir.mkdir());
        Assert.assertTrue((String)"cannot create snapshot directory", (boolean)this.snapDir.mkdir());
        File initFile = new File(this.logDir, "initialize");
        Assert.assertFalse((String)"initialize file already exists", (boolean)initFile.exists());
        ConcurrentHashMap<Long, Integer> sessions = new ConcurrentHashMap<Long, Integer>();
        this.attemptAutoCreateDB(this.logDir, this.snapDir, sessions, "false", -1L);
        this.attemptAutoCreateDB(this.logDir, this.snapDir, sessions, "true", 0L);
        Assert.assertTrue((String)"cannot create initialize file", (boolean)initFile.createNewFile());
        this.attemptAutoCreateDB(this.logDir, this.snapDir, sessions, "false", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTxnLogSyncElapsedTime() throws IOException {
        FileTxnSnapLog fileTxnSnapLog = this.createFileTxnSnapLogWithAutoCreateDataDir(this.logDir, this.snapDir, "true");
        TxnHeader hdr = new TxnHeader(1L, 1, 1L, 1L, 5);
        SetDataTxn txn = new SetDataTxn("/foo", new byte[0], 1);
        Request req = new Request(0L, 0, 0, hdr, (Record)txn, 0L);
        try {
            fileTxnSnapLog.append(req);
            fileTxnSnapLog.commit();
            long syncElapsedTime = fileTxnSnapLog.getTxnLogElapsedSyncTime();
            Assert.assertNotEquals((String)"Did not update syncElapsedTime!", (long)-1L, (long)syncElapsedTime);
        }
        finally {
            fileTxnSnapLog.close();
        }
    }

    @Test
    public void testDirCheckWithCorrectFiles() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        try {
            this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.snapDir);
        }
        catch (FileTxnSnapLog.LogDirContentCheckException | FileTxnSnapLog.SnapDirContentCheckException e) {
            Assert.fail((String)"Should not throw ContentCheckException.");
        }
    }

    @Test
    public void testDirCheckWithSingleDirSetup() throws IOException {
        this.singleDirSetupWithCorrectFiles();
        try {
            this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.logDir);
        }
        catch (FileTxnSnapLog.LogDirContentCheckException | FileTxnSnapLog.SnapDirContentCheckException e) {
            Assert.fail((String)"Should not throw ContentCheckException.");
        }
    }

    @Test(expected=FileTxnSnapLog.LogDirContentCheckException.class)
    public void testDirCheckWithSnapFilesInLogDir() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        this.createSnapshotFile(this.logVersionDir, 3L);
        this.createSnapshotFile(this.logVersionDir, 4L);
        this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.snapDir);
    }

    @Test(expected=FileTxnSnapLog.SnapDirContentCheckException.class)
    public void testDirCheckWithLogFilesInSnapDir() throws IOException {
        this.twoDirSetupWithCorrectFiles();
        this.createLogFile(this.snapVersionDir, 3L);
        this.createLogFile(this.snapVersionDir, 4L);
        this.createFileTxnSnapLogWithNoAutoCreateDataDir(this.logDir, this.snapDir);
    }

    @Test
    public void testACLCreatedDuringFuzzySnapshotSync() throws IOException {
        DataTree leaderDataTree = new DataTree();
        File file = File.createTempFile("snapshot", "zk");
        FileOutputStream os = new FileOutputStream(file);
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)os);
        leaderDataTree.serializeAcls((OutputArchive)oa);
        TxnHeader hdr1 = new TxnHeader(1L, 2, 2L, 2L, 1);
        CreateTxn txn1 = new CreateTxn("/a1", "foo".getBytes(), (List)ZooDefs.Ids.CREATOR_ALL_ACL, false, -1);
        leaderDataTree.processTxn(hdr1, (Record)txn1);
        leaderDataTree.serializeNodes((OutputArchive)oa);
        os.close();
        FileInputStream is = new FileInputStream(file);
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)is);
        DataTree followerDataTree = new DataTree();
        followerDataTree.deserialize((InputArchive)ia, "tree");
        followerDataTree.processTxn(hdr1, (Record)txn1);
        DataNode a1 = leaderDataTree.getNode("/a1");
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((Object)ZooDefs.Ids.CREATOR_ALL_ACL, (Object)leaderDataTree.getACL(a1));
        Assert.assertEquals((Object)ZooDefs.Ids.CREATOR_ALL_ACL, (Object)followerDataTree.getACL(a1));
    }

    @Test
    public void testEmptySnapshotSerialization() throws IOException {
        File dataDir = ClientBase.createEmptyTestDir();
        FileTxnSnapLog snaplog = new FileTxnSnapLog(dataDir, dataDir);
        DataTree dataTree = new DataTree();
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        ZooKeeperServer.setDigestEnabled((boolean)true);
        snaplog.save(dataTree, sessions, true);
        snaplog.restore(dataTree, sessions, (hdr, rec, digest) -> {});
        Assert.assertNull((Object)dataTree.getDigestFromLoadedSnapshot());
    }

    @Test
    public void testSnapshotSerializationCompatibility() throws IOException {
        this.testSnapshotSerializationCompatibility(true, false);
        this.testSnapshotSerializationCompatibility(false, false);
        this.testSnapshotSerializationCompatibility(true, true);
        this.testSnapshotSerializationCompatibility(false, true);
    }

    void testSnapshotSerializationCompatibility(Boolean digestEnabled, Boolean snappyEnabled) throws IOException {
        File dataDir = ClientBase.createEmptyTestDir();
        FileTxnSnapLog snaplog = new FileTxnSnapLog(dataDir, dataDir);
        DataTree dataTree = new DataTree();
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        SnapStream.setStreamMode((SnapStream.StreamMode)(snappyEnabled != false ? SnapStream.StreamMode.SNAPPY : SnapStream.StreamMode.DEFAULT_MODE));
        ZooKeeperServer.setDigestEnabled((boolean)digestEnabled);
        TxnHeader txnHeader = new TxnHeader(1L, 1, 1L, 2L, 1);
        CreateTxn txn = new CreateTxn("/1", "data".getBytes(), null, false, 1);
        Request request = new Request(1L, 1, 1, txnHeader, (Record)txn, 1L);
        dataTree.processTxn(request.getHdr(), request.getTxn());
        snaplog.save(dataTree, sessions, true);
        int expectedNodeCount = dataTree.getNodeCount();
        ZooKeeperServer.setDigestEnabled((digestEnabled == false ? 1 : 0) != 0);
        snaplog.restore(dataTree, sessions, (hdr, rec, digest) -> {});
        Assert.assertEquals((long)expectedNodeCount, (long)dataTree.getNodeCount());
    }
}

