/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.NettyServerCnxn;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.SSLAuthTest;
import org.apache.zookeeper.test.TestByteBufAllocator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxnTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerCnxnTest.class);

    @Override
    public void setUp() throws Exception {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        NettyServerCnxnFactory.setTestAllocator((ByteBufAllocator)TestByteBufAllocator.getInstance());
        this.maxCnxns = 1;
        this.exceptionOnFailedConnect = true;
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        NettyServerCnxnFactory.clearTestAllocator();
        TestByteBufAllocator.checkForLeaks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    public void testSendCloseSession() throws Exception {
        Assert.assertTrue((String)"Didn't instantiate ServerCnxnFactory with NettyServerCnxnFactory!", (boolean)(this.serverFactory instanceof NettyServerCnxnFactory));
        TestableZooKeeper zk = this.createClient();
        ZooKeeperServer zkServer = this.serverFactory.getZooKeeperServer();
        String path = "/a";
        try {
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertNotNull((String)"Didn't create znode:/a", (Object)zk.exists("/a", true));
            Assert.assertEquals((long)1L, (long)zkServer.getZKDatabase().getDataTree().getWatchCount());
            Iterable connections = this.serverFactory.getConnections();
            Assert.assertEquals((String)"Mismatch in number of live connections!", (long)1L, (long)this.serverFactory.getNumAliveConnections());
            for (ServerCnxn serverCnxn : connections) {
                serverCnxn.sendCloseSession();
            }
            LOG.info("Waiting for the channel disconnected event");
            int timeout = 0;
            while (this.serverFactory.getNumAliveConnections() != 0) {
                Thread.sleep(1000L);
                if ((timeout += 1000) <= CONNECTION_TIMEOUT) continue;
                Assert.fail((String)"The number of live connections should be 0");
            }
            Assert.assertEquals((long)0L, (long)zkServer.getZKDatabase().getDataTree().getWatchCount());
        }
        finally {
            zk.close();
        }
    }

    @Test(timeout=40000L, expected=ProtocolException.class)
    public void testMaxConnectionPerIpSurpased() throws Exception {
        Assert.assertTrue((String)"Did not instantiate ServerCnxnFactory with NettyServerCnxnFactory!", (boolean)(this.serverFactory instanceof NettyServerCnxnFactory));
        try (TestableZooKeeper zk1 = this.createClient();){
            TestableZooKeeper zk2 = this.createClient();
            Throwable throwable = null;
            if (zk2 != null) {
                if (throwable != null) {
                    try {
                        zk2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    zk2.close();
                }
            }
        }
    }

    @Test
    public void testClientResponseStatsUpdate() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            BufferStats clientResponseStats = this.serverFactory.getZooKeeperServer().serverStats().getClientResponseStats();
            Assert.assertThat((String)"Last client response size should be initialized with INIT_VALUE", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.equalTo((Object)-1));
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertThat((String)"Last client response size should be greater than 0 after client request was performed", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            byte[] contents = zk.getData("/a", null, null);
            Assert.assertArrayEquals((String)"unexpected data", (byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents);
        }
    }

    @Test
    public void testServerSideThrottling() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            BufferStats clientResponseStats = this.serverFactory.getZooKeeperServer().serverStats().getClientResponseStats();
            Assert.assertThat((String)"Last client response size should be initialized with INIT_VALUE", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.equalTo((Object)-1));
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertThat((String)"Last client response size should be greater than 0 after client request was performed", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            for (ServerCnxn cnxn : this.serverFactory.cnxns) {
                final NettyServerCnxn nettyCnxn = (NettyServerCnxn)cnxn;
                nettyCnxn.disableRecv();
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.getChannel().read();
                    }
                }, 1L, TimeUnit.SECONDS);
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.enableRecv();
                    }
                }, 2L, TimeUnit.SECONDS);
            }
            byte[] contents = zk.getData("/a", null, null);
            Assert.assertArrayEquals((String)"unexpected data", (byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents);
            for (ServerCnxn cnxn : this.serverFactory.cnxns) {
                final NettyServerCnxn nettyCnxn = (NettyServerCnxn)cnxn;
                nettyCnxn.disableRecv();
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.enableRecv();
                    }
                }, 2L, TimeUnit.SECONDS);
            }
            contents = zk.getData("/a", null, null);
            Assert.assertArrayEquals((String)"unexpected data", (byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents);
        }
    }

    @Test
    public void testEnableDisableThrottling_secure_random() throws Exception {
        this.runEnableDisableThrottling(true, true);
    }

    @Test
    public void testEnableDisableThrottling_secure_sequentially() throws Exception {
        this.runEnableDisableThrottling(true, false);
    }

    @Test
    public void testEnableDisableThrottling_nonSecure_random() throws Exception {
        this.runEnableDisableThrottling(false, true);
    }

    @Test
    public void testEnableDisableThrottling_nonSecure_sequentially() throws Exception {
        this.runEnableDisableThrottling(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEnableDisableThrottling(boolean secure, boolean randomDisableEnable) throws Exception {
        ClientX509Util x509Util = null;
        if (secure) {
            x509Util = SSLAuthTest.setUpSecure();
        }
        try {
            NettyServerCnxnFactory factory = (NettyServerCnxnFactory)this.serverFactory;
            factory.setAdvancedFlowControlEnabled(true);
            if (secure) {
                factory.setSecure(true);
            }
            String path = "/testEnableDisableThrottling";
            try (TestableZooKeeper zk = this.createClient();){
                zk.create("/testEnableDisableThrottling", new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                final AtomicBoolean stopped = new AtomicBoolean(false);
                final Random random = new Random();
                Thread enableDisableThread = null;
                enableDisableThread = randomDisableEnable ? new Thread(){

                    @Override
                    public void run() {
                        while (!stopped.get()) {
                            for (ServerCnxn cnxn : ((NettyServerCnxnTest)NettyServerCnxnTest.this).serverFactory.cnxns) {
                                boolean shouldDisableEnable = random.nextBoolean();
                                if (shouldDisableEnable) {
                                    cnxn.disableRecv();
                                    continue;
                                }
                                cnxn.enableRecv();
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        for (ServerCnxn cnxn : ((NettyServerCnxnTest)NettyServerCnxnTest.this).serverFactory.cnxns) {
                            cnxn.enableRecv();
                        }
                    }
                } : new Thread(){

                    @Override
                    public void run() {
                        while (!stopped.get()) {
                            for (ServerCnxn cnxn : ((NettyServerCnxnTest)NettyServerCnxnTest.this).serverFactory.cnxns) {
                                try {
                                    cnxn.disableRecv();
                                    Thread.sleep(10L);
                                    cnxn.enableRecv();
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                };
                enableDisableThread.start();
                LOG.info("started thread to enable and disable recv");
                final int totalRequestsNum = 100000;
                AtomicInteger successResponse = new AtomicInteger();
                CountDownLatch responseReceivedLatch = new CountDownLatch(totalRequestsNum);
                Thread clientThread = new Thread((ZooKeeper)zk, successResponse, responseReceivedLatch){
                    final /* synthetic */ ZooKeeper val$zk;
                    final /* synthetic */ AtomicInteger val$successResponse;
                    final /* synthetic */ CountDownLatch val$responseReceivedLatch;
                    {
                        this.val$zk = zooKeeper;
                        this.val$successResponse = atomicInteger;
                        this.val$responseReceivedLatch = countDownLatch;
                    }

                    @Override
                    public void run() {
                        int requestIssued = 0;
                        while (requestIssued++ < totalRequestsNum) {
                            this.val$zk.getData("/testEnableDisableThrottling", null, new AsyncCallback.DataCallback(){

                                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                                    if (rc == 0) {
                                        val$successResponse.addAndGet(1);
                                    } else {
                                        LOG.info("failed response is {}", (Object)rc);
                                    }
                                    val$responseReceivedLatch.countDown();
                                }
                            }, null);
                        }
                    }
                };
                clientThread.start();
                LOG.info("started thread to issue {} async requests", (Object)totalRequestsNum);
                Assert.assertTrue((boolean)responseReceivedLatch.await(60L, TimeUnit.SECONDS));
                LOG.info("received all {} responses", (Object)totalRequestsNum);
                stopped.set(true);
                enableDisableThread.join();
                LOG.info("enable and disable recv thread exited");
                LOG.info("waiting another 1s for the requests to go through");
                Thread.sleep(1000L);
                Assert.assertEquals((long)successResponse.get(), (long)totalRequestsNum);
            }
        }
        finally {
            if (secure) {
                SSLAuthTest.clearSecureSetting(x509Util);
            }
        }
    }
}

