/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.AsyncNotification;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogReadHandler;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.ReadAheadEntryReader;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.exceptions.EndOfStreamException;
import org.apache.distributedlog.exceptions.IdleReaderException;
import org.apache.distributedlog.util.Utils;

class BKSyncLogReader
implements LogReader,
AsyncNotification {
    private final BKDistributedLogManager bkdlm;
    private final BKLogReadHandler readHandler;
    private final AtomicReference<IOException> readerException = new AtomicReference<Object>(null);
    private final int maxReadAheadWaitTime;
    private CompletableFuture<Void> closeFuture;
    private final Optional<Long> startTransactionId;
    private boolean positioned = false;
    private Entry.Reader currentEntry = null;
    ReadAheadEntryReader readAheadReader = null;
    private final boolean shouldCheckIdleReader;
    private final int idleErrorThresholdMillis;
    private final Counter idleReaderError;

    BKSyncLogReader(DistributedLogConfiguration conf, BKDistributedLogManager bkdlm, DLSN startDLSN, Optional<Long> startTransactionId, StatsLogger statsLogger) throws IOException {
        this.bkdlm = bkdlm;
        this.readHandler = bkdlm.createReadHandler(Optional.empty(), this, true);
        this.maxReadAheadWaitTime = conf.getReadAheadWaitTime();
        this.idleErrorThresholdMillis = conf.getReaderIdleErrorThresholdMillis();
        this.shouldCheckIdleReader = this.idleErrorThresholdMillis > 0 && this.idleErrorThresholdMillis < Integer.MAX_VALUE;
        this.startTransactionId = startTransactionId;
        this.startReadAhead(startDLSN);
        if (!startTransactionId.isPresent()) {
            this.positioned = true;
        }
        StatsLogger syncReaderStatsLogger = statsLogger.scope("sync_reader");
        this.idleReaderError = syncReaderStatsLogger.getCounter("idle_reader_error");
    }

    private void startReadAhead(DLSN startDLSN) throws IOException {
        this.readAheadReader = new ReadAheadEntryReader(this.bkdlm.getStreamName(), startDLSN, this.bkdlm.getConf(), this.readHandler, this.bkdlm.getReaderEntryStore(), this.bkdlm.getScheduler(), Ticker.systemTicker(), this.bkdlm.alertStatsLogger);
        this.readHandler.registerListener(this.readAheadReader);
        this.readHandler.asyncStartFetchLogSegments().thenApply(logSegments -> {
            this.readAheadReader.addStateChangeNotification(this);
            this.readAheadReader.start((List)logSegments.getValue());
            return null;
        });
    }

    synchronized void releaseCurrentEntry() {
        if (null != this.currentEntry) {
            this.currentEntry.release();
            this.currentEntry = null;
        }
    }

    synchronized void checkClosedOrException() throws IOException {
        if (null != this.closeFuture) {
            throw new IOException("Reader is closed");
        }
        if (null != this.readerException.get()) {
            throw this.readerException.get();
        }
    }

    @VisibleForTesting
    ReadAheadEntryReader getReadAheadReader() {
        return this.readAheadReader;
    }

    @VisibleForTesting
    BKLogReadHandler getReadHandler() {
        return this.readHandler;
    }

    private Entry.Reader readNextEntry(boolean nonBlocking) throws IOException {
        Entry.Reader entry = null;
        if (nonBlocking) {
            return this.readAheadReader.getNextReadAheadEntry(0L, TimeUnit.MILLISECONDS);
        }
        while (!this.readAheadReader.isReadAheadCaughtUp() && null == this.readerException.get() && null == entry) {
            entry = this.readAheadReader.getNextReadAheadEntry(this.maxReadAheadWaitTime, TimeUnit.MILLISECONDS);
        }
        if (null != entry) {
            return entry;
        }
        if (this.readAheadReader.isReadAheadCaughtUp() && null == this.readerException.get()) {
            entry = this.readAheadReader.getNextReadAheadEntry(this.maxReadAheadWaitTime, TimeUnit.MILLISECONDS);
        }
        return entry;
    }

    private void markReaderAsIdle() throws IdleReaderException {
        this.idleReaderError.inc();
        IdleReaderException ire = new IdleReaderException("Sync reader on stream " + this.readHandler.getFullyQualifiedName() + " is idle for more than " + this.idleErrorThresholdMillis + " ms");
        this.readerException.compareAndSet(null, (IOException)ire);
        throw ire;
    }

    @Override
    public synchronized LogRecordWithDLSN readNext(boolean nonBlocking) throws IOException {
        this.checkClosedOrException();
        LogRecordWithDLSN record = this.doReadNext(nonBlocking);
        if (null == record && this.shouldCheckIdleReader && this.readAheadReader.getNumCachedEntries() <= 0 && this.readAheadReader.isReaderIdle(this.idleErrorThresholdMillis, TimeUnit.MILLISECONDS)) {
            this.markReaderAsIdle();
        }
        return record;
    }

    private LogRecordWithDLSN doReadNext(boolean nonBlocking) throws IOException {
        LogRecordWithDLSN record;
        block6: {
            record = null;
            while (true) {
                if (null == record) {
                    if (null == this.currentEntry) {
                        this.currentEntry = this.readNextEntry(nonBlocking);
                        if (null == this.currentEntry) {
                            return null;
                        }
                    }
                    if (null != (record = this.currentEntry.nextRecord())) continue;
                    this.currentEntry = null;
                    continue;
                }
                if (record.isEndOfStream()) {
                    EndOfStreamException eos = new EndOfStreamException("End of Stream Reached for " + this.readHandler.getFullyQualifiedName());
                    this.readerException.compareAndSet(null, (IOException)eos);
                    throw eos;
                }
                if (record.isControl()) {
                    record = null;
                    continue;
                }
                if (this.positioned) break block6;
                if (record.getTransactionId() >= this.startTransactionId.get()) break;
                record = null;
            }
            this.positioned = true;
        }
        return record;
    }

    @Override
    public synchronized List<LogRecordWithDLSN> readBulk(boolean nonBlocking, int numLogRecords) throws IOException {
        LinkedList<LogRecordWithDLSN> retList = new LinkedList<LogRecordWithDLSN>();
        int numRead = 0;
        LogRecordWithDLSN record = this.readNext(nonBlocking);
        while (null != record) {
            retList.add(record);
            if (++numRead >= numLogRecords) break;
            record = this.readNext(nonBlocking);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> asyncClose() {
        CompletableFuture<Void> closePromise;
        BKSyncLogReader bKSyncLogReader = this;
        synchronized (bKSyncLogReader) {
            if (null != this.closeFuture) {
                return this.closeFuture;
            }
            closePromise = new CompletableFuture<Void>();
            this.closeFuture = closePromise;
            this.releaseCurrentEntry();
        }
        this.readHandler.unregisterListener(this.readAheadReader);
        this.readAheadReader.removeStateChangeNotification(this);
        FutureUtils.proxyTo(Utils.closeSequence((ExecutorService)this.bkdlm.getScheduler(), true, this.readAheadReader, this.readHandler), closePromise);
        return closePromise;
    }

    @Override
    public void close() throws IOException {
        Utils.ioResult(this.asyncClose());
    }

    @Override
    public void notifyOnError(Throwable cause) {
        if (cause instanceof IOException) {
            this.readerException.compareAndSet(null, (IOException)cause);
        } else {
            this.readerException.compareAndSet(null, new IOException(cause));
        }
    }

    @Override
    public void notifyOnOperationComplete() {
    }
}

