/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.InputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRCTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(CRCTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();

    private void corruptFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        byte[] b = "mahadev".getBytes();
        long writeLen = 500L;
        raf.seek(writeLen);
        raf.write(b);
        raf.close();
    }

    private boolean getCheckSum(FileSnap snap, File snapFile) throws IOException {
        DataTree dt = new DataTree();
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        BufferedInputStream snapIS = new BufferedInputStream(new FileInputStream(snapFile));
        CheckedInputStream crcIn = new CheckedInputStream(snapIS, new Adler32());
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)crcIn);
        try {
            snap.deserialize(dt, sessions, (InputArchive)ia);
        }
        catch (IOException ie) {
            ((InputStream)snapIS).close();
            crcIn.close();
            throw ie;
        }
        long checksum = crcIn.getChecksum().getValue();
        long val = ia.readLong("val");
        ((InputStream)snapIS).close();
        crcIn.close();
        return val != checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecksums() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)150);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        LOG.info("starting up the zookeeper server .. waiting");
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
            for (int i = 0; i < 2000; ++i) {
                zk.create("/crctest- " + i, ("/crctest- " + i).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        f.shutdown();
        zks.shutdown();
        Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        File versionDir = new File(tmpDir, "version-2");
        File[] list = versionDir.listFiles();
        File snapFile = null;
        File logFile = null;
        for (File file : list) {
            LOG.info("file is {}", (Object)file);
            if (!file.getName().startsWith("log")) continue;
            logFile = file;
            this.corruptFile(logFile);
        }
        FileTxnLog flog = new FileTxnLog(versionDir);
        TxnLog.TxnIterator itr = flog.read(1L);
        try {
            while (itr.next()) {
            }
            Assert.fail();
        }
        catch (IOException ie) {
            LOG.warn("crc corruption", (Throwable)ie);
        }
        itr.close();
        FileSnap snap = new FileSnap(versionDir);
        List snapFiles = snap.findNRecentSnapshots(2);
        snapFile = (File)snapFiles.get(0);
        this.corruptFile(snapFile);
        boolean cfile = false;
        try {
            cfile = this.getCheckSum(snap, snapFile);
        }
        catch (IOException ie) {
            snapFile = (File)snapFiles.get(1);
            this.corruptFile(snapFile);
            cfile = this.getCheckSum(snap, snapFile);
        }
        Assert.assertTrue((boolean)cfile);
    }
}

