/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.BindableService;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.common.grpc.proxy.ChannelFinder;
import org.apache.bookkeeper.common.grpc.proxy.ProxyHandlerRegistry;
import org.apache.bookkeeper.common.grpc.stats.MonitoringServerInterceptor;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.server.conf.StorageServerConfiguration;
import org.apache.bookkeeper.stream.server.exceptions.StorageServerRuntimeException;
import org.apache.bookkeeper.stream.server.grpc.GrpcServerSpec;
import org.apache.bookkeeper.stream.server.grpc.GrpcStorageContainerService;
import org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.apache.bookkeeper.stream.storage.impl.grpc.GrpcServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServer
extends AbstractLifecycleComponent<StorageServerConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(GrpcServer.class);
    private final Endpoint myEndpoint;
    private final Server grpcServer;

    public static GrpcServer build(GrpcServerSpec spec) {
        return new GrpcServer(spec.storeSupplier().get(), spec.storeServerConf(), spec.endpoint(), spec.localServerName(), spec.localHandlerRegistry(), spec.statsLogger());
    }

    public GrpcServer(StorageContainerStore storageContainerStore, StorageServerConfiguration conf, Endpoint myEndpoint, StatsLogger statsLogger) {
        this(storageContainerStore, conf, myEndpoint, null, null, statsLogger);
    }

    @VisibleForTesting
    public GrpcServer(StorageContainerStore storageContainerStore, StorageServerConfiguration conf, Endpoint myEndpoint, String localServerName, HandlerRegistry localHandlerRegistry, StatsLogger statsLogger) {
        super("range-grpc-server", (ComponentConfiguration)conf, statsLogger);
        this.myEndpoint = myEndpoint;
        if (null != localServerName) {
            InProcessServerBuilder serverBuilder = (InProcessServerBuilder)InProcessServerBuilder.forName((String)localServerName).directExecutor();
            if (null != localHandlerRegistry) {
                serverBuilder = (InProcessServerBuilder)serverBuilder.fallbackHandlerRegistry(localHandlerRegistry);
            }
            this.grpcServer = serverBuilder.build();
        } else {
            MonitoringServerInterceptor monitoringInterceptor = MonitoringServerInterceptor.create((StatsLogger)statsLogger.scope("services"), (boolean)true);
            ProxyHandlerRegistry.Builder proxyRegistryBuilder = ProxyHandlerRegistry.newBuilder().setChannelFinder((ChannelFinder)storageContainerStore);
            for (ServerServiceDefinition definition : GrpcServices.create(null)) {
                ServerServiceDefinition monitoredService = ServerInterceptors.intercept((ServerServiceDefinition)definition, (ServerInterceptor[])new ServerInterceptor[]{monitoringInterceptor});
                proxyRegistryBuilder = proxyRegistryBuilder.addService(monitoredService);
            }
            ServerServiceDefinition locationService = ServerInterceptors.intercept((BindableService)new GrpcStorageContainerService(storageContainerStore), (ServerInterceptor[])new ServerInterceptor[]{monitoringInterceptor});
            this.grpcServer = ServerBuilder.forPort((int)this.myEndpoint.getPort()).addService(locationService).fallbackHandlerRegistry((HandlerRegistry)proxyRegistryBuilder.build()).build();
        }
    }

    @VisibleForTesting
    Server getGrpcServer() {
        return this.grpcServer;
    }

    protected void doStart() {
        try {
            this.grpcServer.start();
        }
        catch (IOException e) {
            log.error("Failed to start grpc server", (Throwable)e);
            throw new StorageServerRuntimeException("Failed to start grpc server", e);
        }
    }

    protected void doStop() {
        this.grpcServer.shutdown();
    }

    protected void doClose() throws IOException {
    }
}

