/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.allocator.impl;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ResourceLeakDetector;
import java.util.function.Consumer;
import org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufAllocatorImpl
extends AbstractByteBufAllocator
implements ByteBufAllocator {
    private static final Logger log = LoggerFactory.getLogger(ByteBufAllocatorImpl.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    private final ByteBufAllocator pooledAllocator;
    private final ByteBufAllocator unpooledAllocator;
    private final PoolingPolicy poolingPolicy;
    private final OutOfMemoryPolicy outOfMemoryPolicy;
    private final Consumer<OutOfMemoryError> outOfMemoryListener;

    ByteBufAllocatorImpl(ByteBufAllocator pooledAllocator, ByteBufAllocator unpooledAllocator, PoolingPolicy poolingPolicy, int poolingConcurrency, OutOfMemoryPolicy outOfMemoryPolicy, Consumer<OutOfMemoryError> outOfMemoryListener, LeakDetectionPolicy leakDetectionPolicy) {
        super(poolingPolicy == PoolingPolicy.PooledDirect);
        this.poolingPolicy = poolingPolicy;
        this.outOfMemoryPolicy = outOfMemoryPolicy;
        this.outOfMemoryListener = outOfMemoryListener == null ? v -> log.error("Unable to allocate memory", (Throwable)v) : outOfMemoryListener;
        this.pooledAllocator = poolingPolicy == PoolingPolicy.PooledDirect ? (pooledAllocator == null ? (poolingConcurrency == PooledByteBufAllocator.defaultNumDirectArena() ? PooledByteBufAllocator.DEFAULT : new PooledByteBufAllocator(true, poolingConcurrency, poolingConcurrency, PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), PooledByteBufAllocator.defaultSmallCacheSize(), PooledByteBufAllocator.defaultNormalCacheSize(), PooledByteBufAllocator.defaultUseCacheForAllThreads())) : pooledAllocator) : null;
        this.unpooledAllocator = unpooledAllocator != null ? unpooledAllocator : UnpooledByteBufAllocator.DEFAULT;
        switch (leakDetectionPolicy) {
            case Disabled: {
                if (log.isDebugEnabled()) {
                    log.debug("Disable Netty allocator leak detector");
                }
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
                break;
            }
            case Simple: {
                log.info("Setting Netty allocator leak detector to Simple");
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.SIMPLE);
                break;
            }
            case Advanced: {
                log.info("Setting Netty allocator leak detector to Advanced");
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
                break;
            }
            case Paranoid: {
                log.info("Setting Netty allocator leak detector to Paranoid");
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
            }
        }
    }

    public ByteBuf buffer() {
        return this.buffer(256);
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.buffer(initialCapacity, Integer.MAX_VALUE);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        if (this.poolingPolicy == PoolingPolicy.PooledDirect) {
            return this.newDirectBuffer(initialCapacity, maxCapacity, true);
        }
        return this.newHeapBuffer(initialCapacity, maxCapacity);
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        try {
            ByteBufAllocator alloc = this.poolingPolicy == PoolingPolicy.PooledDirect ? this.pooledAllocator : this.unpooledAllocator;
            return alloc.heapBuffer(initialCapacity, maxCapacity);
        }
        catch (OutOfMemoryError e) {
            this.outOfMemoryListener.accept(e);
            throw e;
        }
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.newDirectBuffer(initialCapacity, maxCapacity, false);
    }

    private ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity, boolean canFallbackToHeap) {
        if (this.poolingPolicy == PoolingPolicy.PooledDirect) {
            try {
                return this.pooledAllocator.directBuffer(initialCapacity, maxCapacity);
            }
            catch (OutOfMemoryError e) {
                if (canFallbackToHeap && this.outOfMemoryPolicy == OutOfMemoryPolicy.FallbackToHeap) {
                    try {
                        return this.unpooledAllocator.heapBuffer(initialCapacity, maxCapacity);
                    }
                    catch (OutOfMemoryError e2) {
                        this.outOfMemoryListener.accept(e2);
                        throw e2;
                    }
                }
                this.outOfMemoryListener.accept(e);
                throw e;
            }
        }
        try {
            return this.unpooledAllocator.directBuffer(initialCapacity, maxCapacity);
        }
        catch (OutOfMemoryError e) {
            this.outOfMemoryListener.accept(e);
            throw e;
        }
    }

    public boolean isDirectBufferPooled() {
        return this.pooledAllocator != null && this.pooledAllocator.isDirectBufferPooled();
    }
}

