/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.kv;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.bookkeeper.common.coder.Coder;
import org.apache.bookkeeper.proto.statestore.kv.Command;
import org.apache.bookkeeper.proto.statestore.kv.DeleteRequest;
import org.apache.bookkeeper.proto.statestore.kv.NopRequest;
import org.apache.bookkeeper.proto.statestore.kv.PutIfAbsentRequest;
import org.apache.bookkeeper.proto.statestore.kv.PutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KVUtils {
    private static final Logger log = LoggerFactory.getLogger(KVUtils.class);
    static final Command NOP_CMD = Command.newBuilder().setNopReq(NopRequest.newBuilder().build()).build();

    static ByteBuf serialize(ByteBuf valBuf, long revision) {
        int serializedSize = valBuf.readableBytes() + 8;
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(serializedSize);
        buffer.writeLong(revision);
        buffer.writeBytes(valBuf);
        return buffer;
    }

    static ByteBuf serialize(byte[] value, long revision) {
        int serializedSize = value.length + 8;
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(serializedSize);
        buffer.writeLong(revision);
        buffer.writeBytes(value);
        return buffer;
    }

    static <V> V deserialize(Coder<V> valCoder, ByteBuf valBuf) {
        valBuf.skipBytes(8);
        return (V)valCoder.decode(valBuf);
    }

    static Command newCommand(ByteBuf cmdBuf) throws InvalidProtocolBufferException {
        return Command.parseFrom(cmdBuf.nioBuffer());
    }

    static ByteBuf newCommandBuf(Command cmd) throws IOException {
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer(cmd.getSerializedSize());
        try {
            cmd.writeTo((OutputStream)new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            buf.release();
            throw e;
        }
        return buf;
    }

    static PutRequest newPutRequest(byte[] keyBytes, byte[] valBytes) {
        return PutRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap((byte[])keyBytes)).setValue(UnsafeByteOperations.unsafeWrap((byte[])valBytes)).build();
    }

    static PutIfAbsentRequest newPutIfAbsentRequest(byte[] keyBytes, byte[] valBytes) {
        return PutIfAbsentRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap((byte[])keyBytes)).setValue(UnsafeByteOperations.unsafeWrap((byte[])valBytes)).build();
    }

    static DeleteRequest newDeleteRequest(byte[] keyBytes) {
        return DeleteRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap((byte[])keyBytes)).build();
    }

    private KVUtils() {
    }
}

