/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.rbac.engine;

import com.google.common.collect.ImmutableList;
import java.util.List;

public class AuthorizationDecision {
    private final Output decision;
    private final ImmutableList<String> policyNames;

    public AuthorizationDecision(Output decision, List<String> policyNames) {
        this.decision = decision;
        this.policyNames = ImmutableList.copyOf(policyNames);
    }

    public Output getDecision() {
        return this.decision;
    }

    public ImmutableList<String> getPolicyNames() {
        return this.policyNames;
    }

    public String toString() {
        StringBuilder authzStr = new StringBuilder();
        switch (this.decision) {
            case ALLOW: {
                authzStr.append("Authorization Decision: ALLOW. \n");
                break;
            }
            case DENY: {
                authzStr.append("Authorization Decision: DENY. \n");
                break;
            }
            case UNKNOWN: {
                authzStr.append("Authorization Decision: UNKNOWN. \n");
                break;
            }
        }
        for (String policyName : this.policyNames) {
            authzStr.append(policyName).append("; \n");
        }
        return authzStr.toString();
    }

    public static enum Output {
        ALLOW,
        DENY,
        UNKNOWN;

    }
}

