/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.Listener;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Address;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HttpProtocolOptions;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChainMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class XdsClientImpl2
extends XdsClient {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private static final String ADS_TYPE_URL_LDS_V2 = "type.googleapis.com/envoy.api.v2.Listener";
    private static final String ADS_TYPE_URL_LDS = "type.googleapis.com/envoy.config.listener.v3.Listener";
    private static final String ADS_TYPE_URL_RDS_V2 = "type.googleapis.com/envoy.api.v2.RouteConfiguration";
    private static final String ADS_TYPE_URL_RDS = "type.googleapis.com/envoy.config.route.v3.RouteConfiguration";
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER_V2 = "type.googleapis.com/envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager";
    private static final String TYPE_URL_HTTP_CONNECTION_MANAGER = "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager";
    private static final String ADS_TYPE_URL_CDS_V2 = "type.googleapis.com/envoy.api.v2.Cluster";
    private static final String ADS_TYPE_URL_CDS = "type.googleapis.com/envoy.config.cluster.v3.Cluster";
    private static final String ADS_TYPE_URL_EDS_V2 = "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment";
    private static final String ADS_TYPE_URL_EDS = "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment";
    private final MessagePrinter respPrinter = new MessagePrinter();
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final String targetName;
    private final XdsClient.XdsChannel xdsChannel;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final Stopwatch adsStreamRetryStopwatch;
    private EnvoyProtoData.Node node;
    private final Map<String, ResourceSubscriber> ldsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> rdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> cdsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final Map<String, ResourceSubscriber> edsResourceSubscribers = new HashMap<String, ResourceSubscriber>();
    private final LoadStatsManager loadStatsManager = new LoadStatsManager();
    private String ldsVersion = "";
    private String rdsVersion = "";
    private String cdsVersion = "";
    private String edsVersion = "";
    @Nullable
    private AbstractAdsStream adsStream;
    @Nullable
    private BackoffPolicy retryBackoffPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle rpcRetryTimer;
    @Nullable
    private LoadReportClient lrsClient;
    private int loadReportCount;
    @Nullable
    private XdsClient.ListenerWatcher listenerWatcher;
    private int listenerPort = -1;
    @Nullable
    private SynchronizationContext.ScheduledHandle ldsRespTimer;

    XdsClientImpl2(String targetName, XdsClient.XdsChannel channel, EnvoyProtoData.Node node, SynchronizationContext syncContext, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.targetName = (String)Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        this.xdsChannel = (XdsClient.XdsChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.node = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatch");
        this.adsStreamRetryStopwatch = (Stopwatch)stopwatchSupplier.get();
        this.logId = InternalLogId.allocate((String)"xds-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutting down");
        this.xdsChannel.getManagedChannel().shutdown();
        if (this.adsStream != null) {
            this.adsStream.close((Exception)Status.CANCELLED.withDescription("shutdown").asException());
        }
        this.cleanUpResourceTimers();
        if (this.lrsClient != null) {
            this.lrsClient.stopLoadReporting();
            this.lrsClient = null;
        }
        if (this.rpcRetryTimer != null) {
            this.rpcRetryTimer.cancel();
        }
    }

    private void cleanUpResourceTimers() {
        if (this.ldsRespTimer != null) {
            this.ldsRespTimer.cancel();
            this.ldsRespTimer = null;
        }
        for (ResourceSubscriber subscriber : this.ldsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.rdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.cdsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
        for (ResourceSubscriber subscriber : this.edsResourceSubscribers.values()) {
            subscriber.stopTimer();
        }
    }

    @Override
    void watchLdsResource(String resourceName, XdsClient.LdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.ldsResourceSubscribers.get(resourceName);
        if (subscriber == null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe CDS resource {0}", resourceName);
            subscriber = new ResourceSubscriber(ResourceType.LDS, resourceName);
            this.ldsResourceSubscribers.put(resourceName, subscriber);
            this.adjustResourceSubscription(ResourceType.LDS, this.ldsResourceSubscribers.keySet());
        }
        subscriber.addWatcher(watcher);
    }

    @Override
    void cancelLdsResourceWatch(String resourceName, XdsClient.LdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.ldsResourceSubscribers.get(resourceName);
        subscriber.removeWatcher(watcher);
        if (!subscriber.isWatched()) {
            subscriber.stopTimer();
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe LDS resource {0}", resourceName);
            this.ldsResourceSubscribers.remove(resourceName);
            this.adjustResourceSubscription(ResourceType.LDS, this.ldsResourceSubscribers.keySet());
        }
    }

    @Override
    void watchRdsResource(String resourceName, XdsClient.RdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.rdsResourceSubscribers.get(resourceName);
        if (subscriber == null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe RDS resource {0}", resourceName);
            subscriber = new ResourceSubscriber(ResourceType.RDS, resourceName);
            this.rdsResourceSubscribers.put(resourceName, subscriber);
            this.adjustResourceSubscription(ResourceType.RDS, this.rdsResourceSubscribers.keySet());
        }
        subscriber.addWatcher(watcher);
    }

    @Override
    void cancelRdsResourceWatch(String resourceName, XdsClient.RdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.rdsResourceSubscribers.get(resourceName);
        subscriber.removeWatcher(watcher);
        if (!subscriber.isWatched()) {
            subscriber.stopTimer();
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe RDS resource {0}", resourceName);
            this.rdsResourceSubscribers.remove(resourceName);
            this.adjustResourceSubscription(ResourceType.RDS, this.rdsResourceSubscribers.keySet());
        }
    }

    @Override
    void watchCdsResource(String resourceName, XdsClient.CdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.cdsResourceSubscribers.get(resourceName);
        if (subscriber == null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe CDS resource {0}", resourceName);
            subscriber = new ResourceSubscriber(ResourceType.CDS, resourceName);
            this.cdsResourceSubscribers.put(resourceName, subscriber);
            this.adjustResourceSubscription(ResourceType.CDS, this.cdsResourceSubscribers.keySet());
        }
        subscriber.addWatcher(watcher);
    }

    @Override
    void cancelCdsResourceWatch(String resourceName, XdsClient.CdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.cdsResourceSubscribers.get(resourceName);
        subscriber.removeWatcher(watcher);
        if (!subscriber.isWatched()) {
            subscriber.stopTimer();
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe CDS resource {0}", resourceName);
            this.cdsResourceSubscribers.remove(resourceName);
            this.adjustResourceSubscription(ResourceType.CDS, this.cdsResourceSubscribers.keySet());
        }
    }

    @Override
    void watchEdsResource(String resourceName, XdsClient.EdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.edsResourceSubscribers.get(resourceName);
        if (subscriber == null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe EDS resource {0}", resourceName);
            subscriber = new ResourceSubscriber(ResourceType.EDS, resourceName);
            this.edsResourceSubscribers.put(resourceName, subscriber);
            this.adjustResourceSubscription(ResourceType.EDS, this.edsResourceSubscribers.keySet());
        }
        subscriber.addWatcher(watcher);
    }

    @Override
    void cancelEdsResourceWatch(String resourceName, XdsClient.EdsResourceWatcher watcher) {
        ResourceSubscriber subscriber = this.edsResourceSubscribers.get(resourceName);
        subscriber.removeWatcher(watcher);
        if (!subscriber.isWatched()) {
            subscriber.stopTimer();
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Unsubscribe EDS resource {0}", resourceName);
            this.edsResourceSubscribers.remove(resourceName);
            this.adjustResourceSubscription(ResourceType.EDS, this.edsResourceSubscribers.keySet());
        }
    }

    @Override
    void watchListenerData(int port, XdsClient.ListenerWatcher watcher) {
        Preconditions.checkState((this.listenerWatcher == null ? 1 : 0) != 0, (Object)"ListenerWatcher already registered");
        this.listenerWatcher = (XdsClient.ListenerWatcher)Preconditions.checkNotNull((Object)watcher, (Object)"watcher");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port needs to be > 0");
        this.listenerPort = port;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Started watching listener for port {0}", port);
        if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        this.updateNodeMetadataForListenerRequest(port);
        this.adsStream.sendXdsRequest(ResourceType.LDS, (Collection)ImmutableList.of());
        this.ldsRespTimer = this.syncContext.schedule((Runnable)new ListenerResourceFetchTimeoutTask(":" + port), 15L, TimeUnit.SECONDS, this.timeService);
    }

    private void updateNodeMetadataForListenerRequest(int port) {
        HashMap<String, Object> newMetadata = new HashMap<String, Object>();
        if (this.node.getMetadata() != null) {
            newMetadata.putAll(this.node.getMetadata());
        }
        newMetadata.put("TRAFFICDIRECTOR_PROXYLESS", "1");
        EnvoyProtoData.Address listeningAddress = new EnvoyProtoData.Address("0.0.0.0", port);
        this.node = this.node.toBuilder().setMetadata(newMetadata).addListeningAddresses(listeningAddress).build();
    }

    @Override
    void reportClientStats() {
        if (this.lrsClient == null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Turning on load reporting");
            this.lrsClient = new LoadReportClient(this.targetName, this.loadStatsManager, this.xdsChannel, this.node, this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        }
        if (this.loadReportCount == 0) {
            this.lrsClient.startLoadReporting();
        }
        ++this.loadReportCount;
    }

    @Override
    void cancelClientStatsReport() {
        Preconditions.checkState((this.loadReportCount > 0 ? 1 : 0) != 0, (Object)"load reporting was never started");
        --this.loadReportCount;
        if (this.loadReportCount == 0) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Turning off load reporting");
            this.lrsClient.stopLoadReporting();
            this.lrsClient = null;
        }
    }

    @Override
    LoadStatsManager.LoadStatsStore addClientStats(String clusterName, @Nullable String clusterServiceName) {
        return this.loadStatsManager.addLoadStats(clusterName, clusterServiceName);
    }

    @Override
    void removeClientStats(String clusterName, @Nullable String clusterServiceName) {
        this.loadStatsManager.removeLoadStats(clusterName, clusterServiceName);
    }

    public String toString() {
        return this.logId.toString();
    }

    private void startRpcStream() {
        Preconditions.checkState((this.adsStream == null ? 1 : 0) != 0, (Object)"Previous adsStream has not been cleared yet");
        this.adsStream = this.xdsChannel.isUseProtocolV3() ? new AdsStream() : new AdsStreamV2();
        this.adsStream.start();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "ADS stream started");
        this.adsStreamRetryStopwatch.reset().start();
    }

    private void handleLdsResponse(DiscoveryResponseData ldsResponse) {
        if (this.listenerWatcher != null) {
            this.handleLdsResponseForServer(ldsResponse);
        } else {
            this.handleLdsResponseForClient(ldsResponse);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleLdsResponseForClient(DiscoveryResponseData ldsResponse) {
        ResourceSubscriber subscriber;
        ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener> listeners = new ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener>(ldsResponse.getResourcesList().size());
        ArrayList<String> listenerNames = new ArrayList<String>(ldsResponse.getResourcesList().size());
        try {
            for (Any any : ldsResponse.getResourcesList()) {
                void var5_6;
                if (any.getTypeUrl().equals(ADS_TYPE_URL_LDS_V2)) {
                    Any any2 = any.toBuilder().setTypeUrl(ADS_TYPE_URL_LDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener)var5_6.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener.class);
                listeners.add(listener);
                listenerNames.add(listener.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listeners in LDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.LDS, this.ldsResourceSubscribers.keySet(), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received LDS response for resources: {0}", listenerNames);
        HashMap<String, io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager> httpConnectionManagers = new HashMap<String, io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager>(listeners.size());
        try {
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener : listeners) {
                Any apiListener = listener.getApiListener().getApiListener();
                if (apiListener.getTypeUrl().equals(TYPE_URL_HTTP_CONNECTION_MANAGER_V2)) {
                    apiListener = apiListener.toBuilder().setTypeUrl(TYPE_URL_HTTP_CONNECTION_MANAGER).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager hcm = (io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager)apiListener.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.class);
                httpConnectionManagers.put(listener.getName(), hcm);
            }
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack HttpConnectionManagers in Listeners of LDS response {0}", new Object[]{invalidProtocolBufferException});
            this.adsStream.sendNackRequest(ResourceType.LDS, this.ldsResourceSubscribers.keySet(), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)invalidProtocolBufferException));
            return;
        }
        HashMap<String, XdsClient.LdsUpdate> hashMap = new HashMap<String, XdsClient.LdsUpdate>();
        HashSet<String> rdsNames = new HashSet<String>();
        String errorMessage = null;
        for (Map.Entry entry : httpConnectionManagers.entrySet()) {
            HttpProtocolOptions options;
            String listenerName = (String)entry.getKey();
            io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager hcm = (io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager)entry.getValue();
            XdsClient.LdsUpdate.Builder updateBuilder = XdsClient.LdsUpdate.newBuilder();
            if (hcm.hasRouteConfig()) {
                for (VirtualHost virtualHostProto : hcm.getRouteConfig().getVirtualHostsList()) {
                    EnvoyProtoData.StructOrError<EnvoyProtoData.VirtualHost> virtualHost = EnvoyProtoData.VirtualHost.fromEnvoyProtoVirtualHost(virtualHostProto);
                    if (virtualHost.getErrorDetail() != null) {
                        errorMessage = "Listener " + listenerName + " contains invalid virtual host: " + virtualHost.getErrorDetail();
                        break;
                    }
                    updateBuilder.addVirtualHost(virtualHost.getStruct());
                }
            } else if (hcm.hasRds()) {
                Rds rds = hcm.getRds();
                if (!rds.getConfigSource().hasAds()) {
                    errorMessage = "Listener " + listenerName + " with RDS config_source not set to ADS";
                } else {
                    updateBuilder.setRdsName(rds.getRouteConfigName());
                    rdsNames.add(rds.getRouteConfigName());
                }
            } else {
                errorMessage = "Listener " + listenerName + " without inline RouteConfiguration or RDS";
            }
            if (errorMessage != null) break;
            if (hcm.hasCommonHttpProtocolOptions() && (options = hcm.getCommonHttpProtocolOptions()).hasMaxStreamDuration()) {
                updateBuilder.setHttpMaxStreamDurationNano(Durations.toNanos((Duration)options.getMaxStreamDuration()));
            }
            hashMap.put(listenerName, updateBuilder.build());
        }
        if (errorMessage != null) {
            this.adsStream.sendNackRequest(ResourceType.LDS, this.ldsResourceSubscribers.keySet(), ldsResponse.getVersionInfo(), errorMessage);
            return;
        }
        this.adsStream.sendAckRequest(ResourceType.LDS, this.ldsResourceSubscribers.keySet(), ldsResponse.getVersionInfo());
        for (String resource : this.ldsResourceSubscribers.keySet()) {
            subscriber = this.ldsResourceSubscribers.get(resource);
            if (hashMap.containsKey(resource)) {
                subscriber.onData((XdsClient.ResourceUpdate)hashMap.get(resource));
                continue;
            }
            subscriber.onAbsent();
        }
        for (String resource : this.rdsResourceSubscribers.keySet()) {
            if (rdsNames.contains(resource)) continue;
            subscriber = this.rdsResourceSubscribers.get(resource);
            subscriber.onAbsent();
        }
    }

    private void handleRdsResponse(DiscoveryResponseData rdsResponse) {
        HashMap<String, RouteConfiguration> routeConfigs = new HashMap<String, RouteConfiguration>(rdsResponse.getResourcesList().size());
        try {
            for (Any res : rdsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_RDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_RDS).build();
                }
                RouteConfiguration rc = (RouteConfiguration)res.unpack(RouteConfiguration.class);
                routeConfigs.put(rc.getName(), rc);
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack RouteConfiguration in RDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.RDS, this.rdsResourceSubscribers.keySet(), rdsResponse.getVersionInfo(), "Malformed RDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received RDS response for resources: {0}", routeConfigs.keySet());
        HashMap<String, XdsClient.RdsUpdate> rdsUpdates = new HashMap<String, XdsClient.RdsUpdate>();
        String errorMessage = null;
        for (Map.Entry entry : routeConfigs.entrySet()) {
            String routeConfigName = (String)entry.getKey();
            RouteConfiguration routeConfig = (RouteConfiguration)entry.getValue();
            ArrayList<EnvoyProtoData.VirtualHost> virtualHosts = new ArrayList<EnvoyProtoData.VirtualHost>(routeConfig.getVirtualHostsCount());
            for (VirtualHost virtualHostProto : routeConfig.getVirtualHostsList()) {
                EnvoyProtoData.StructOrError<EnvoyProtoData.VirtualHost> virtualHost = EnvoyProtoData.VirtualHost.fromEnvoyProtoVirtualHost(virtualHostProto);
                if (virtualHost.getErrorDetail() != null) {
                    errorMessage = "RouteConfiguration " + routeConfigName + " contains invalid virtual host: " + virtualHost.getErrorDetail();
                    break;
                }
                virtualHosts.add(virtualHost.getStruct());
            }
            if (errorMessage != null) break;
            rdsUpdates.put(routeConfigName, XdsClient.RdsUpdate.fromVirtualHosts(virtualHosts));
        }
        if (errorMessage != null) {
            this.adsStream.sendNackRequest(ResourceType.RDS, this.rdsResourceSubscribers.keySet(), rdsResponse.getVersionInfo(), errorMessage);
            return;
        }
        this.adsStream.sendAckRequest(ResourceType.RDS, this.rdsResourceSubscribers.keySet(), rdsResponse.getVersionInfo());
        for (String resource : this.rdsResourceSubscribers.keySet()) {
            if (!rdsUpdates.containsKey(resource)) continue;
            ResourceSubscriber subscriber = this.rdsResourceSubscribers.get(resource);
            subscriber.onData((XdsClient.ResourceUpdate)rdsUpdates.get(resource));
        }
    }

    private void handleLdsResponseForServer(DiscoveryResponseData ldsResponse) {
        io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener requestedListener = null;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Listener count: {0}", ldsResponse.getResourcesList().size());
        try {
            for (Any res : ldsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_LDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_LDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener)res.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener.class);
                this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Found listener {0}", listener.toString());
                if (!this.isRequestedListener(listener)) continue;
                requestedListener = listener;
                this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Requested listener found: {0}", listener.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listeners in LDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.LDS, (Collection)ImmutableList.of(), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)e));
            return;
        }
        XdsClient.ListenerUpdate listenerUpdate = null;
        if (requestedListener != null) {
            if (this.ldsRespTimer != null) {
                this.ldsRespTimer.cancel();
                this.ldsRespTimer = null;
            }
            try {
                listenerUpdate = XdsClient.ListenerUpdate.newBuilder().setListener(EnvoyServerProtoData.Listener.fromEnvoyProtoListener(requestedListener)).build();
            }
            catch (InvalidProtocolBufferException e) {
                this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Listener in LDS response {0}", new Object[]{e});
                this.adsStream.sendNackRequest(ResourceType.LDS, (Collection)ImmutableList.of(), ldsResponse.getVersionInfo(), "Malformed LDS response: " + (Object)((Object)e));
                return;
            }
        } else if (this.ldsRespTimer == null) {
            this.listenerWatcher.onResourceDoesNotExist(":" + this.listenerPort);
        }
        this.adsStream.sendAckRequest(ResourceType.LDS, (Collection)ImmutableList.of(), ldsResponse.getVersionInfo());
        if (listenerUpdate != null) {
            this.listenerWatcher.onListenerChanged(listenerUpdate);
        }
    }

    private boolean isRequestedListener(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener listener) {
        return this.isAddressMatching(listener.getAddress()) && this.hasMatchingFilter(listener.getFilterChainsList());
    }

    private boolean isAddressMatching(Address address) {
        return address.hasSocketAddress() && address.getSocketAddress().getPortValue() == this.listenerPort;
    }

    private boolean hasMatchingFilter(List<FilterChain> filterChainsList) {
        for (FilterChain filterChain : filterChainsList) {
            FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            if (this.listenerPort != filterChainMatch.getDestinationPort().getValue()) continue;
            return true;
        }
        return false;
    }

    private void handleCdsResponse(DiscoveryResponseData cdsResponse) {
        ResourceSubscriber subscriber;
        this.adsStream.cdsRespNonce = cdsResponse.getNonce();
        ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster> clusters = new ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster>(cdsResponse.getResourcesList().size());
        ArrayList<String> clusterNames = new ArrayList<String>(cdsResponse.getResourcesList().size());
        try {
            for (Any res : cdsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_CDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_CDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster cluster = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster)res.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster.class);
                clusters.add(cluster);
                clusterNames.add(cluster.getName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack Clusters in CDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.CDS, this.cdsResourceSubscribers.keySet(), cdsResponse.getVersionInfo(), "Malformed CDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received CDS response for resources: {0}", clusterNames);
        String errorMessage = null;
        HashMap<String, XdsClient.CdsUpdate> cdsUpdates = new HashMap<String, XdsClient.CdsUpdate>();
        HashSet<String> edsServices = new HashSet<String>();
        for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster cluster : clusters) {
            XdsClient.CdsUpdate.Builder updateBuilder;
            String clusterName;
            block18: {
                clusterName = cluster.getName();
                if (!this.cdsResourceSubscribers.containsKey(clusterName)) continue;
                updateBuilder = XdsClient.CdsUpdate.newBuilder();
                updateBuilder.setClusterName(clusterName);
                if (!cluster.getType().equals((Object)Cluster.DiscoveryType.EDS)) {
                    errorMessage = "Cluster " + clusterName + " : only EDS discovery type is supported in gRPC.";
                    break;
                }
                Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
                if (!edsClusterConfig.getEdsConfig().hasAds()) {
                    errorMessage = "Cluster " + clusterName + " : field eds_cluster_config must be set to indicate to use EDS over ADS.";
                    break;
                }
                if (!edsClusterConfig.getServiceName().isEmpty()) {
                    updateBuilder.setEdsServiceName(edsClusterConfig.getServiceName());
                    edsServices.add(edsClusterConfig.getServiceName());
                } else {
                    edsServices.add(clusterName);
                }
                if (!cluster.getLbPolicy().equals((Object)Cluster.LbPolicy.ROUND_ROBIN)) {
                    errorMessage = "Cluster " + clusterName + " : only round robin load balancing policy is supported in gRPC.";
                    break;
                }
                updateBuilder.setLbPolicy("round_robin");
                if (cluster.hasLrsServer()) {
                    if (!cluster.getLrsServer().hasSelf()) {
                        errorMessage = "Cluster " + clusterName + " : only support enabling LRS for the same management server.";
                        break;
                    }
                    updateBuilder.setLrsServerName("");
                }
                try {
                    EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = XdsClientImpl2.getTlsContextFromCluster(cluster);
                    if (upstreamTlsContext == null || upstreamTlsContext.getCommonTlsContext() == null) break block18;
                    updateBuilder.setUpstreamTlsContext(upstreamTlsContext);
                }
                catch (InvalidProtocolBufferException e) {
                    errorMessage = "Cluster " + clusterName + " : " + e.getMessage();
                    break;
                }
            }
            cdsUpdates.put(clusterName, updateBuilder.build());
        }
        if (errorMessage != null) {
            this.adsStream.sendNackRequest(ResourceType.CDS, this.cdsResourceSubscribers.keySet(), cdsResponse.getVersionInfo(), errorMessage);
            return;
        }
        this.adsStream.sendAckRequest(ResourceType.CDS, this.cdsResourceSubscribers.keySet(), cdsResponse.getVersionInfo());
        for (String resource : this.cdsResourceSubscribers.keySet()) {
            subscriber = this.cdsResourceSubscribers.get(resource);
            if (cdsUpdates.containsKey(resource)) {
                subscriber.onData((XdsClient.ResourceUpdate)cdsUpdates.get(resource));
                continue;
            }
            subscriber.onAbsent();
        }
        for (String resource : this.edsResourceSubscribers.keySet()) {
            subscriber = this.edsResourceSubscribers.get(resource);
            if (edsServices.contains(resource)) continue;
            subscriber.onAbsent();
        }
    }

    @Nullable
    private static EnvoyServerProtoData.UpstreamTlsContext getTlsContextFromCluster(io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster cluster) throws InvalidProtocolBufferException {
        if (cluster.hasTransportSocket() && "tls".equals(cluster.getTransportSocket().getName())) {
            Any any = cluster.getTransportSocket().getTypedConfig();
            return EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext((UpstreamTlsContext)any.unpack(UpstreamTlsContext.class));
        }
        return null;
    }

    private void handleEdsResponse(DiscoveryResponseData edsResponse) {
        ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment> clusterLoadAssignments = new ArrayList<io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment>(edsResponse.getResourcesList().size());
        ArrayList<String> claNames = new ArrayList<String>(edsResponse.getResourcesList().size());
        try {
            for (Any res : edsResponse.getResourcesList()) {
                if (res.getTypeUrl().equals(ADS_TYPE_URL_EDS_V2)) {
                    res = res.toBuilder().setTypeUrl(ADS_TYPE_URL_EDS).build();
                }
                io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment assignment = (io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment)res.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment.class);
                clusterLoadAssignments.add(assignment);
                claNames.add(assignment.getClusterName());
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to unpack ClusterLoadAssignments in EDS response {0}", new Object[]{e});
            this.adsStream.sendNackRequest(ResourceType.EDS, this.edsResourceSubscribers.keySet(), edsResponse.getVersionInfo(), "Malformed EDS response: " + (Object)((Object)e));
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS response for resources: {0}", claNames);
        String errorMessage = null;
        HashMap<String, XdsClient.EdsUpdate> edsUpdates = new HashMap<String, XdsClient.EdsUpdate>();
        for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment assignment : clusterLoadAssignments) {
            String clusterName = assignment.getClusterName();
            if (!this.edsResourceSubscribers.containsKey(clusterName)) continue;
            XdsClient.EdsUpdate.Builder updateBuilder = XdsClient.EdsUpdate.newBuilder();
            updateBuilder.setClusterName(clusterName);
            HashSet<Integer> priorities = new HashSet<Integer>();
            int maxPriority = -1;
            for (LocalityLbEndpoints localityLbEndpoints : assignment.getEndpointsList()) {
                if (!localityLbEndpoints.hasLoadBalancingWeight() || localityLbEndpoints.getLoadBalancingWeight().getValue() < 1) continue;
                int localityPriority = localityLbEndpoints.getPriority();
                if (localityPriority < 0) {
                    errorMessage = "ClusterLoadAssignment " + clusterName + " : locality with negative priority.";
                    break;
                }
                maxPriority = Math.max(maxPriority, localityPriority);
                priorities.add(localityPriority);
                for (LbEndpoint lbEndpoint : localityLbEndpoints.getLbEndpointsList()) {
                    if (lbEndpoint.getEndpoint().hasAddress()) continue;
                    errorMessage = "ClusterLoadAssignment " + clusterName + " : endpoint with no address.";
                    break;
                }
                if (errorMessage != null) break;
                updateBuilder.addLocalityLbEndpoints(EnvoyProtoData.Locality.fromEnvoyProtoLocality(localityLbEndpoints.getLocality()), EnvoyProtoData.LocalityLbEndpoints.fromEnvoyProtoLocalityLbEndpoints(localityLbEndpoints));
            }
            if (errorMessage != null) break;
            if (priorities.size() != maxPriority + 1) {
                errorMessage = "ClusterLoadAssignment " + clusterName + " : sparse priorities.";
                break;
            }
            for (ClusterLoadAssignment.Policy.DropOverload dropOverload : assignment.getPolicy().getDropOverloadsList()) {
                updateBuilder.addDropPolicy(EnvoyProtoData.DropOverload.fromEnvoyProtoDropOverload(dropOverload));
            }
            XdsClient.EdsUpdate update = updateBuilder.build();
            edsUpdates.put(clusterName, update);
        }
        if (errorMessage != null) {
            this.adsStream.sendNackRequest(ResourceType.EDS, this.edsResourceSubscribers.keySet(), edsResponse.getVersionInfo(), errorMessage);
            return;
        }
        this.adsStream.sendAckRequest(ResourceType.EDS, this.edsResourceSubscribers.keySet(), edsResponse.getVersionInfo());
        for (String resource : this.edsResourceSubscribers.keySet()) {
            ResourceSubscriber subscriber = this.edsResourceSubscribers.get(resource);
            if (!edsUpdates.containsKey(resource)) continue;
            subscriber.onData((XdsClient.ResourceUpdate)edsUpdates.get(resource));
        }
    }

    private void adjustResourceSubscription(ResourceType type, Collection<String> resources) {
        if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        this.adsStream.sendXdsRequest(type, resources);
    }

    @VisibleForTesting
    static final class MessagePrinter {
        private final JsonFormat.Printer printer;

        @VisibleForTesting
        MessagePrinter() {
            TypeRegistry registry = TypeRegistry.newBuilder().add(io.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener.getDescriptor()).add(Listener.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager.getDescriptor()).add(HttpConnectionManager.getDescriptor()).add(RouteConfiguration.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.RouteConfiguration.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster.getDescriptor()).add(Cluster.getDescriptor()).add(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment.getDescriptor()).add(ClusterLoadAssignment.getDescriptor()).build();
            this.printer = JsonFormat.printer().usingTypeRegistry(registry);
        }

        @VisibleForTesting
        String print(MessageOrBuilder message) {
            String res;
            try {
                res = this.printer.print(message);
            }
            catch (InvalidProtocolBufferException e) {
                res = message + " (failed to pretty-print: " + (Object)((Object)e) + ")";
            }
            return res;
        }
    }

    @VisibleForTesting
    final class ListenerResourceFetchTimeoutTask
    implements Runnable {
        private String resourceName;

        ListenerResourceFetchTimeoutTask(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public void run() {
            XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Did not receive resource info {0} after {1} seconds, conclude it absent", this.resourceName, 15);
            XdsClientImpl2.this.ldsRespTimer = null;
            XdsClientImpl2.this.listenerWatcher.onResourceDoesNotExist(this.resourceName);
        }
    }

    private final class AdsStream
    extends AbstractAdsStream {
        private final AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stub;
        private StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest> requestWriter;

        AdsStream() {
            this.stub = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc.newStub((Channel)XdsClientImpl2.this.xdsChannel.getManagedChannel());
        }

        @Override
        void start() {
            StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse> responseReader = new StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse>(){

                public void onNext(final io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse response) {
                    XdsClientImpl2.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (XdsClientImpl2.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                                XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", new Object[]{ResourceType.fromTypeUrl(response.getTypeUrl()), XdsClientImpl2.this.respPrinter.print(response)});
                            }
                            DiscoveryResponseData responseData = DiscoveryResponseData.fromEnvoyProto(response);
                            AdsStream.this.handleResponse(responseData);
                        }
                    });
                }

                public void onError(final Throwable t) {
                    XdsClientImpl2.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStream.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    XdsClientImpl2.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStream.this.handleRpcCompleted();
                        }
                    });
                }
            };
            this.requestWriter = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)this.stub.withWaitForReady()).streamAggregatedResources(responseReader);
        }

        @Override
        void sendDiscoveryRequest(DiscoveryRequestData request) {
            Preconditions.checkState((this.requestWriter != null ? 1 : 0) != 0, (Object)"ADS stream has not been started");
            io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest requestProto = request.toEnvoyProto();
            this.requestWriter.onNext((Object)requestProto);
            XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", requestProto);
        }

        @Override
        void sendError(Exception error) {
            this.requestWriter.onError((Throwable)error);
        }
    }

    private final class AdsStreamV2
    extends AbstractAdsStream {
        private final AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stubV2;
        private StreamObserver<DiscoveryRequest> requestWriterV2;

        AdsStreamV2() {
            this.stubV2 = AggregatedDiscoveryServiceGrpc.newStub((Channel)XdsClientImpl2.this.xdsChannel.getManagedChannel());
        }

        @Override
        void start() {
            StreamObserver<DiscoveryResponse> responseReaderV2 = new StreamObserver<DiscoveryResponse>(){

                public void onNext(final DiscoveryResponse response) {
                    XdsClientImpl2.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (XdsClientImpl2.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                                XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", new Object[]{ResourceType.fromTypeUrl(response.getTypeUrl()), XdsClientImpl2.this.respPrinter.print(response)});
                            }
                            DiscoveryResponseData responseData = DiscoveryResponseData.fromEnvoyProtoV2(response);
                            AdsStreamV2.this.handleResponse(responseData);
                        }
                    });
                }

                public void onError(final Throwable t) {
                    XdsClientImpl2.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV2.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    XdsClientImpl2.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV2.this.handleRpcCompleted();
                        }
                    });
                }
            };
            this.requestWriterV2 = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)this.stubV2.withWaitForReady()).streamAggregatedResources(responseReaderV2);
        }

        @Override
        void sendDiscoveryRequest(DiscoveryRequestData request) {
            Preconditions.checkState((this.requestWriterV2 != null ? 1 : 0) != 0, (Object)"ADS stream has not been started");
            DiscoveryRequest requestProto = request.toEnvoyProtoV2();
            this.requestWriterV2.onNext((Object)requestProto);
            XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", requestProto);
        }

        @Override
        void sendError(Exception error) {
            this.requestWriterV2.onError((Throwable)error);
        }
    }

    private abstract class AbstractAdsStream {
        private boolean responseReceived;
        private boolean closed;
        private String ldsRespNonce = "";
        private String rdsRespNonce = "";
        private String cdsRespNonce = "";
        private String edsRespNonce = "";

        private AbstractAdsStream() {
        }

        abstract void start();

        abstract void sendDiscoveryRequest(DiscoveryRequestData var1);

        abstract void sendError(Exception var1);

        final void handleResponse(DiscoveryResponseData response) {
            if (this.closed) {
                return;
            }
            this.responseReceived = true;
            String respNonce = response.getNonce();
            ResourceType resourceType = response.getResourceType();
            switch (resourceType) {
                case LDS: {
                    this.ldsRespNonce = respNonce;
                    XdsClientImpl2.this.handleLdsResponse(response);
                    break;
                }
                case RDS: {
                    this.rdsRespNonce = respNonce;
                    XdsClientImpl2.this.handleRdsResponse(response);
                    break;
                }
                case CDS: {
                    this.cdsRespNonce = respNonce;
                    XdsClientImpl2.this.handleCdsResponse(response);
                    break;
                }
                case EDS: {
                    this.edsRespNonce = respNonce;
                    XdsClientImpl2.this.handleEdsResponse(response);
                    break;
                }
                case UNKNOWN: {
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received an unknown type of DiscoveryResponse\n{0}", respNonce);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Missing case in enum switch: " + (Object)((Object)resourceType)));
                }
            }
        }

        final void handleRpcError(Throwable t) {
            this.handleStreamClosed(Status.fromThrowable((Throwable)t));
        }

        final void handleRpcCompleted() {
            this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
        }

        private void handleStreamClosed(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "ADS stream closed with status {0}: {1}. Cause: {2}", error.getCode(), error.getDescription(), error.getCause());
            this.closed = true;
            if (XdsClientImpl2.this.listenerWatcher != null) {
                XdsClientImpl2.this.listenerWatcher.onError(error);
            }
            for (ResourceSubscriber subscriber : XdsClientImpl2.this.ldsResourceSubscribers.values()) {
                subscriber.onError(error);
            }
            for (ResourceSubscriber subscriber : XdsClientImpl2.this.rdsResourceSubscribers.values()) {
                subscriber.onError(error);
            }
            for (ResourceSubscriber subscriber : XdsClientImpl2.this.cdsResourceSubscribers.values()) {
                subscriber.onError(error);
            }
            for (ResourceSubscriber subscriber : XdsClientImpl2.this.edsResourceSubscribers.values()) {
                subscriber.onError(error);
            }
            this.cleanUp();
            XdsClientImpl2.this.cleanUpResourceTimers();
            if (this.responseReceived || XdsClientImpl2.this.retryBackoffPolicy == null) {
                XdsClientImpl2.this.retryBackoffPolicy = XdsClientImpl2.this.backoffPolicyProvider.get();
            }
            long delayNanos = 0L;
            if (!this.responseReceived) {
                delayNanos = Math.max(0L, XdsClientImpl2.this.retryBackoffPolicy.nextBackoffNanos() - XdsClientImpl2.this.adsStreamRetryStopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
            XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry ADS stream in {0} ns", delayNanos);
            XdsClientImpl2.this.rpcRetryTimer = XdsClientImpl2.this.syncContext.schedule((Runnable)new RpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, XdsClientImpl2.this.timeService);
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (XdsClientImpl2.this.adsStream == this) {
                XdsClientImpl2.this.adsStream = null;
            }
        }

        private void sendXdsRequest(ResourceType resourceType, Collection<String> resourceNames) {
            String nonce;
            String version;
            switch (resourceType) {
                case LDS: {
                    version = XdsClientImpl2.this.ldsVersion;
                    nonce = this.ldsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending LDS request for resources: {0}", resourceNames);
                    break;
                }
                case RDS: {
                    version = XdsClientImpl2.this.rdsVersion;
                    nonce = this.rdsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending RDS request for resources: {0}", resourceNames);
                    break;
                }
                case CDS: {
                    version = XdsClientImpl2.this.cdsVersion;
                    nonce = this.cdsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending CDS request for resources: {0}", resourceNames);
                    break;
                }
                case EDS: {
                    version = XdsClientImpl2.this.edsVersion;
                    nonce = this.edsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending EDS request for resources: {0}", resourceNames);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)resourceType)));
                }
            }
            DiscoveryRequestData request = new DiscoveryRequestData(resourceType, resourceNames, version, nonce, XdsClientImpl2.this.node, null);
            this.sendDiscoveryRequest(request);
        }

        private void sendAckRequest(ResourceType resourceType, Collection<String> resourceNames, String versionInfo) {
            String nonce;
            switch (resourceType) {
                case LDS: {
                    XdsClientImpl2.this.ldsVersion = versionInfo;
                    nonce = this.ldsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for LDS update, version: {0}", versionInfo);
                    break;
                }
                case RDS: {
                    XdsClientImpl2.this.rdsVersion = versionInfo;
                    nonce = this.rdsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for RDS update, version: {0}", versionInfo);
                    break;
                }
                case CDS: {
                    XdsClientImpl2.this.cdsVersion = versionInfo;
                    nonce = this.cdsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for CDS update, version: {0}", versionInfo);
                    break;
                }
                case EDS: {
                    XdsClientImpl2.this.edsVersion = versionInfo;
                    nonce = this.edsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending ACK for EDS update, version: {0}", versionInfo);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)resourceType)));
                }
            }
            DiscoveryRequestData request = new DiscoveryRequestData(resourceType, resourceNames, versionInfo, nonce, XdsClientImpl2.this.node, null);
            this.sendDiscoveryRequest(request);
        }

        private void sendNackRequest(ResourceType resourceType, Collection<String> resourceNames, String rejectVersion, String message) {
            String nonce;
            String versionInfo;
            switch (resourceType) {
                case LDS: {
                    versionInfo = XdsClientImpl2.this.ldsVersion;
                    nonce = this.ldsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for LDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                case RDS: {
                    versionInfo = XdsClientImpl2.this.rdsVersion;
                    nonce = this.rdsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for RDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                case CDS: {
                    versionInfo = XdsClientImpl2.this.cdsVersion;
                    nonce = this.cdsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for CDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                case EDS: {
                    versionInfo = XdsClientImpl2.this.edsVersion;
                    nonce = this.edsRespNonce;
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Sending NACK for EDS update, version: {0}, reason: {1}", rejectVersion, message);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)resourceType)));
                }
            }
            com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(message).build();
            DiscoveryRequestData request = new DiscoveryRequestData(resourceType, resourceNames, versionInfo, nonce, XdsClientImpl2.this.node, error);
            this.sendDiscoveryRequest(request);
        }
    }

    private static final class DiscoveryResponseData {
        private final ResourceType resourceType;
        private final List<Any> resources;
        private final String versionInfo;
        private final String nonce;

        DiscoveryResponseData(ResourceType resourceType, List<Any> resources, String versionInfo, String nonce) {
            this.resourceType = resourceType;
            this.resources = resources;
            this.versionInfo = versionInfo;
            this.nonce = nonce;
        }

        ResourceType getResourceType() {
            return this.resourceType;
        }

        List<Any> getResourcesList() {
            return this.resources;
        }

        String getVersionInfo() {
            return this.versionInfo;
        }

        String getNonce() {
            return this.nonce;
        }

        static DiscoveryResponseData fromEnvoyProto(io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse proto) {
            return new DiscoveryResponseData(ResourceType.fromTypeUrl(proto.getTypeUrl()), proto.getResourcesList(), proto.getVersionInfo(), proto.getNonce());
        }

        static DiscoveryResponseData fromEnvoyProtoV2(DiscoveryResponse proto) {
            return new DiscoveryResponseData(ResourceType.fromTypeUrl(proto.getTypeUrl()), proto.getResourcesList(), proto.getVersionInfo(), proto.getNonce());
        }
    }

    private static final class DiscoveryRequestData {
        private final ResourceType resourceType;
        private final Collection<String> resourceNames;
        private final String versionInfo;
        private final String responseNonce;
        private final EnvoyProtoData.Node node;
        @Nullable
        private final com.google.rpc.Status errorDetail;

        DiscoveryRequestData(ResourceType resourceType, Collection<String> resourceNames, String versionInfo, String responseNonce, EnvoyProtoData.Node node, @Nullable com.google.rpc.Status errorDetail) {
            this.resourceType = resourceType;
            this.resourceNames = resourceNames;
            this.versionInfo = versionInfo;
            this.responseNonce = responseNonce;
            this.node = node;
            this.errorDetail = errorDetail;
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest toEnvoyProto() {
            DiscoveryRequest.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest.newBuilder().setVersionInfo(this.versionInfo).setNode(this.node.toEnvoyProtoNode()).addAllResourceNames(this.resourceNames).setTypeUrl(this.resourceType.typeUrl()).setResponseNonce(this.responseNonce);
            if (this.errorDetail != null) {
                builder.setErrorDetail(this.errorDetail);
            }
            return builder.build();
        }

        DiscoveryRequest toEnvoyProtoV2() {
            DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setVersionInfo(this.versionInfo).setNode(this.node.toEnvoyProtoNodeV2()).addAllResourceNames(this.resourceNames).setTypeUrl(this.resourceType.typeUrlV2()).setResponseNonce(this.responseNonce);
            if (this.errorDetail != null) {
                builder.setErrorDetail(this.errorDetail);
            }
            return builder.build();
        }
    }

    private final class ResourceSubscriber {
        private final ResourceType type;
        private final String resource;
        private final Set<XdsClient.ResourceWatcher> watchers = new HashSet<XdsClient.ResourceWatcher>();
        private XdsClient.ResourceUpdate data;
        private boolean absent;
        private SynchronizationContext.ScheduledHandle respTimer;

        ResourceSubscriber(ResourceType type, String resource) {
            this.type = type;
            this.resource = resource;
            if (XdsClientImpl2.this.rpcRetryTimer != null && XdsClientImpl2.this.rpcRetryTimer.isPending()) {
                return;
            }
            this.restartTimer();
        }

        void addWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((!this.watchers.contains(watcher) ? 1 : 0) != 0, (String)"watcher %s already registered", (Object)watcher);
            this.watchers.add(watcher);
            if (this.data != null) {
                this.notifyWatcher(watcher, this.data);
            } else if (this.absent) {
                watcher.onResourceDoesNotExist(this.resource);
            }
        }

        void removeWatcher(XdsClient.ResourceWatcher watcher) {
            Preconditions.checkArgument((boolean)this.watchers.contains(watcher), (String)"watcher %s not registered", (Object)watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", new Object[]{ResourceSubscriber.this.type, ResourceSubscriber.this.resource});
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent();
                }

                public String toString() {
                    return (Object)((Object)ResourceSubscriber.this.type) + this.getClass().getSimpleName();
                }
            }
            this.respTimer = XdsClientImpl2.this.syncContext.schedule((Runnable)new ResourceNotFound(), 15L, TimeUnit.SECONDS, XdsClientImpl2.this.timeService);
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        void onData(XdsClient.ResourceUpdate data) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            XdsClient.ResourceUpdate oldData = this.data;
            this.data = data;
            this.absent = false;
            if (!Objects.equals(oldData, data)) {
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    this.notifyWatcher(watcher, data);
                }
            }
        }

        void onAbsent() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            XdsClientImpl2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", new Object[]{this.type, this.resource});
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                for (XdsClient.ResourceWatcher watcher : this.watchers) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            }
        }

        void onError(Status error) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            for (XdsClient.ResourceWatcher watcher : this.watchers) {
                watcher.onError(error);
            }
        }

        private void notifyWatcher(XdsClient.ResourceWatcher watcher, XdsClient.ResourceUpdate update) {
            switch (this.type) {
                case LDS: {
                    ((XdsClient.LdsResourceWatcher)watcher).onChanged((XdsClient.LdsUpdate)update);
                    break;
                }
                case RDS: {
                    ((XdsClient.RdsResourceWatcher)watcher).onChanged((XdsClient.RdsUpdate)update);
                    break;
                }
                case CDS: {
                    ((XdsClient.CdsResourceWatcher)watcher).onChanged((XdsClient.CdsUpdate)update);
                    break;
                }
                case EDS: {
                    ((XdsClient.EdsResourceWatcher)watcher).onChanged((XdsClient.EdsUpdate)update);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"should never be here");
                }
            }
        }
    }

    @VisibleForTesting
    static enum ResourceType {
        UNKNOWN,
        LDS,
        RDS,
        CDS,
        EDS;


        @VisibleForTesting
        String typeUrl() {
            switch (this) {
                case LDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_LDS;
                }
                case RDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_RDS;
                }
                case CDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_CDS;
                }
                case EDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_EDS;
                }
            }
            throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)this)));
        }

        private String typeUrlV2() {
            switch (this) {
                case LDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_LDS_V2;
                }
                case RDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_RDS_V2;
                }
                case CDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_CDS_V2;
                }
                case EDS: {
                    return XdsClientImpl2.ADS_TYPE_URL_EDS_V2;
                }
            }
            throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)this)));
        }

        private static ResourceType fromTypeUrl(String typeUrl) {
            switch (typeUrl) {
                case "type.googleapis.com/envoy.config.listener.v3.Listener": 
                case "type.googleapis.com/envoy.api.v2.Listener": {
                    return LDS;
                }
                case "type.googleapis.com/envoy.config.route.v3.RouteConfiguration": 
                case "type.googleapis.com/envoy.api.v2.RouteConfiguration": {
                    return RDS;
                }
                case "type.googleapis.com/envoy.config.cluster.v3.Cluster": 
                case "type.googleapis.com/envoy.api.v2.Cluster": {
                    return CDS;
                }
                case "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment": 
                case "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment": {
                    return EDS;
                }
            }
            return UNKNOWN;
        }
    }

    @VisibleForTesting
    final class RpcRetryTask
    implements Runnable {
        RpcRetryTask() {
        }

        @Override
        public void run() {
            XdsClientImpl2.this.startRpcStream();
            if (XdsClientImpl2.this.listenerWatcher != null) {
                XdsClientImpl2.this.adsStream.sendXdsRequest(ResourceType.LDS, (Collection)ImmutableList.of());
                XdsClientImpl2.this.ldsRespTimer = XdsClientImpl2.this.syncContext.schedule((Runnable)new ListenerResourceFetchTimeoutTask(":" + XdsClientImpl2.this.listenerPort), 15L, TimeUnit.SECONDS, XdsClientImpl2.this.timeService);
            }
            if (!XdsClientImpl2.this.ldsResourceSubscribers.isEmpty()) {
                XdsClientImpl2.this.adsStream.sendXdsRequest(ResourceType.LDS, XdsClientImpl2.this.ldsResourceSubscribers.keySet());
                for (ResourceSubscriber subscriber : XdsClientImpl2.this.ldsResourceSubscribers.values()) {
                    subscriber.restartTimer();
                }
            }
            if (!XdsClientImpl2.this.rdsResourceSubscribers.isEmpty()) {
                XdsClientImpl2.this.adsStream.sendXdsRequest(ResourceType.RDS, XdsClientImpl2.this.rdsResourceSubscribers.keySet());
                for (ResourceSubscriber subscriber : XdsClientImpl2.this.rdsResourceSubscribers.values()) {
                    subscriber.restartTimer();
                }
            }
            if (!XdsClientImpl2.this.cdsResourceSubscribers.isEmpty()) {
                XdsClientImpl2.this.adsStream.sendXdsRequest(ResourceType.CDS, XdsClientImpl2.this.cdsResourceSubscribers.keySet());
                for (ResourceSubscriber subscriber : XdsClientImpl2.this.cdsResourceSubscribers.values()) {
                    subscriber.restartTimer();
                }
            }
            if (!XdsClientImpl2.this.edsResourceSubscribers.isEmpty()) {
                XdsClientImpl2.this.adsStream.sendXdsRequest(ResourceType.EDS, XdsClientImpl2.this.edsResourceSubscribers.keySet());
                for (ResourceSubscriber subscriber : XdsClientImpl2.this.edsResourceSubscribers.values()) {
                    subscriber.restartTimer();
                }
            }
        }
    }
}

