/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.bk;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.BookKeeperClient;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.bk.LedgerAllocator;
import org.apache.distributedlog.bk.LedgerMetadata;
import org.apache.distributedlog.bk.QuorumConfig;
import org.apache.distributedlog.bk.QuorumConfigProvider;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.util.Utils;
import org.apache.distributedlog.zk.ZKTransaction;
import org.apache.distributedlog.zk.ZKVersionedSetOp;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLedgerAllocator
implements LedgerAllocator,
FutureEventListener<LedgerHandle>,
Transaction.OpListener<Version> {
    static final Logger LOG = LoggerFactory.getLogger(SimpleLedgerAllocator.class);
    final ZooKeeperClient zkc;
    final BookKeeperClient bkc;
    final String allocatePath;
    Phase phase = Phase.HANDED_OVER;
    LongVersion version = new LongVersion(-1L);
    CompletableFuture<LedgerHandle> allocatePromise;
    Transaction<Object> tryObtainTxn = null;
    Transaction.OpListener<LedgerHandle> tryObtainListener = null;
    Long ledgerIdLeftFromPrevAllocation = null;
    LedgerHandle allocatedLh = null;
    LedgerMetadata ledgerMetadata;
    CompletableFuture<Void> closeFuture = null;
    final LinkedList<CompletableFuture<Void>> ledgerDeletions = new LinkedList();
    private final QuorumConfigProvider quorumConfigProvider;

    static CompletableFuture<Versioned<byte[]>> getAndCreateAllocationData(final String allocatePath, final ZooKeeperClient zkc) {
        return Utils.zkGetData(zkc, allocatePath, false).thenCompose(new Function<Versioned<byte[]>, CompletionStage<Versioned<byte[]>>>(){

            @Override
            public CompletableFuture<Versioned<byte[]>> apply(Versioned<byte[]> result) {
                if (null != result && null != result.getVersion() && null != result.getValue()) {
                    return FutureUtils.value(result);
                }
                return SimpleLedgerAllocator.createAllocationData(allocatePath, zkc);
            }
        });
    }

    private static CompletableFuture<Versioned<byte[]>> createAllocationData(String allocatePath, ZooKeeperClient zkc) {
        try {
            CompletableFuture<Versioned<byte[]>> promise = new CompletableFuture<Versioned<byte[]>>();
            zkc.get().create(allocatePath, DistributedLogConstants.EMPTY_BYTES, zkc.getDefaultACL(), CreateMode.PERSISTENT, (rc, path, ctx, name) -> {
                if (KeeperException.Code.OK.intValue() == rc) {
                    promise.complete(new Versioned((Object)DistributedLogConstants.EMPTY_BYTES, (Version)new LongVersion(0L)));
                } else if (KeeperException.Code.NODEEXISTS.intValue() == rc) {
                    FutureUtils.proxyTo(Utils.zkGetData(zkc, allocatePath, false), (CompletableFuture)promise);
                } else {
                    promise.completeExceptionally(Utils.zkException(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)), allocatePath));
                }
            }, null);
            return promise;
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            return FutureUtils.exception((Throwable)Utils.zkException(e, allocatePath));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FutureUtils.exception((Throwable)Utils.zkException(e, allocatePath));
        }
    }

    public static CompletableFuture<SimpleLedgerAllocator> of(String allocatePath, Versioned<byte[]> allocationData, QuorumConfigProvider quorumConfigProvider, ZooKeeperClient zkc, BookKeeperClient bkc) {
        return SimpleLedgerAllocator.of(allocatePath, allocationData, quorumConfigProvider, zkc, bkc, null);
    }

    public static CompletableFuture<SimpleLedgerAllocator> of(String allocatePath, Versioned<byte[]> allocationData, QuorumConfigProvider quorumConfigProvider, ZooKeeperClient zkc, BookKeeperClient bkc, LedgerMetadata ledgerMetadata) {
        if (null != allocationData && null != allocationData.getValue() && null != allocationData.getVersion()) {
            return FutureUtils.value((Object)new SimpleLedgerAllocator(allocatePath, allocationData, quorumConfigProvider, zkc, bkc, ledgerMetadata));
        }
        return SimpleLedgerAllocator.getAndCreateAllocationData(allocatePath, zkc).thenApply(allocationData1 -> new SimpleLedgerAllocator(allocatePath, (Versioned<byte[]>)allocationData1, quorumConfigProvider, zkc, bkc, ledgerMetadata));
    }

    public SimpleLedgerAllocator(String allocatePath, Versioned<byte[]> allocationData, QuorumConfigProvider quorumConfigProvider, ZooKeeperClient zkc, BookKeeperClient bkc) {
        this(allocatePath, allocationData, quorumConfigProvider, zkc, bkc, null);
    }

    public SimpleLedgerAllocator(String allocatePath, Versioned<byte[]> allocationData, QuorumConfigProvider quorumConfigProvider, ZooKeeperClient zkc, BookKeeperClient bkc, LedgerMetadata ledgerMetadata) {
        this.zkc = zkc;
        this.bkc = bkc;
        this.allocatePath = allocatePath;
        this.quorumConfigProvider = quorumConfigProvider;
        this.ledgerMetadata = ledgerMetadata;
        this.initialize(allocationData);
    }

    private void initialize(Versioned<byte[]> allocationData) {
        this.setVersion((LongVersion)allocationData.getVersion());
        byte[] data = (byte[])allocationData.getValue();
        if (null != data && data.length > 0) {
            try {
                this.ledgerIdLeftFromPrevAllocation = DLUtils.bytes2LogSegmentId(data);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Invalid data found in allocator path {} : ", (Object)this.allocatePath, (Object)nfe);
            }
        }
    }

    private synchronized void deleteLedgerLeftFromPreviousAllocationIfNecessary() {
        if (null != this.ledgerIdLeftFromPrevAllocation) {
            LOG.info("Deleting allocated-but-unused ledger left from previous allocation {}.", (Object)this.ledgerIdLeftFromPrevAllocation);
            this.deleteLedger(this.ledgerIdLeftFromPrevAllocation);
            this.ledgerIdLeftFromPrevAllocation = null;
        }
    }

    @Override
    public synchronized void allocate() throws IOException {
        if (Phase.ERROR == this.phase) {
            throw new AllocationException(Phase.ERROR, "Error on ledger allocator for " + this.allocatePath);
        }
        if (Phase.HANDED_OVER == this.phase) {
            this.allocateLedger(this.ledgerMetadata);
        }
    }

    @Override
    public synchronized CompletableFuture<LedgerHandle> tryObtain(Transaction<Object> txn, Transaction.OpListener<LedgerHandle> listener) {
        if (Phase.ERROR == this.phase) {
            return FutureUtils.exception((Throwable)new AllocationException(Phase.ERROR, "Error on allocating ledger under " + this.allocatePath));
        }
        if (Phase.HANDING_OVER == this.phase || Phase.HANDED_OVER == this.phase || null != this.tryObtainTxn) {
            return FutureUtils.exception((Throwable)new ConcurrentObtainException(this.phase, "Ledger handle is handling over to another thread : " + (Object)((Object)this.phase)));
        }
        this.tryObtainTxn = txn;
        this.tryObtainListener = listener;
        if (null != this.allocatedLh) {
            this.completeAllocation(this.allocatedLh);
        }
        return this.allocatePromise;
    }

    @Override
    public void onCommit(Version r) {
        this.confirmObtain((LongVersion)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmObtain(LongVersion zkVersion) {
        boolean shouldAllocate = false;
        Transaction.OpListener<LedgerHandle> listenerToNotify = null;
        LedgerHandle lhToNotify = null;
        SimpleLedgerAllocator simpleLedgerAllocator = this;
        synchronized (simpleLedgerAllocator) {
            if (Phase.HANDING_OVER == this.phase) {
                this.setPhase(Phase.HANDED_OVER);
                this.setVersion(zkVersion);
                listenerToNotify = this.tryObtainListener;
                lhToNotify = this.allocatedLh;
                this.allocatedLh = null;
                this.allocatePromise = null;
                this.tryObtainTxn = null;
                this.tryObtainListener = null;
                shouldAllocate = true;
            }
        }
        if (null != listenerToNotify && null != lhToNotify) {
            listenerToNotify.onCommit(lhToNotify);
        }
        if (shouldAllocate) {
            this.allocateLedger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAbort(Throwable t) {
        Transaction.OpListener<LedgerHandle> listenerToNotify;
        SimpleLedgerAllocator simpleLedgerAllocator = this;
        synchronized (simpleLedgerAllocator) {
            listenerToNotify = this.tryObtainListener;
            if (t instanceof KeeperException && ((KeeperException)t).code() == KeeperException.Code.BADVERSION) {
                LOG.info("Set ledger allocator {} to ERROR state after hit bad version : version = {}", (Object)this.allocatePath, (Object)this.getVersion());
                this.setPhase(Phase.ERROR);
            } else if (Phase.HANDING_OVER == this.phase) {
                this.setPhase(Phase.ALLOCATED);
                this.tryObtainTxn = null;
                this.tryObtainListener = null;
            }
        }
        if (null != listenerToNotify) {
            listenerToNotify.onAbort(t);
        }
    }

    private synchronized void setPhase(Phase phase) {
        this.phase = phase;
        LOG.info("Ledger allocator {} moved to phase {} : version = {}.", new Object[]{this.allocatePath, phase, this.version});
    }

    private synchronized void allocateLedger() {
        this.allocateLedger(null);
    }

    private synchronized void allocateLedger(LedgerMetadata ledgerMetadata) {
        if (Phase.HANDED_OVER != this.phase) {
            LOG.error("Trying allocate ledger for {} in phase {}, giving up.", (Object)this.allocatePath, (Object)this.phase);
            return;
        }
        this.setPhase(Phase.ALLOCATING);
        this.allocatePromise = new CompletableFuture();
        QuorumConfig quorumConfig = this.quorumConfigProvider.getQuorumConfig();
        this.bkc.createLedger(quorumConfig.getEnsembleSize(), quorumConfig.getWriteQuorumSize(), quorumConfig.getAckQuorumSize(), ledgerMetadata).whenComplete((BiConsumer)((Object)this));
    }

    private synchronized void completeAllocation(LedgerHandle lh) {
        this.allocatedLh = lh;
        if (null == this.tryObtainTxn) {
            return;
        }
        Op zkSetDataOp = Op.setData((String)this.allocatePath, (byte[])DistributedLogConstants.EMPTY_BYTES, (int)((int)this.version.getLongVersion()));
        ZKVersionedSetOp commitOp = new ZKVersionedSetOp(zkSetDataOp, this);
        this.tryObtainTxn.addOp(commitOp);
        this.setPhase(Phase.HANDING_OVER);
        this.allocatePromise.complete(lh);
    }

    private synchronized void failAllocation(Throwable cause) {
        this.allocatePromise.completeExceptionally(cause);
    }

    public void onSuccess(LedgerHandle lh) {
        this.markAsAllocated(lh);
    }

    public void onFailure(Throwable cause) {
        LOG.error("Error creating ledger for allocating {} : ", (Object)this.allocatePath, (Object)cause);
        this.setPhase(Phase.ERROR);
        this.failAllocation(cause);
    }

    private synchronized LongVersion getVersion() {
        return this.version;
    }

    private synchronized void setVersion(LongVersion newVersion) {
        Version.Occurred occurred = newVersion.compare((Version)this.version);
        if (occurred == Version.Occurred.AFTER) {
            LOG.info("Ledger allocator for {} moved version from {} to {}.", new Object[]{this.allocatePath, this.version, newVersion});
            this.version = newVersion;
        } else {
            LOG.warn("Ledger allocator for {} received an old version {}, current version is {}.", new Object[]{this.allocatePath, newVersion, this.version});
        }
    }

    private void markAsAllocated(final LedgerHandle lh) {
        byte[] data = DLUtils.logSegmentId2Bytes(lh.getId());
        Utils.zkSetData(this.zkc, this.allocatePath, data, this.getVersion()).whenComplete((BiConsumer)new FutureEventListener<LongVersion>(){

            public void onSuccess(LongVersion version) {
                SimpleLedgerAllocator.this.deleteLedgerLeftFromPreviousAllocationIfNecessary();
                SimpleLedgerAllocator.this.setVersion(version);
                SimpleLedgerAllocator.this.setPhase(Phase.ALLOCATED);
                SimpleLedgerAllocator.this.completeAllocation(lh);
            }

            public void onFailure(Throwable cause) {
                SimpleLedgerAllocator.this.setPhase(Phase.ERROR);
                SimpleLedgerAllocator.this.deleteLedger(lh.getId());
                LOG.error("Fail mark ledger {} as allocated under {} : ", new Object[]{lh.getId(), SimpleLedgerAllocator.this.allocatePath, cause});
                SimpleLedgerAllocator.this.failAllocation(cause);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteLedger(long ledgerId) {
        CompletableFuture<Void> deleteFuture = this.bkc.deleteLedger(ledgerId, true);
        LinkedList<CompletableFuture<Void>> linkedList = this.ledgerDeletions;
        synchronized (linkedList) {
            this.ledgerDeletions.add(deleteFuture);
        }
        deleteFuture.whenComplete((value, cause) -> {
            if (null != cause) {
                LOG.error("Error deleting ledger {} for ledger allocator {}, retrying : ", new Object[]{ledgerId, this.allocatePath, cause});
                if (!this.isClosing()) {
                    this.deleteLedger(ledgerId);
                }
            }
            LinkedList<CompletableFuture<Void>> linkedList = this.ledgerDeletions;
            synchronized (linkedList) {
                this.ledgerDeletions.remove(deleteFuture);
            }
        });
    }

    private synchronized boolean isClosing() {
        return this.closeFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> closeInternal(boolean cleanup) {
        CompletableFuture<Void> closePromise;
        SimpleLedgerAllocator simpleLedgerAllocator = this;
        synchronized (simpleLedgerAllocator) {
            if (null != this.closeFuture) {
                return this.closeFuture;
            }
            closePromise = new CompletableFuture<Void>();
            this.closeFuture = closePromise;
        }
        if (!cleanup) {
            LOG.info("Abort ledger allocator without cleaning up on {}.", (Object)this.allocatePath);
            FutureUtils.complete(closePromise, null);
            return closePromise;
        }
        this.cleanupAndClose(closePromise);
        return closePromise;
    }

    private void cleanupAndClose(final CompletableFuture<Void> closePromise) {
        LOG.info("Closing ledger allocator on {}.", (Object)this.allocatePath);
        final ZKTransaction txn = new ZKTransaction(this.zkc);
        this.tryObtain(txn, new Transaction.OpListener<LedgerHandle>(){

            @Override
            public void onCommit(LedgerHandle r) {
                this.complete();
            }

            @Override
            public void onAbort(Throwable t) {
                this.complete();
            }

            private void complete() {
                closePromise.complete(null);
                LOG.info("Closed ledger allocator on {}.", (Object)SimpleLedgerAllocator.this.allocatePath);
            }
        }).whenComplete((BiConsumer)new FutureEventListener<LedgerHandle>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(LedgerHandle lh) {
                ArrayList outstandingDeletions;
                SimpleLedgerAllocator.this.deleteLedger(lh.getId());
                LinkedList<CompletableFuture<Void>> linkedList = SimpleLedgerAllocator.this.ledgerDeletions;
                synchronized (linkedList) {
                    outstandingDeletions = Lists.newArrayList(SimpleLedgerAllocator.this.ledgerDeletions);
                }
                FutureUtils.collect((List)outstandingDeletions).whenComplete((BiConsumer)new FutureEventListener<List<Void>>(){

                    public void onSuccess(List<Void> values) {
                        txn.execute();
                    }

                    public void onFailure(Throwable cause) {
                        LOG.debug("Fail to obtain the allocated ledger handle when closing the allocator : ", cause);
                        FutureUtils.complete((CompletableFuture)closePromise, null);
                    }
                });
            }

            public void onFailure(Throwable cause) {
                LOG.debug("Fail to obtain the allocated ledger handle when closing the allocator : ", cause);
                FutureUtils.complete((CompletableFuture)closePromise, null);
            }
        });
    }

    @Override
    public void start() {
    }

    public CompletableFuture<Void> asyncClose() {
        return this.closeInternal(false);
    }

    public CompletableFuture<Void> delete() {
        return this.closeInternal(true).thenCompose(value -> Utils.zkDelete(this.zkc, this.allocatePath, this.getVersion()));
    }

    static class ConcurrentObtainException
    extends AllocationException {
        private static final long serialVersionUID = -8532471098537176913L;

        public ConcurrentObtainException(Phase phase, String msg) {
            super(phase, msg);
        }
    }

    static class AllocationException
    extends IOException {
        private static final long serialVersionUID = -1111397872059426882L;
        private final Phase phase;

        public AllocationException(Phase phase, String msg) {
            super(msg);
            this.phase = phase;
        }

        public Phase getPhase() {
            return this.phase;
        }
    }

    static enum Phase {
        ALLOCATING,
        ALLOCATED,
        HANDING_OVER,
        HANDED_OVER,
        ERROR;

    }
}

