/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands;

import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.common.BKCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractStreamCommand<CommandFlagsT extends CliFlags>
extends BKCommand<CommandFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamCommand.class);

    protected AbstractStreamCommand(CliSpec<CommandFlagsT> spec) {
        super(spec);
    }

    protected boolean acceptServiceUri(ServiceURI serviceURI) {
        return "bk".equals(serviceURI.getServiceName());
    }

    protected boolean apply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, CommandFlagsT cmdFlags) {
        if (serviceURI == null) {
            serviceURI = ServiceURI.DEFAULT_LOCAL_STREAM_STORAGE_SERVICE_URI;
            log.info("Service Uri is not specified. Using default service uri : {}", (Object)serviceURI);
        }
        return this.doApply(serviceURI, conf, globalFlags, cmdFlags);
    }

    protected abstract boolean doApply(ServiceURI var1, CompositeConfiguration var2, BKFlags var3, CommandFlagsT var4);
}

