/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumAuthTestBase
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(QuorumAuthTestBase.class);
    protected List<QuorumPeerTestBase.MainThread> mt = new ArrayList<QuorumPeerTestBase.MainThread>();
    protected static File jaasConfigDir;

    public static void setupJaasConfig(String jaasEntries) {
        try {
            jaasConfigDir = ClientBase.createTmpDir();
            File saslConfFile = new File(jaasConfigDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write(jaasEntries);
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            LOG.error("Failed to create tmp directory to hold JAAS conf file", (Throwable)ioe);
        }
        Configuration.getConfiguration().refresh();
    }

    public static void cleanupJaasConfig() {
        if (jaasConfigDir != null) {
            FileUtils.deleteQuietly((File)jaasConfigDir);
        }
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.multiAddress.enabled");
    }

    protected String startQuorum(int serverCount, Map<String, String> authConfigs, int authServerCount) throws IOException {
        return this.startQuorum(serverCount, authConfigs, authServerCount, false);
    }

    protected String startMultiAddressQuorum(int serverCount, Map<String, String> authConfigs, int authServerCount) throws IOException {
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        return this.startQuorum(serverCount, authConfigs, authServerCount, true);
    }

    protected String startQuorum(int serverCount, Map<String, String> authConfigs, int authServerCount, boolean multiAddress) throws IOException {
        StringBuilder connectStr = new StringBuilder();
        int[] clientPorts = this.startQuorum(serverCount, connectStr, authConfigs, authServerCount, multiAddress);
        for (int i = 0; i < serverCount; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        return connectStr.toString();
    }

    protected int[] startQuorum(int serverCount, StringBuilder connectStr, Map<String, String> authConfigs, int authServerCount, boolean multiAddress) throws IOException {
        int i;
        int[] clientPorts = new int[serverCount];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < serverCount; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = String.format("server.%d=localhost:%d:%d", i2, PortAssignment.unique(), PortAssignment.unique());
            if (multiAddress) {
                server = server + String.format("|localhost:%d:%d", PortAssignment.unique(), PortAssignment.unique());
            }
            sb.append(server + ":participant\n");
            connectStr.append("127.0.0.1:" + clientPorts[i2]);
            if (i2 >= serverCount - 1) continue;
            connectStr.append(",");
        }
        String quorumCfg = sb.toString();
        for (i = 0; i < authServerCount; ++i) {
            this.startServer(authConfigs, clientPorts, quorumCfg, i);
        }
        int j = 0;
        while (j < serverCount - authServerCount) {
            QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(i, clientPorts[i], quorumCfg);
            this.mt.add(mthread);
            mthread.start();
            ++j;
            ++i;
        }
        return clientPorts;
    }

    private void startServer(Map<String, String> authConfigs, int[] clientPorts, String quorumCfg, int i) throws IOException {
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(i, clientPorts[i], quorumCfg, authConfigs);
        this.mt.add(mthread);
        mthread.start();
    }

    protected void startServer(QuorumPeerTestBase.MainThread restartPeer, Map<String, String> authConfigs) throws IOException {
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(restartPeer.getMyid(), restartPeer.getClientPort(), restartPeer.getQuorumCfgSection(), authConfigs);
        this.mt.add(mthread);
        mthread.start();
    }

    void shutdownAll() {
        for (int i = 0; i < this.mt.size(); ++i) {
            this.shutdown(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QuorumPeerTestBase.MainThread shutdown(int index) {
        QuorumPeerTestBase.MainThread mainThread = this.mt.get(index);
        try {
            mainThread.shutdown();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.mt.remove(index);
        }
        mainThread.deleteBaseDir();
        return mainThread;
    }
}

