/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.LearnerSyncThrottler;
import org.apache.zookeeper.server.quorum.SyncThrottleException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class LearnerSyncThrottlerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSyncThrottlerTest.class);
    private LearnerSyncThrottler.SyncType syncType;

    public LearnerSyncThrottlerTest(LearnerSyncThrottler.SyncType syncType) {
        this.syncType = syncType;
    }

    @Parameterized.Parameters
    public static Collection syncTypes() {
        return Arrays.asList({LearnerSyncThrottler.SyncType.DIFF}, {LearnerSyncThrottler.SyncType.SNAP});
    }

    @Test(expected=SyncThrottleException.class)
    public void testTooManySyncsNonessential() throws Exception {
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(5, this.syncType);
        for (int i = 0; i < 6; ++i) {
            throttler.beginSync(false);
        }
    }

    @Test(expected=SyncThrottleException.class)
    public void testTooManySyncsEssential() throws Exception {
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(5, this.syncType);
        try {
            for (int i = 0; i < 6; ++i) {
                throttler.beginSync(true);
            }
        }
        catch (SyncThrottleException ex) {
            Assert.fail((String)"essential syncs should not be throttled");
        }
        throttler.endSync();
        throttler.beginSync(false);
    }

    @Test
    public void testNoThrottle() throws Exception {
        int i;
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(5, this.syncType);
        try {
            for (i = 0; i < 6; ++i) {
                throttler.beginSync(true);
            }
        }
        catch (SyncThrottleException ex) {
            Assert.fail((String)"essential syncs should not be throttled");
        }
        throttler.endSync();
        for (i = 0; i < 5; ++i) {
            throttler.endSync();
            throttler.beginSync(false);
        }
        Assert.assertTrue((String)"should get here without exception", (boolean)true);
    }

    @Test
    public void testTryWithResourceNoThrottle() throws Exception {
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(1, this.syncType);
        for (int i = 0; i < 3; ++i) {
            throttler.beginSync(false);
            try {
                Assert.assertEquals((long)1L, (long)throttler.getSyncInProgress());
                continue;
            }
            finally {
                throttler.endSync();
            }
        }
    }

    @Test
    public void testTryWithResourceThrottle() throws Exception {
        LearnerSyncThrottler throttler = new LearnerSyncThrottler(1, this.syncType);
        try {
            throttler.beginSync(true);
            try {
                throttler.beginSync(false);
                Assert.fail((String)"shouldn't be able to have both syncs open");
            }
            catch (SyncThrottleException syncThrottleException) {
                // empty catch block
            }
            throttler.endSync();
        }
        catch (SyncThrottleException e) {
            Assert.fail((String)"First sync shouldn't be throttled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelNoThrottle() {
        int numThreads = 50;
        final LearnerSyncThrottler throttler = new LearnerSyncThrottler(50, this.syncType);
        ExecutorService threadPool = Executors.newFixedThreadPool(50);
        final CountDownLatch threadStartLatch = new CountDownLatch(50);
        final CountDownLatch syncProgressLatch = new CountDownLatch(50);
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(50);
        for (int i = 0; i < 50; ++i) {
            results.add(threadPool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    threadStartLatch.countDown();
                    try {
                        threadStartLatch.await();
                        throttler.beginSync(false);
                        syncProgressLatch.countDown();
                        syncProgressLatch.await();
                        throttler.endSync();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
            }));
        }
        try {
            for (Future future : results) {
                Assert.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        catch (Exception exception) {
        }
        finally {
            threadPool.shutdown();
        }
    }
}

