/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZKParameterized;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ZKParameterized.RunnerFactory.class)
public class ServerIdTest
extends ClientBase {
    private final TestType testType;

    @Parameterized.Parameters
    public static List<TestType> data() {
        ArrayList<TestType> testTypes = new ArrayList<TestType>();
        for (boolean ttlsEnabled : new boolean[]{true, false}) {
            for (int serverId = 0; serverId <= 255; ++serverId) {
                testTypes.add(new TestType(ttlsEnabled, serverId));
            }
        }
        return testTypes;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("zookeeper.extendedTypesEnabled");
    }

    public ServerIdTest(TestType testType) {
        this.testType = testType;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        System.setProperty("zookeeper.extendedTypesEnabled", Boolean.toString(this.testType.ttlsEnabled));
        LOG.info("ttlsEnabled: {} - ServerId: {}", (Object)this.testType.ttlsEnabled, (Object)this.testType.serverId);
        try {
            super.setUpWithServerId(this.testType.serverId);
        }
        catch (RuntimeException e) {
            if (this.testType.ttlsEnabled && (long)this.testType.serverId >= 254L) {
                return;
            }
            throw e;
        }
    }

    @Test
    public void doTest() throws Exception {
        if (this.testType.ttlsEnabled && (long)this.testType.serverId >= 254L) {
            return;
        }
        try (TestableZooKeeper zk = null;){
            zk = this.createClient();
            zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.delete("/foo", -1);
            if (this.testType.ttlsEnabled) {
                zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, new Stat(), 1000L);
            } else {
                try {
                    zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, new Stat(), 1000L);
                    Assert.fail((String)"Should have thrown KeeperException.UnimplementedException");
                }
                catch (KeeperException.UnimplementedException unimplementedException) {
                    // empty catch block
                }
            }
        }
    }

    private static class TestType {
        final boolean ttlsEnabled;
        final int serverId;

        TestType(boolean ttlsEnabled, int serverId) {
            this.ttlsEnabled = ttlsEnabled;
            this.serverId = serverId;
        }
    }
}

