/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stats.AlertStatsLogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogReadHandler;
import org.apache.distributedlog.BookKeeperClient;
import org.apache.distributedlog.BookKeeperClientBuilder;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ReadAheadEntryReader;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.exceptions.AlreadyTruncatedTransactionException;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.impl.logsegment.BKLogSegmentEntryStore;
import org.apache.distributedlog.injector.AsyncFailureInjector;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.logsegment.LogSegmentEntryStore;
import org.apache.distributedlog.util.ConfUtils;
import org.apache.distributedlog.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestReadAheadEntryReader
extends TestDistributedLogBase {
    private static final int MAX_CACHED_ENTRIES = 5;
    private static final int NUM_PREFETCH_ENTRIES = 10;
    @Rule
    public TestName runtime = new TestName();
    private DistributedLogConfiguration baseConf;
    private OrderedScheduler scheduler;
    private BookKeeperClient bkc;
    private ZooKeeperClient zkc;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.baseConf = new DistributedLogConfiguration();
        this.baseConf.addConfiguration((Configuration)conf);
        this.baseConf.setOutputBufferSize(0);
        this.baseConf.setPeriodicFlushFrequencyMilliSeconds(0);
        this.baseConf.setImmediateFlushEnabled(false);
        this.baseConf.setReadAheadMaxRecords(5);
        this.baseConf.setNumPrefetchEntriesPerLogSegment(10);
        this.baseConf.setMaxPrefetchEntriesPerLogSegment(10);
        this.zkc = ZooKeeperClientBuilder.newBuilder().name("test-zk").zkServers(bkutil.getZkServers()).sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).zkAclId(conf.getZkAclId()).build();
        this.bkc = BookKeeperClientBuilder.newBuilder().name("test-bk").dlConfig(conf).ledgersPath("/ledgers").zkServers(bkutil.getZkServers()).build();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-read-ahead-entry-reader").numThreads(1).build();
    }

    @Override
    @After
    public void teardown() throws Exception {
        if (null != this.bkc) {
            this.bkc.close();
        }
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
        if (null != this.zkc) {
            this.zkc.close();
        }
        super.teardown();
    }

    private ReadAheadEntryReader createEntryReader(String streamName, DLSN fromDLSN, BKDistributedLogManager dlm, DistributedLogConfiguration conf) throws Exception {
        BKLogReadHandler readHandler = dlm.createReadHandler(Optional.empty(), true);
        BKLogSegmentEntryStore entryStore = new BKLogSegmentEntryStore(conf, ConfUtils.getConstDynConf((DistributedLogConfiguration)conf), this.zkc, this.bkc, this.scheduler, null, (StatsLogger)NullStatsLogger.INSTANCE, AsyncFailureInjector.NULL);
        return new ReadAheadEntryReader(streamName, fromDLSN, conf, readHandler, (LogSegmentEntryStore)entryStore, this.scheduler, Ticker.systemTicker(), new AlertStatsLogger((StatsLogger)NullStatsLogger.INSTANCE, "test-alert"));
    }

    private void ensureOrderSchedulerEmpty(String streamName) throws Exception {
        CompletableFuture promise = new CompletableFuture();
        this.scheduler.executeOrdered((Object)streamName, () -> FutureUtils.complete((CompletableFuture)promise, null));
        Utils.ioResult(promise);
    }

    void generateCompletedLogSegments(DistributedLogManager dlm, long numCompletedSegments, long segmentSize) throws Exception {
        this.generateCompletedLogSegments(dlm, numCompletedSegments, segmentSize, 1L);
    }

    void generateCompletedLogSegments(DistributedLogManager dlm, long numCompletedSegments, long segmentSize, long startTxId) throws Exception {
        long txid = startTxId;
        for (long i = 0L; i < numCompletedSegments; ++i) {
            AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
            for (long j = 1L; j <= segmentSize; ++j) {
                Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txid++)));
                LogRecord ctrlRecord = DLMTestUtil.getLogRecordInstance(txid);
                ctrlRecord.setControl();
                Utils.ioResult((CompletableFuture)writer.write(ctrlRecord));
            }
            Utils.close((AsyncCloseable)writer);
        }
    }

    AsyncLogWriter createInprogressLogSegment(DistributedLogManager dlm, DistributedLogConfiguration conf, long segmentSize) throws Exception {
        AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        for (long i = 1L; i <= segmentSize; ++i) {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(i)));
            LogRecord ctrlRecord = DLMTestUtil.getLogRecordInstance(i);
            ctrlRecord.setControl();
            Utils.ioResult((CompletableFuture)writer.write(ctrlRecord));
        }
        return writer;
    }

    void expectAlreadyTruncatedTransactionException(ReadAheadEntryReader reader, String errMsg) throws Exception {
        try {
            reader.checkLastException();
            Assert.fail((String)errMsg);
        }
        catch (AlreadyTruncatedTransactionException alreadyTruncatedTransactionException) {
            // empty catch block
        }
    }

    void expectIllegalStateException(ReadAheadEntryReader reader, String errMsg) throws Exception {
        try {
            reader.checkLastException();
            Assert.fail((String)errMsg);
        }
        catch (DLIllegalStateException dLIllegalStateException) {
            // empty catch block
        }
    }

    void expectNoException(ReadAheadEntryReader reader) throws Exception {
        reader.checkLastException();
    }

    @Test(timeout=60000L)
    public void testStartWithEmptySegmentList() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(this.baseConf, streamName);
        ReadAheadEntryReader readAheadEntryReader = this.createEntryReader(streamName, DLSN.InitialDLSN, dlm, this.baseConf);
        readAheadEntryReader.start((List)Lists.newArrayList());
        this.ensureOrderSchedulerEmpty(streamName);
        Assert.assertFalse((String)"ReadAhead should not be initialized with empty segment list", (boolean)readAheadEntryReader.isInitialized());
        Assert.assertTrue((String)"ReadAhead should be empty when it isn't initialized", (boolean)readAheadEntryReader.isCacheEmpty());
        Assert.assertFalse((String)"ReadAhead should not be marked as caught up when it isn't initialized", (boolean)readAheadEntryReader.isReadAheadCaughtUp());
        this.generateCompletedLogSegments((DistributedLogManager)dlm, 1L, 3L);
        List segments = dlm.getLogSegments();
        Assert.assertEquals((String)(segments.size() + " log segments found, expected to be only one"), (long)1L, (long)segments.size());
        readAheadEntryReader.onSegmentsUpdated(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        Assert.assertTrue((String)"ReadAhead should be initialized with non-empty segment list", (boolean)readAheadEntryReader.isInitialized());
        Assert.assertNotNull((String)"current segment reader should be initialized", (Object)readAheadEntryReader.getCurrentSegmentReader());
        Assert.assertEquals((String)("current segment sequence number should be " + ((LogSegmentMetadata)segments.get(0)).getLogSegmentSequenceNumber()), (long)((LogSegmentMetadata)segments.get(0)).getLogSegmentSequenceNumber(), (long)readAheadEntryReader.getCurrentSegmentSequenceNumber());
        Assert.assertNull((String)"there should be no next segment reader", (Object)readAheadEntryReader.getNextSegmentReader());
        Assert.assertTrue((String)"there should be no remaining segment readers", (boolean)readAheadEntryReader.getSegmentReaders().isEmpty());
        Utils.close((AsyncCloseable)readAheadEntryReader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testInitializeMultipleClosedLogSegments0() throws Exception {
        this.testInitializeMultipleClosedLogSegments(5, DLSN.InitialDLSN, 0);
    }

    @Test(timeout=60000L)
    public void testInitializeMultipleClosedLogSegments1() throws Exception {
        this.testInitializeMultipleClosedLogSegments(5, new DLSN(4L, 0L, 0L), 3);
    }

    private void testInitializeMultipleClosedLogSegments(int numLogSegments, DLSN fromDLSN, int expectedCurrentSegmentIdx) throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(this.baseConf, streamName);
        this.generateCompletedLogSegments((DistributedLogManager)dlm, 1L, 3L, 1L);
        this.generateCompletedLogSegments((DistributedLogManager)dlm, numLogSegments - 1, 1L, 7L);
        List segments = dlm.getLogSegments();
        Assert.assertEquals((String)(segments.size() + " log segments found, expected to be " + numLogSegments), (long)numLogSegments, (long)segments.size());
        ReadAheadEntryReader readAheadEntryReader = this.createEntryReader(streamName, fromDLSN, dlm, this.baseConf);
        readAheadEntryReader.start(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        Assert.assertTrue((String)"ReadAhead should be initialized with non-empty segment list", (boolean)readAheadEntryReader.isInitialized());
        Assert.assertNotNull((String)"current segment reader should be initialized", (Object)readAheadEntryReader.getCurrentSegmentReader());
        Assert.assertTrue((String)"current segment reader should be open and started", (readAheadEntryReader.getCurrentSegmentReader().isReaderOpen() && readAheadEntryReader.getCurrentSegmentReader().isReaderStarted() ? 1 : 0) != 0);
        Assert.assertEquals((String)("current segment reader should read " + segments.get(expectedCurrentSegmentIdx)), segments.get(expectedCurrentSegmentIdx), (Object)readAheadEntryReader.getCurrentSegmentReader().getSegment());
        Assert.assertEquals((String)("current segment sequence number should be " + ((LogSegmentMetadata)segments.get(expectedCurrentSegmentIdx)).getLogSegmentSequenceNumber()), (long)((LogSegmentMetadata)segments.get(expectedCurrentSegmentIdx)).getLogSegmentSequenceNumber(), (long)readAheadEntryReader.getCurrentSegmentSequenceNumber());
        Assert.assertNull((String)"next segment reader should not be initialized since it is a closed log segment", (Object)readAheadEntryReader.getNextSegmentReader());
        Assert.assertEquals((String)("there should be " + (numLogSegments - (expectedCurrentSegmentIdx + 1)) + " remaining segment readers"), (long)(numLogSegments - (expectedCurrentSegmentIdx + 1)), (long)readAheadEntryReader.getSegmentReaders().size());
        int segmentIdx = expectedCurrentSegmentIdx + 1;
        for (ReadAheadEntryReader.SegmentReader reader : readAheadEntryReader.getSegmentReaders()) {
            LogSegmentMetadata expectedSegment = (LogSegmentMetadata)segments.get(segmentIdx);
            Assert.assertEquals((String)("Segment should " + expectedSegment), (Object)expectedSegment, (Object)reader.getSegment());
            Assert.assertTrue((String)("Segment reader for " + expectedSegment + " should be open"), (boolean)reader.isReaderOpen());
            Assert.assertFalse((String)("Segment reader for " + expectedSegment + " should not be started"), (boolean)reader.isReaderStarted());
            ++segmentIdx;
        }
        Utils.close((AsyncCloseable)readAheadEntryReader);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testPositioningAtInvalidLogSegment() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(this.baseConf, streamName);
        this.generateCompletedLogSegments((DistributedLogManager)dlm, 3L, 3L);
        AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        Utils.ioResult((CompletableFuture)writer.truncate(new DLSN(2L, 1L, 0L)));
        List segments = dlm.getLogSegments();
        ReadAheadEntryReader readAheadEntryReader = this.createEntryReader(streamName, DLSN.InitialDLSN, dlm, this.baseConf);
        readAheadEntryReader.start(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        this.expectNoException(readAheadEntryReader);
        Entry.Reader entryReader = readAheadEntryReader.getNextReadAheadEntry(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)entryReader.getLSSN());
        Assert.assertEquals((long)1L, (long)entryReader.getEntryId());
        entryReader.release();
        Utils.close((AsyncCloseable)readAheadEntryReader);
        readAheadEntryReader = this.createEntryReader(streamName, new DLSN(2L, 0L, 0L), dlm, this.baseConf);
        readAheadEntryReader.start(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        this.expectNoException(readAheadEntryReader);
        entryReader = readAheadEntryReader.getNextReadAheadEntry(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)entryReader.getLSSN());
        Assert.assertEquals((long)1L, (long)entryReader.getEntryId());
        entryReader.release();
        Utils.close((AsyncCloseable)readAheadEntryReader);
        readAheadEntryReader = this.createEntryReader(streamName, new DLSN(2L, 2L, 0L), dlm, this.baseConf);
        readAheadEntryReader.start(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        this.expectNoException(readAheadEntryReader);
        entryReader = readAheadEntryReader.getNextReadAheadEntry(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)entryReader.getLSSN());
        Assert.assertEquals((long)2L, (long)entryReader.getEntryId());
        entryReader.release();
        Utils.close((AsyncCloseable)readAheadEntryReader);
        Utils.close((AsyncCloseable)writer);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testPositioningIgnoreTruncationStatus() throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.baseConf);
        confLocal.setIgnoreTruncationStatus(true);
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, streamName);
        this.generateCompletedLogSegments((DistributedLogManager)dlm, 3L, 2L);
        AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        Utils.ioResult((CompletableFuture)writer.truncate(new DLSN(2L, 1L, 0L)));
        List segments = dlm.getLogSegments();
        ReadAheadEntryReader readAheadEntryReader = this.createEntryReader(streamName, DLSN.InitialDLSN, dlm, confLocal);
        readAheadEntryReader.start(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        this.expectNoException(readAheadEntryReader);
        Utils.close((AsyncCloseable)readAheadEntryReader);
        readAheadEntryReader = this.createEntryReader(streamName, new DLSN(2L, 0L, 0L), dlm, confLocal);
        readAheadEntryReader.start(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        this.expectNoException(readAheadEntryReader);
        Utils.close((AsyncCloseable)readAheadEntryReader);
        readAheadEntryReader = this.createEntryReader(streamName, new DLSN(2L, 1L, 0L), dlm, confLocal);
        readAheadEntryReader.start(segments);
        this.ensureOrderSchedulerEmpty(streamName);
        this.expectNoException(readAheadEntryReader);
        Utils.close((AsyncCloseable)readAheadEntryReader);
        Utils.close((AsyncCloseable)writer);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testLogSegmentSequenceNumberGap() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(this.baseConf, streamName);
        this.generateCompletedLogSegments((DistributedLogManager)dlm, 3L, 2L);
        List segments = dlm.getLogSegments();
        ReadAheadEntryReader readAheadEntryReader = this.createEntryReader(streamName, DLSN.InitialDLSN, dlm, this.baseConf);
        readAheadEntryReader.start(segments.subList(0, 1));
        int expectedCurrentSegmentIdx = 0;
        this.ensureOrderSchedulerEmpty(streamName);
        Assert.assertTrue((String)"ReadAhead should be initialized with non-empty segment list", (boolean)readAheadEntryReader.isInitialized());
        Assert.assertNotNull((String)"current segment reader should be initialized", (Object)readAheadEntryReader.getCurrentSegmentReader());
        Assert.assertTrue((String)"current segment reader should be open and started", (readAheadEntryReader.getCurrentSegmentReader().isReaderOpen() && readAheadEntryReader.getCurrentSegmentReader().isReaderStarted() ? 1 : 0) != 0);
        Assert.assertEquals((String)("current segment reader should read " + segments.get(expectedCurrentSegmentIdx)), segments.get(expectedCurrentSegmentIdx), (Object)readAheadEntryReader.getCurrentSegmentReader().getSegment());
        Assert.assertEquals((String)("current segment sequence number should be " + ((LogSegmentMetadata)segments.get(expectedCurrentSegmentIdx)).getLogSegmentSequenceNumber()), (long)((LogSegmentMetadata)segments.get(expectedCurrentSegmentIdx)).getLogSegmentSequenceNumber(), (long)readAheadEntryReader.getCurrentSegmentSequenceNumber());
        Assert.assertNull((String)"next segment reader should not be initialized since it is a closed log segment", (Object)readAheadEntryReader.getNextSegmentReader());
        readAheadEntryReader.onSegmentsUpdated(segments.subList(2, 3));
        this.ensureOrderSchedulerEmpty(streamName);
        this.expectIllegalStateException(readAheadEntryReader, "inconsistent log segment found");
        Utils.close((AsyncCloseable)readAheadEntryReader);
        dlm.close();
    }
}

