/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSLAuthTest
extends ClientBase {
    private ClientX509Util clientX509Util;

    public static ClientX509Util setUpSecure() throws Exception {
        ClientX509Util x509Util = new ClientX509Util();
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty(x509Util.getSslAuthProviderProperty(), "x509");
        System.setProperty(x509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(x509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty(x509Util.getSslTruststoreLocationProperty(), testDataPath + "/ssl/testTrustStore.jks");
        System.setProperty(x509Util.getSslTruststorePasswdProperty(), "testpass");
        System.setProperty("javax.net.debug", "ssl");
        System.setProperty("zookeeper.authProvider.x509", "org.apache.zookeeper.server.auth.X509AuthenticationProvider");
        return x509Util;
    }

    public static void clearSecureSetting(ClientX509Util clientX509Util) {
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty(clientX509Util.getSslAuthProviderProperty());
        System.clearProperty(clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(clientX509Util.getSslTruststorePasswdProperty());
        System.clearProperty("javax.net.debug");
        System.clearProperty("zookeeper.authProvider.x509");
        clientX509Util.close();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.clientX509Util = SSLAuthTest.setUpSecure();
        String host = "localhost";
        int port = PortAssignment.unique();
        this.hostPort = host + ":" + port;
        this.serverFactory = ServerCnxnFactory.createFactory();
        this.serverFactory.configure(new InetSocketAddress(host, port), this.maxCnxns, -1, true);
        super.setUp();
    }

    @After
    public void teardown() throws Exception {
        SSLAuthTest.clearSecureSetting(this.clientX509Util);
    }

    @Test
    public void testRejection() throws Exception {
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty(this.clientX509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testUntrustedKeyStore.jks");
        System.setProperty(this.clientX509Util.getSslKeystorePasswdProperty(), "testpass");
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        new TestableZooKeeper(this.hostPort, CONNECTION_TIMEOUT, watcher);
        Assert.assertFalse((String)"Untrusted certificate should not result in successful connection", (boolean)watcher.clientConnected.await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testMisconfiguration() throws Exception {
        System.clearProperty(this.clientX509Util.getSslAuthProviderProperty());
        System.clearProperty(this.clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(this.clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslTruststorePasswdProperty());
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        new TestableZooKeeper(this.hostPort, CONNECTION_TIMEOUT, watcher);
        Assert.assertFalse((String)"Missing SSL configuration should not result in successful connection", (boolean)watcher.clientConnected.await(1000L, TimeUnit.MILLISECONDS));
    }
}

