/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.common.IOUtils;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourLetterWordsTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(FourLetterWordsTest.class);
    @Rule
    public Timeout timeout = Timeout.millis((long)30000L);

    @Test
    public void testFourLetterWords() throws Exception {
        this.verify("ruok", "imok");
        this.verify("envi", "java.version");
        this.verify("conf", "clientPort");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("dump", "Session");
        this.verify("wchs", "watches");
        this.verify("wchp", "");
        this.verify("wchc", "");
        this.verify("srst", "reset");
        this.verify("crst", "reset");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("gtmk", "306");
        this.verify("isro", "rw");
        TestableZooKeeper zk = this.createClient();
        String sid = FourLetterWordsTest.getHexSessionId(zk.getSessionId());
        this.verify("stat", "queued");
        this.verify("srvr", "Outstanding");
        this.verify("cons", sid);
        this.verify("dump", sid);
        this.verify("dirs", "size");
        zk.getData("/", true, null);
        this.verify("stat", "queued");
        this.verify("srvr", "Outstanding");
        this.verify("cons", sid);
        this.verify("dump", sid);
        this.verify("wchs", "watching 1");
        this.verify("wchp", sid);
        this.verify("wchc", sid);
        this.verify("dirs", "size");
        zk.close();
        this.verify("ruok", "imok");
        this.verify("envi", "java.version");
        this.verify("conf", "clientPort");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("dump", "Session");
        this.verify("wchs", "watch");
        this.verify("wchp", "");
        this.verify("wchc", "");
        this.verify("srst", "reset");
        this.verify("crst", "reset");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("mntr", "zk_server_state\tstandalone");
        this.verify("mntr", "num_alive_connections");
        this.verify("stat", "Connections");
        this.verify("srvr", "Connections");
        this.verify("dirs", "size");
    }

    private String sendRequest(String cmd) throws IOException, X509Exception.SSLContextException {
        ClientBase.HostPort hpobj = ClientBase.parseHostPortList(this.hostPort).get(0);
        return FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)cmd);
    }

    private String sendRequest(String cmd, int timeout) throws IOException, X509Exception.SSLContextException {
        ClientBase.HostPort hpobj = ClientBase.parseHostPortList(this.hostPort).get(0);
        return FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)cmd, (boolean)false, (int)timeout);
    }

    private void verify(String cmd, String expected) throws IOException, X509Exception.SSLContextException {
        String resp = this.sendRequest(cmd);
        LOG.info("cmd {} expected {} got {}", new Object[]{cmd, expected, resp});
        Assert.assertTrue((boolean)resp.contains(expected));
    }

    @Test
    public void testValidateStatOutput() throws Exception {
        TestableZooKeeper zk1 = this.createClient();
        TestableZooKeeper zk2 = this.createClient();
        String resp = this.sendRequest("stat");
        BufferedReader in = new BufferedReader(new StringReader(resp));
        String line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^.*\\s\\d+\\.\\d+\\.\\d+-.*$", line));
        Assert.assertTrue((boolean)Pattern.matches("^Clients:$", in.readLine()));
        int count = 0;
        while ((line = in.readLine()).length() > 0) {
            ++count;
            Assert.assertTrue((boolean)Pattern.matches("^ /.*:\\d+\\[\\d+\\]\\(queued=\\d+,recved=\\d+,sent=\\d+\\)$", line));
        }
        Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Latency min/avg/max: \\d+/-?[0-9]*.?[0-9]*/\\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Received: \\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Sent: \\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Connections: \\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Outstanding: \\d+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Zxid: 0x[\\da-fA-F]+$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Mode: .*$", line));
        line = in.readLine();
        Assert.assertTrue((boolean)Pattern.matches("^Node count: \\d+$", line));
        zk1.close();
        zk2.close();
    }

    @Test
    public void testValidateConsOutput() throws Exception {
        String line;
        TestableZooKeeper zk1 = this.createClient();
        TestableZooKeeper zk2 = this.createClient();
        String resp = this.sendRequest("cons");
        BufferedReader in = new BufferedReader(new StringReader(resp));
        int count = 0;
        while ((line = in.readLine()) != null && line.length() > 0) {
            ++count;
            Assert.assertTrue((String)line, (boolean)Pattern.matches("^ /.*:\\d+\\[\\d+\\]\\(queued=\\d+,recved=\\d+,sent=\\d+.*\\)$", line));
        }
        Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
        zk1.close();
        zk2.close();
    }

    @Test(timeout=60000L)
    public void testValidateSocketTimeout() throws Exception {
        String resp = this.sendRequest("isro", 2000);
        Assert.assertTrue((boolean)resp.contains("rw"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetTraceMask() throws Exception {
        String gtmkResp = this.sendRequest("gtmk");
        Assert.assertNotNull((Object)gtmkResp);
        gtmkResp = gtmkResp.trim();
        Assert.assertFalse((boolean)gtmkResp.isEmpty());
        long formerMask = Long.valueOf(gtmkResp);
        try {
            this.verify(this.buildSetTraceMaskRequest(0L), "0");
            this.verify("gtmk", "0");
        }
        finally {
            this.sendRequest(this.buildSetTraceMaskRequest(formerMask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildSetTraceMaskRequest(long mask) throws IOException {
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            dos.writeBytes("stmk");
            dos.writeLong(mask);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dos);
            IOUtils.closeStream((Closeable)baos);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dos);
        IOUtils.closeStream((Closeable)baos);
        return new String(baos.toByteArray());
    }
}

