/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.SaslException;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerSessionTracker;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerMainTest;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzySnapshotRelatedTest
extends QuorumPeerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(FuzzySnapshotRelatedTest.class);
    QuorumPeerTestBase.MainThread[] mt = null;
    ZooKeeper[] zk = null;
    int[] clientPorts = null;
    int leaderId;
    int followerA;

    @Before
    public void setup() throws Exception {
        int i;
        ZooKeeperServer.setDigestEnabled((boolean)true);
        LOG.info("Start up a 3 server quorum");
        int ENSEMBLE_SERVERS = 3;
        this.clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            this.clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + this.clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        this.mt = new QuorumPeerTestBase.MainThread[3];
        this.zk = new ZooKeeper[3];
        for (i = 0; i < 3; ++i) {
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, this.clientPorts[i], currentQuorumCfgSection, false){

                @Override
                public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                    return new CustomizedQPMain();
                }
            };
            this.mt[i].start();
            this.zk[i] = new ZooKeeper("127.0.0.1:" + this.clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        QuorumPeerMainTest.waitForAll(this.zk, ZooKeeper.States.CONNECTED);
        LOG.info("all servers started");
        this.leaderId = -1;
        this.followerA = -1;
        for (i = 0; i < 3; ++i) {
            if (this.mt[i].main.quorumPeer.leader != null) {
                this.leaderId = i;
                continue;
            }
            if (this.followerA != -1) continue;
            this.followerA = i;
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ZooKeeperServer.setDigestEnabled((boolean)false);
        if (this.mt != null) {
            for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
                mainThread.shutdown();
            }
        }
        if (this.zk != null) {
            for (QuorumPeerTestBase.MainThread mainThread : this.zk) {
                mainThread.close();
            }
        }
    }

    @Test
    public void testMultiOpConsistency() throws Exception {
        LOG.info("Create a parent node");
        String path = "/testMultiOpConsistency";
        this.createEmptyNode(this.zk[this.followerA], "/testMultiOpConsistency", CreateMode.PERSISTENT);
        LOG.info("Hook to catch the 2nd sub create node txn in multi-op");
        CustomDataTree dt = (CustomDataTree)this.mt[this.followerA].main.quorumPeer.getZkDb().getDataTree();
        final ZooKeeperServer zkServer = this.mt[this.followerA].main.quorumPeer.getActiveServer();
        String node1 = "/testMultiOpConsistency/1";
        String node2 = "/testMultiOpConsistency/2";
        dt.addNodeCreateListener(node2, new NodeCreateListener(){

            @Override
            public void process(String path) {
                LOG.info("Take a snapshot");
                zkServer.takeSnapshot(true);
            }
        });
        LOG.info("Issue a multi op to create 2 nodes");
        this.zk[this.followerA].multi(Arrays.asList(Op.create((String)node1, (byte[])node1.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)node2, (byte[])node2.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
        LOG.info("Restart the server");
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTING);
        this.mt[this.followerA].start();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Make sure the node consistent with leader");
        Assert.assertEquals((Object)new String(this.zk[this.leaderId].getData(node2, null, null)), (Object)new String(this.zk[this.followerA].getData(node2, null, null)));
    }

    @Test
    public void testPZxidUpdatedDuringSnapSyncing() throws Exception {
        LOG.info("Enable force snapshot sync");
        System.setProperty("zookeeper.forceSnapshotSync", "true");
        String parent = "/testPZxidUpdatedWhenDeletingNonExistNode";
        String child = "/testPZxidUpdatedWhenDeletingNonExistNode/child";
        this.createEmptyNode(this.zk[this.leaderId], "/testPZxidUpdatedWhenDeletingNonExistNode", CreateMode.PERSISTENT);
        this.createEmptyNode(this.zk[this.leaderId], "/testPZxidUpdatedWhenDeletingNonExistNode/child", CreateMode.EPHEMERAL);
        this.createEmptyNode(this.zk[this.leaderId], "/testPZxidUpdatedWhenDeletingNonExistNode/child1", CreateMode.EPHEMERAL);
        LOG.info("shutdown follower {}", (Object)this.followerA);
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTING);
        LOG.info("Set up ZKDatabase to catch the node serializing in DataTree");
        this.addSerializeListener(this.leaderId, "/testPZxidUpdatedWhenDeletingNonExistNode", "/testPZxidUpdatedWhenDeletingNonExistNode/child");
        LOG.info("Restart follower A to trigger a SNAP sync with leader");
        this.mt[this.followerA].start();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Check and make sure the pzxid of the parent is the same on leader and follower A");
        this.compareStat("/testPZxidUpdatedWhenDeletingNonExistNode", this.leaderId, this.followerA);
    }

    @Test
    public void testPZxidUpdatedWhenLoadingSnapshot() throws Exception {
        String parent = "/testPZxidUpdatedDuringTakingSnapshot";
        String child = "/testPZxidUpdatedDuringTakingSnapshot/child";
        this.createEmptyNode(this.zk[this.followerA], "/testPZxidUpdatedDuringTakingSnapshot", CreateMode.PERSISTENT);
        this.createEmptyNode(this.zk[this.followerA], "/testPZxidUpdatedDuringTakingSnapshot/child", CreateMode.EPHEMERAL);
        this.createEmptyNode(this.zk[this.leaderId], "/testPZxidUpdatedDuringTakingSnapshot/child1", CreateMode.EPHEMERAL);
        LOG.info("Set up ZKDatabase to catch the node serializing in DataTree");
        this.addSerializeListener(this.followerA, "/testPZxidUpdatedDuringTakingSnapshot", "/testPZxidUpdatedDuringTakingSnapshot/child");
        LOG.info("Take snapshot on follower A");
        ZooKeeperServer zkServer = this.mt[this.followerA].main.quorumPeer.getActiveServer();
        zkServer.takeSnapshot(true);
        LOG.info("Restarting follower A to load snapshot");
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CLOSED);
        this.mt[this.followerA].start();
        this.zk[this.followerA] = new ZooKeeper("127.0.0.1:" + this.clientPorts[this.followerA], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Check and make sure the pzxid of the parent is the same on leader and follower A");
        this.compareStat("/testPZxidUpdatedDuringTakingSnapshot", this.leaderId, this.followerA);
    }

    @Test
    public void testMultiOpDigestConsistentDuringSnapshot() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        LOG.info("Create some txns");
        String path = "/testMultiOpDigestConsistentDuringSnapshot";
        this.createEmptyNode(this.zk[this.followerA], "/testMultiOpDigestConsistentDuringSnapshot", CreateMode.PERSISTENT);
        CustomDataTree dt = (CustomDataTree)this.mt[this.followerA].main.quorumPeer.getZkDb().getDataTree();
        final CountDownLatch setDataLatch = new CountDownLatch(1);
        final CountDownLatch continueSetDataLatch = new CountDownLatch(1);
        final ZooKeeper followerZk = this.zk[this.followerA];
        dt.setDigestSerializeListener(new DigestSerializeListener(){

            @Override
            public void process() {
                LOG.info("Trigger a multi op in async");
                followerZk.multi(Arrays.asList(Op.create((String)"/multi0", (byte[])"/multi0".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/testMultiOpDigestConsistentDuringSnapshot", (byte[])"new data".getBytes(), (int)-1)), new AsyncCallback.MultiCallback(){

                    public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    }
                }, null);
                LOG.info("Wait for the signal to continue");
                try {
                    setDataLatch.await(3L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    LOG.error("Error while waiting for set data txn, {}", (Throwable)e);
                }
            }

            @Override
            public void finished() {
                LOG.info("Finished writing digest out, continue");
                continueSetDataLatch.countDown();
            }
        });
        dt.setDataListener(new SetDataTxnListener(){

            @Override
            public void process() {
                setDataLatch.countDown();
                try {
                    continueSetDataLatch.await(3L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    LOG.error("Error while waiting for continue signal, {}", (Throwable)e);
                }
            }
        });
        LOG.info("Trigger a snapshot");
        ZooKeeperServer zkServer = this.mt[this.followerA].main.quorumPeer.getActiveServer();
        zkServer.takeSnapshot(true);
        this.checkNoMismatchReported();
        LOG.info("Restart the server to load the snapshot again");
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTING);
        this.mt[this.followerA].start();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Make sure there is nothing caught in the digest mismatch");
        this.checkNoMismatchReported();
    }

    private void checkNoMismatchReported() {
        long mismatch = (Long)MetricsUtils.currentServerMetrics().get("digest_mismatches_count");
        Assert.assertFalse((String)("The mismatch count should be zero but is: " + mismatch), (mismatch > 0L ? 1 : 0) != 0);
    }

    private void addSerializeListener(int sid, String parent, final String child) {
        final ZooKeeper zkClient = this.zk[sid];
        CustomDataTree dt = (CustomDataTree)this.mt[sid].main.quorumPeer.getZkDb().getDataTree();
        dt.addListener(parent, new NodeSerializeListener(){

            @Override
            public void nodeSerialized(String path) {
                try {
                    zkClient.delete(child, -1);
                    zkClient.close();
                    LOG.info("Deleted the child node after the parent is serialized");
                }
                catch (Exception e) {
                    LOG.error("Error when deleting node {}", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareStat(String path, int sid, int compareWithSid) throws Exception {
        ZooKeeper[] compareZk = new ZooKeeper[]{new ZooKeeper("127.0.0.1:" + this.clientPorts[sid], ClientBase.CONNECTION_TIMEOUT, (Watcher)this), new ZooKeeper("127.0.0.1:" + this.clientPorts[compareWithSid], ClientBase.CONNECTION_TIMEOUT, (Watcher)this)};
        QuorumPeerMainTest.waitForAll(compareZk, ZooKeeper.States.CONNECTED);
        try {
            Stat stat1 = new Stat();
            compareZk[0].getData(path, null, stat1);
            Stat stat2 = new Stat();
            compareZk[1].getData(path, null, stat2);
            Assert.assertEquals((Object)stat1, (Object)stat2);
        }
        finally {
            for (ZooKeeper z : compareZk) {
                z.close();
            }
        }
    }

    @Test
    public void testGlobalSessionConsistency() throws Exception {
        LOG.info("Hook to catch the commitSession event on followerA");
        CustomizedQPMain followerAMain = (CustomizedQPMain)this.mt[this.followerA].main;
        final ZooKeeperServer zkServer = followerAMain.quorumPeer.getActiveServer();
        final AtomicBoolean shouldTakeSnapshot = new AtomicBoolean(true);
        followerAMain.setCommitSessionListener(new CommitSessionListener(){

            @Override
            public void process(long sessionId) {
                LOG.info("Take snapshot");
                if (shouldTakeSnapshot.getAndSet(false)) {
                    zkServer.takeSnapshot(true);
                }
            }
        });
        LOG.info("Create a global session");
        ZooKeeper globalClient = new ZooKeeper("127.0.0.1:" + this.clientPorts[this.followerA], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        QuorumPeerMainTest.waitForOne(globalClient, ZooKeeper.States.CONNECTED);
        LOG.info("Restart followerA to load the data from disk");
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTING);
        this.mt[this.followerA].start();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Make sure the global sessions are consistent with leader");
        ConcurrentHashMap globalSessionsOnLeader = this.mt[this.leaderId].main.quorumPeer.getZkDb().getSessionWithTimeOuts();
        ConcurrentHashMap globalSessionsOnFollowerA = this.mt[this.followerA].main.quorumPeer.getZkDb().getSessionWithTimeOuts();
        LOG.info("sessions are {}, {}", globalSessionsOnLeader.keySet(), globalSessionsOnFollowerA.keySet());
        Assert.assertTrue((boolean)globalSessionsOnFollowerA.keySet().containsAll(globalSessionsOnLeader.keySet()));
    }

    private void createEmptyNode(ZooKeeper zk, String path, CreateMode mode) throws Exception {
        zk.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    static class CustomizedQPMain
    extends QuorumPeerTestBase.TestQPMain {
        CommitSessionListener commitSessionListener;

        CustomizedQPMain() {
        }

        public void setCommitSessionListener(CommitSessionListener listener) {
            this.commitSessionListener = listener;
        }

        protected QuorumPeer getQuorumPeer() throws SaslException {
            return new QuorumPeer(){

                public void setZKDatabase(ZKDatabase database) {
                    super.setZKDatabase(new ZKDatabase(this.getTxnFactory()){

                        public DataTree createDataTree() {
                            return new CustomDataTree();
                        }
                    });
                }

                protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
                    return new Follower((QuorumPeer)this, new FollowerZooKeeperServer(logFactory, this, this.getZkDb()){

                        public void createSessionTracker() {
                            this.sessionTracker = new LearnerSessionTracker((SessionTracker.SessionExpirer)this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener()){

                                public synchronized boolean commitSession(long sessionId, int sessionTimeout) {
                                    if (commitSessionListener != null) {
                                        commitSessionListener.process(sessionId);
                                    }
                                    return super.commitSession(sessionId, sessionTimeout);
                                }
                            };
                        }
                    });
                }
            };
        }
    }

    static interface CommitSessionListener {
        public void process(long var1);
    }

    static interface NodeSerializeListener {
        public void nodeSerialized(String var1);
    }

    static class CustomDataTree
    extends DataTree {
        Map<String, NodeCreateListener> nodeCreateListeners = new HashMap<String, NodeCreateListener>();
        Map<String, NodeSerializeListener> listeners = new HashMap<String, NodeSerializeListener>();
        DigestSerializeListener digestListener;
        SetDataTxnListener setListener;

        CustomDataTree() {
        }

        public void serializeNodeData(OutputArchive oa, String path, DataNode node) throws IOException {
            super.serializeNodeData(oa, path, node);
            NodeSerializeListener listener = this.listeners.get(path);
            if (listener != null) {
                listener.nodeSerialized(path);
            }
        }

        public void addListener(String path, NodeSerializeListener listener) {
            this.listeners.put(path, listener);
        }

        public void createNode(String path, byte[] data, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time, Stat outputStat) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
            NodeCreateListener listener = this.nodeCreateListeners.get(path);
            if (listener != null) {
                listener.process(path);
            }
            super.createNode(path, data, acl, ephemeralOwner, parentCVersion, zxid, time, outputStat);
        }

        public void addNodeCreateListener(String path, NodeCreateListener listener) {
            this.nodeCreateListeners.put(path, listener);
        }

        public void setDigestSerializeListener(DigestSerializeListener listener) {
            this.digestListener = listener;
        }

        public void setDataListener(SetDataTxnListener listener) {
            this.setListener = listener;
        }

        public boolean serializeZxidDigest(OutputArchive oa) throws IOException {
            if (this.digestListener != null) {
                this.digestListener.process();
            }
            boolean result = super.serializeZxidDigest(oa);
            if (this.digestListener != null) {
                this.digestListener.finished();
            }
            return result;
        }

        public Stat setData(String path, byte[] data, int version, long zxid, long time) throws KeeperException.NoNodeException {
            if (this.setListener != null) {
                this.setListener.process();
            }
            return super.setData(path, data, version, zxid, time);
        }
    }

    static interface SetDataTxnListener {
        public void process();
    }

    static interface DigestSerializeListener {
        public void process();

        public void finished();
    }

    static interface NodeCreateListener {
        public void process(String var1);
    }
}

