/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerMaxCnxnsTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerMaxCnxnsTest.class);
    private static int SERVER_COUNT = 3;
    private QuorumPeerTestBase.MainThread[] mt;
    private ZooKeeper[] clients;

    @Test(timeout=120000L)
    public void testMaxZooKeeperClientsWithNIOServerCnxnFactory() throws Exception {
        String serverCnxnFactory = "org.apache.zookeeper.server.NIOServerCnxnFactory";
        this.testMaxZooKeeperClients(serverCnxnFactory);
    }

    @Test(timeout=120000L)
    public void testMaxZooKeeperClientsWithNettyServerCnxnFactory() throws Exception {
        String serverCnxnFactory = "org.apache.zookeeper.server.NettyServerCnxnFactory";
        this.testMaxZooKeeperClients(serverCnxnFactory);
    }

    private void testMaxZooKeeperClients(String serverCnxnFactory) throws Exception {
        int i;
        int[] clientPorts = new int[SERVER_COUNT];
        int maxCnxns = 2;
        StringBuilder sb = new StringBuilder();
        sb.append("maxCnxns=" + maxCnxns + "\n");
        sb.append("serverCnxnFactory=" + serverCnxnFactory + "\n");
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        for (i = 0; i < SERVER_COUNT; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        int maxAllowedConnection = maxCnxns * SERVER_COUNT;
        String cxnString = this.getCxnString(clientPorts);
        final CountDownLatch countDownLatch = new CountDownLatch(maxAllowedConnection);
        ZooKeeper[] clients = new ZooKeeper[maxAllowedConnection];
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    countDownLatch.countDown();
                }
            }
        };
        for (int i3 = 0; i3 < maxAllowedConnection; ++i3) {
            clients[i3] = new ZooKeeper(cxnString, ClientBase.CONNECTION_TIMEOUT, watcher);
            Thread.sleep(100L);
        }
        countDownLatch.await();
        ClientBase.CountdownWatcher cdw = new ClientBase.CountdownWatcher();
        ZooKeeper extraClient = new ZooKeeper(cxnString, ClientBase.CONNECTION_TIMEOUT, (Watcher)cdw);
        try {
            cdw.waitForConnected(ClientBase.CONNECTION_TIMEOUT / 2);
            Assert.fail((String)"Client is not supposed to get connected as max connection already reached.");
        }
        catch (TimeoutException e) {
            extraClient.close();
        }
        clients[0].close();
        cdw = new ClientBase.CountdownWatcher();
        extraClient = new ZooKeeper(cxnString, ClientBase.CONNECTION_TIMEOUT, (Watcher)cdw);
        cdw.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        String create = extraClient.create("/test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)"/test", (Object)create);
        extraClient.close();
    }

    private String getCxnString(int[] clientPorts) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < clientPorts.length; ++i) {
            builder.append("127.0.0.1:" + clientPorts[i]);
            if (i == clientPorts.length - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    @Override
    @After
    public void tearDown() {
        if (this.clients != null) {
            for (ZooKeeper zooKeeper : this.clients) {
                try {
                    zooKeeper.close();
                }
                catch (InterruptedException e) {
                    LOG.warn("ZooKeeper interrupted while closing it.", (Throwable)e);
                }
            }
        }
        if (this.mt != null) {
            for (int i = 0; i < SERVER_COUNT; ++i) {
                try {
                    this.mt[i].shutdown();
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.warn("Quorum Peer interrupted while shutting it down", (Throwable)e);
                }
            }
        }
    }
}

