/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class GetAllChildrenNumberTest
extends ClientBase {
    private static final String BASE = "/getAllChildrenNumberTest";
    private static final String BASE_EXT = "/getAllChildrenNumberTestEXT";
    private static final int PERSISTENT_CNT = 2;
    private static final int EPHEMERAL_CNT = 3;
    private ZooKeeper zk;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
        this.generatePaths(2, 3);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testGetAllChildrenNumberSync() throws KeeperException, InterruptedException {
        try {
            this.zk.getAllChildrenNumber(null);
            Assert.fail((String)"the path for getAllChildrenNumber must not be null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)this.zk.getAllChildrenNumber("/getAllChildrenNumberTest/0"));
        Assert.assertEquals((long)0L, (long)this.zk.getAllChildrenNumber("/getAllChildrenNumberTest/0/ephem0"));
        Assert.assertEquals((long)0L, (long)this.zk.getAllChildrenNumber(BASE_EXT));
        Assert.assertEquals((long)8L, (long)this.zk.getAllChildrenNumber(BASE));
        Assert.assertEquals((long)13L, (long)this.zk.getAllChildrenNumber("/"));
    }

    @Test
    public void testGetAllChildrenNumberAsync() throws IOException, KeeperException, InterruptedException {
        final CountDownLatch doneProcessing = new CountDownLatch(1);
        this.zk.getAllChildrenNumber("/", new AsyncCallback.AllChildrenNumberCallback(){

            public void processResult(int rc, String path, Object ctx, int number) {
                if (path == null) {
                    Assert.fail((String)String.format("the path of getAllChildrenNumber was null.", new Object[0]));
                }
                Assert.assertEquals((long)13L, (long)number);
                doneProcessing.countDown();
            }
        }, null);
        long waitForCallbackSecs = 2L;
        if (!doneProcessing.await(waitForCallbackSecs, TimeUnit.SECONDS)) {
            Assert.fail((String)String.format("getAllChildrenNumber didn't callback within %d seconds", waitForCallbackSecs));
        }
    }

    private void generatePaths(int persistantCnt, int ephemeralCnt) throws KeeperException, InterruptedException {
        this.zk.create(BASE, BASE.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create(BASE_EXT, BASE_EXT.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int p = 0; p < persistantCnt; ++p) {
            String base = "/getAllChildrenNumberTest/" + p;
            this.zk.create(base, base.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int e = 0; e < ephemeralCnt; ++e) {
                String ephem = base + "/ephem" + e;
                this.zk.create(ephem, ephem.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
        }
    }
}

