/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.sc;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.stream.proto.cluster.ClusterAssignmentData;
import org.apache.bookkeeper.stream.proto.cluster.ClusterMetadata;
import org.apache.bookkeeper.stream.proto.cluster.ServerAssignmentData;
import org.apache.bookkeeper.stream.storage.impl.sc.StorageContainerController;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStorageContainerController
implements StorageContainerController {
    private static final Logger log = LoggerFactory.getLogger(DefaultStorageContainerController.class);

    @Override
    public ClusterAssignmentData computeIdealState(ClusterMetadata clusterMetadata, ClusterAssignmentData currentState, Set<BookieId> currentCluster) {
        HashMap currentServerAssignments;
        if (currentCluster.isEmpty()) {
            log.info("Current cluster is empty. No alive server is found.");
            return currentState;
        }
        try {
            currentServerAssignments = currentState.getServersMap().entrySet().stream().collect(Collectors.toMap(e1 -> BookieId.parse((String)((String)e1.getKey())), e2 -> ((ServerAssignmentData)e2.getValue()).getContainersList().stream().collect(Collectors.toSet())));
        }
        catch (UncheckedExecutionException uee) {
            log.warn("Invalid cluster assignment data is found : {} - {}. Recompute assignment from empty state", (Object)currentState, (Object)uee.getCause().getMessage());
            currentServerAssignments = Maps.newHashMap();
        }
        Set currentServersAssigned = currentServerAssignments.keySet();
        if (currentServersAssigned.isEmpty()) {
            return DefaultStorageContainerController.initializeIdealState(clusterMetadata, currentCluster);
        }
        ImmutableSet serversAdded = Sets.difference(currentCluster, currentServersAssigned).immutableCopy();
        ImmutableSet serversRemoved = Sets.difference(currentServersAssigned, currentCluster).immutableCopy();
        if (serversAdded.isEmpty() && serversRemoved.isEmpty()) {
            return currentState;
        }
        log.info("Storage container controller detects cluster changed:\n\t {} servers added: {}\n\t {} servers removed: {}", new Object[]{serversAdded.size(), serversAdded, serversRemoved.size(), serversRemoved});
        Set containersToReassign = currentServerAssignments.entrySet().stream().filter(serverEntry -> !currentCluster.contains(serverEntry.getKey())).flatMap(serverEntry -> ((Set)serverEntry.getValue()).stream()).collect(Collectors.toSet());
        TreeSet<Pair<BookieId, LinkedList<Long>>> assignmentQueue = new TreeSet<Pair<BookieId, LinkedList<Long>>>(new ServerAssignmentDataComparator());
        for (Map.Entry entry : currentServerAssignments.entrySet()) {
            BookieId host = (BookieId)entry.getKey();
            if (!currentCluster.contains(host)) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Host {} is not in current cluster anymore", (Object)host);
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace("Adding host {} to assignment queue", (Object)host);
            }
            assignmentQueue.add((Pair<BookieId, LinkedList<Long>>)Pair.of((Object)host, (Object)Lists.newLinkedList((Iterable)((Iterable)entry.getValue()))));
        }
        for (BookieId server : serversAdded) {
            assignmentQueue.add((Pair<BookieId, LinkedList<Long>>)Pair.of((Object)server, (Object)Lists.newLinkedList()));
        }
        for (Long containerId : containersToReassign) {
            Pair<BookieId, LinkedList<Long>> leastLoadedServer = assignmentQueue.pollFirst();
            ((LinkedList)leastLoadedServer.getValue()).add(containerId);
            assignmentQueue.add(leastLoadedServer);
        }
        int diffAllowed = (long)assignmentQueue.size() > clusterMetadata.getNumStorageContainers() ? 1 : (clusterMetadata.getNumStorageContainers() % (long)assignmentQueue.size() == 0L ? 0 : 1);
        Pair<BookieId, LinkedList<Long>> leastLoaded = assignmentQueue.first();
        Pair<BookieId, LinkedList<Long>> mostLoaded = assignmentQueue.last();
        while (((LinkedList)mostLoaded.getValue()).size() - ((LinkedList)leastLoaded.getValue()).size() > diffAllowed) {
            leastLoaded = assignmentQueue.pollFirst();
            mostLoaded = assignmentQueue.pollLast();
            Long containerId = (Long)((LinkedList)mostLoaded.getValue()).removeFirst();
            ((LinkedList)leastLoaded.getValue()).addLast(containerId);
            assignmentQueue.add(leastLoaded);
            assignmentQueue.add(mostLoaded);
            leastLoaded = assignmentQueue.first();
            mostLoaded = assignmentQueue.last();
        }
        HashMap newAssignmentMap = Maps.newHashMap();
        assignmentQueue.forEach(assignment -> newAssignmentMap.put(((BookieId)assignment.getKey()).toString(), ServerAssignmentData.newBuilder().addAllContainers((Iterable)assignment.getValue()).build()));
        return ClusterAssignmentData.newBuilder().putAllServers((Map)newAssignmentMap).build();
    }

    static ClusterAssignmentData initializeIdealState(ClusterMetadata clusterMetadata, Set<BookieId> currentCluster) {
        ArrayList serverList = Lists.newArrayListWithExpectedSize((int)currentCluster.size());
        serverList.addAll(currentCluster);
        Collections.shuffle(serverList);
        int numServers = currentCluster.size();
        int numTotalContainers = (int)clusterMetadata.getNumStorageContainers();
        int numContainersPerServer = numTotalContainers / currentCluster.size();
        HashMap assignmentMap = Maps.newHashMap();
        int serverIdx = 0;
        while (serverIdx < serverList.size()) {
            BookieId server = (BookieId)serverList.get(serverIdx);
            int finalServerIdx = serverIdx++;
            ServerAssignmentData assignmentData = ServerAssignmentData.newBuilder().addAllContainers((Iterable)LongStream.rangeClosed(0L, numContainersPerServer).boxed().map(j -> j * (long)numServers + (long)finalServerIdx).filter(containerId -> containerId < (long)numTotalContainers).collect(Collectors.toSet())).build();
            assignmentMap.put(server.toString(), assignmentData);
        }
        return ClusterAssignmentData.newBuilder().putAllServers((Map)assignmentMap).build();
    }

    static final class ServerAssignmentDataComparator
    implements Comparator<Pair<BookieId, LinkedList<Long>>> {
        ServerAssignmentDataComparator() {
        }

        @Override
        public int compare(Pair<BookieId, LinkedList<Long>> o1, Pair<BookieId, LinkedList<Long>> o2) {
            int res = Integer.compare(((LinkedList)o1.getValue()).size(), ((LinkedList)o2.getValue()).size());
            if (0 == res) {
                return String.CASE_INSENSITIVE_ORDER.compare(((BookieId)o1.getKey()).toString(), ((BookieId)o2.getKey()).toString());
            }
            return res;
        }
    }
}

