/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.alts.internal.AltsContext;
import io.grpc.alts.internal.HandshakerResult;
import io.grpc.alts.internal.RpcProtocolVersions;
import io.grpc.alts.internal.SecurityLevel;
import java.util.Map;

public final class AltsAuthContext {
    final AltsContext context;

    public AltsAuthContext(HandshakerResult result) {
        this.context = AltsContext.newBuilder().setApplicationProtocol(result.getApplicationProtocol()).setRecordProtocol(result.getRecordProtocol()).setSecurityLevel(SecurityLevel.INTEGRITY_AND_PRIVACY).setPeerServiceAccount(result.getPeerIdentity().getServiceAccount()).setLocalServiceAccount(result.getLocalIdentity().getServiceAccount()).setPeerRpcVersions(result.getPeerRpcVersions()).putAllPeerAttributes(result.getPeerIdentity().getAttributes()).build();
    }

    @VisibleForTesting
    public static AltsAuthContext getDefaultInstance() {
        return new AltsAuthContext(HandshakerResult.newBuilder().build());
    }

    public String getApplicationProtocol() {
        return this.context.getApplicationProtocol();
    }

    public String getRecordProtocol() {
        return this.context.getRecordProtocol();
    }

    public SecurityLevel getSecurityLevel() {
        return this.context.getSecurityLevel();
    }

    public String getPeerServiceAccount() {
        return this.context.getPeerServiceAccount();
    }

    public String getLocalServiceAccount() {
        return this.context.getLocalServiceAccount();
    }

    public RpcProtocolVersions getPeerRpcVersions() {
        return this.context.getPeerRpcVersions();
    }

    public Map<String, String> getPeerAttributes() {
        return this.context.getPeerAttributes();
    }
}

