/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.feature;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.bookkeeper.feature.Feature;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.feature.ConfigurationFeatureProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationFeatureProvider {
    @Test(timeout=60000L)
    public void testConfigurationFeatureProvider() throws Exception {
        String rootScope = "dl";
        ConcurrentBaseConfiguration featureConf = new ConcurrentBaseConfiguration();
        ConcurrentHashMap features = new ConcurrentHashMap();
        ConfigurationFeatureProvider featureProvider = new ConfigurationFeatureProvider(rootScope, featureConf, features);
        String featureName1 = "feature1";
        String fullFeatureName1 = rootScope + "." + featureName1;
        int availability1 = 1234;
        featureConf.setProperty(fullFeatureName1, (Object)availability1);
        Feature feature1 = featureProvider.getFeature(featureName1);
        Assert.assertEquals((long)availability1, (long)feature1.availability());
        Assert.assertTrue((boolean)features.containsKey(fullFeatureName1));
        Assert.assertTrue((feature1 == features.get(fullFeatureName1) ? 1 : 0) != 0);
        String subScope = "subscope";
        String featureName2 = "feature2";
        String fullFeatureName2 = rootScope + "." + subScope + "." + featureName2;
        int availability2 = 4321;
        featureConf.setProperty(fullFeatureName2, (Object)availability2);
        Feature feature2 = featureProvider.scope(subScope).getFeature(featureName2);
        Assert.assertEquals((long)availability2, (long)feature2.availability());
        Assert.assertTrue((boolean)features.containsKey(fullFeatureName2));
        Assert.assertTrue((feature2 == features.get(fullFeatureName2) ? 1 : 0) != 0);
    }
}

