/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.table;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.AdminCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class DeleteTableCommand
extends AdminCommand<Flags> {
    private static final String NAME = "delete";
    private static final String DESC = "Delete a table";

    public DeleteTableCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<table-name>").build());
    }

    @Override
    protected void run(StorageAdminClient admin, BKFlags globalFlags, Flags flags) throws Exception {
        Preconditions.checkArgument((!flags.arguments.isEmpty() ? 1 : 0) != 0, (Object)"Table name is not provided");
        String streamName = (String)flags.arguments.get(0);
        try {
            FutureUtils.result((CompletableFuture)admin.deleteStream(globalFlags.namespace, streamName));
            this.spec.console().println("Successfully deleted table '" + streamName + "' from namespace '" + globalFlags.namespace + "'");
        }
        catch (NamespaceNotFoundException nfe) {
            this.spec.console().println("Namespace '" + globalFlags.namespace + "' does not exist");
        }
        catch (StreamNotFoundException snfe) {
            this.spec.console().println("Table '" + streamName + "' does not exist");
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

