/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.util.Base64;

public class TCPSSLOptionsConverter {
    public static void fromJson(JsonObject json, TCPSSLOptions obj) {
        if (json.getValue("crlPaths") instanceof JsonArray) {
            json.getJsonArray("crlPaths").forEach(item -> {
                if (item instanceof String) {
                    obj.addCrlPath((String)item);
                }
            });
        }
        if (json.getValue("crlValues") instanceof JsonArray) {
            json.getJsonArray("crlValues").forEach(item -> {
                if (item instanceof String) {
                    obj.addCrlValue(Buffer.buffer(Base64.getDecoder().decode((String)item)));
                }
            });
        }
        if (json.getValue("enabledCipherSuites") instanceof JsonArray) {
            json.getJsonArray("enabledCipherSuites").forEach(item -> {
                if (item instanceof String) {
                    obj.addEnabledCipherSuite((String)item);
                }
            });
        }
        if (json.getValue("enabledSecureTransportProtocols") instanceof JsonArray) {
            json.getJsonArray("enabledSecureTransportProtocols").forEach(item -> {
                if (item instanceof String) {
                    obj.addEnabledSecureTransportProtocol((String)item);
                }
            });
        }
        if (json.getValue("idleTimeout") instanceof Number) {
            obj.setIdleTimeout(((Number)json.getValue("idleTimeout")).intValue());
        }
        if (json.getValue("jdkSslEngineOptions") instanceof JsonObject) {
            obj.setJdkSslEngineOptions(new JdkSSLEngineOptions((JsonObject)json.getValue("jdkSslEngineOptions")));
        }
        if (json.getValue("keyStoreOptions") instanceof JsonObject) {
            obj.setKeyStoreOptions(new JksOptions((JsonObject)json.getValue("keyStoreOptions")));
        }
        if (json.getValue("openSslEngineOptions") instanceof JsonObject) {
            obj.setOpenSslEngineOptions(new OpenSSLEngineOptions((JsonObject)json.getValue("openSslEngineOptions")));
        }
        if (json.getValue("pemKeyCertOptions") instanceof JsonObject) {
            obj.setPemKeyCertOptions(new PemKeyCertOptions((JsonObject)json.getValue("pemKeyCertOptions")));
        }
        if (json.getValue("pemTrustOptions") instanceof JsonObject) {
            obj.setPemTrustOptions(new PemTrustOptions((JsonObject)json.getValue("pemTrustOptions")));
        }
        if (json.getValue("pfxKeyCertOptions") instanceof JsonObject) {
            obj.setPfxKeyCertOptions(new PfxOptions((JsonObject)json.getValue("pfxKeyCertOptions")));
        }
        if (json.getValue("pfxTrustOptions") instanceof JsonObject) {
            obj.setPfxTrustOptions(new PfxOptions((JsonObject)json.getValue("pfxTrustOptions")));
        }
        if (json.getValue("soLinger") instanceof Number) {
            obj.setSoLinger(((Number)json.getValue("soLinger")).intValue());
        }
        if (json.getValue("ssl") instanceof Boolean) {
            obj.setSsl((Boolean)json.getValue("ssl"));
        }
        if (json.getValue("tcpKeepAlive") instanceof Boolean) {
            obj.setTcpKeepAlive((Boolean)json.getValue("tcpKeepAlive"));
        }
        if (json.getValue("tcpNoDelay") instanceof Boolean) {
            obj.setTcpNoDelay((Boolean)json.getValue("tcpNoDelay"));
        }
        if (json.getValue("trustStoreOptions") instanceof JsonObject) {
            obj.setTrustStoreOptions(new JksOptions((JsonObject)json.getValue("trustStoreOptions")));
        }
        if (json.getValue("useAlpn") instanceof Boolean) {
            obj.setUseAlpn((Boolean)json.getValue("useAlpn"));
        }
        if (json.getValue("usePooledBuffers") instanceof Boolean) {
            obj.setUsePooledBuffers((Boolean)json.getValue("usePooledBuffers"));
        }
    }

    public static void toJson(TCPSSLOptions obj, JsonObject json) {
        JsonArray array;
        if (obj.getCrlPaths() != null) {
            array = new JsonArray();
            obj.getCrlPaths().forEach(item -> array.add((String)item));
            json.put("crlPaths", array);
        }
        if (obj.getCrlValues() != null) {
            array = new JsonArray();
            obj.getCrlValues().forEach(item -> array.add(item.getBytes()));
            json.put("crlValues", array);
        }
        if (obj.getEnabledCipherSuites() != null) {
            array = new JsonArray();
            obj.getEnabledCipherSuites().forEach(item -> array.add((String)item));
            json.put("enabledCipherSuites", array);
        }
        if (obj.getEnabledSecureTransportProtocols() != null) {
            array = new JsonArray();
            obj.getEnabledSecureTransportProtocols().forEach(item -> array.add((String)item));
            json.put("enabledSecureTransportProtocols", array);
        }
        json.put("idleTimeout", obj.getIdleTimeout());
        if (obj.getJdkSslEngineOptions() != null) {
            json.put("jdkSslEngineOptions", obj.getJdkSslEngineOptions().toJson());
        }
        if (obj.getKeyStoreOptions() != null) {
            json.put("keyStoreOptions", obj.getKeyStoreOptions().toJson());
        }
        if (obj.getOpenSslEngineOptions() != null) {
            json.put("openSslEngineOptions", obj.getOpenSslEngineOptions().toJson());
        }
        if (obj.getPemKeyCertOptions() != null) {
            json.put("pemKeyCertOptions", obj.getPemKeyCertOptions().toJson());
        }
        if (obj.getPemTrustOptions() != null) {
            json.put("pemTrustOptions", obj.getPemTrustOptions().toJson());
        }
        if (obj.getPfxKeyCertOptions() != null) {
            json.put("pfxKeyCertOptions", obj.getPfxKeyCertOptions().toJson());
        }
        if (obj.getPfxTrustOptions() != null) {
            json.put("pfxTrustOptions", obj.getPfxTrustOptions().toJson());
        }
        json.put("soLinger", obj.getSoLinger());
        json.put("ssl", obj.isSsl());
        json.put("tcpKeepAlive", obj.isTcpKeepAlive());
        json.put("tcpNoDelay", obj.isTcpNoDelay());
        if (obj.getTrustStoreOptions() != null) {
            json.put("trustStoreOptions", obj.getTrustStoreOptions().toJson());
        }
        json.put("useAlpn", obj.isUseAlpn());
        json.put("usePooledBuffers", obj.isUsePooledBuffers());
    }
}

