/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stats.AlertStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ReadUtils;
import org.apache.distributedlog.callback.LogSegmentNamesListener;
import org.apache.distributedlog.exceptions.LogEmptyException;
import org.apache.distributedlog.exceptions.LogSegmentNotFoundException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.io.AsyncAbortable;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.logsegment.LogSegmentEntryStore;
import org.apache.distributedlog.logsegment.LogSegmentFilter;
import org.apache.distributedlog.logsegment.LogSegmentMetadataCache;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.logsegment.PerStreamLogSegmentCache;
import org.apache.distributedlog.metadata.LogMetadata;
import org.apache.distributedlog.metadata.LogStreamMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BKLogHandler
implements AsyncCloseable,
AsyncAbortable {
    static final Logger LOG = LoggerFactory.getLogger(BKLogHandler.class);
    protected final LogMetadata logMetadata;
    protected final DistributedLogConfiguration conf;
    protected final LogStreamMetadataStore streamMetadataStore;
    protected final LogSegmentMetadataStore metadataStore;
    protected final LogSegmentMetadataCache metadataCache;
    protected final LogSegmentEntryStore entryStore;
    protected final int firstNumEntriesPerReadLastRecordScan;
    protected final int maxNumEntriesPerReadLastRecordScan;
    protected volatile long lastLedgerRollingTimeMillis = -1L;
    protected final OrderedScheduler scheduler;
    protected final StatsLogger statsLogger;
    protected final AlertStatsLogger alertStatsLogger;
    protected volatile boolean reportGetSegmentStats = false;
    private final String lockClientId;
    protected static final AtomicReferenceFieldUpdater<BKLogHandler, IOException> METADATA_EXCEPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BKLogHandler.class, IOException.class, "metadataException");
    private volatile IOException metadataException = null;
    protected final PerStreamLogSegmentCache logSegmentCache;
    protected final long metadataLatencyWarnThresholdMillis;
    private final OpStatsLogger getInprogressSegmentStat;
    private final OpStatsLogger getCompletedSegmentStat;
    private final OpStatsLogger negativeGetInprogressSegmentStat;
    private final OpStatsLogger negativeGetCompletedSegmentStat;
    private final OpStatsLogger recoverLastEntryStats;
    private final OpStatsLogger recoverScannedEntriesStats;

    BKLogHandler(LogMetadata metadata, DistributedLogConfiguration conf, LogStreamMetadataStore streamMetadataStore, LogSegmentMetadataCache metadataCache, LogSegmentEntryStore entryStore, OrderedScheduler scheduler, StatsLogger statsLogger, AlertStatsLogger alertStatsLogger, String lockClientId) {
        this.logMetadata = metadata;
        this.conf = conf;
        this.scheduler = scheduler;
        this.statsLogger = statsLogger;
        this.alertStatsLogger = alertStatsLogger;
        this.logSegmentCache = new PerStreamLogSegmentCache(metadata.getLogName(), conf.isLogSegmentSequenceNumberValidationEnabled());
        this.firstNumEntriesPerReadLastRecordScan = conf.getFirstNumEntriesPerReadLastRecordScan();
        this.maxNumEntriesPerReadLastRecordScan = conf.getMaxNumEntriesPerReadLastRecordScan();
        this.streamMetadataStore = streamMetadataStore;
        this.metadataStore = streamMetadataStore.getLogSegmentMetadataStore();
        this.metadataCache = metadataCache;
        this.entryStore = entryStore;
        this.lockClientId = lockClientId;
        this.metadataLatencyWarnThresholdMillis = conf.getMetadataLatencyWarnThresholdMillis();
        StatsLogger segmentsLogger = statsLogger.scope("logsegments");
        this.getInprogressSegmentStat = segmentsLogger.getOpStatsLogger("get_inprogress_segment");
        this.getCompletedSegmentStat = segmentsLogger.getOpStatsLogger("get_completed_segment");
        this.negativeGetInprogressSegmentStat = segmentsLogger.getOpStatsLogger("negative_get_inprogress_segment");
        this.negativeGetCompletedSegmentStat = segmentsLogger.getOpStatsLogger("negative_get_completed_segment");
        this.recoverLastEntryStats = segmentsLogger.getOpStatsLogger("recover_last_entry");
        this.recoverScannedEntriesStats = segmentsLogger.getOpStatsLogger("recover_scanned_entries");
    }

    BKLogHandler checkMetadataException() throws IOException {
        IOException ioe = METADATA_EXCEPTION_UPDATER.get(this);
        if (null != ioe) {
            throw ioe;
        }
        return this;
    }

    public void reportGetSegmentStats(boolean enabled) {
        this.reportGetSegmentStats = enabled;
    }

    public String getLockClientId() {
        return this.lockClientId;
    }

    public CompletableFuture<LogRecordWithDLSN> asyncGetFirstLogRecord() {
        final CompletableFuture<LogRecordWithDLSN> promise = new CompletableFuture<LogRecordWithDLSN>();
        this.streamMetadataStore.logExists(this.logMetadata.getUri(), this.logMetadata.getLogName()).whenComplete((BiConsumer)new FutureEventListener<Void>(){

            public void onSuccess(Void value) {
                BKLogHandler.this.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null).whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

                    public void onSuccess(Versioned<List<LogSegmentMetadata>> ledgerList) {
                        if (((List)ledgerList.getValue()).isEmpty()) {
                            promise.completeExceptionally((Throwable)new LogEmptyException("Log " + BKLogHandler.this.getFullyQualifiedName() + " has no records"));
                            return;
                        }
                        CompletableFuture firstRecord = null;
                        for (LogSegmentMetadata ledger : (List)ledgerList.getValue()) {
                            if (ledger.isTruncated() || ledger.getRecordCount() <= 0 && !ledger.isInProgress()) continue;
                            firstRecord = BKLogHandler.this.asyncReadFirstUserRecord(ledger, DLSN.InitialDLSN);
                            break;
                        }
                        if (null != firstRecord) {
                            FutureUtils.proxyTo(firstRecord, (CompletableFuture)promise);
                        } else {
                            promise.completeExceptionally((Throwable)new LogEmptyException("Log " + BKLogHandler.this.getFullyQualifiedName() + " has no records"));
                        }
                    }

                    public void onFailure(Throwable cause) {
                        promise.completeExceptionally(cause);
                    }
                });
            }

            public void onFailure(Throwable cause) {
                promise.completeExceptionally(cause);
            }
        });
        return promise;
    }

    public CompletableFuture<LogRecordWithDLSN> getLastLogRecordAsync(final boolean recover, final boolean includeEndOfStream) {
        final CompletableFuture<LogRecordWithDLSN> promise = new CompletableFuture<LogRecordWithDLSN>();
        this.streamMetadataStore.logExists(this.logMetadata.getUri(), this.logMetadata.getLogName()).whenComplete((BiConsumer)new FutureEventListener<Void>(){

            public void onSuccess(Void value) {
                BKLogHandler.this.readLogSegmentsFromStore(LogSegmentMetadata.DESC_COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null).whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

                    public void onSuccess(Versioned<List<LogSegmentMetadata>> ledgerList) {
                        if (((List)ledgerList.getValue()).isEmpty()) {
                            promise.completeExceptionally((Throwable)new LogEmptyException("Log " + BKLogHandler.this.getFullyQualifiedName() + " has no records"));
                            return;
                        }
                        BKLogHandler.this.asyncGetLastLogRecord(((List)ledgerList.getValue()).iterator(), promise, recover, false, includeEndOfStream);
                    }

                    public void onFailure(Throwable cause) {
                        promise.completeExceptionally(cause);
                    }
                });
            }

            public void onFailure(Throwable cause) {
                promise.completeExceptionally(cause);
            }
        });
        return promise;
    }

    private void asyncGetLastLogRecord(final Iterator<LogSegmentMetadata> ledgerIter, final CompletableFuture<LogRecordWithDLSN> promise, final boolean fence, final boolean includeControlRecord, final boolean includeEndOfStream) {
        if (ledgerIter.hasNext()) {
            LogSegmentMetadata metadata = ledgerIter.next();
            this.asyncReadLastRecord(metadata, fence, includeControlRecord, includeEndOfStream).whenComplete((BiConsumer)new FutureEventListener<LogRecordWithDLSN>(){

                public void onSuccess(LogRecordWithDLSN record) {
                    if (null == record) {
                        BKLogHandler.this.asyncGetLastLogRecord(ledgerIter, promise, fence, includeControlRecord, includeEndOfStream);
                    } else {
                        promise.complete(record);
                    }
                }

                public void onFailure(Throwable cause) {
                    promise.completeExceptionally(cause);
                }
            });
        } else {
            promise.completeExceptionally((Throwable)new LogEmptyException("Log " + this.getFullyQualifiedName() + " has no records"));
        }
    }

    private CompletableFuture<LogRecordWithDLSN> asyncReadFirstUserRecord(LogSegmentMetadata ledger, DLSN beginDLSN) {
        return ReadUtils.asyncReadFirstUserRecord(this.getFullyQualifiedName(), ledger, this.firstNumEntriesPerReadLastRecordScan, this.maxNumEntriesPerReadLastRecordScan, new AtomicInteger(0), (ExecutorService)this.scheduler, this.entryStore, beginDLSN);
    }

    private CompletableFuture<Long> asyncGetLogRecordCount(LogSegmentMetadata ledger, DLSN beginDLSN, long endPosition) {
        return this.asyncReadFirstUserRecord(ledger, beginDLSN).thenApply(beginRecord -> {
            long recordCount = 0L;
            if (null != beginRecord) {
                recordCount = endPosition + 1L - (long)beginRecord.getLastPositionWithinLogSegment();
            }
            return recordCount;
        });
    }

    private CompletableFuture<Long> asyncGetLogRecordCount(LogSegmentMetadata ledger, DLSN beginDLSN) {
        if (ledger.isInProgress() && ledger.isDLSNinThisSegment(beginDLSN)) {
            return this.asyncReadLastUserRecord(ledger).thenCompose(endRecord -> {
                if (null != endRecord) {
                    return this.asyncGetLogRecordCount(ledger, beginDLSN, endRecord.getLastPositionWithinLogSegment());
                }
                return FutureUtils.value((Object)0L);
            });
        }
        if (ledger.isInProgress()) {
            return this.asyncReadLastUserRecord(ledger).thenApply(endRecord -> {
                if (null != endRecord) {
                    return endRecord.getLastPositionWithinLogSegment();
                }
                return 0L;
            });
        }
        if (ledger.isDLSNinThisSegment(beginDLSN)) {
            return this.asyncGetLogRecordCount(ledger, beginDLSN, ledger.getRecordCount());
        }
        return FutureUtils.value((Object)ledger.getRecordCount());
    }

    public CompletableFuture<Long> asyncGetLogRecordCount(final DLSN beginDLSN) {
        return this.streamMetadataStore.logExists(this.logMetadata.getUri(), this.logMetadata.getLogName()).thenCompose(new Function<Void, CompletableFuture<Long>>(){

            @Override
            public CompletableFuture<Long> apply(Void done) {
                return BKLogHandler.this.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null).thenCompose(new Function<Versioned<List<LogSegmentMetadata>>, CompletableFuture<Long>>(){

                    @Override
                    public CompletableFuture<Long> apply(Versioned<List<LogSegmentMetadata>> ledgerList) {
                        ArrayList futureCounts = Lists.newArrayListWithExpectedSize((int)((List)ledgerList.getValue()).size());
                        for (LogSegmentMetadata ledger : (List)ledgerList.getValue()) {
                            if (ledger.getLogSegmentSequenceNumber() < beginDLSN.getLogSegmentSequenceNo()) continue;
                            futureCounts.add(BKLogHandler.this.asyncGetLogRecordCount(ledger, beginDLSN));
                        }
                        return FutureUtils.collect((List)futureCounts).thenApply(counts -> BKLogHandler.this.sum(counts));
                    }
                });
            }
        });
    }

    private Long sum(List<Long> values) {
        long sum = 0L;
        for (Long value : values) {
            sum += value.longValue();
        }
        return sum;
    }

    public CompletableFuture<Void> asyncAbort() {
        return this.asyncClose();
    }

    public CompletableFuture<LogRecordWithDLSN> asyncReadLastUserRecord(LogSegmentMetadata l) {
        return this.asyncReadLastRecord(l, false, false, false);
    }

    public CompletableFuture<LogRecordWithDLSN> asyncReadLastRecord(LogSegmentMetadata l, boolean fence, boolean includeControl, boolean includeEndOfStream) {
        final AtomicInteger numRecordsScanned = new AtomicInteger(0);
        final Stopwatch stopwatch = Stopwatch.createStarted();
        return ReadUtils.asyncReadLastRecord(this.getFullyQualifiedName(), l, fence, includeControl, includeEndOfStream, this.firstNumEntriesPerReadLastRecordScan, this.maxNumEntriesPerReadLastRecordScan, numRecordsScanned, (ExecutorService)this.scheduler, this.entryStore).whenComplete((BiConsumer)new FutureEventListener<LogRecordWithDLSN>(){

            public void onSuccess(LogRecordWithDLSN value) {
                BKLogHandler.this.recoverLastEntryStats.registerSuccessfulEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                BKLogHandler.this.recoverScannedEntriesStats.registerSuccessfulValue((long)numRecordsScanned.get());
            }

            public void onFailure(Throwable cause) {
                BKLogHandler.this.recoverLastEntryStats.registerFailedEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        });
    }

    protected void setLastLedgerRollingTimeMillis(long rollingTimeMillis) {
        if (this.lastLedgerRollingTimeMillis < rollingTimeMillis) {
            this.lastLedgerRollingTimeMillis = rollingTimeMillis;
        }
    }

    public String getFullyQualifiedName() {
        return this.logMetadata.getFullyQualifiedName();
    }

    protected List<LogSegmentMetadata> getCachedLogSegments(Comparator<LogSegmentMetadata> comparator) throws UnexpectedException {
        try {
            return this.logSegmentCache.getLogSegments(comparator);
        }
        catch (UnexpectedException ue) {
            LOG.error("Unexpected exception on getting log segments from the cache for stream {}", (Object)this.getFullyQualifiedName(), (Object)ue);
            METADATA_EXCEPTION_UPDATER.compareAndSet(this, null, (IOException)((Object)ue));
            throw ue;
        }
    }

    protected void addLogSegmentToCache(String name, LogSegmentMetadata metadata) {
        this.metadataCache.put(metadata.getZkPath(), metadata);
        this.logSegmentCache.add(name, metadata);
        if (!metadata.isInProgress() && this.lastLedgerRollingTimeMillis < metadata.getCompletionTime()) {
            this.lastLedgerRollingTimeMillis = metadata.getCompletionTime();
        }
        if (this.reportGetSegmentStats) {
            long ts = System.currentTimeMillis();
            if (metadata.isInProgress()) {
                long elapsedMillis = ts - metadata.getFirstTxId();
                long elapsedMicroSec = TimeUnit.MILLISECONDS.toMicros(elapsedMillis);
                if (elapsedMicroSec > 0L) {
                    if (elapsedMillis > this.metadataLatencyWarnThresholdMillis) {
                        LOG.warn("{} received inprogress log segment in {} millis: {}", new Object[]{this.getFullyQualifiedName(), elapsedMillis, metadata});
                    }
                    this.getInprogressSegmentStat.registerSuccessfulEvent(elapsedMicroSec, TimeUnit.MICROSECONDS);
                } else {
                    this.negativeGetInprogressSegmentStat.registerSuccessfulEvent(-elapsedMicroSec, TimeUnit.MICROSECONDS);
                }
            } else {
                long elapsedMillis = ts - metadata.getCompletionTime();
                long elapsedMicroSec = TimeUnit.MILLISECONDS.toMicros(elapsedMillis);
                if (elapsedMicroSec > 0L) {
                    if (elapsedMillis > this.metadataLatencyWarnThresholdMillis) {
                        LOG.warn("{} received completed log segment in {} millis : {}", new Object[]{this.getFullyQualifiedName(), elapsedMillis, metadata});
                    }
                    this.getCompletedSegmentStat.registerSuccessfulEvent(elapsedMicroSec, TimeUnit.MICROSECONDS);
                } else {
                    this.negativeGetCompletedSegmentStat.registerSuccessfulEvent(-elapsedMicroSec, TimeUnit.MICROSECONDS);
                }
            }
        }
    }

    protected LogSegmentMetadata readLogSegmentFromCache(String name) {
        return this.logSegmentCache.get(name);
    }

    protected LogSegmentMetadata removeLogSegmentFromCache(String name) {
        this.metadataCache.invalidate(name);
        return this.logSegmentCache.remove(name);
    }

    protected void updateLogSegmentCache(Set<String> logSegmentsRemoved, Map<String, LogSegmentMetadata> logSegmentsAdded) {
        for (String string : logSegmentsRemoved) {
            this.metadataCache.invalidate(string);
        }
        for (Map.Entry entry : logSegmentsAdded.entrySet()) {
            this.metadataCache.put((String)entry.getKey(), (LogSegmentMetadata)entry.getValue());
        }
        this.logSegmentCache.update(logSegmentsRemoved, logSegmentsAdded);
    }

    public CompletableFuture<Versioned<List<LogSegmentMetadata>>> readLogSegmentsFromStore(final Comparator<LogSegmentMetadata> comparator, final LogSegmentFilter segmentFilter, LogSegmentNamesListener logSegmentNamesListener) {
        final CompletableFuture<Versioned<List<LogSegmentMetadata>>> readResult = new CompletableFuture<Versioned<List<LogSegmentMetadata>>>();
        this.metadataStore.getLogSegmentNames(this.logMetadata.getLogSegmentsPath(), logSegmentNamesListener).whenComplete((BiConsumer)new FutureEventListener<Versioned<List<String>>>(){

            public void onFailure(Throwable cause) {
                readResult.completeExceptionally(cause);
            }

            public void onSuccess(Versioned<List<String>> logSegmentNames) {
                BKLogHandler.this.readLogSegmentsFromStore(logSegmentNames, comparator, segmentFilter, readResult);
            }
        });
        return readResult;
    }

    protected void readLogSegmentsFromStore(final Versioned<List<String>> logSegmentNames, final Comparator<LogSegmentMetadata> comparator, LogSegmentFilter segmentFilter, final CompletableFuture<Versioned<List<LogSegmentMetadata>>> readResult) {
        HashSet<String> segmentsReceived = new HashSet<String>();
        segmentsReceived.addAll(segmentFilter.filter((Collection)logSegmentNames.getValue()));
        final Set<String> removedSegments = Collections.synchronizedSet(new HashSet());
        final Map<String, LogSegmentMetadata> addedSegments = Collections.synchronizedMap(new HashMap());
        Pair<Set<String>, Set<String>> segmentChanges = this.logSegmentCache.diff(segmentsReceived);
        Set segmentsAdded = (Set)segmentChanges.getLeft();
        removedSegments.addAll((Collection)segmentChanges.getRight());
        if (segmentsAdded.isEmpty()) {
            List<LogSegmentMetadata> segmentList;
            if (LOG.isTraceEnabled()) {
                LOG.trace("No segments added for {}.", (Object)this.getFullyQualifiedName());
            }
            this.updateLogSegmentCache(removedSegments, addedSegments);
            try {
                segmentList = this.getCachedLogSegments(comparator);
            }
            catch (UnexpectedException e) {
                readResult.completeExceptionally(e);
                return;
            }
            readResult.complete((Versioned<List<LogSegmentMetadata>>)new Versioned(segmentList, logSegmentNames.getVersion()));
            return;
        }
        final AtomicInteger numChildren = new AtomicInteger(segmentsAdded.size());
        final AtomicInteger numFailures = new AtomicInteger(0);
        for (final String segment : segmentsAdded) {
            String logSegmentPath = this.logMetadata.getLogSegmentPath(segment);
            LogSegmentMetadata cachedSegment = this.metadataCache.get(logSegmentPath);
            if (null != cachedSegment) {
                addedSegments.put(segment, cachedSegment);
                this.completeReadLogSegmentsFromStore(removedSegments, addedSegments, comparator, readResult, logSegmentNames.getVersion(), numChildren, numFailures);
                continue;
            }
            this.metadataStore.getLogSegment(logSegmentPath).whenComplete((BiConsumer)new FutureEventListener<LogSegmentMetadata>(){

                public void onSuccess(LogSegmentMetadata result) {
                    addedSegments.put(segment, result);
                    this.complete();
                }

                public void onFailure(Throwable cause) {
                    if (cause instanceof LogSegmentNotFoundException) {
                        removedSegments.add(segment);
                        this.complete();
                    } else if (1 == numFailures.incrementAndGet()) {
                        readResult.completeExceptionally(cause);
                        return;
                    }
                }

                private void complete() {
                    BKLogHandler.this.completeReadLogSegmentsFromStore(removedSegments, addedSegments, comparator, readResult, logSegmentNames.getVersion(), numChildren, numFailures);
                }
            });
        }
    }

    private void completeReadLogSegmentsFromStore(Set<String> removedSegments, Map<String, LogSegmentMetadata> addedSegments, Comparator<LogSegmentMetadata> comparator, CompletableFuture<Versioned<List<LogSegmentMetadata>>> readResult, Version logSegmentNamesVersion, AtomicInteger numChildren, AtomicInteger numFailures) {
        List<LogSegmentMetadata> segmentList;
        if (0 != numChildren.decrementAndGet()) {
            return;
        }
        if (numFailures.get() > 0) {
            return;
        }
        this.updateLogSegmentCache(removedSegments, addedSegments);
        try {
            segmentList = this.getCachedLogSegments(comparator);
        }
        catch (UnexpectedException e) {
            readResult.completeExceptionally(e);
            return;
        }
        readResult.complete((Versioned<List<LogSegmentMetadata>>)new Versioned(segmentList, logSegmentNamesVersion));
    }
}

