/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.cookie;

import java.io.PrintStream;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.tools.cli.commands.cookie.CookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCookieCommand
extends CookieCommand<Flags> {
    private static final Logger log = LoggerFactory.getLogger(GetCookieCommand.class);
    private static final String NAME = "get";
    private static final String DESC = "Retrieve a cookie for a given bookie";

    public GetCookieCommand() {
        this(new Flags());
    }

    GetCookieCommand(PrintStream console) {
        this(new Flags(), console);
    }

    public GetCookieCommand(Flags flags) {
        this(flags, System.out);
    }

    private GetCookieCommand(Flags flags, PrintStream console) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).withConsole(console).withArgumentsUsage("<bookie-id>").build());
    }

    @Override
    protected void apply(RegistrationManager rm, Flags cmdFlags) throws Exception {
        String bookieId = this.getBookieId(cmdFlags);
        try {
            Versioned<Cookie> cookie = Cookie.readFromRegistrationManager(rm, new BookieSocketAddress(bookieId));
            this.spec.console().println("Cookie for bookie '" + bookieId + "' is:");
            this.spec.console().println("---");
            this.spec.console().println(cookie.getValue());
            this.spec.console().println("---");
        }
        catch (BookieException.CookieNotFoundException cee) {
            this.spec.console().println("Cookie not found for bookie '" + bookieId + "'");
            throw cee;
        }
        catch (BookieException be) {
            this.spec.console().println("Exception on getting cookie for bookie '" + bookieId + "'");
            be.printStackTrace(this.spec.console());
            throw be;
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

