/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.fast_hdfs_resource;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ambari.fast_hdfs_resource.Resource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class Runner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, URISyntaxException {
        String jsonFilePath;
        File file;
        if (args.length != 1) {
            System.err.println("Incorrect number of arguments. Please provide:\n1) Path to json file\nExiting...");
            System.exit(1);
        }
        if (!(file = new File(jsonFilePath = args[0])).isFile()) {
            System.err.println("File " + jsonFilePath + " doesn't exist.\nExiting...");
            System.exit(1);
        }
        Gson gson = new Gson();
        Resource[] resources = null;
        HashMap<String, FileSystem> fileSystemNameToInstance = new HashMap<String, FileSystem>();
        HashMap fileSystemToResource = new HashMap();
        try {
            resources = gson.fromJson((Reader)new FileReader(jsonFilePath), Resource[].class);
            Configuration conf = new Configuration();
            FileSystem dfs = null;
            for (Resource resource : resources) {
                String nameservice = resource.getNameservice();
                if (!fileSystemNameToInstance.containsKey(nameservice)) {
                    URI fileSystemUrl = nameservice == null ? FileSystem.getDefaultUri(conf) : new URI(nameservice);
                    dfs = FileSystem.get(fileSystemUrl, conf);
                    System.out.println("Initializing filesystem uri: " + fileSystemUrl);
                    dfs.initialize(fileSystemUrl, conf);
                    fileSystemNameToInstance.put(nameservice, dfs);
                }
                if (!fileSystemToResource.containsKey(nameservice)) {
                    fileSystemToResource.put(nameservice, new ArrayList());
                }
                ((List)fileSystemToResource.get(nameservice)).add(resource);
            }
            for (Map.Entry entry : fileSystemToResource.entrySet()) {
                String nameservice = (String)entry.getKey();
                List resourcesNameservice = (List)entry.getValue();
                for (Resource resource : resourcesNameservice) {
                    if (nameservice != null) {
                        System.out.println("Creating: " + resource + " in " + nameservice);
                    } else {
                        System.out.println("Creating: " + resource + " in default filesystem");
                    }
                    dfs = (FileSystem)fileSystemNameToInstance.get(nameservice);
                    Resource.checkResourceParameters(resource, dfs);
                    Path pathHadoop = null;
                    if (resource.getAction().equals("download")) {
                        pathHadoop = new Path(resource.getSource());
                    } else {
                        String path = resource.getTarget();
                        pathHadoop = new Path(path);
                        if (!resource.isManageIfExists() && dfs.exists(pathHadoop)) {
                            System.out.println(String.format("Skipping the operation for not managed DFS directory %s  since immutable_paths contains it.", path));
                            continue;
                        }
                    }
                    if (resource.getAction().equals("create")) {
                        Resource.createResource(resource, dfs, pathHadoop);
                        Resource.setMode(resource, dfs, pathHadoop);
                        Resource.setOwner(resource, dfs, pathHadoop);
                        continue;
                    }
                    if (resource.getAction().equals("delete")) {
                        dfs.delete(pathHadoop, true);
                        continue;
                    }
                    if (!resource.getAction().equals("download")) continue;
                    dfs.copyToLocalFile(pathHadoop, new Path(resource.getTarget()));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception occurred, Reason: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            for (FileSystem dfs : fileSystemNameToInstance.values()) {
                dfs.close();
            }
        }
        System.out.println("All resources created.");
    }
}

