//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Protocol Buffers describing the Runner API, which is the runner-independent,
// SDK-independent definition of the Beam model.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.17.3
// source: beam_runner_api.proto

package pipeline_v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BeamConstants_Constants int32

const (
	// All timestamps of elements or window boundaries must be within
	// the interval [MIN_TIMESTAMP_MILLIS, MAX_TIMESTAMP_MILLIS].
	// The smallest representable timestamp of an element or a window boundary.
	BeamConstants_MIN_TIMESTAMP_MILLIS BeamConstants_Constants = 0
	// The largest representable timestamp of an element or a window boundary.
	BeamConstants_MAX_TIMESTAMP_MILLIS BeamConstants_Constants = 1
	// The maximum timestamp for the global window.
	// Triggers use max timestamp to set timers' timestamp. Timers fire when
	// the watermark passes their timestamps. So, the timestamp needs to be
	// smaller than the MAX_TIMESTAMP_MILLIS.
	// One standard day is subtracted from MAX_TIMESTAMP_MILLIS to make sure
	// the max timestamp is smaller than MAX_TIMESTAMP_MILLIS even after rounding up
	// to seconds or minutes.
	BeamConstants_GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS BeamConstants_Constants = 2
)

// Enum value maps for BeamConstants_Constants.
var (
	BeamConstants_Constants_name = map[int32]string{
		0: "MIN_TIMESTAMP_MILLIS",
		1: "MAX_TIMESTAMP_MILLIS",
		2: "GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS",
	}
	BeamConstants_Constants_value = map[string]int32{
		"MIN_TIMESTAMP_MILLIS":               0,
		"MAX_TIMESTAMP_MILLIS":               1,
		"GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS": 2,
	}
)

func (x BeamConstants_Constants) Enum() *BeamConstants_Constants {
	p := new(BeamConstants_Constants)
	*p = x
	return p
}

func (x BeamConstants_Constants) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BeamConstants_Constants) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[0].Descriptor()
}

func (BeamConstants_Constants) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[0]
}

func (x BeamConstants_Constants) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BeamConstants_Constants.Descriptor instead.
func (BeamConstants_Constants) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{0, 0}
}

// Primitive transforms may not specify composite sub-transforms.
type StandardPTransforms_Primitives int32

const (
	// ParDo is a Beam transform for generic parallel processing. The ParDo
	// processing paradigm is similar to the “Map” phase of a
	// Map/Shuffle/Reduce-style algorithm: a ParDo transform considers each
	// element in the input PCollection, performs some processing function
	// (your user code) on that element, and emits zero, one, or multiple
	// elements to an output PCollection.
	//
	// See https://beam.apache.org/documentation/programming-guide/#pardo
	// for additional details.
	//
	// Payload: ParDoPayload
	StandardPTransforms_PAR_DO StandardPTransforms_Primitives = 0
	// Flatten is a Beam transform for PCollection objects that store the same
	// data type. Flatten merges multiple PCollection objects into a single
	// logical PCollection.
	//
	// See https://beam.apache.org/documentation/programming-guide/#flatten
	// for additional details.
	//
	// Payload: None
	StandardPTransforms_FLATTEN StandardPTransforms_Primitives = 1
	// GroupByKey is a Beam transform for processing collections of key/value
	// pairs. It’s a parallel reduction operation, analogous to the Shuffle
	// phase of a Map/Shuffle/Reduce-style algorithm. The input to GroupByKey is
	// a collection of key/value pairs that represents a multimap, where the
	// collection contains multiple pairs that have the same key, but different
	// values. Given such a collection, you use GroupByKey to collect all of the
	// values associated with each unique key.
	//
	// See https://beam.apache.org/documentation/programming-guide/#groupbykey
	// for additional details.
	//
	// Never defines an environment as the runner is required to implement this
	// transform.
	//
	// Payload: None
	StandardPTransforms_GROUP_BY_KEY StandardPTransforms_Primitives = 2
	// A transform which produces a single empty byte array at the minimum
	// timestamp in the GlobalWindow.
	//
	// Never defines an environment as the runner is required to implement this
	// transform.
	//
	// Payload: None
	StandardPTransforms_IMPULSE StandardPTransforms_Primitives = 3
	// Windowing subdivides a PCollection according to the timestamps of its
	// individual elements. Transforms that aggregate multiple elements, such as
	// GroupByKey and Combine, work implicitly on a per-window basis — they
	// process each PCollection as a succession of multiple, finite windows,
	// though the entire collection itself may be of unbounded size.
	//
	// See https://beam.apache.org/documentation/programming-guide/#windowing
	// for additional details.
	//
	// Payload: WindowIntoPayload
	StandardPTransforms_ASSIGN_WINDOWS StandardPTransforms_Primitives = 4
	// A testing input that generates an unbounded {@link PCollection} of
	// elements, advancing the watermark and processing time as elements are
	// emitted. After all of the specified elements are emitted, ceases to
	// produce output.
	//
	// See https://beam.apache.org/blog/2016/10/20/test-stream.html
	// for additional details.
	//
	// Payload: TestStreamPayload
	StandardPTransforms_TEST_STREAM StandardPTransforms_Primitives = 5
	// Represents mapping of main input window onto side input window.
	//
	// Side input window mapping function:
	// Input: KV<nonce, MainInputWindow>
	// Output: KV<nonce, SideInputWindow>
	//
	// For each main input window, the side input window is returned. The
	// nonce is used by a runner to associate each input with its output.
	// The nonce is represented as an opaque set of bytes.
	//
	// Payload: SideInput#window_mapping_fn FunctionSpec
	StandardPTransforms_MAP_WINDOWS StandardPTransforms_Primitives = 6
	// Used to merge windows during a GroupByKey.
	//
	// Window merging function:
	// Input: KV<nonce, iterable<OriginalWindow>>
	// Output: KV<nonce, KV<iterable<UnmergedOriginalWindow>, iterable<KV<MergedWindow, iterable<ConsumedOriginalWindow>>>>
	//
	// For each set of original windows, a list of all unmerged windows is
	// output alongside a map of merged window to set of consumed windows.
	// All original windows must be contained in either the unmerged original
	// window set or one of the consumed original window sets. Each original
	// window can only be part of one output set. The nonce is used by a runner
	// to associate each input with its output. The nonce is represented as an
	// opaque set of bytes.
	//
	// Payload: WindowingStrategy#window_fn FunctionSpec
	StandardPTransforms_MERGE_WINDOWS StandardPTransforms_Primitives = 7
	// A transform that translates a given element to its human-readable
	// representation.
	//
	// Input: KV<nonce, element>
	// Output: KV<nonce, string>
	//
	// For each given element, the implementation returns the best-effort
	// human-readable representation. When possible, the implementation could
	// call a user-overridable method on the type. For example, Java could
	// call `toString()`, Python could call `str()`, Golang could call
	// `String()`.  The nonce is used by a runner to associate each input with
	// its output. The nonce is represented as an opaque set of bytes.
	//
	// Payload: none
	StandardPTransforms_TO_STRING StandardPTransforms_Primitives = 8
)

// Enum value maps for StandardPTransforms_Primitives.
var (
	StandardPTransforms_Primitives_name = map[int32]string{
		0: "PAR_DO",
		1: "FLATTEN",
		2: "GROUP_BY_KEY",
		3: "IMPULSE",
		4: "ASSIGN_WINDOWS",
		5: "TEST_STREAM",
		6: "MAP_WINDOWS",
		7: "MERGE_WINDOWS",
		8: "TO_STRING",
	}
	StandardPTransforms_Primitives_value = map[string]int32{
		"PAR_DO":         0,
		"FLATTEN":        1,
		"GROUP_BY_KEY":   2,
		"IMPULSE":        3,
		"ASSIGN_WINDOWS": 4,
		"TEST_STREAM":    5,
		"MAP_WINDOWS":    6,
		"MERGE_WINDOWS":  7,
		"TO_STRING":      8,
	}
)

func (x StandardPTransforms_Primitives) Enum() *StandardPTransforms_Primitives {
	p := new(StandardPTransforms_Primitives)
	*p = x
	return p
}

func (x StandardPTransforms_Primitives) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardPTransforms_Primitives) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[1].Descriptor()
}

func (StandardPTransforms_Primitives) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[1]
}

func (x StandardPTransforms_Primitives) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardPTransforms_Primitives.Descriptor instead.
func (StandardPTransforms_Primitives) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{4, 0}
}

type StandardPTransforms_DeprecatedPrimitives int32

const (
	// Represents the operation to read a Bounded or Unbounded source.
	// Payload: ReadPayload.
	StandardPTransforms_READ StandardPTransforms_DeprecatedPrimitives = 0
	// Runners should move away from translating `CreatePCollectionView` and treat this as
	// part of the translation for a `ParDo` side input.
	StandardPTransforms_CREATE_VIEW StandardPTransforms_DeprecatedPrimitives = 1
)

// Enum value maps for StandardPTransforms_DeprecatedPrimitives.
var (
	StandardPTransforms_DeprecatedPrimitives_name = map[int32]string{
		0: "READ",
		1: "CREATE_VIEW",
	}
	StandardPTransforms_DeprecatedPrimitives_value = map[string]int32{
		"READ":        0,
		"CREATE_VIEW": 1,
	}
)

func (x StandardPTransforms_DeprecatedPrimitives) Enum() *StandardPTransforms_DeprecatedPrimitives {
	p := new(StandardPTransforms_DeprecatedPrimitives)
	*p = x
	return p
}

func (x StandardPTransforms_DeprecatedPrimitives) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardPTransforms_DeprecatedPrimitives) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[2].Descriptor()
}

func (StandardPTransforms_DeprecatedPrimitives) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[2]
}

func (x StandardPTransforms_DeprecatedPrimitives) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardPTransforms_DeprecatedPrimitives.Descriptor instead.
func (StandardPTransforms_DeprecatedPrimitives) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{4, 1}
}

type StandardPTransforms_Composites int32

const (
	// Represents the Combine.perKey() operation.
	// If this is produced by an SDK, it is assumed that the SDK understands
	// each of CombineComponents.
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY StandardPTransforms_Composites = 0
	// Represents the Combine.globally() operation.
	// If this is produced by an SDK, it is assumed that the SDK understands
	// each of CombineComponents.
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_GLOBALLY StandardPTransforms_Composites = 1
	// Represents the Reshuffle operation.
	StandardPTransforms_RESHUFFLE StandardPTransforms_Composites = 2
	// Less well-known. Payload: WriteFilesPayload.
	StandardPTransforms_WRITE_FILES StandardPTransforms_Composites = 3
	// Payload: PubSubReadPayload.
	StandardPTransforms_PUBSUB_READ StandardPTransforms_Composites = 4
	// Payload: PubSubWritePayload.
	StandardPTransforms_PUBSUB_WRITE StandardPTransforms_Composites = 5
	// Represents the GroupIntoBatches.WithShardedKey operation.
	// Payload: GroupIntoBatchesPayload
	StandardPTransforms_GROUP_INTO_BATCHES_WITH_SHARDED_KEY StandardPTransforms_Composites = 6
)

// Enum value maps for StandardPTransforms_Composites.
var (
	StandardPTransforms_Composites_name = map[int32]string{
		0: "COMBINE_PER_KEY",
		1: "COMBINE_GLOBALLY",
		2: "RESHUFFLE",
		3: "WRITE_FILES",
		4: "PUBSUB_READ",
		5: "PUBSUB_WRITE",
		6: "GROUP_INTO_BATCHES_WITH_SHARDED_KEY",
	}
	StandardPTransforms_Composites_value = map[string]int32{
		"COMBINE_PER_KEY":                     0,
		"COMBINE_GLOBALLY":                    1,
		"RESHUFFLE":                           2,
		"WRITE_FILES":                         3,
		"PUBSUB_READ":                         4,
		"PUBSUB_WRITE":                        5,
		"GROUP_INTO_BATCHES_WITH_SHARDED_KEY": 6,
	}
)

func (x StandardPTransforms_Composites) Enum() *StandardPTransforms_Composites {
	p := new(StandardPTransforms_Composites)
	*p = x
	return p
}

func (x StandardPTransforms_Composites) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardPTransforms_Composites) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[3].Descriptor()
}

func (StandardPTransforms_Composites) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[3]
}

func (x StandardPTransforms_Composites) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardPTransforms_Composites.Descriptor instead.
func (StandardPTransforms_Composites) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{4, 2}
}

// Payload for all of these: CombinePayload
type StandardPTransforms_CombineComponents int32

const (
	// Represents the Pre-Combine part of a lifted Combine Per Key, as described
	// in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.ta0g6ase8z07
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_PRECOMBINE StandardPTransforms_CombineComponents = 0
	// Represents the Merge Accumulators part of a lifted Combine Per Key, as
	// described in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.jco9rvatld5m
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_MERGE_ACCUMULATORS StandardPTransforms_CombineComponents = 1
	// Represents the Extract Outputs part of a lifted Combine Per Key, as
	// described in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.i9i6p8gtl6ku
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_EXTRACT_OUTPUTS StandardPTransforms_CombineComponents = 2
	// Represents the Combine Grouped Values transform, as described in the
	// following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.aj86ew4v1wk
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_GROUPED_VALUES StandardPTransforms_CombineComponents = 3
	// Represents the Convert To Accumulators transform, as described in the
	// following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.h5697l1scd9x
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS StandardPTransforms_CombineComponents = 4
)

// Enum value maps for StandardPTransforms_CombineComponents.
var (
	StandardPTransforms_CombineComponents_name = map[int32]string{
		0: "COMBINE_PER_KEY_PRECOMBINE",
		1: "COMBINE_PER_KEY_MERGE_ACCUMULATORS",
		2: "COMBINE_PER_KEY_EXTRACT_OUTPUTS",
		3: "COMBINE_GROUPED_VALUES",
		4: "COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS",
	}
	StandardPTransforms_CombineComponents_value = map[string]int32{
		"COMBINE_PER_KEY_PRECOMBINE":              0,
		"COMBINE_PER_KEY_MERGE_ACCUMULATORS":      1,
		"COMBINE_PER_KEY_EXTRACT_OUTPUTS":         2,
		"COMBINE_GROUPED_VALUES":                  3,
		"COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS": 4,
	}
)

func (x StandardPTransforms_CombineComponents) Enum() *StandardPTransforms_CombineComponents {
	p := new(StandardPTransforms_CombineComponents)
	*p = x
	return p
}

func (x StandardPTransforms_CombineComponents) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardPTransforms_CombineComponents) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[4].Descriptor()
}

func (StandardPTransforms_CombineComponents) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[4]
}

func (x StandardPTransforms_CombineComponents) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardPTransforms_CombineComponents.Descriptor instead.
func (StandardPTransforms_CombineComponents) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{4, 3}
}

// Payload for all of these: ParDoPayload containing the user's SDF
type StandardPTransforms_SplittableParDoComponents int32

const (
	// Pairs the input element with its initial restriction.
	// Input: element; output: KV(element, restriction).
	StandardPTransforms_PAIR_WITH_RESTRICTION StandardPTransforms_SplittableParDoComponents = 0
	// Splits the restriction of each element/restriction pair and returns the
	// resulting splits, with a corresponding floating point size estimation
	// for each.
	//
	// A reasonable value for size is the number of bytes expected to be
	// produced by this (element, restriction) pair.
	//
	// Input: KV(element, restriction)
	// Output: KV(KV(element, restriction), size))
	StandardPTransforms_SPLIT_AND_SIZE_RESTRICTIONS StandardPTransforms_SplittableParDoComponents = 1
	// Applies the DoFn to every element and restriction.
	//
	// All primary and residuals returned from checkpointing or splitting must
	// have the same type as the input to this transform.
	//
	// Input: KV(KV(element, restriction), size); output: DoFn's output.
	StandardPTransforms_PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS StandardPTransforms_SplittableParDoComponents = 2
	// Truncates the restriction of each element/restriction pair and returns
	// the finite restriction which will be processed when a pipeline is
	// drained. See
	// https://docs.google.com/document/d/1NExwHlj-2q2WUGhSO4jTu8XGhDPmm3cllSN8IMmWci8/edit#.
	// for additional details about drain.
	//
	// Input: KV(KV(element, restriction), size);
	// Output: KV(KV(element, restriction), size).
	StandardPTransforms_TRUNCATE_SIZED_RESTRICTION StandardPTransforms_SplittableParDoComponents = 3
)

// Enum value maps for StandardPTransforms_SplittableParDoComponents.
var (
	StandardPTransforms_SplittableParDoComponents_name = map[int32]string{
		0: "PAIR_WITH_RESTRICTION",
		1: "SPLIT_AND_SIZE_RESTRICTIONS",
		2: "PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS",
		3: "TRUNCATE_SIZED_RESTRICTION",
	}
	StandardPTransforms_SplittableParDoComponents_value = map[string]int32{
		"PAIR_WITH_RESTRICTION":                   0,
		"SPLIT_AND_SIZE_RESTRICTIONS":             1,
		"PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS": 2,
		"TRUNCATE_SIZED_RESTRICTION":              3,
	}
)

func (x StandardPTransforms_SplittableParDoComponents) Enum() *StandardPTransforms_SplittableParDoComponents {
	p := new(StandardPTransforms_SplittableParDoComponents)
	*p = x
	return p
}

func (x StandardPTransforms_SplittableParDoComponents) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardPTransforms_SplittableParDoComponents) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[5].Descriptor()
}

func (StandardPTransforms_SplittableParDoComponents) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[5]
}

func (x StandardPTransforms_SplittableParDoComponents) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardPTransforms_SplittableParDoComponents.Descriptor instead.
func (StandardPTransforms_SplittableParDoComponents) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{4, 4}
}

// Payload for all of these: GroupIntoBatchesPayload
type StandardPTransforms_GroupIntoBatchesComponents int32

const (
	StandardPTransforms_GROUP_INTO_BATCHES StandardPTransforms_GroupIntoBatchesComponents = 0
)

// Enum value maps for StandardPTransforms_GroupIntoBatchesComponents.
var (
	StandardPTransforms_GroupIntoBatchesComponents_name = map[int32]string{
		0: "GROUP_INTO_BATCHES",
	}
	StandardPTransforms_GroupIntoBatchesComponents_value = map[string]int32{
		"GROUP_INTO_BATCHES": 0,
	}
)

func (x StandardPTransforms_GroupIntoBatchesComponents) Enum() *StandardPTransforms_GroupIntoBatchesComponents {
	p := new(StandardPTransforms_GroupIntoBatchesComponents)
	*p = x
	return p
}

func (x StandardPTransforms_GroupIntoBatchesComponents) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardPTransforms_GroupIntoBatchesComponents) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[6].Descriptor()
}

func (StandardPTransforms_GroupIntoBatchesComponents) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[6]
}

func (x StandardPTransforms_GroupIntoBatchesComponents) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardPTransforms_GroupIntoBatchesComponents.Descriptor instead.
func (StandardPTransforms_GroupIntoBatchesComponents) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{4, 5}
}

type StandardSideInputTypes_Enum int32

const (
	// Represents a view over a PCollection<V>.
	//
	// StateGetRequests performed on this side input must use
	// StateKey.IterableSideInput.
	StandardSideInputTypes_ITERABLE StandardSideInputTypes_Enum = 0
	// Represents a view over a PCollection<KV<K, V>>.
	//
	// StateGetRequests performed on this side input must use
	// StateKey.IterableSideInput or StateKey.MultimapSideInput.
	StandardSideInputTypes_MULTIMAP StandardSideInputTypes_Enum = 1
)

// Enum value maps for StandardSideInputTypes_Enum.
var (
	StandardSideInputTypes_Enum_name = map[int32]string{
		0: "ITERABLE",
		1: "MULTIMAP",
	}
	StandardSideInputTypes_Enum_value = map[string]int32{
		"ITERABLE": 0,
		"MULTIMAP": 1,
	}
)

func (x StandardSideInputTypes_Enum) Enum() *StandardSideInputTypes_Enum {
	p := new(StandardSideInputTypes_Enum)
	*p = x
	return p
}

func (x StandardSideInputTypes_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardSideInputTypes_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[7].Descriptor()
}

func (StandardSideInputTypes_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[7]
}

func (x StandardSideInputTypes_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardSideInputTypes_Enum.Descriptor instead.
func (StandardSideInputTypes_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{5, 0}
}

type IsBounded_Enum int32

const (
	IsBounded_UNSPECIFIED IsBounded_Enum = 0
	IsBounded_UNBOUNDED   IsBounded_Enum = 1
	IsBounded_BOUNDED     IsBounded_Enum = 2
)

// Enum value maps for IsBounded_Enum.
var (
	IsBounded_Enum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "UNBOUNDED",
		2: "BOUNDED",
	}
	IsBounded_Enum_value = map[string]int32{
		"UNSPECIFIED": 0,
		"UNBOUNDED":   1,
		"BOUNDED":     2,
	}
)

func (x IsBounded_Enum) Enum() *IsBounded_Enum {
	p := new(IsBounded_Enum)
	*p = x
	return p
}

func (x IsBounded_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IsBounded_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[8].Descriptor()
}

func (IsBounded_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[8]
}

func (x IsBounded_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IsBounded_Enum.Descriptor instead.
func (IsBounded_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{16, 0}
}

type StandardCoders_Enum int32

const (
	// Components: None
	StandardCoders_BYTES StandardCoders_Enum = 0
	// Components: None
	StandardCoders_STRING_UTF8 StandardCoders_Enum = 10
	// Components: The key and value coder, in that order.
	StandardCoders_KV StandardCoders_Enum = 1
	// Components: None
	StandardCoders_BOOL StandardCoders_Enum = 12
	// Variable length Encodes a 64-bit integer.
	// Components: None
	StandardCoders_VARINT StandardCoders_Enum = 2
	// Encodes the floating point value as a big-endian 64-bit integer
	// according to the IEEE 754 double format bit layout.
	// Components: None
	StandardCoders_DOUBLE StandardCoders_Enum = 11
	// Encodes an iterable of elements.
	//
	// The encoding for an iterable [e1...eN] of known length N is
	//
	//    fixed32(N)
	//    encode(e1) encode(e2) encode(e3) ... encode(eN)
	//
	// If the length is unknown, it is batched up into groups of size b1..bM
	// and encoded as
	//
	//     fixed32(-1)
	//     varInt64(b1) encode(e1) encode(e2) ... encode(e_b1)
	//     varInt64(b2) encode(e_(b1+1)) encode(e_(b1+2)) ... encode(e_(b1+b2))
	//     ...
	//     varInt64(bM) encode(e_(N-bM+1)) encode(e_(N-bM+2)) ... encode(eN)
	//     varInt64(0)
	//
	// Components: Coder for a single element.
	StandardCoders_ITERABLE StandardCoders_Enum = 3
	// Encodes a timer containing a user key, a dynamic timer tag, a clear bit,
	// a fire timestamp, a hold timestamp, the windows and the paneinfo.
	// The encoding is represented as:
	//   user key - user defined key, uses the component coder.
	//   dynamic timer tag - a string which identifies a timer.
	//   windows - uses component coders.
	//   clear bit - a boolean set for clearing the timer.
	//   fire timestamp - a big endian 8 byte integer representing millis-since-epoch.
	//     The encoded representation is shifted so that the byte representation of
	//     negative values are lexicographically ordered before the byte representation
	//     of positive values. This is typically done by subtracting -9223372036854775808
	//     from the value and encoding it as a signed big endian integer. Example values:
	//
	//     -9223372036854775808: 00 00 00 00 00 00 00 00
	//                     -255: 7F FF FF FF FF FF FF 01
	//                       -1: 7F FF FF FF FF FF FF FF
	//                        0: 80 00 00 00 00 00 00 00
	//                        1: 80 00 00 00 00 00 00 01
	//                      256: 80 00 00 00 00 00 01 00
	//      9223372036854775807: FF FF FF FF FF FF FF FF
	//   hold timestamp - similar to the fire timestamp.
	//   paneinfo - similar to the paneinfo of the windowed_value.
	// Components: Coder for the key and windows.
	StandardCoders_TIMER StandardCoders_Enum = 4
	// Components: None
	StandardCoders_INTERVAL_WINDOW StandardCoders_Enum = 5
	// Components: The coder to attach a length prefix to
	StandardCoders_LENGTH_PREFIX StandardCoders_Enum = 6
	// Components: None
	StandardCoders_GLOBAL_WINDOW StandardCoders_Enum = 7
	// Encodes an element, the windows it is in, the timestamp of the element,
	// and the pane of the element. The encoding is represented as:
	// timestamp windows pane element
	//   timestamp - A big endian 8 byte integer representing millis-since-epoch.
	//     The encoded representation is shifted so that the byte representation
	//     of negative values are lexicographically ordered before the byte
	//     representation of positive values. This is typically done by
	//     subtracting -9223372036854775808 from the value and encoding it as a
	//     signed big endian integer. Example values:
	//
	//     -9223372036854775808: 00 00 00 00 00 00 00 00
	//                     -255: 7F FF FF FF FF FF FF 01
	//                       -1: 7F FF FF FF FF FF FF FF
	//                        0: 80 00 00 00 00 00 00 00
	//                        1: 80 00 00 00 00 00 00 01
	//                      256: 80 00 00 00 00 00 01 00
	//      9223372036854775807: FF FF FF FF FF FF FF FF
	//
	//   windows - The windows are encoded using the beam:coder:iterable:v1
	//     format, where the windows are encoded using the supplied window
	//     coder.
	//
	//   pane - The first byte of the pane info determines which type of
	//     encoding is used, as well as the is_first, is_last, and timing
	//     fields. If this byte is bits [0 1 2 3 4 5 6 7], then:
	//     * bits [0 1 2 3] determine the encoding as follows:
	//         0000 - The entire pane info is encoded as a single byte.
	//                The is_first, is_last, and timing fields are encoded
	//                as below, and the index and non-speculative index are
	//                both zero (and hence are not encoded here).
	//         0001 - The pane info is encoded as this byte plus a single
	//                VarInt encoed integer representing the pane index. The
	//                non-speculative index can be derived as follows:
	//                  -1 if the pane is early, otherwise equal to index.
	//         0010 - The pane info is encoded as this byte plus two VarInt
	//                encoded integers representing the pane index and
	//                non-speculative index respectively.
	//     * bits [4 5] encode the timing as follows:
	//         00 - early
	//         01 - on time
	//         10 - late
	//         11 - unknown
	//     * bit 6 is 1 if this is the first pane, 0 otherwise.
	//     * bit 7 is 1 if this is the last pane, 0 otherwise.
	//
	//   element - The element incoded using the supplied element coder.
	//
	// Components: The element coder and the window coder, in that order.
	StandardCoders_WINDOWED_VALUE StandardCoders_Enum = 8
	// A windowed value coder with parameterized timestamp, windows and pane info.
	// Encodes an element with only the value of the windowed value.
	// Decodes the value and assigns the parameterized timestamp, windows and pane info to the
	// windowed value.
	// Components: The element coder and the window coder, in that order
	// The payload of this coder is an encoded windowed value using the
	// beam:coder:windowed_value:v1 coder parameterized by a beam:coder:bytes:v1
	// element coder and the window coder that this param_windowed_value coder uses.
	StandardCoders_PARAM_WINDOWED_VALUE StandardCoders_Enum = 14
	// Encodes an iterable of elements, some of which may be stored elsewhere.
	//
	// The encoding for a state-backed iterable is the same as that for
	// an iterable, but the final varInt64(0) terminating the set of batches
	// may instead be replaced by
	//
	//     varInt64(-1)
	//     varInt64(len(token))
	//     token
	//
	// where token is an opaque byte string that can be used to fetch the
	// remainder of the iterable (e.g. over the state API).
	//
	// Components: Coder for a single element.
	// Experimental.
	StandardCoders_STATE_BACKED_ITERABLE StandardCoders_Enum = 9
	// Encodes an arbitrary user defined window and its max timestamp (inclusive).
	// The encoding format is:
	//   maxTimestamp window
	//
	//   maxTimestamp - A big endian 8 byte integer representing millis-since-epoch.
	//     The encoded representation is shifted so that the byte representation
	//     of negative values are lexicographically ordered before the byte
	//     representation of positive values. This is typically done by
	//     subtracting -9223372036854775808 from the value and encoding it as a
	//     signed big endian integer. Example values:
	//
	//     -9223372036854775808: 00 00 00 00 00 00 00 00
	//                     -255: 7F FF FF FF FF FF FF 01
	//                       -1: 7F FF FF FF FF FF FF FF
	//                        0: 80 00 00 00 00 00 00 00
	//                        1: 80 00 00 00 00 00 00 01
	//                      256: 80 00 00 00 00 00 01 00
	//      9223372036854775807: FF FF FF FF FF FF FF FF
	//
	//   window - the window is encoded using the supplied window coder.
	//
	// Components: Coder for the custom window type.
	StandardCoders_CUSTOM_WINDOW StandardCoders_Enum = 16
	// Encodes a "row", an element with a known schema, defined by an
	// instance of Schema from schema.proto.
	//
	// A row is encoded as the concatenation of:
	//   - The number of attributes in the schema, encoded with
	//     beam:coder:varint:v1. This makes it possible to detect certain
	//     allowed schema changes (appending or removing columns) in
	//     long-running streaming pipelines.
	//   - A byte array representing a packed bitset indicating null fields (a
	//     1 indicating a null) encoded with beam:coder:bytes:v1. The unused
	//     bits in the last byte must be set to 0. If there are no nulls an
	//     empty byte array is encoded.
	//     The two-byte bitset (not including the lenghth-prefix) for the row
	//     [NULL, 0, 0, 0, NULL, 0, 0, NULL, 0, NULL] would be
	//     [0b10010001, 0b00000010]
	//   - An encoding for each non-null field, concatenated together.
	//
	// Schema types are mapped to coders as follows:
	//   AtomicType:
	//     BYTE:      not yet a standard coder (BEAM-7996)
	//     INT16:     not yet a standard coder (BEAM-7996)
	//     INT32:     beam:coder:varint:v1
	//     INT64:     beam:coder:varint:v1
	//     FLOAT:     not yet a standard coder (BEAM-7996)
	//     DOUBLE:    beam:coder:double:v1
	//     STRING:    beam:coder:string_utf8:v1
	//     BOOLEAN:   beam:coder:bool:v1
	//     BYTES:     beam:coder:bytes:v1
	//   ArrayType:   beam:coder:iterable:v1 (always has a known length)
	//   MapType:     not a standard coder, specification defined below.
	//   RowType:     beam:coder:row:v1
	//   LogicalType: Uses the coder for its representation.
	//
	// The MapType is encoded by:
	//   - An INT32 representing the size of the map (N)
	//   - Followed by N interleaved keys and values, encoded with their
	//     corresponding coder.
	//
	// Nullable types in container types (ArrayType, MapType) are encoded by:
	//   - A one byte null indicator, 0x00 for null values, or 0x01 for present
	//     values.
	//   - For present values the null indicator is followed by the value
	//     encoded with it's corresponding coder.
	//
	// Well known logical types:
	//   beam:logical_type:micros_instant:v1
	//   - Representation type: ROW<seconds: INT64, micros: INT64>
	//   - A timestamp without a timezone where seconds + micros represents the
	//     amount of time since the epoch.
	//
	// The payload for RowCoder is an instance of Schema.
	// Components: None
	// Experimental.
	StandardCoders_ROW StandardCoders_Enum = 13
	// Encodes a user key and a shard id which is an opaque byte string.
	//
	// The encoding for a sharded key consists of a shard id byte string and the
	// encoded user key in the following order:
	//
	//     - shard id using beam:coder:bytes:v1
	//     - encoded user key
	//
	// Examples:
	// user key with an empty shard id
	//     0x00
	//     encode(user_key)
	//
	// user key with a shard id taking up two bytes.
	//     0x02
	//     0x11 0x22
	//     encode(user_key)
	//
	// Components: the user key coder.
	// Experimental.
	StandardCoders_SHARDED_KEY StandardCoders_Enum = 15
)

// Enum value maps for StandardCoders_Enum.
var (
	StandardCoders_Enum_name = map[int32]string{
		0:  "BYTES",
		10: "STRING_UTF8",
		1:  "KV",
		12: "BOOL",
		2:  "VARINT",
		11: "DOUBLE",
		3:  "ITERABLE",
		4:  "TIMER",
		5:  "INTERVAL_WINDOW",
		6:  "LENGTH_PREFIX",
		7:  "GLOBAL_WINDOW",
		8:  "WINDOWED_VALUE",
		14: "PARAM_WINDOWED_VALUE",
		9:  "STATE_BACKED_ITERABLE",
		16: "CUSTOM_WINDOW",
		13: "ROW",
		15: "SHARDED_KEY",
	}
	StandardCoders_Enum_value = map[string]int32{
		"BYTES":                 0,
		"STRING_UTF8":           10,
		"KV":                    1,
		"BOOL":                  12,
		"VARINT":                2,
		"DOUBLE":                11,
		"ITERABLE":              3,
		"TIMER":                 4,
		"INTERVAL_WINDOW":       5,
		"LENGTH_PREFIX":         6,
		"GLOBAL_WINDOW":         7,
		"WINDOWED_VALUE":        8,
		"PARAM_WINDOWED_VALUE":  14,
		"STATE_BACKED_ITERABLE": 9,
		"CUSTOM_WINDOW":         16,
		"ROW":                   13,
		"SHARDED_KEY":           15,
	}
)

func (x StandardCoders_Enum) Enum() *StandardCoders_Enum {
	p := new(StandardCoders_Enum)
	*p = x
	return p
}

func (x StandardCoders_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardCoders_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[9].Descriptor()
}

func (StandardCoders_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[9]
}

func (x StandardCoders_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardCoders_Enum.Descriptor instead.
func (StandardCoders_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{27, 0}
}

type MergeStatus_Enum int32

const (
	MergeStatus_UNSPECIFIED MergeStatus_Enum = 0
	// The WindowFn does not require merging.
	// Examples: global window, FixedWindows, SlidingWindows
	MergeStatus_NON_MERGING MergeStatus_Enum = 1
	// The WindowFn is merging and the PCollection has not had merging
	// performed.
	// Example: Sessions prior to a GroupByKey
	MergeStatus_NEEDS_MERGE MergeStatus_Enum = 2
	// The WindowFn is merging and the PCollection has had merging occur
	// already.
	// Example: Sessions after a GroupByKey
	MergeStatus_ALREADY_MERGED MergeStatus_Enum = 3
)

// Enum value maps for MergeStatus_Enum.
var (
	MergeStatus_Enum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "NON_MERGING",
		2: "NEEDS_MERGE",
		3: "ALREADY_MERGED",
	}
	MergeStatus_Enum_value = map[string]int32{
		"UNSPECIFIED":    0,
		"NON_MERGING":    1,
		"NEEDS_MERGE":    2,
		"ALREADY_MERGED": 3,
	}
)

func (x MergeStatus_Enum) Enum() *MergeStatus_Enum {
	p := new(MergeStatus_Enum)
	*p = x
	return p
}

func (x MergeStatus_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MergeStatus_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[10].Descriptor()
}

func (MergeStatus_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[10]
}

func (x MergeStatus_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MergeStatus_Enum.Descriptor instead.
func (MergeStatus_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{29, 0}
}

type AccumulationMode_Enum int32

const (
	AccumulationMode_UNSPECIFIED AccumulationMode_Enum = 0
	// The aggregation is discarded when it is output
	AccumulationMode_DISCARDING AccumulationMode_Enum = 1
	// The aggregation is accumulated across outputs
	AccumulationMode_ACCUMULATING AccumulationMode_Enum = 2
	// The aggregation emits retractions when it is output
	AccumulationMode_RETRACTING AccumulationMode_Enum = 3
)

// Enum value maps for AccumulationMode_Enum.
var (
	AccumulationMode_Enum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "DISCARDING",
		2: "ACCUMULATING",
		3: "RETRACTING",
	}
	AccumulationMode_Enum_value = map[string]int32{
		"UNSPECIFIED":  0,
		"DISCARDING":   1,
		"ACCUMULATING": 2,
		"RETRACTING":   3,
	}
)

func (x AccumulationMode_Enum) Enum() *AccumulationMode_Enum {
	p := new(AccumulationMode_Enum)
	*p = x
	return p
}

func (x AccumulationMode_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccumulationMode_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[11].Descriptor()
}

func (AccumulationMode_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[11]
}

func (x AccumulationMode_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccumulationMode_Enum.Descriptor instead.
func (AccumulationMode_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{30, 0}
}

type ClosingBehavior_Enum int32

const (
	ClosingBehavior_UNSPECIFIED ClosingBehavior_Enum = 0
	// Emit output when a window expires, whether or not there has been
	// any new data since the last output.
	ClosingBehavior_EMIT_ALWAYS ClosingBehavior_Enum = 1
	// Only emit output when new data has arrives since the last output
	ClosingBehavior_EMIT_IF_NONEMPTY ClosingBehavior_Enum = 2
)

// Enum value maps for ClosingBehavior_Enum.
var (
	ClosingBehavior_Enum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "EMIT_ALWAYS",
		2: "EMIT_IF_NONEMPTY",
	}
	ClosingBehavior_Enum_value = map[string]int32{
		"UNSPECIFIED":      0,
		"EMIT_ALWAYS":      1,
		"EMIT_IF_NONEMPTY": 2,
	}
)

func (x ClosingBehavior_Enum) Enum() *ClosingBehavior_Enum {
	p := new(ClosingBehavior_Enum)
	*p = x
	return p
}

func (x ClosingBehavior_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClosingBehavior_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[12].Descriptor()
}

func (ClosingBehavior_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[12]
}

func (x ClosingBehavior_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClosingBehavior_Enum.Descriptor instead.
func (ClosingBehavior_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{31, 0}
}

type OnTimeBehavior_Enum int32

const (
	OnTimeBehavior_UNSPECIFIED OnTimeBehavior_Enum = 0
	// Always fire the on-time pane. Even if there is no new data since
	// the previous firing, an element will be produced.
	OnTimeBehavior_FIRE_ALWAYS OnTimeBehavior_Enum = 1
	// Only fire the on-time pane if there is new data since the previous firing.
	OnTimeBehavior_FIRE_IF_NONEMPTY OnTimeBehavior_Enum = 2
)

// Enum value maps for OnTimeBehavior_Enum.
var (
	OnTimeBehavior_Enum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "FIRE_ALWAYS",
		2: "FIRE_IF_NONEMPTY",
	}
	OnTimeBehavior_Enum_value = map[string]int32{
		"UNSPECIFIED":      0,
		"FIRE_ALWAYS":      1,
		"FIRE_IF_NONEMPTY": 2,
	}
)

func (x OnTimeBehavior_Enum) Enum() *OnTimeBehavior_Enum {
	p := new(OnTimeBehavior_Enum)
	*p = x
	return p
}

func (x OnTimeBehavior_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnTimeBehavior_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[13].Descriptor()
}

func (OnTimeBehavior_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[13]
}

func (x OnTimeBehavior_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnTimeBehavior_Enum.Descriptor instead.
func (OnTimeBehavior_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{32, 0}
}

type OutputTime_Enum int32

const (
	OutputTime_UNSPECIFIED OutputTime_Enum = 0
	// The output has the timestamp of the end of the window.
	OutputTime_END_OF_WINDOW OutputTime_Enum = 1
	// The output has the latest timestamp of the input elements since
	// the last output.
	OutputTime_LATEST_IN_PANE OutputTime_Enum = 2
	// The output has the earliest timestamp of the input elements since
	// the last output.
	OutputTime_EARLIEST_IN_PANE OutputTime_Enum = 3
)

// Enum value maps for OutputTime_Enum.
var (
	OutputTime_Enum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "END_OF_WINDOW",
		2: "LATEST_IN_PANE",
		3: "EARLIEST_IN_PANE",
	}
	OutputTime_Enum_value = map[string]int32{
		"UNSPECIFIED":      0,
		"END_OF_WINDOW":    1,
		"LATEST_IN_PANE":   2,
		"EARLIEST_IN_PANE": 3,
	}
)

func (x OutputTime_Enum) Enum() *OutputTime_Enum {
	p := new(OutputTime_Enum)
	*p = x
	return p
}

func (x OutputTime_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputTime_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[14].Descriptor()
}

func (OutputTime_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[14]
}

func (x OutputTime_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputTime_Enum.Descriptor instead.
func (OutputTime_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{33, 0}
}

type TimeDomain_Enum int32

const (
	TimeDomain_UNSPECIFIED TimeDomain_Enum = 0
	// Event time is time from the perspective of the data
	TimeDomain_EVENT_TIME TimeDomain_Enum = 1
	// Processing time is time from the perspective of the
	// execution of your pipeline
	TimeDomain_PROCESSING_TIME TimeDomain_Enum = 2
)

// Enum value maps for TimeDomain_Enum.
var (
	TimeDomain_Enum_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "EVENT_TIME",
		2: "PROCESSING_TIME",
	}
	TimeDomain_Enum_value = map[string]int32{
		"UNSPECIFIED":     0,
		"EVENT_TIME":      1,
		"PROCESSING_TIME": 2,
	}
)

func (x TimeDomain_Enum) Enum() *TimeDomain_Enum {
	p := new(TimeDomain_Enum)
	*p = x
	return p
}

func (x TimeDomain_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TimeDomain_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[15].Descriptor()
}

func (TimeDomain_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[15]
}

func (x TimeDomain_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TimeDomain_Enum.Descriptor instead.
func (TimeDomain_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{34, 0}
}

type StandardArtifacts_Types int32

const (
	// A URN for locally-accessible artifact files.
	// payload: ArtifactFilePayload
	StandardArtifacts_FILE StandardArtifacts_Types = 0
	// A URN for artifacts described by URLs.
	// payload: ArtifactUrlPayload
	StandardArtifacts_URL StandardArtifacts_Types = 1
	// A URN for artifacts embedded in ArtifactInformation proto.
	// payload: EmbeddedFilePayload.
	StandardArtifacts_EMBEDDED StandardArtifacts_Types = 2
	// A URN for Python artifacts hosted on PYPI.
	// payload: PypiPayload
	StandardArtifacts_PYPI StandardArtifacts_Types = 3
	// A URN for Java artifacts hosted on a Maven repository.
	// payload: MavenPayload
	StandardArtifacts_MAVEN StandardArtifacts_Types = 4
	// A URN for deferred artifacts.
	// payload: DeferredArtifactPayload
	StandardArtifacts_DEFERRED StandardArtifacts_Types = 5
)

// Enum value maps for StandardArtifacts_Types.
var (
	StandardArtifacts_Types_name = map[int32]string{
		0: "FILE",
		1: "URL",
		2: "EMBEDDED",
		3: "PYPI",
		4: "MAVEN",
		5: "DEFERRED",
	}
	StandardArtifacts_Types_value = map[string]int32{
		"FILE":     0,
		"URL":      1,
		"EMBEDDED": 2,
		"PYPI":     3,
		"MAVEN":    4,
		"DEFERRED": 5,
	}
)

func (x StandardArtifacts_Types) Enum() *StandardArtifacts_Types {
	p := new(StandardArtifacts_Types)
	*p = x
	return p
}

func (x StandardArtifacts_Types) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardArtifacts_Types) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[16].Descriptor()
}

func (StandardArtifacts_Types) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[16]
}

func (x StandardArtifacts_Types) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardArtifacts_Types.Descriptor instead.
func (StandardArtifacts_Types) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{38, 0}
}

type StandardArtifacts_Roles int32

const (
	// A URN for staging-to role.
	// payload: ArtifactStagingToRolePayload
	StandardArtifacts_STAGING_TO StandardArtifacts_Roles = 0
	// A URN for pip-requirements-file role.
	// payload: None
	StandardArtifacts_PIP_REQUIREMENTS_FILE StandardArtifacts_Roles = 1
)

// Enum value maps for StandardArtifacts_Roles.
var (
	StandardArtifacts_Roles_name = map[int32]string{
		0: "STAGING_TO",
		1: "PIP_REQUIREMENTS_FILE",
	}
	StandardArtifacts_Roles_value = map[string]int32{
		"STAGING_TO":            0,
		"PIP_REQUIREMENTS_FILE": 1,
	}
)

func (x StandardArtifacts_Roles) Enum() *StandardArtifacts_Roles {
	p := new(StandardArtifacts_Roles)
	*p = x
	return p
}

func (x StandardArtifacts_Roles) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardArtifacts_Roles) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[17].Descriptor()
}

func (StandardArtifacts_Roles) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[17]
}

func (x StandardArtifacts_Roles) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardArtifacts_Roles.Descriptor instead.
func (StandardArtifacts_Roles) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{38, 1}
}

type StandardEnvironments_Environments int32

const (
	StandardEnvironments_DOCKER   StandardEnvironments_Environments = 0 // A managed docker container to run user code.
	StandardEnvironments_PROCESS  StandardEnvironments_Environments = 1 // A managed native process to run user code.
	StandardEnvironments_EXTERNAL StandardEnvironments_Environments = 2 // An external non managed process to run user code.
	StandardEnvironments_DEFAULT  StandardEnvironments_Environments = 3 // Used as a stub when context is missing a runner-provided default environment.
)

// Enum value maps for StandardEnvironments_Environments.
var (
	StandardEnvironments_Environments_name = map[int32]string{
		0: "DOCKER",
		1: "PROCESS",
		2: "EXTERNAL",
		3: "DEFAULT",
	}
	StandardEnvironments_Environments_value = map[string]int32{
		"DOCKER":   0,
		"PROCESS":  1,
		"EXTERNAL": 2,
		"DEFAULT":  3,
	}
)

func (x StandardEnvironments_Environments) Enum() *StandardEnvironments_Environments {
	p := new(StandardEnvironments_Environments)
	*p = x
	return p
}

func (x StandardEnvironments_Environments) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardEnvironments_Environments) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[18].Descriptor()
}

func (StandardEnvironments_Environments) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[18]
}

func (x StandardEnvironments_Environments) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardEnvironments_Environments.Descriptor instead.
func (StandardEnvironments_Environments) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{48, 0}
}

type StandardProtocols_Enum int32

const (
	// Indicates suport for progress reporting via the legacy Metrics proto.
	StandardProtocols_LEGACY_PROGRESS_REPORTING StandardProtocols_Enum = 0
	// Indicates suport for progress reporting via the new MonitoringInfo proto.
	StandardProtocols_PROGRESS_REPORTING StandardProtocols_Enum = 1
	// Indicates suport for worker status protocol defined at
	// https://s.apache.org/beam-fn-api-harness-status.
	StandardProtocols_WORKER_STATUS StandardProtocols_Enum = 2
	// Indicates this SDK can take advantage of multiple cores when processing
	// concurrent process bundle requests. (Note that all SDKs must process
	// an unbounded number of concurrent process bundle requests; this capability
	// simply indicates this SDK can actually parallelize the work across multiple
	// cores.
	StandardProtocols_MULTI_CORE_BUNDLE_PROCESSING StandardProtocols_Enum = 3
	// Indicates that this SDK handles the InstructionRequest of type
	// HarnessMonitoringInfosRequest.
	// A request to provide full MonitoringInfo data associated with
	// the entire SDK harness process, not specific to a bundle.
	StandardProtocols_HARNESS_MONITORING_INFOS StandardProtocols_Enum = 4
)

// Enum value maps for StandardProtocols_Enum.
var (
	StandardProtocols_Enum_name = map[int32]string{
		0: "LEGACY_PROGRESS_REPORTING",
		1: "PROGRESS_REPORTING",
		2: "WORKER_STATUS",
		3: "MULTI_CORE_BUNDLE_PROCESSING",
		4: "HARNESS_MONITORING_INFOS",
	}
	StandardProtocols_Enum_value = map[string]int32{
		"LEGACY_PROGRESS_REPORTING":    0,
		"PROGRESS_REPORTING":           1,
		"WORKER_STATUS":                2,
		"MULTI_CORE_BUNDLE_PROCESSING": 3,
		"HARNESS_MONITORING_INFOS":     4,
	}
)

func (x StandardProtocols_Enum) Enum() *StandardProtocols_Enum {
	p := new(StandardProtocols_Enum)
	*p = x
	return p
}

func (x StandardProtocols_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardProtocols_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[19].Descriptor()
}

func (StandardProtocols_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[19]
}

func (x StandardProtocols_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardProtocols_Enum.Descriptor instead.
func (StandardProtocols_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{52, 0}
}

type StandardRunnerProtocols_Enum int32

const (
	// Indicates suport the MonitoringInfo short id protocol.
	StandardRunnerProtocols_MONITORING_INFO_SHORT_IDS StandardRunnerProtocols_Enum = 0
)

// Enum value maps for StandardRunnerProtocols_Enum.
var (
	StandardRunnerProtocols_Enum_name = map[int32]string{
		0: "MONITORING_INFO_SHORT_IDS",
	}
	StandardRunnerProtocols_Enum_value = map[string]int32{
		"MONITORING_INFO_SHORT_IDS": 0,
	}
)

func (x StandardRunnerProtocols_Enum) Enum() *StandardRunnerProtocols_Enum {
	p := new(StandardRunnerProtocols_Enum)
	*p = x
	return p
}

func (x StandardRunnerProtocols_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardRunnerProtocols_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[20].Descriptor()
}

func (StandardRunnerProtocols_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[20]
}

func (x StandardRunnerProtocols_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardRunnerProtocols_Enum.Descriptor instead.
func (StandardRunnerProtocols_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{53, 0}
}

type StandardRequirements_Enum int32

const (
	// This requirement indicates the state_spec and time_spec fields of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_STATEFUL_PROCESSING StandardRequirements_Enum = 0
	// This requirement indicates the requests_finalization field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_BUNDLE_FINALIZATION StandardRequirements_Enum = 1
	// This requirement indicates the requires_stable_input field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_STABLE_INPUT StandardRequirements_Enum = 2
	// This requirement indicates the requires_time_sorted_input field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_TIME_SORTED_INPUT StandardRequirements_Enum = 3
	// This requirement indicates the restriction_coder_id field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_SPLITTABLE_DOFN StandardRequirements_Enum = 4
)

// Enum value maps for StandardRequirements_Enum.
var (
	StandardRequirements_Enum_name = map[int32]string{
		0: "REQUIRES_STATEFUL_PROCESSING",
		1: "REQUIRES_BUNDLE_FINALIZATION",
		2: "REQUIRES_STABLE_INPUT",
		3: "REQUIRES_TIME_SORTED_INPUT",
		4: "REQUIRES_SPLITTABLE_DOFN",
	}
	StandardRequirements_Enum_value = map[string]int32{
		"REQUIRES_STATEFUL_PROCESSING": 0,
		"REQUIRES_BUNDLE_FINALIZATION": 1,
		"REQUIRES_STABLE_INPUT":        2,
		"REQUIRES_TIME_SORTED_INPUT":   3,
		"REQUIRES_SPLITTABLE_DOFN":     4,
	}
)

func (x StandardRequirements_Enum) Enum() *StandardRequirements_Enum {
	p := new(StandardRequirements_Enum)
	*p = x
	return p
}

func (x StandardRequirements_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardRequirements_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[21].Descriptor()
}

func (StandardRequirements_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[21]
}

func (x StandardRequirements_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardRequirements_Enum.Descriptor instead.
func (StandardRequirements_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{54, 0}
}

type StandardDisplayData_DisplayData int32

const (
	// A string label and value. Has a payload containing an encoded
	// LabelledPayload.
	StandardDisplayData_LABELLED StandardDisplayData_DisplayData = 0
)

// Enum value maps for StandardDisplayData_DisplayData.
var (
	StandardDisplayData_DisplayData_name = map[int32]string{
		0: "LABELLED",
	}
	StandardDisplayData_DisplayData_value = map[string]int32{
		"LABELLED": 0,
	}
)

func (x StandardDisplayData_DisplayData) Enum() *StandardDisplayData_DisplayData {
	p := new(StandardDisplayData_DisplayData)
	*p = x
	return p
}

func (x StandardDisplayData_DisplayData) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardDisplayData_DisplayData) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[22].Descriptor()
}

func (StandardDisplayData_DisplayData) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[22]
}

func (x StandardDisplayData_DisplayData) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardDisplayData_DisplayData.Descriptor instead.
func (StandardDisplayData_DisplayData) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{56, 0}
}

type StandardResourceHints_Enum int32

const (
	// Describes hardware accelerators that are desired to have in the execution environment.
	StandardResourceHints_ACCELERATOR StandardResourceHints_Enum = 0
	// Describes desired minimal available RAM size in transform's execution environment.
	// SDKs should convert the size to bytes, but can allow users to specify human-friendly units (e.g. GiB).
	StandardResourceHints_MIN_RAM_BYTES StandardResourceHints_Enum = 1
)

// Enum value maps for StandardResourceHints_Enum.
var (
	StandardResourceHints_Enum_name = map[int32]string{
		0: "ACCELERATOR",
		1: "MIN_RAM_BYTES",
	}
	StandardResourceHints_Enum_value = map[string]int32{
		"ACCELERATOR":   0,
		"MIN_RAM_BYTES": 1,
	}
)

func (x StandardResourceHints_Enum) Enum() *StandardResourceHints_Enum {
	p := new(StandardResourceHints_Enum)
	*p = x
	return p
}

func (x StandardResourceHints_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardResourceHints_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_runner_api_proto_enumTypes[23].Descriptor()
}

func (StandardResourceHints_Enum) Type() protoreflect.EnumType {
	return &file_beam_runner_api_proto_enumTypes[23]
}

func (x StandardResourceHints_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardResourceHints_Enum.Descriptor instead.
func (StandardResourceHints_Enum) EnumDescriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{61, 0}
}

type BeamConstants struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BeamConstants) Reset() {
	*x = BeamConstants{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeamConstants) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeamConstants) ProtoMessage() {}

func (x *BeamConstants) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeamConstants.ProtoReflect.Descriptor instead.
func (*BeamConstants) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{0}
}

// A set of mappings from id to message. This is included as an optional field
// on any proto message that may contain references needing resolution.
type Components struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A map from pipeline-scoped id to PTransform.
	//
	// Keys of the transforms map may be used by runners to identify pipeline
	// steps. Hence it's recommended to use strings that are not too long that
	// match regex '[A-Za-z0-9-_]+'.
	Transforms map[string]*PTransform `protobuf:"bytes,1,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*PCollection `protobuf:"bytes,2,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*WindowingStrategy `protobuf:"bytes,3,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*Coder `protobuf:"bytes,4,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments map[string]*Environment `protobuf:"bytes,5,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Components) Reset() {
	*x = Components{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Components) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Components) ProtoMessage() {}

func (x *Components) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Components.ProtoReflect.Descriptor instead.
func (*Components) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{1}
}

func (x *Components) GetTransforms() map[string]*PTransform {
	if x != nil {
		return x.Transforms
	}
	return nil
}

func (x *Components) GetPcollections() map[string]*PCollection {
	if x != nil {
		return x.Pcollections
	}
	return nil
}

func (x *Components) GetWindowingStrategies() map[string]*WindowingStrategy {
	if x != nil {
		return x.WindowingStrategies
	}
	return nil
}

func (x *Components) GetCoders() map[string]*Coder {
	if x != nil {
		return x.Coders
	}
	return nil
}

func (x *Components) GetEnvironments() map[string]*Environment {
	if x != nil {
		return x.Environments
	}
	return nil
}

// A Pipeline is a hierarchical graph of PTransforms, linked
// by PCollections. A typical graph may look like:
//
//   Impulse -> PCollection -> ParDo -> PCollection -> GroupByKey -> ...
//                                   \> PCollection -> ParDo      -> ...
//                                                  \> ParDo      -> ...
//   Impulse -> PCollection -> ParDo -> PCollection -> ...
//
// This is represented by a number of by-reference maps to transforms,
// PCollections, SDK environments, coders, etc., for
// supporting compact reuse and arbitrary graph structure.
type Pipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The coders, UDFs, graph nodes, etc, that make up
	// this pipeline.
	Components *Components `protobuf:"bytes,1,opt,name=components,proto3" json:"components,omitempty"`
	// (Required) The ids of all PTransforms that are not contained within another
	// PTransform. These must be in shallow topological order, so that traversing
	// them recursively in this order yields a recursively topological traversal.
	RootTransformIds []string `protobuf:"bytes,2,rep,name=root_transform_ids,json=rootTransformIds,proto3" json:"root_transform_ids,omitempty"`
	// (Optional) Static display data for the pipeline. If there is none,
	// it may be omitted.
	DisplayData []*DisplayData `protobuf:"bytes,3,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// (Optional) A set of requirements that the runner MUST understand and be
	// able to faithfully provide in order to execute this pipeline. These
	// may indicate that a runner must inspect new fields on a component or
	// provide additional guarantees when processing specific transforms.
	// A runner should reject any pipelines with unknown requirements.
	Requirements []string `protobuf:"bytes,4,rep,name=requirements,proto3" json:"requirements,omitempty"`
}

func (x *Pipeline) Reset() {
	*x = Pipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline) ProtoMessage() {}

func (x *Pipeline) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline.ProtoReflect.Descriptor instead.
func (*Pipeline) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{2}
}

func (x *Pipeline) GetComponents() *Components {
	if x != nil {
		return x.Components
	}
	return nil
}

func (x *Pipeline) GetRootTransformIds() []string {
	if x != nil {
		return x.RootTransformIds
	}
	return nil
}

func (x *Pipeline) GetDisplayData() []*DisplayData {
	if x != nil {
		return x.DisplayData
	}
	return nil
}

func (x *Pipeline) GetRequirements() []string {
	if x != nil {
		return x.Requirements
	}
	return nil
}

// Transforms are the operations in your pipeline, and provide a generic
// processing framework. You provide processing logic in the form of a function
// object (colloquially referred to as “user code”), and your user code is
// applied to each element of an input PCollection (or more than one
// PCollection). Depending on the pipeline runner and back-end that you choose,
// many different workers across a cluster may execute instances of your user
// code in parallel. The user code running on each worker generates the output
// elements that are ultimately added to the final output PCollection that the
// transform produces.
//
// The Beam SDKs contain a number of different transforms that you can apply to
// your pipeline’s PCollections. These include general-purpose core transforms,
// such as ParDo or Combine. There are also pre-written composite transforms
// included in the SDKs, which combine one or more of the core transforms in a
// useful processing pattern, such as counting or combining elements in a
// collection. You can also define your own more complex composite transforms to
// fit your pipeline’s exact use case.
type PTransform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A unique name for the application node.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here and be unique, even if it is
	// autogenerated.
	UniqueName string `protobuf:"bytes,5,opt,name=unique_name,json=uniqueName,proto3" json:"unique_name,omitempty"`
	// (Optional) A URN and payload that, together, fully defined the semantics
	// of this transform.
	//
	// If absent, this must be an "anonymous" composite transform.
	//
	// For primitive transform in the Runner API, this is required, and the
	// payloads are well-defined messages. When the URN indicates ParDo it
	// is a ParDoPayload, and so on. For some special composite transforms,
	// the payload is also officially defined. See StandardPTransforms for
	// details.
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// (Optional) A list of the ids of transforms that it contains.
	//
	// Primitive transforms (see StandardPTransforms.Primitives) are not allowed
	// to specify subtransforms.
	//
	// Note that a composite transform may have zero subtransforms as long as it
	// only outputs PCollections that are in its inputs.
	Subtransforms []string `protobuf:"bytes,2,rep,name=subtransforms,proto3" json:"subtransforms,omitempty"`
	// (Required) A map from local names of inputs (unique only with this map, and
	// likely embedded in the transform payload and serialized user code) to
	// PCollection ids.
	//
	// The payload for this transform may clarify the relationship of these
	// inputs. For example:
	//
	//  - for a Flatten transform they are merged
	//  - for a ParDo transform, some may be side inputs
	//
	// All inputs are recorded here so that the topological ordering of
	// the graph is consistent whether or not the payload is understood.
	Inputs map[string]string `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from local names of outputs (unique only within this map,
	// and likely embedded in the transform payload and serialized user code)
	// to PCollection ids.
	//
	// The URN or payload for this transform node may clarify the type and
	// relationship of these outputs. For example:
	//
	//  - for a ParDo transform, these are tags on PCollections, which will be
	//    embedded in the DoFn.
	Outputs map[string]string `protobuf:"bytes,4,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) Static display data for this PTransform application. If
	// there is none, it may be omitted.
	DisplayData []*DisplayData `protobuf:"bytes,6,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// Environment where the current PTransform should be executed in.
	//
	// Transforms that are required to be implemented by a runner must omit this.
	// All other transforms are required to specify this.
	EnvironmentId string `protobuf:"bytes,7,opt,name=environment_id,json=environmentId,proto3" json:"environment_id,omitempty"`
	// (Optional) A map from URNs designating a type of annotation, to the
	// annotation in binary format. For example, an annotation could indicate
	// that this PTransform has specific privacy properties.
	//
	// A runner MAY ignore types of annotations it doesn't understand. Therefore
	// annotations MUST NOT be used for metadata that can affect correct
	// execution of the transform.
	Annotations map[string][]byte `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PTransform) Reset() {
	*x = PTransform{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PTransform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PTransform) ProtoMessage() {}

func (x *PTransform) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PTransform.ProtoReflect.Descriptor instead.
func (*PTransform) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{3}
}

func (x *PTransform) GetUniqueName() string {
	if x != nil {
		return x.UniqueName
	}
	return ""
}

func (x *PTransform) GetSpec() *FunctionSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *PTransform) GetSubtransforms() []string {
	if x != nil {
		return x.Subtransforms
	}
	return nil
}

func (x *PTransform) GetInputs() map[string]string {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *PTransform) GetOutputs() map[string]string {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *PTransform) GetDisplayData() []*DisplayData {
	if x != nil {
		return x.DisplayData
	}
	return nil
}

func (x *PTransform) GetEnvironmentId() string {
	if x != nil {
		return x.EnvironmentId
	}
	return ""
}

func (x *PTransform) GetAnnotations() map[string][]byte {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type StandardPTransforms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardPTransforms) Reset() {
	*x = StandardPTransforms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardPTransforms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardPTransforms) ProtoMessage() {}

func (x *StandardPTransforms) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardPTransforms.ProtoReflect.Descriptor instead.
func (*StandardPTransforms) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{4}
}

type StandardSideInputTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardSideInputTypes) Reset() {
	*x = StandardSideInputTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardSideInputTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardSideInputTypes) ProtoMessage() {}

func (x *StandardSideInputTypes) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardSideInputTypes.ProtoReflect.Descriptor instead.
func (*StandardSideInputTypes) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{5}
}

// A PCollection!
type PCollection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A unique name for the PCollection.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here, even if it is autogenerated.
	UniqueName string `protobuf:"bytes,1,opt,name=unique_name,json=uniqueName,proto3" json:"unique_name,omitempty"`
	// (Required) The id of the Coder for this PCollection.
	CoderId string `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	// (Required) Whether this PCollection is bounded or unbounded
	IsBounded IsBounded_Enum `protobuf:"varint,3,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	// (Required) The id of the windowing strategy for this PCollection.
	WindowingStrategyId string `protobuf:"bytes,4,opt,name=windowing_strategy_id,json=windowingStrategyId,proto3" json:"windowing_strategy_id,omitempty"`
	// (Optional) Static display data for the PCollection. If there is none,
	// it may be omitted.
	DisplayData []*DisplayData `protobuf:"bytes,5,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
}

func (x *PCollection) Reset() {
	*x = PCollection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PCollection) ProtoMessage() {}

func (x *PCollection) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PCollection.ProtoReflect.Descriptor instead.
func (*PCollection) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{6}
}

func (x *PCollection) GetUniqueName() string {
	if x != nil {
		return x.UniqueName
	}
	return ""
}

func (x *PCollection) GetCoderId() string {
	if x != nil {
		return x.CoderId
	}
	return ""
}

func (x *PCollection) GetIsBounded() IsBounded_Enum {
	if x != nil {
		return x.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

func (x *PCollection) GetWindowingStrategyId() string {
	if x != nil {
		return x.WindowingStrategyId
	}
	return ""
}

func (x *PCollection) GetDisplayData() []*DisplayData {
	if x != nil {
		return x.DisplayData
	}
	return nil
}

// The payload for the primitive ParDo transform.
type ParDoPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The FunctionSpec of the DoFn.
	DoFn *FunctionSpec `protobuf:"bytes,1,opt,name=do_fn,json=doFn,proto3" json:"do_fn,omitempty"`
	// (Optional) A mapping of local input names to side inputs, describing
	// the expected access pattern.
	SideInputs map[string]*SideInput `protobuf:"bytes,3,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) A mapping of local state names to state specifications.
	// If this is set, the stateful processing requirement should also
	// be placed in the pipeline requirements.
	StateSpecs map[string]*StateSpec `protobuf:"bytes,4,rep,name=state_specs,json=stateSpecs,proto3" json:"state_specs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) A mapping of local timer family names to timer family
	// specifications. If this is set, the stateful processing requirement should
	// also be placed in the pipeline requirements.
	TimerFamilySpecs map[string]*TimerFamilySpec `protobuf:"bytes,9,rep,name=timer_family_specs,json=timerFamilySpecs,proto3" json:"timer_family_specs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) Only set when this ParDo contains a splittable DoFn.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RestrictionCoderId string `protobuf:"bytes,7,opt,name=restriction_coder_id,json=restrictionCoderId,proto3" json:"restriction_coder_id,omitempty"`
	// (Optional) Only set when this ParDo can request bundle finalization.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RequestsFinalization bool `protobuf:"varint,8,opt,name=requests_finalization,json=requestsFinalization,proto3" json:"requests_finalization,omitempty"`
	// Whether this stage requires time sorted input.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RequiresTimeSortedInput bool `protobuf:"varint,10,opt,name=requires_time_sorted_input,json=requiresTimeSortedInput,proto3" json:"requires_time_sorted_input,omitempty"`
	// Whether this stage requires stable input.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RequiresStableInput bool `protobuf:"varint,11,opt,name=requires_stable_input,json=requiresStableInput,proto3" json:"requires_stable_input,omitempty"`
}

func (x *ParDoPayload) Reset() {
	*x = ParDoPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParDoPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParDoPayload) ProtoMessage() {}

func (x *ParDoPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParDoPayload.ProtoReflect.Descriptor instead.
func (*ParDoPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{7}
}

func (x *ParDoPayload) GetDoFn() *FunctionSpec {
	if x != nil {
		return x.DoFn
	}
	return nil
}

func (x *ParDoPayload) GetSideInputs() map[string]*SideInput {
	if x != nil {
		return x.SideInputs
	}
	return nil
}

func (x *ParDoPayload) GetStateSpecs() map[string]*StateSpec {
	if x != nil {
		return x.StateSpecs
	}
	return nil
}

func (x *ParDoPayload) GetTimerFamilySpecs() map[string]*TimerFamilySpec {
	if x != nil {
		return x.TimerFamilySpecs
	}
	return nil
}

func (x *ParDoPayload) GetRestrictionCoderId() string {
	if x != nil {
		return x.RestrictionCoderId
	}
	return ""
}

func (x *ParDoPayload) GetRequestsFinalization() bool {
	if x != nil {
		return x.RequestsFinalization
	}
	return false
}

func (x *ParDoPayload) GetRequiresTimeSortedInput() bool {
	if x != nil {
		return x.RequiresTimeSortedInput
	}
	return false
}

func (x *ParDoPayload) GetRequiresStableInput() bool {
	if x != nil {
		return x.RequiresStableInput
	}
	return false
}

type StateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Spec:
	//	*StateSpec_ReadModifyWriteSpec
	//	*StateSpec_BagSpec
	//	*StateSpec_CombiningSpec
	//	*StateSpec_MapSpec
	//	*StateSpec_SetSpec
	//	*StateSpec_OrderedListSpec
	Spec isStateSpec_Spec `protobuf_oneof:"spec"`
}

func (x *StateSpec) Reset() {
	*x = StateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateSpec) ProtoMessage() {}

func (x *StateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateSpec.ProtoReflect.Descriptor instead.
func (*StateSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{8}
}

func (m *StateSpec) GetSpec() isStateSpec_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (x *StateSpec) GetReadModifyWriteSpec() *ReadModifyWriteStateSpec {
	if x, ok := x.GetSpec().(*StateSpec_ReadModifyWriteSpec); ok {
		return x.ReadModifyWriteSpec
	}
	return nil
}

func (x *StateSpec) GetBagSpec() *BagStateSpec {
	if x, ok := x.GetSpec().(*StateSpec_BagSpec); ok {
		return x.BagSpec
	}
	return nil
}

func (x *StateSpec) GetCombiningSpec() *CombiningStateSpec {
	if x, ok := x.GetSpec().(*StateSpec_CombiningSpec); ok {
		return x.CombiningSpec
	}
	return nil
}

func (x *StateSpec) GetMapSpec() *MapStateSpec {
	if x, ok := x.GetSpec().(*StateSpec_MapSpec); ok {
		return x.MapSpec
	}
	return nil
}

func (x *StateSpec) GetSetSpec() *SetStateSpec {
	if x, ok := x.GetSpec().(*StateSpec_SetSpec); ok {
		return x.SetSpec
	}
	return nil
}

func (x *StateSpec) GetOrderedListSpec() *OrderedListStateSpec {
	if x, ok := x.GetSpec().(*StateSpec_OrderedListSpec); ok {
		return x.OrderedListSpec
	}
	return nil
}

type isStateSpec_Spec interface {
	isStateSpec_Spec()
}

type StateSpec_ReadModifyWriteSpec struct {
	ReadModifyWriteSpec *ReadModifyWriteStateSpec `protobuf:"bytes,1,opt,name=read_modify_write_spec,json=readModifyWriteSpec,proto3,oneof"`
}

type StateSpec_BagSpec struct {
	BagSpec *BagStateSpec `protobuf:"bytes,2,opt,name=bag_spec,json=bagSpec,proto3,oneof"`
}

type StateSpec_CombiningSpec struct {
	CombiningSpec *CombiningStateSpec `protobuf:"bytes,3,opt,name=combining_spec,json=combiningSpec,proto3,oneof"`
}

type StateSpec_MapSpec struct {
	MapSpec *MapStateSpec `protobuf:"bytes,4,opt,name=map_spec,json=mapSpec,proto3,oneof"`
}

type StateSpec_SetSpec struct {
	SetSpec *SetStateSpec `protobuf:"bytes,5,opt,name=set_spec,json=setSpec,proto3,oneof"`
}

type StateSpec_OrderedListSpec struct {
	OrderedListSpec *OrderedListStateSpec `protobuf:"bytes,6,opt,name=ordered_list_spec,json=orderedListSpec,proto3,oneof"`
}

func (*StateSpec_ReadModifyWriteSpec) isStateSpec_Spec() {}

func (*StateSpec_BagSpec) isStateSpec_Spec() {}

func (*StateSpec_CombiningSpec) isStateSpec_Spec() {}

func (*StateSpec_MapSpec) isStateSpec_Spec() {}

func (*StateSpec_SetSpec) isStateSpec_Spec() {}

func (*StateSpec_OrderedListSpec) isStateSpec_Spec() {}

type ReadModifyWriteStateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CoderId string `protobuf:"bytes,1,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
}

func (x *ReadModifyWriteStateSpec) Reset() {
	*x = ReadModifyWriteStateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadModifyWriteStateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadModifyWriteStateSpec) ProtoMessage() {}

func (x *ReadModifyWriteStateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadModifyWriteStateSpec.ProtoReflect.Descriptor instead.
func (*ReadModifyWriteStateSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{9}
}

func (x *ReadModifyWriteStateSpec) GetCoderId() string {
	if x != nil {
		return x.CoderId
	}
	return ""
}

type BagStateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ElementCoderId string `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId,proto3" json:"element_coder_id,omitempty"`
}

func (x *BagStateSpec) Reset() {
	*x = BagStateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BagStateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BagStateSpec) ProtoMessage() {}

func (x *BagStateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BagStateSpec.ProtoReflect.Descriptor instead.
func (*BagStateSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{10}
}

func (x *BagStateSpec) GetElementCoderId() string {
	if x != nil {
		return x.ElementCoderId
	}
	return ""
}

type OrderedListStateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ElementCoderId string `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId,proto3" json:"element_coder_id,omitempty"`
}

func (x *OrderedListStateSpec) Reset() {
	*x = OrderedListStateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderedListStateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderedListStateSpec) ProtoMessage() {}

func (x *OrderedListStateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderedListStateSpec.ProtoReflect.Descriptor instead.
func (*OrderedListStateSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{11}
}

func (x *OrderedListStateSpec) GetElementCoderId() string {
	if x != nil {
		return x.ElementCoderId
	}
	return ""
}

type CombiningStateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccumulatorCoderId string        `protobuf:"bytes,1,opt,name=accumulator_coder_id,json=accumulatorCoderId,proto3" json:"accumulator_coder_id,omitempty"`
	CombineFn          *FunctionSpec `protobuf:"bytes,2,opt,name=combine_fn,json=combineFn,proto3" json:"combine_fn,omitempty"`
}

func (x *CombiningStateSpec) Reset() {
	*x = CombiningStateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CombiningStateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CombiningStateSpec) ProtoMessage() {}

func (x *CombiningStateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CombiningStateSpec.ProtoReflect.Descriptor instead.
func (*CombiningStateSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{12}
}

func (x *CombiningStateSpec) GetAccumulatorCoderId() string {
	if x != nil {
		return x.AccumulatorCoderId
	}
	return ""
}

func (x *CombiningStateSpec) GetCombineFn() *FunctionSpec {
	if x != nil {
		return x.CombineFn
	}
	return nil
}

type MapStateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyCoderId   string `protobuf:"bytes,1,opt,name=key_coder_id,json=keyCoderId,proto3" json:"key_coder_id,omitempty"`
	ValueCoderId string `protobuf:"bytes,2,opt,name=value_coder_id,json=valueCoderId,proto3" json:"value_coder_id,omitempty"`
}

func (x *MapStateSpec) Reset() {
	*x = MapStateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapStateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapStateSpec) ProtoMessage() {}

func (x *MapStateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapStateSpec.ProtoReflect.Descriptor instead.
func (*MapStateSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{13}
}

func (x *MapStateSpec) GetKeyCoderId() string {
	if x != nil {
		return x.KeyCoderId
	}
	return ""
}

func (x *MapStateSpec) GetValueCoderId() string {
	if x != nil {
		return x.ValueCoderId
	}
	return ""
}

type SetStateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ElementCoderId string `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId,proto3" json:"element_coder_id,omitempty"`
}

func (x *SetStateSpec) Reset() {
	*x = SetStateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetStateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetStateSpec) ProtoMessage() {}

func (x *SetStateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetStateSpec.ProtoReflect.Descriptor instead.
func (*SetStateSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{14}
}

func (x *SetStateSpec) GetElementCoderId() string {
	if x != nil {
		return x.ElementCoderId
	}
	return ""
}

type TimerFamilySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TimeDomain         TimeDomain_Enum `protobuf:"varint,1,opt,name=time_domain,json=timeDomain,proto3,enum=org.apache.beam.model.pipeline.v1.TimeDomain_Enum" json:"time_domain,omitempty"`
	TimerFamilyCoderId string          `protobuf:"bytes,2,opt,name=timer_family_coder_id,json=timerFamilyCoderId,proto3" json:"timer_family_coder_id,omitempty"`
}

func (x *TimerFamilySpec) Reset() {
	*x = TimerFamilySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimerFamilySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimerFamilySpec) ProtoMessage() {}

func (x *TimerFamilySpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimerFamilySpec.ProtoReflect.Descriptor instead.
func (*TimerFamilySpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{15}
}

func (x *TimerFamilySpec) GetTimeDomain() TimeDomain_Enum {
	if x != nil {
		return x.TimeDomain
	}
	return TimeDomain_UNSPECIFIED
}

func (x *TimerFamilySpec) GetTimerFamilyCoderId() string {
	if x != nil {
		return x.TimerFamilyCoderId
	}
	return ""
}

type IsBounded struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IsBounded) Reset() {
	*x = IsBounded{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IsBounded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsBounded) ProtoMessage() {}

func (x *IsBounded) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsBounded.ProtoReflect.Descriptor instead.
func (*IsBounded) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{16}
}

// The payload for the primitive Read transform.
type ReadPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The FunctionSpec of the source for this Read.
	Source *FunctionSpec `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// (Required) Whether the source is bounded or unbounded
	IsBounded IsBounded_Enum `protobuf:"varint,2,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
}

func (x *ReadPayload) Reset() {
	*x = ReadPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadPayload) ProtoMessage() {}

func (x *ReadPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadPayload.ProtoReflect.Descriptor instead.
func (*ReadPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{17}
}

func (x *ReadPayload) GetSource() *FunctionSpec {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *ReadPayload) GetIsBounded() IsBounded_Enum {
	if x != nil {
		return x.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

// The payload for the WindowInto transform.
type WindowIntoPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The FunctionSpec of the WindowFn.
	WindowFn *FunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn,proto3" json:"window_fn,omitempty"`
}

func (x *WindowIntoPayload) Reset() {
	*x = WindowIntoPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowIntoPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowIntoPayload) ProtoMessage() {}

func (x *WindowIntoPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowIntoPayload.ProtoReflect.Descriptor instead.
func (*WindowIntoPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{18}
}

func (x *WindowIntoPayload) GetWindowFn() *FunctionSpec {
	if x != nil {
		return x.WindowFn
	}
	return nil
}

// The payload for the special-but-not-primitive Combine transform.
type CombinePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The FunctionSpec of the CombineFn.
	CombineFn *FunctionSpec `protobuf:"bytes,1,opt,name=combine_fn,json=combineFn,proto3" json:"combine_fn,omitempty"`
	// (Required) A reference to the Coder to use for accumulators of the CombineFn
	AccumulatorCoderId string `protobuf:"bytes,2,opt,name=accumulator_coder_id,json=accumulatorCoderId,proto3" json:"accumulator_coder_id,omitempty"`
}

func (x *CombinePayload) Reset() {
	*x = CombinePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CombinePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CombinePayload) ProtoMessage() {}

func (x *CombinePayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CombinePayload.ProtoReflect.Descriptor instead.
func (*CombinePayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{19}
}

func (x *CombinePayload) GetCombineFn() *FunctionSpec {
	if x != nil {
		return x.CombineFn
	}
	return nil
}

func (x *CombinePayload) GetAccumulatorCoderId() string {
	if x != nil {
		return x.AccumulatorCoderId
	}
	return ""
}

// The payload for the test-only primitive TestStream
type TestStreamPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) the coder for elements in the TestStream events
	CoderId string `protobuf:"bytes,1,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	// (Optional) If specified, the TestStream will replay these events.
	Events []*TestStreamPayload_Event `protobuf:"bytes,2,rep,name=events,proto3" json:"events,omitempty"`
	// (Optional) If specified, points to a TestStreamService to be
	// used to retrieve events.
	Endpoint *ApiServiceDescriptor `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (x *TestStreamPayload) Reset() {
	*x = TestStreamPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestStreamPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestStreamPayload) ProtoMessage() {}

func (x *TestStreamPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestStreamPayload.ProtoReflect.Descriptor instead.
func (*TestStreamPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{20}
}

func (x *TestStreamPayload) GetCoderId() string {
	if x != nil {
		return x.CoderId
	}
	return ""
}

func (x *TestStreamPayload) GetEvents() []*TestStreamPayload_Event {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *TestStreamPayload) GetEndpoint() *ApiServiceDescriptor {
	if x != nil {
		return x.Endpoint
	}
	return nil
}

type EventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of PCollections to read from. These are the PTransform outputs
	// local names. These are a subset of the TestStream's outputs. This allows
	// Interactive Beam to cache many PCollections from a pipeline then replay a
	// subset of them.
	OutputIds []string `protobuf:"bytes,1,rep,name=output_ids,json=outputIds,proto3" json:"output_ids,omitempty"`
}

func (x *EventsRequest) Reset() {
	*x = EventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventsRequest) ProtoMessage() {}

func (x *EventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventsRequest.ProtoReflect.Descriptor instead.
func (*EventsRequest) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{21}
}

func (x *EventsRequest) GetOutputIds() []string {
	if x != nil {
		return x.OutputIds
	}
	return nil
}

// The payload for the special-but-not-primitive WriteFiles transform.
type WriteFilesPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The FunctionSpec of the FileBasedSink.
	Sink *FunctionSpec `protobuf:"bytes,1,opt,name=sink,proto3" json:"sink,omitempty"`
	// (Required) The format function.
	FormatFunction           *FunctionSpec         `protobuf:"bytes,2,opt,name=format_function,json=formatFunction,proto3" json:"format_function,omitempty"`
	WindowedWrites           bool                  `protobuf:"varint,3,opt,name=windowed_writes,json=windowedWrites,proto3" json:"windowed_writes,omitempty"`
	RunnerDeterminedSharding bool                  `protobuf:"varint,4,opt,name=runner_determined_sharding,json=runnerDeterminedSharding,proto3" json:"runner_determined_sharding,omitempty"`
	SideInputs               map[string]*SideInput `protobuf:"bytes,5,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *WriteFilesPayload) Reset() {
	*x = WriteFilesPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteFilesPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFilesPayload) ProtoMessage() {}

func (x *WriteFilesPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFilesPayload.ProtoReflect.Descriptor instead.
func (*WriteFilesPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{22}
}

func (x *WriteFilesPayload) GetSink() *FunctionSpec {
	if x != nil {
		return x.Sink
	}
	return nil
}

func (x *WriteFilesPayload) GetFormatFunction() *FunctionSpec {
	if x != nil {
		return x.FormatFunction
	}
	return nil
}

func (x *WriteFilesPayload) GetWindowedWrites() bool {
	if x != nil {
		return x.WindowedWrites
	}
	return false
}

func (x *WriteFilesPayload) GetRunnerDeterminedSharding() bool {
	if x != nil {
		return x.RunnerDeterminedSharding
	}
	return false
}

func (x *WriteFilesPayload) GetSideInputs() map[string]*SideInput {
	if x != nil {
		return x.SideInputs
	}
	return nil
}

// Payload used by Google Cloud Pub/Sub read transform.
// This can be used by runners that wish to override Beam Pub/Sub read transform
// with a native implementation.
// The SDK should guarantee that only one of topic, subscription,
// topic_runtime_overridden and subscription_runtime_overridden is set.
// The output of PubSubReadPayload should be bytes of serialized PubsubMessage
// proto if with_attributes == true. Otherwise, the bytes is the raw payload.
type PubSubReadPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Topic to read from. Exactly one of topic or subscription should be set.
	// Topic format is: /topics/project_id/subscription_name
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Subscription to read from. Exactly one of topic or subscription should be set.
	// Subscription format is: /subscriptions/project_id/subscription_name
	Subscription string `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Attribute that provides element timestamps.
	TimestampAttribute string `protobuf:"bytes,3,opt,name=timestamp_attribute,json=timestampAttribute,proto3" json:"timestamp_attribute,omitempty"`
	// Attribute to be used for uniquely identifying messages.
	IdAttribute string `protobuf:"bytes,4,opt,name=id_attribute,json=idAttribute,proto3" json:"id_attribute,omitempty"`
	// If true, reads Pub/Sub payload as well as attributes. If false, reads only the payload.
	WithAttributes bool `protobuf:"varint,5,opt,name=with_attributes,json=withAttributes,proto3" json:"with_attributes,omitempty"`
	// If set, the topic is expected to be provided during runtime.
	TopicRuntimeOverridden string `protobuf:"bytes,6,opt,name=topic_runtime_overridden,json=topicRuntimeOverridden,proto3" json:"topic_runtime_overridden,omitempty"`
	// If set, the subscription that is expected to be provided during runtime.
	SubscriptionRuntimeOverridden string `protobuf:"bytes,7,opt,name=subscription_runtime_overridden,json=subscriptionRuntimeOverridden,proto3" json:"subscription_runtime_overridden,omitempty"`
}

func (x *PubSubReadPayload) Reset() {
	*x = PubSubReadPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubSubReadPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubSubReadPayload) ProtoMessage() {}

func (x *PubSubReadPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubSubReadPayload.ProtoReflect.Descriptor instead.
func (*PubSubReadPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{23}
}

func (x *PubSubReadPayload) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *PubSubReadPayload) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *PubSubReadPayload) GetTimestampAttribute() string {
	if x != nil {
		return x.TimestampAttribute
	}
	return ""
}

func (x *PubSubReadPayload) GetIdAttribute() string {
	if x != nil {
		return x.IdAttribute
	}
	return ""
}

func (x *PubSubReadPayload) GetWithAttributes() bool {
	if x != nil {
		return x.WithAttributes
	}
	return false
}

func (x *PubSubReadPayload) GetTopicRuntimeOverridden() string {
	if x != nil {
		return x.TopicRuntimeOverridden
	}
	return ""
}

func (x *PubSubReadPayload) GetSubscriptionRuntimeOverridden() string {
	if x != nil {
		return x.SubscriptionRuntimeOverridden
	}
	return ""
}

// Payload used by Google Cloud Pub/Sub write transform.
// This can be used by runners that wish to override Beam Pub/Sub write transform
// with a native implementation.
// The SDK should guarantee that only one of topic and topic_runtime_overridden
// is set.
// The output of PubSubWritePayload should be bytes if serialized PubsubMessage
// proto.
type PubSubWritePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Topic to write to.
	// Topic format is: /topics/project_id/subscription_name
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Attribute that provides element timestamps.
	TimestampAttribute string `protobuf:"bytes,2,opt,name=timestamp_attribute,json=timestampAttribute,proto3" json:"timestamp_attribute,omitempty"`
	// Attribute that uniquely identify messages.
	IdAttribute string `protobuf:"bytes,3,opt,name=id_attribute,json=idAttribute,proto3" json:"id_attribute,omitempty"`
	// If set, the topic is expected to be provided during runtime.
	TopicRuntimeOverridden string `protobuf:"bytes,4,opt,name=topic_runtime_overridden,json=topicRuntimeOverridden,proto3" json:"topic_runtime_overridden,omitempty"`
}

func (x *PubSubWritePayload) Reset() {
	*x = PubSubWritePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubSubWritePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubSubWritePayload) ProtoMessage() {}

func (x *PubSubWritePayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubSubWritePayload.ProtoReflect.Descriptor instead.
func (*PubSubWritePayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{24}
}

func (x *PubSubWritePayload) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *PubSubWritePayload) GetTimestampAttribute() string {
	if x != nil {
		return x.TimestampAttribute
	}
	return ""
}

func (x *PubSubWritePayload) GetIdAttribute() string {
	if x != nil {
		return x.IdAttribute
	}
	return ""
}

func (x *PubSubWritePayload) GetTopicRuntimeOverridden() string {
	if x != nil {
		return x.TopicRuntimeOverridden
	}
	return ""
}

// Payload for GroupIntoBatches composite transform.
type GroupIntoBatchesPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max size of a batch.
	BatchSize int64 `protobuf:"varint,1,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	// Max byte size of a batch in element.
	BatchSizeBytes int64 `protobuf:"varint,3,opt,name=batch_size_bytes,json=batchSizeBytes,proto3" json:"batch_size_bytes,omitempty"`
	// (Optional) Max duration a batch is allowed to be cached in states.
	MaxBufferingDurationMillis int64 `protobuf:"varint,2,opt,name=max_buffering_duration_millis,json=maxBufferingDurationMillis,proto3" json:"max_buffering_duration_millis,omitempty"`
}

func (x *GroupIntoBatchesPayload) Reset() {
	*x = GroupIntoBatchesPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupIntoBatchesPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupIntoBatchesPayload) ProtoMessage() {}

func (x *GroupIntoBatchesPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupIntoBatchesPayload.ProtoReflect.Descriptor instead.
func (*GroupIntoBatchesPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{25}
}

func (x *GroupIntoBatchesPayload) GetBatchSize() int64 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

func (x *GroupIntoBatchesPayload) GetBatchSizeBytes() int64 {
	if x != nil {
		return x.BatchSizeBytes
	}
	return 0
}

func (x *GroupIntoBatchesPayload) GetMaxBufferingDurationMillis() int64 {
	if x != nil {
		return x.MaxBufferingDurationMillis
	}
	return 0
}

// A coder, the binary format for serialization and deserialization of data in
// a pipeline.
type Coder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A specification for the coder, as a URN plus parameters. This
	// may be a cross-language agreed-upon format, or it may be a "custom coder"
	// that can only be used by a particular SDK. It does not include component
	// coders, as it is beneficial for these to be comprehensible to a runner
	// regardless of whether the binary format is agreed-upon.
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// (Optional) If this coder is parametric, such as ListCoder(VarIntCoder),
	// this is a list of the components. In order for encodings to be identical,
	// the FunctionSpec and all components must be identical, recursively.
	ComponentCoderIds []string `protobuf:"bytes,2,rep,name=component_coder_ids,json=componentCoderIds,proto3" json:"component_coder_ids,omitempty"`
}

func (x *Coder) Reset() {
	*x = Coder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Coder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Coder) ProtoMessage() {}

func (x *Coder) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Coder.ProtoReflect.Descriptor instead.
func (*Coder) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{26}
}

func (x *Coder) GetSpec() *FunctionSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Coder) GetComponentCoderIds() []string {
	if x != nil {
		return x.ComponentCoderIds
	}
	return nil
}

type StandardCoders struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardCoders) Reset() {
	*x = StandardCoders{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardCoders) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardCoders) ProtoMessage() {}

func (x *StandardCoders) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardCoders.ProtoReflect.Descriptor instead.
func (*StandardCoders) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{27}
}

// A windowing strategy describes the window function, triggering, allowed
// lateness, and accumulation mode for a PCollection.
//
// TODO: consider inlining field on PCollection
type WindowingStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The FunctionSpec of the UDF that assigns windows,
	// merges windows, and shifts timestamps before they are
	// combined according to the OutputTime.
	WindowFn *FunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn,proto3" json:"window_fn,omitempty"`
	// (Required) Whether or not the window fn is merging.
	//
	// This knowledge is required for many optimizations.
	MergeStatus MergeStatus_Enum `protobuf:"varint,2,opt,name=merge_status,json=mergeStatus,proto3,enum=org.apache.beam.model.pipeline.v1.MergeStatus_Enum" json:"merge_status,omitempty"`
	// (Required) The coder for the windows of this PCollection.
	WindowCoderId string `protobuf:"bytes,3,opt,name=window_coder_id,json=windowCoderId,proto3" json:"window_coder_id,omitempty"`
	// (Required) The trigger to use when grouping this PCollection.
	Trigger *Trigger `protobuf:"bytes,4,opt,name=trigger,proto3" json:"trigger,omitempty"`
	// (Required) The accumulation mode indicates whether new panes are a full
	// replacement for prior panes or whether they are deltas to be combined
	// with other panes (the combine should correspond to whatever the upstream
	// grouping transform is).
	AccumulationMode AccumulationMode_Enum `protobuf:"varint,5,opt,name=accumulation_mode,json=accumulationMode,proto3,enum=org.apache.beam.model.pipeline.v1.AccumulationMode_Enum" json:"accumulation_mode,omitempty"`
	// (Required) The OutputTime specifies, for a grouping transform, how to
	// compute the aggregate timestamp. The window_fn will first possibly shift
	// it later, then the OutputTime takes the max, min, or ignores it and takes
	// the end of window.
	//
	// This is actually only for input to grouping transforms, but since they
	// may be introduced in runner-specific ways, it is carried along with the
	// windowing strategy.
	OutputTime OutputTime_Enum `protobuf:"varint,6,opt,name=output_time,json=outputTime,proto3,enum=org.apache.beam.model.pipeline.v1.OutputTime_Enum" json:"output_time,omitempty"`
	// (Required) Indicate when output should be omitted upon window expiration.
	ClosingBehavior ClosingBehavior_Enum `protobuf:"varint,7,opt,name=closing_behavior,json=closingBehavior,proto3,enum=org.apache.beam.model.pipeline.v1.ClosingBehavior_Enum" json:"closing_behavior,omitempty"`
	// (Required) The duration, in milliseconds, beyond the end of a window at
	// which the window becomes droppable.
	AllowedLateness int64 `protobuf:"varint,8,opt,name=allowed_lateness,json=allowedLateness,proto3" json:"allowed_lateness,omitempty"`
	// (Required) Indicate whether empty on-time panes should be omitted.
	OnTimeBehavior OnTimeBehavior_Enum `protobuf:"varint,9,opt,name=OnTimeBehavior,proto3,enum=org.apache.beam.model.pipeline.v1.OnTimeBehavior_Enum" json:"OnTimeBehavior,omitempty"`
	// (Required) Whether or not the window fn assigns inputs to exactly one window
	//
	// This knowledge is required for some optimizations
	AssignsToOneWindow bool `protobuf:"varint,10,opt,name=assigns_to_one_window,json=assignsToOneWindow,proto3" json:"assigns_to_one_window,omitempty"`
	// (Optional) Environment where the current window_fn should be applied in.
	// Runner that executes the pipeline may choose to override this if needed.
	// If not specified, environment will be decided by the runner.
	EnvironmentId string `protobuf:"bytes,11,opt,name=environment_id,json=environmentId,proto3" json:"environment_id,omitempty"`
}

func (x *WindowingStrategy) Reset() {
	*x = WindowingStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowingStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowingStrategy) ProtoMessage() {}

func (x *WindowingStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowingStrategy.ProtoReflect.Descriptor instead.
func (*WindowingStrategy) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{28}
}

func (x *WindowingStrategy) GetWindowFn() *FunctionSpec {
	if x != nil {
		return x.WindowFn
	}
	return nil
}

func (x *WindowingStrategy) GetMergeStatus() MergeStatus_Enum {
	if x != nil {
		return x.MergeStatus
	}
	return MergeStatus_UNSPECIFIED
}

func (x *WindowingStrategy) GetWindowCoderId() string {
	if x != nil {
		return x.WindowCoderId
	}
	return ""
}

func (x *WindowingStrategy) GetTrigger() *Trigger {
	if x != nil {
		return x.Trigger
	}
	return nil
}

func (x *WindowingStrategy) GetAccumulationMode() AccumulationMode_Enum {
	if x != nil {
		return x.AccumulationMode
	}
	return AccumulationMode_UNSPECIFIED
}

func (x *WindowingStrategy) GetOutputTime() OutputTime_Enum {
	if x != nil {
		return x.OutputTime
	}
	return OutputTime_UNSPECIFIED
}

func (x *WindowingStrategy) GetClosingBehavior() ClosingBehavior_Enum {
	if x != nil {
		return x.ClosingBehavior
	}
	return ClosingBehavior_UNSPECIFIED
}

func (x *WindowingStrategy) GetAllowedLateness() int64 {
	if x != nil {
		return x.AllowedLateness
	}
	return 0
}

func (x *WindowingStrategy) GetOnTimeBehavior() OnTimeBehavior_Enum {
	if x != nil {
		return x.OnTimeBehavior
	}
	return OnTimeBehavior_UNSPECIFIED
}

func (x *WindowingStrategy) GetAssignsToOneWindow() bool {
	if x != nil {
		return x.AssignsToOneWindow
	}
	return false
}

func (x *WindowingStrategy) GetEnvironmentId() string {
	if x != nil {
		return x.EnvironmentId
	}
	return ""
}

// Whether or not a PCollection's WindowFn is non-merging, merging, or
// merging-but-already-merged, in which case a subsequent GroupByKey is almost
// always going to do something the user does not want
type MergeStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MergeStatus) Reset() {
	*x = MergeStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeStatus) ProtoMessage() {}

func (x *MergeStatus) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeStatus.ProtoReflect.Descriptor instead.
func (*MergeStatus) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{29}
}

// Whether or not subsequent outputs of aggregations should be entire
// replacement values or just the aggregation of inputs received since
// the prior output.
type AccumulationMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AccumulationMode) Reset() {
	*x = AccumulationMode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccumulationMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccumulationMode) ProtoMessage() {}

func (x *AccumulationMode) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccumulationMode.ProtoReflect.Descriptor instead.
func (*AccumulationMode) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{30}
}

// Controls whether or not an aggregating transform should output data
// when a window expires.
type ClosingBehavior struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ClosingBehavior) Reset() {
	*x = ClosingBehavior{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClosingBehavior) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClosingBehavior) ProtoMessage() {}

func (x *ClosingBehavior) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClosingBehavior.ProtoReflect.Descriptor instead.
func (*ClosingBehavior) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{31}
}

// Controls whether or not an aggregating transform should output data
// when an on-time pane is empty.
type OnTimeBehavior struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *OnTimeBehavior) Reset() {
	*x = OnTimeBehavior{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnTimeBehavior) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnTimeBehavior) ProtoMessage() {}

func (x *OnTimeBehavior) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnTimeBehavior.ProtoReflect.Descriptor instead.
func (*OnTimeBehavior) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{32}
}

// When a number of windowed, timestamped inputs are aggregated, the timestamp
// for the resulting output.
type OutputTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *OutputTime) Reset() {
	*x = OutputTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputTime) ProtoMessage() {}

func (x *OutputTime) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputTime.ProtoReflect.Descriptor instead.
func (*OutputTime) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{33}
}

// The different time domains in the Beam model.
type TimeDomain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TimeDomain) Reset() {
	*x = TimeDomain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeDomain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeDomain) ProtoMessage() {}

func (x *TimeDomain) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeDomain.ProtoReflect.Descriptor instead.
func (*TimeDomain) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{34}
}

// A small DSL for expressing when to emit new aggregations
// from a GroupByKey or CombinePerKey
//
// A trigger is described in terms of when it is _ready_ to permit output.
type Trigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full disjoint union of possible triggers.
	//
	// Types that are assignable to Trigger:
	//	*Trigger_AfterAll_
	//	*Trigger_AfterAny_
	//	*Trigger_AfterEach_
	//	*Trigger_AfterEndOfWindow_
	//	*Trigger_AfterProcessingTime_
	//	*Trigger_AfterSynchronizedProcessingTime_
	//	*Trigger_Always_
	//	*Trigger_Default_
	//	*Trigger_ElementCount_
	//	*Trigger_Never_
	//	*Trigger_OrFinally_
	//	*Trigger_Repeat_
	Trigger isTrigger_Trigger `protobuf_oneof:"trigger"`
}

func (x *Trigger) Reset() {
	*x = Trigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger) ProtoMessage() {}

func (x *Trigger) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger.ProtoReflect.Descriptor instead.
func (*Trigger) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35}
}

func (m *Trigger) GetTrigger() isTrigger_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *Trigger) GetAfterAll() *Trigger_AfterAll {
	if x, ok := x.GetTrigger().(*Trigger_AfterAll_); ok {
		return x.AfterAll
	}
	return nil
}

func (x *Trigger) GetAfterAny() *Trigger_AfterAny {
	if x, ok := x.GetTrigger().(*Trigger_AfterAny_); ok {
		return x.AfterAny
	}
	return nil
}

func (x *Trigger) GetAfterEach() *Trigger_AfterEach {
	if x, ok := x.GetTrigger().(*Trigger_AfterEach_); ok {
		return x.AfterEach
	}
	return nil
}

func (x *Trigger) GetAfterEndOfWindow() *Trigger_AfterEndOfWindow {
	if x, ok := x.GetTrigger().(*Trigger_AfterEndOfWindow_); ok {
		return x.AfterEndOfWindow
	}
	return nil
}

func (x *Trigger) GetAfterProcessingTime() *Trigger_AfterProcessingTime {
	if x, ok := x.GetTrigger().(*Trigger_AfterProcessingTime_); ok {
		return x.AfterProcessingTime
	}
	return nil
}

func (x *Trigger) GetAfterSynchronizedProcessingTime() *Trigger_AfterSynchronizedProcessingTime {
	if x, ok := x.GetTrigger().(*Trigger_AfterSynchronizedProcessingTime_); ok {
		return x.AfterSynchronizedProcessingTime
	}
	return nil
}

func (x *Trigger) GetAlways() *Trigger_Always {
	if x, ok := x.GetTrigger().(*Trigger_Always_); ok {
		return x.Always
	}
	return nil
}

func (x *Trigger) GetDefault() *Trigger_Default {
	if x, ok := x.GetTrigger().(*Trigger_Default_); ok {
		return x.Default
	}
	return nil
}

func (x *Trigger) GetElementCount() *Trigger_ElementCount {
	if x, ok := x.GetTrigger().(*Trigger_ElementCount_); ok {
		return x.ElementCount
	}
	return nil
}

func (x *Trigger) GetNever() *Trigger_Never {
	if x, ok := x.GetTrigger().(*Trigger_Never_); ok {
		return x.Never
	}
	return nil
}

func (x *Trigger) GetOrFinally() *Trigger_OrFinally {
	if x, ok := x.GetTrigger().(*Trigger_OrFinally_); ok {
		return x.OrFinally
	}
	return nil
}

func (x *Trigger) GetRepeat() *Trigger_Repeat {
	if x, ok := x.GetTrigger().(*Trigger_Repeat_); ok {
		return x.Repeat
	}
	return nil
}

type isTrigger_Trigger interface {
	isTrigger_Trigger()
}

type Trigger_AfterAll_ struct {
	AfterAll *Trigger_AfterAll `protobuf:"bytes,1,opt,name=after_all,json=afterAll,proto3,oneof"`
}

type Trigger_AfterAny_ struct {
	AfterAny *Trigger_AfterAny `protobuf:"bytes,2,opt,name=after_any,json=afterAny,proto3,oneof"`
}

type Trigger_AfterEach_ struct {
	AfterEach *Trigger_AfterEach `protobuf:"bytes,3,opt,name=after_each,json=afterEach,proto3,oneof"`
}

type Trigger_AfterEndOfWindow_ struct {
	AfterEndOfWindow *Trigger_AfterEndOfWindow `protobuf:"bytes,4,opt,name=after_end_of_window,json=afterEndOfWindow,proto3,oneof"`
}

type Trigger_AfterProcessingTime_ struct {
	AfterProcessingTime *Trigger_AfterProcessingTime `protobuf:"bytes,5,opt,name=after_processing_time,json=afterProcessingTime,proto3,oneof"`
}

type Trigger_AfterSynchronizedProcessingTime_ struct {
	AfterSynchronizedProcessingTime *Trigger_AfterSynchronizedProcessingTime `protobuf:"bytes,6,opt,name=after_synchronized_processing_time,json=afterSynchronizedProcessingTime,proto3,oneof"`
}

type Trigger_Always_ struct {
	Always *Trigger_Always `protobuf:"bytes,12,opt,name=always,proto3,oneof"`
}

type Trigger_Default_ struct {
	Default *Trigger_Default `protobuf:"bytes,7,opt,name=default,proto3,oneof"`
}

type Trigger_ElementCount_ struct {
	ElementCount *Trigger_ElementCount `protobuf:"bytes,8,opt,name=element_count,json=elementCount,proto3,oneof"`
}

type Trigger_Never_ struct {
	Never *Trigger_Never `protobuf:"bytes,9,opt,name=never,proto3,oneof"`
}

type Trigger_OrFinally_ struct {
	OrFinally *Trigger_OrFinally `protobuf:"bytes,10,opt,name=or_finally,json=orFinally,proto3,oneof"`
}

type Trigger_Repeat_ struct {
	Repeat *Trigger_Repeat `protobuf:"bytes,11,opt,name=repeat,proto3,oneof"`
}

func (*Trigger_AfterAll_) isTrigger_Trigger() {}

func (*Trigger_AfterAny_) isTrigger_Trigger() {}

func (*Trigger_AfterEach_) isTrigger_Trigger() {}

func (*Trigger_AfterEndOfWindow_) isTrigger_Trigger() {}

func (*Trigger_AfterProcessingTime_) isTrigger_Trigger() {}

func (*Trigger_AfterSynchronizedProcessingTime_) isTrigger_Trigger() {}

func (*Trigger_Always_) isTrigger_Trigger() {}

func (*Trigger_Default_) isTrigger_Trigger() {}

func (*Trigger_ElementCount_) isTrigger_Trigger() {}

func (*Trigger_Never_) isTrigger_Trigger() {}

func (*Trigger_OrFinally_) isTrigger_Trigger() {}

func (*Trigger_Repeat_) isTrigger_Trigger() {}

// A specification for a transformation on a timestamp.
//
// Primarily used by AfterProcessingTime triggers to transform
// the arrival time of input to a target time for firing.
type TimestampTransform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to TimestampTransform:
	//	*TimestampTransform_Delay_
	//	*TimestampTransform_AlignTo_
	TimestampTransform isTimestampTransform_TimestampTransform `protobuf_oneof:"timestamp_transform"`
}

func (x *TimestampTransform) Reset() {
	*x = TimestampTransform{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampTransform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampTransform) ProtoMessage() {}

func (x *TimestampTransform) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampTransform.ProtoReflect.Descriptor instead.
func (*TimestampTransform) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{36}
}

func (m *TimestampTransform) GetTimestampTransform() isTimestampTransform_TimestampTransform {
	if m != nil {
		return m.TimestampTransform
	}
	return nil
}

func (x *TimestampTransform) GetDelay() *TimestampTransform_Delay {
	if x, ok := x.GetTimestampTransform().(*TimestampTransform_Delay_); ok {
		return x.Delay
	}
	return nil
}

func (x *TimestampTransform) GetAlignTo() *TimestampTransform_AlignTo {
	if x, ok := x.GetTimestampTransform().(*TimestampTransform_AlignTo_); ok {
		return x.AlignTo
	}
	return nil
}

type isTimestampTransform_TimestampTransform interface {
	isTimestampTransform_TimestampTransform()
}

type TimestampTransform_Delay_ struct {
	Delay *TimestampTransform_Delay `protobuf:"bytes,1,opt,name=delay,proto3,oneof"`
}

type TimestampTransform_AlignTo_ struct {
	AlignTo *TimestampTransform_AlignTo `protobuf:"bytes,2,opt,name=align_to,json=alignTo,proto3,oneof"`
}

func (*TimestampTransform_Delay_) isTimestampTransform_TimestampTransform() {}

func (*TimestampTransform_AlignTo_) isTimestampTransform_TimestampTransform() {}

// A specification for how to "side input" a PCollection.
type SideInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) URN of the access pattern required by the `view_fn` to present
	// the desired SDK-specific interface to a UDF.
	//
	// This access pattern defines the SDK harness <-> Runner Harness RPC
	// interface for accessing a side input.
	//
	// The only access pattern intended for Beam, because of its superior
	// performance possibilities, is "beam:sideinput:multimap" (or some such
	// URN)
	AccessPattern *FunctionSpec `protobuf:"bytes,1,opt,name=access_pattern,json=accessPattern,proto3" json:"access_pattern,omitempty"`
	// (Required) The FunctionSpec of the UDF that adapts a particular
	// access_pattern to a user-facing view type.
	//
	// For example, View.asSingleton() may include a `view_fn` that adapts a
	// specially-designed multimap to a single value per window.
	ViewFn *FunctionSpec `protobuf:"bytes,2,opt,name=view_fn,json=viewFn,proto3" json:"view_fn,omitempty"`
	// (Required) The FunctionSpec of the UDF that maps a main input window
	// to a side input window.
	//
	// For example, when the main input is in fixed windows of one hour, this
	// can specify that the side input should be accessed according to the day
	// in which that hour falls.
	WindowMappingFn *FunctionSpec `protobuf:"bytes,3,opt,name=window_mapping_fn,json=windowMappingFn,proto3" json:"window_mapping_fn,omitempty"`
}

func (x *SideInput) Reset() {
	*x = SideInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SideInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SideInput) ProtoMessage() {}

func (x *SideInput) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SideInput.ProtoReflect.Descriptor instead.
func (*SideInput) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{37}
}

func (x *SideInput) GetAccessPattern() *FunctionSpec {
	if x != nil {
		return x.AccessPattern
	}
	return nil
}

func (x *SideInput) GetViewFn() *FunctionSpec {
	if x != nil {
		return x.ViewFn
	}
	return nil
}

func (x *SideInput) GetWindowMappingFn() *FunctionSpec {
	if x != nil {
		return x.WindowMappingFn
	}
	return nil
}

type StandardArtifacts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardArtifacts) Reset() {
	*x = StandardArtifacts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardArtifacts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardArtifacts) ProtoMessage() {}

func (x *StandardArtifacts) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardArtifacts.ProtoReflect.Descriptor instead.
func (*StandardArtifacts) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{38}
}

type ArtifactFilePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// a string for an artifact file path e.g. "/tmp/foo.jar"
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The hex-encoded sha256 checksum of the artifact.
	Sha256 string `protobuf:"bytes,2,opt,name=sha256,proto3" json:"sha256,omitempty"`
}

func (x *ArtifactFilePayload) Reset() {
	*x = ArtifactFilePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactFilePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactFilePayload) ProtoMessage() {}

func (x *ArtifactFilePayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactFilePayload.ProtoReflect.Descriptor instead.
func (*ArtifactFilePayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{39}
}

func (x *ArtifactFilePayload) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ArtifactFilePayload) GetSha256() string {
	if x != nil {
		return x.Sha256
	}
	return ""
}

type ArtifactUrlPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// a string for an artifact URL e.g. "https://.../foo.jar" or "gs://tmp/foo.jar"
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// (Optional) The hex-encoded sha256 checksum of the artifact if available.
	Sha256 string `protobuf:"bytes,2,opt,name=sha256,proto3" json:"sha256,omitempty"`
}

func (x *ArtifactUrlPayload) Reset() {
	*x = ArtifactUrlPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactUrlPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactUrlPayload) ProtoMessage() {}

func (x *ArtifactUrlPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactUrlPayload.ProtoReflect.Descriptor instead.
func (*ArtifactUrlPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{40}
}

func (x *ArtifactUrlPayload) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *ArtifactUrlPayload) GetSha256() string {
	if x != nil {
		return x.Sha256
	}
	return ""
}

type EmbeddedFilePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// raw data bytes for an embedded artifact
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *EmbeddedFilePayload) Reset() {
	*x = EmbeddedFilePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EmbeddedFilePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmbeddedFilePayload) ProtoMessage() {}

func (x *EmbeddedFilePayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmbeddedFilePayload.ProtoReflect.Descriptor instead.
func (*EmbeddedFilePayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{41}
}

func (x *EmbeddedFilePayload) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

type PyPIPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pypi compatible artifact id e.g. "apache-beam"
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// Pypi compatible version string.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PyPIPayload) Reset() {
	*x = PyPIPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PyPIPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PyPIPayload) ProtoMessage() {}

func (x *PyPIPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PyPIPayload.ProtoReflect.Descriptor instead.
func (*PyPIPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{42}
}

func (x *PyPIPayload) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

func (x *PyPIPayload) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type MavenPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A string specifying Maven artifact.
	// The standard format is "groupId:artifactId:version[:packaging[:classifier]]"
	Artifact string `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	// (Optional) Repository URL. If not specified, Maven central is used by default.
	RepositoryUrl string `protobuf:"bytes,2,opt,name=repository_url,json=repositoryUrl,proto3" json:"repository_url,omitempty"`
}

func (x *MavenPayload) Reset() {
	*x = MavenPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MavenPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenPayload) ProtoMessage() {}

func (x *MavenPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MavenPayload.ProtoReflect.Descriptor instead.
func (*MavenPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{43}
}

func (x *MavenPayload) GetArtifact() string {
	if x != nil {
		return x.Artifact
	}
	return ""
}

func (x *MavenPayload) GetRepositoryUrl() string {
	if x != nil {
		return x.RepositoryUrl
	}
	return ""
}

type DeferredArtifactPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique string identifier assigned by the creator of this payload. The creator may use this key to confirm
	// whether they can parse the data.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Data for deferred artifacts. Interpretation of bytes is delegated to the creator of this payload.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *DeferredArtifactPayload) Reset() {
	*x = DeferredArtifactPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeferredArtifactPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeferredArtifactPayload) ProtoMessage() {}

func (x *DeferredArtifactPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeferredArtifactPayload.ProtoReflect.Descriptor instead.
func (*DeferredArtifactPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{44}
}

func (x *DeferredArtifactPayload) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *DeferredArtifactPayload) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

type ArtifactStagingToRolePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A generated staged name (relative path under staging directory).
	StagedName string `protobuf:"bytes,1,opt,name=staged_name,json=stagedName,proto3" json:"staged_name,omitempty"`
}

func (x *ArtifactStagingToRolePayload) Reset() {
	*x = ArtifactStagingToRolePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactStagingToRolePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactStagingToRolePayload) ProtoMessage() {}

func (x *ArtifactStagingToRolePayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactStagingToRolePayload.ProtoReflect.Descriptor instead.
func (*ArtifactStagingToRolePayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{45}
}

func (x *ArtifactStagingToRolePayload) GetStagedName() string {
	if x != nil {
		return x.StagedName
	}
	return ""
}

type ArtifactInformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A URN that describes the type of artifact
	TypeUrn     string `protobuf:"bytes,1,opt,name=type_urn,json=typeUrn,proto3" json:"type_urn,omitempty"`
	TypePayload []byte `protobuf:"bytes,2,opt,name=type_payload,json=typePayload,proto3" json:"type_payload,omitempty"`
	// A URN that describes the role of artifact
	RoleUrn     string `protobuf:"bytes,3,opt,name=role_urn,json=roleUrn,proto3" json:"role_urn,omitempty"`
	RolePayload []byte `protobuf:"bytes,4,opt,name=role_payload,json=rolePayload,proto3" json:"role_payload,omitempty"`
}

func (x *ArtifactInformation) Reset() {
	*x = ArtifactInformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactInformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactInformation) ProtoMessage() {}

func (x *ArtifactInformation) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactInformation.ProtoReflect.Descriptor instead.
func (*ArtifactInformation) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{46}
}

func (x *ArtifactInformation) GetTypeUrn() string {
	if x != nil {
		return x.TypeUrn
	}
	return ""
}

func (x *ArtifactInformation) GetTypePayload() []byte {
	if x != nil {
		return x.TypePayload
	}
	return nil
}

func (x *ArtifactInformation) GetRoleUrn() string {
	if x != nil {
		return x.RoleUrn
	}
	return ""
}

func (x *ArtifactInformation) GetRolePayload() []byte {
	if x != nil {
		return x.RolePayload
	}
	return nil
}

// An environment for executing UDFs. By default, an SDK container URL, but
// can also be a process forked by a command, or an externally managed process.
type Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The URN of the payload
	Urn string `protobuf:"bytes,2,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// (Optional) Static display data for the environment. If there is none,
	// it may be omitted.
	DisplayData []*DisplayData `protobuf:"bytes,4,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// (Optional) A set of capabilities this environment supports. This is
	// typically a list of common URNs designating coders, transforms, etc. that
	// this environment understands (and a runner MAY use) despite not
	// appearing in the pipeline proto. This may also be used to indicate
	// support of optional protocols not tied to a concrete component.
	Capabilities []string `protobuf:"bytes,5,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
	// (Optional) artifact dependency information used for executing UDFs in this environment.
	Dependencies []*ArtifactInformation `protobuf:"bytes,6,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// (Optional) A mapping of resource URNs to requested values.  The encoding
	// of the values is specified by the URN.  Resource hints are advisory;
	// a runner is free to ignore resource hints that it does not understand.
	ResourceHints map[string][]byte `protobuf:"bytes,7,rep,name=resource_hints,json=resourceHints,proto3" json:"resource_hints,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Environment) Reset() {
	*x = Environment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment) ProtoMessage() {}

func (x *Environment) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment.ProtoReflect.Descriptor instead.
func (*Environment) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{47}
}

func (x *Environment) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *Environment) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *Environment) GetDisplayData() []*DisplayData {
	if x != nil {
		return x.DisplayData
	}
	return nil
}

func (x *Environment) GetCapabilities() []string {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

func (x *Environment) GetDependencies() []*ArtifactInformation {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *Environment) GetResourceHints() map[string][]byte {
	if x != nil {
		return x.ResourceHints
	}
	return nil
}

type StandardEnvironments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardEnvironments) Reset() {
	*x = StandardEnvironments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardEnvironments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardEnvironments) ProtoMessage() {}

func (x *StandardEnvironments) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardEnvironments.ProtoReflect.Descriptor instead.
func (*StandardEnvironments) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{48}
}

// The payload of a Docker image
type DockerPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ContainerImage string `protobuf:"bytes,1,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"` // implicitly linux_amd64.
}

func (x *DockerPayload) Reset() {
	*x = DockerPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DockerPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DockerPayload) ProtoMessage() {}

func (x *DockerPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DockerPayload.ProtoReflect.Descriptor instead.
func (*DockerPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{49}
}

func (x *DockerPayload) GetContainerImage() string {
	if x != nil {
		return x.ContainerImage
	}
	return ""
}

type ProcessPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Os      string            `protobuf:"bytes,1,opt,name=os,proto3" json:"os,omitempty"`                                                                                           // "linux", "darwin", ..
	Arch    string            `protobuf:"bytes,2,opt,name=arch,proto3" json:"arch,omitempty"`                                                                                       // "amd64", ..
	Command string            `protobuf:"bytes,3,opt,name=command,proto3" json:"command,omitempty"`                                                                                 // process to execute
	Env     map[string]string `protobuf:"bytes,4,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Environment variables
}

func (x *ProcessPayload) Reset() {
	*x = ProcessPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessPayload) ProtoMessage() {}

func (x *ProcessPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessPayload.ProtoReflect.Descriptor instead.
func (*ProcessPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{50}
}

func (x *ProcessPayload) GetOs() string {
	if x != nil {
		return x.Os
	}
	return ""
}

func (x *ProcessPayload) GetArch() string {
	if x != nil {
		return x.Arch
	}
	return ""
}

func (x *ProcessPayload) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *ProcessPayload) GetEnv() map[string]string {
	if x != nil {
		return x.Env
	}
	return nil
}

type ExternalPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Endpoint *ApiServiceDescriptor `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Params   map[string]string     `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Arbitrary extra parameters to pass
}

func (x *ExternalPayload) Reset() {
	*x = ExternalPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalPayload) ProtoMessage() {}

func (x *ExternalPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalPayload.ProtoReflect.Descriptor instead.
func (*ExternalPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{51}
}

func (x *ExternalPayload) GetEndpoint() *ApiServiceDescriptor {
	if x != nil {
		return x.Endpoint
	}
	return nil
}

func (x *ExternalPayload) GetParams() map[string]string {
	if x != nil {
		return x.Params
	}
	return nil
}

// These URNs are used to indicate capabilities of environments that cannot
// simply be expressed as a component (such as a Coder or PTransform) that this
// environment understands.
type StandardProtocols struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardProtocols) Reset() {
	*x = StandardProtocols{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardProtocols) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardProtocols) ProtoMessage() {}

func (x *StandardProtocols) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardProtocols.ProtoReflect.Descriptor instead.
func (*StandardProtocols) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{52}
}

// These URNs are used to indicate capabilities of runner that an environment
// may take advantage of when interacting with this runner.
type StandardRunnerProtocols struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardRunnerProtocols) Reset() {
	*x = StandardRunnerProtocols{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardRunnerProtocols) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardRunnerProtocols) ProtoMessage() {}

func (x *StandardRunnerProtocols) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardRunnerProtocols.ProtoReflect.Descriptor instead.
func (*StandardRunnerProtocols) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{53}
}

// These URNs are used to indicate requirements of a pipeline that cannot
// simply be expressed as a component (such as a Coder or PTransform) that the
// runner must understand. In many cases, this indicates a particular field
// of a transform must be inspected and respected (which allows new fields
// to be added in a forwards-compatible way).
type StandardRequirements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardRequirements) Reset() {
	*x = StandardRequirements{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardRequirements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardRequirements) ProtoMessage() {}

func (x *StandardRequirements) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardRequirements.ProtoReflect.Descriptor instead.
func (*StandardRequirements) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{54}
}

// A URN along with a parameter object whose schema is determined by the
// URN.
//
// This structure is reused in two distinct, but compatible, ways:
//
// 1. This can be a specification of the function over PCollections
//    that a PTransform computes.
// 2. This can be a specification of a user-defined function, possibly
//    SDK-specific. (external to this message must be adequate context
//    to indicate the environment in which the UDF can be understood).
//
// Though not explicit in this proto, there are two possibilities
// for the relationship of a runner to this specification that
// one should bear in mind:
//
// 1. The runner understands the URN. For example, it might be
//    a well-known URN like "beam:transform:Top" or
//    "beam:window_fn:FixedWindows" with
//    an agreed-upon payload (e.g. a number or duration,
//    respectively).
// 2. The runner does not understand the URN. It might be an
//    SDK specific URN such as "beam:dofn:javasdk:1.0"
//    that indicates to the SDK what the payload is,
//    such as a serialized Java DoFn from a particular
//    version of the Beam Java SDK. The payload will often
//    then be an opaque message such as bytes in a
//    language-specific serialization format.
type FunctionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A URN that describes the accompanying payload.
	// For any URN that is not recognized (by whomever is inspecting
	// it) the parameter payload should be treated as opaque and
	// passed as-is.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *FunctionSpec) Reset() {
	*x = FunctionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionSpec) ProtoMessage() {}

func (x *FunctionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionSpec.ProtoReflect.Descriptor instead.
func (*FunctionSpec) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{55}
}

func (x *FunctionSpec) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *FunctionSpec) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// A set of well known URNs describing display data.
//
// All descriptions must contain how the value should be classified and how it
// is encoded. Note that some types are logical types which convey contextual
// information about the pipeline in addition to an encoding while others only
// specify the encoding itself.
type StandardDisplayData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardDisplayData) Reset() {
	*x = StandardDisplayData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardDisplayData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardDisplayData) ProtoMessage() {}

func (x *StandardDisplayData) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardDisplayData.ProtoReflect.Descriptor instead.
func (*StandardDisplayData) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{56}
}

type LabelledPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A human readable label for the value.
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	// (Required) A value which will be displayed to the user.
	//
	// Types that are assignable to Value:
	//	*LabelledPayload_StringValue
	//	*LabelledPayload_BoolValue
	//	*LabelledPayload_DoubleValue
	Value isLabelledPayload_Value `protobuf_oneof:"value"`
}

func (x *LabelledPayload) Reset() {
	*x = LabelledPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelledPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelledPayload) ProtoMessage() {}

func (x *LabelledPayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelledPayload.ProtoReflect.Descriptor instead.
func (*LabelledPayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{57}
}

func (x *LabelledPayload) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (m *LabelledPayload) GetValue() isLabelledPayload_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *LabelledPayload) GetStringValue() string {
	if x, ok := x.GetValue().(*LabelledPayload_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *LabelledPayload) GetBoolValue() bool {
	if x, ok := x.GetValue().(*LabelledPayload_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *LabelledPayload) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*LabelledPayload_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

type isLabelledPayload_Value interface {
	isLabelledPayload_Value()
}

type LabelledPayload_StringValue struct {
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type LabelledPayload_BoolValue struct {
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type LabelledPayload_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*LabelledPayload_StringValue) isLabelledPayload_Value() {}

func (*LabelledPayload_BoolValue) isLabelledPayload_Value() {}

func (*LabelledPayload_DoubleValue) isLabelledPayload_Value() {}

// Static display data associated with a pipeline component. Display data is
// useful for pipeline runners IOs and diagnostic dashboards to display details
// about annotated components.
type DisplayData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A key used to describe the type of display data. See StandardDisplayData
	// for the set of well known urns describing how the payload is meant to be
	// interpreted.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *DisplayData) Reset() {
	*x = DisplayData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisplayData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayData) ProtoMessage() {}

func (x *DisplayData) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayData.ProtoReflect.Descriptor instead.
func (*DisplayData) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{58}
}

func (x *DisplayData) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *DisplayData) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// A disjoint union of all the things that may contain references
// that require Components to resolve.
type MessageWithComponents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Optional) The by-reference components of the root message,
	// enabling a standalone message.
	//
	// If this is absent, it is expected that there are no
	// references.
	Components *Components `protobuf:"bytes,1,opt,name=components,proto3" json:"components,omitempty"`
	// (Required) The root message that may contain pointers
	// that should be resolved by looking inside components.
	//
	// Types that are assignable to Root:
	//	*MessageWithComponents_Coder
	//	*MessageWithComponents_CombinePayload
	//	*MessageWithComponents_FunctionSpec
	//	*MessageWithComponents_ParDoPayload
	//	*MessageWithComponents_Ptransform
	//	*MessageWithComponents_Pcollection
	//	*MessageWithComponents_ReadPayload
	//	*MessageWithComponents_SideInput
	//	*MessageWithComponents_WindowIntoPayload
	//	*MessageWithComponents_WindowingStrategy
	Root isMessageWithComponents_Root `protobuf_oneof:"root"`
}

func (x *MessageWithComponents) Reset() {
	*x = MessageWithComponents{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageWithComponents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageWithComponents) ProtoMessage() {}

func (x *MessageWithComponents) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageWithComponents.ProtoReflect.Descriptor instead.
func (*MessageWithComponents) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{59}
}

func (x *MessageWithComponents) GetComponents() *Components {
	if x != nil {
		return x.Components
	}
	return nil
}

func (m *MessageWithComponents) GetRoot() isMessageWithComponents_Root {
	if m != nil {
		return m.Root
	}
	return nil
}

func (x *MessageWithComponents) GetCoder() *Coder {
	if x, ok := x.GetRoot().(*MessageWithComponents_Coder); ok {
		return x.Coder
	}
	return nil
}

func (x *MessageWithComponents) GetCombinePayload() *CombinePayload {
	if x, ok := x.GetRoot().(*MessageWithComponents_CombinePayload); ok {
		return x.CombinePayload
	}
	return nil
}

func (x *MessageWithComponents) GetFunctionSpec() *FunctionSpec {
	if x, ok := x.GetRoot().(*MessageWithComponents_FunctionSpec); ok {
		return x.FunctionSpec
	}
	return nil
}

func (x *MessageWithComponents) GetParDoPayload() *ParDoPayload {
	if x, ok := x.GetRoot().(*MessageWithComponents_ParDoPayload); ok {
		return x.ParDoPayload
	}
	return nil
}

func (x *MessageWithComponents) GetPtransform() *PTransform {
	if x, ok := x.GetRoot().(*MessageWithComponents_Ptransform); ok {
		return x.Ptransform
	}
	return nil
}

func (x *MessageWithComponents) GetPcollection() *PCollection {
	if x, ok := x.GetRoot().(*MessageWithComponents_Pcollection); ok {
		return x.Pcollection
	}
	return nil
}

func (x *MessageWithComponents) GetReadPayload() *ReadPayload {
	if x, ok := x.GetRoot().(*MessageWithComponents_ReadPayload); ok {
		return x.ReadPayload
	}
	return nil
}

func (x *MessageWithComponents) GetSideInput() *SideInput {
	if x, ok := x.GetRoot().(*MessageWithComponents_SideInput); ok {
		return x.SideInput
	}
	return nil
}

func (x *MessageWithComponents) GetWindowIntoPayload() *WindowIntoPayload {
	if x, ok := x.GetRoot().(*MessageWithComponents_WindowIntoPayload); ok {
		return x.WindowIntoPayload
	}
	return nil
}

func (x *MessageWithComponents) GetWindowingStrategy() *WindowingStrategy {
	if x, ok := x.GetRoot().(*MessageWithComponents_WindowingStrategy); ok {
		return x.WindowingStrategy
	}
	return nil
}

type isMessageWithComponents_Root interface {
	isMessageWithComponents_Root()
}

type MessageWithComponents_Coder struct {
	Coder *Coder `protobuf:"bytes,2,opt,name=coder,proto3,oneof"`
}

type MessageWithComponents_CombinePayload struct {
	CombinePayload *CombinePayload `protobuf:"bytes,3,opt,name=combine_payload,json=combinePayload,proto3,oneof"`
}

type MessageWithComponents_FunctionSpec struct {
	FunctionSpec *FunctionSpec `protobuf:"bytes,4,opt,name=function_spec,json=functionSpec,proto3,oneof"`
}

type MessageWithComponents_ParDoPayload struct {
	ParDoPayload *ParDoPayload `protobuf:"bytes,6,opt,name=par_do_payload,json=parDoPayload,proto3,oneof"`
}

type MessageWithComponents_Ptransform struct {
	Ptransform *PTransform `protobuf:"bytes,7,opt,name=ptransform,proto3,oneof"`
}

type MessageWithComponents_Pcollection struct {
	Pcollection *PCollection `protobuf:"bytes,8,opt,name=pcollection,proto3,oneof"`
}

type MessageWithComponents_ReadPayload struct {
	ReadPayload *ReadPayload `protobuf:"bytes,9,opt,name=read_payload,json=readPayload,proto3,oneof"`
}

type MessageWithComponents_SideInput struct {
	SideInput *SideInput `protobuf:"bytes,11,opt,name=side_input,json=sideInput,proto3,oneof"`
}

type MessageWithComponents_WindowIntoPayload struct {
	WindowIntoPayload *WindowIntoPayload `protobuf:"bytes,12,opt,name=window_into_payload,json=windowIntoPayload,proto3,oneof"`
}

type MessageWithComponents_WindowingStrategy struct {
	WindowingStrategy *WindowingStrategy `protobuf:"bytes,13,opt,name=windowing_strategy,json=windowingStrategy,proto3,oneof"`
}

func (*MessageWithComponents_Coder) isMessageWithComponents_Root() {}

func (*MessageWithComponents_CombinePayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_FunctionSpec) isMessageWithComponents_Root() {}

func (*MessageWithComponents_ParDoPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_Ptransform) isMessageWithComponents_Root() {}

func (*MessageWithComponents_Pcollection) isMessageWithComponents_Root() {}

func (*MessageWithComponents_ReadPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_SideInput) isMessageWithComponents_Root() {}

func (*MessageWithComponents_WindowIntoPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_WindowingStrategy) isMessageWithComponents_Root() {}

// The payload for an executable stage. This will eventually be passed to an SDK in the form of a
// ProcessBundleDescriptor.
type ExecutableStagePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) Environment in which this stage executes.
	//
	// We use an environment rather than environment id
	// because ExecutableStages use environments directly. This may change in the future.
	Environment *Environment `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// The wire coder settings of this executable stage
	WireCoderSettings []*ExecutableStagePayload_WireCoderSetting `protobuf:"bytes,9,rep,name=wire_coder_settings,json=wireCoderSettings,proto3" json:"wire_coder_settings,omitempty"`
	// (Required) Input PCollection id. This must be present as a value in the inputs of any
	// PTransform the ExecutableStagePayload is the payload of.
	Input string `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// The side inputs required for this executable stage. Each side input of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	SideInputs []*ExecutableStagePayload_SideInputId `protobuf:"bytes,3,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty"`
	// PTransform ids contained within this executable stage. This must contain at least one
	// PTransform id.
	Transforms []string `protobuf:"bytes,4,rep,name=transforms,proto3" json:"transforms,omitempty"`
	// Output PCollection ids. This must be equal to the values of the outputs of any
	// PTransform the ExecutableStagePayload is the payload of.
	Outputs []string `protobuf:"bytes,5,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// (Required) The components for the Executable Stage. This must contain all of the Transforms
	// in transforms, and the closure of all of the components they recognize.
	Components *Components `protobuf:"bytes,6,opt,name=components,proto3" json:"components,omitempty"`
	// The user states required for this executable stage. Each user state of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	UserStates []*ExecutableStagePayload_UserStateId `protobuf:"bytes,7,rep,name=user_states,json=userStates,proto3" json:"user_states,omitempty"`
	// The timers required for this executable stage. Each timer of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	Timers []*ExecutableStagePayload_TimerId `protobuf:"bytes,8,rep,name=timers,proto3" json:"timers,omitempty"`
	// The timerfamilies required for this executable stage. Each timer familyof each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	TimerFamilies []*ExecutableStagePayload_TimerFamilyId `protobuf:"bytes,10,rep,name=timerFamilies,proto3" json:"timerFamilies,omitempty"`
}

func (x *ExecutableStagePayload) Reset() {
	*x = ExecutableStagePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutableStagePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableStagePayload) ProtoMessage() {}

func (x *ExecutableStagePayload) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableStagePayload.ProtoReflect.Descriptor instead.
func (*ExecutableStagePayload) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{60}
}

func (x *ExecutableStagePayload) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *ExecutableStagePayload) GetWireCoderSettings() []*ExecutableStagePayload_WireCoderSetting {
	if x != nil {
		return x.WireCoderSettings
	}
	return nil
}

func (x *ExecutableStagePayload) GetInput() string {
	if x != nil {
		return x.Input
	}
	return ""
}

func (x *ExecutableStagePayload) GetSideInputs() []*ExecutableStagePayload_SideInputId {
	if x != nil {
		return x.SideInputs
	}
	return nil
}

func (x *ExecutableStagePayload) GetTransforms() []string {
	if x != nil {
		return x.Transforms
	}
	return nil
}

func (x *ExecutableStagePayload) GetOutputs() []string {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *ExecutableStagePayload) GetComponents() *Components {
	if x != nil {
		return x.Components
	}
	return nil
}

func (x *ExecutableStagePayload) GetUserStates() []*ExecutableStagePayload_UserStateId {
	if x != nil {
		return x.UserStates
	}
	return nil
}

func (x *ExecutableStagePayload) GetTimers() []*ExecutableStagePayload_TimerId {
	if x != nil {
		return x.Timers
	}
	return nil
}

func (x *ExecutableStagePayload) GetTimerFamilies() []*ExecutableStagePayload_TimerFamilyId {
	if x != nil {
		return x.TimerFamilies
	}
	return nil
}

type StandardResourceHints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StandardResourceHints) Reset() {
	*x = StandardResourceHints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandardResourceHints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardResourceHints) ProtoMessage() {}

func (x *StandardResourceHints) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardResourceHints.ProtoReflect.Descriptor instead.
func (*StandardResourceHints) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{61}
}

type TestStreamPayload_Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//	*TestStreamPayload_Event_WatermarkEvent
	//	*TestStreamPayload_Event_ProcessingTimeEvent
	//	*TestStreamPayload_Event_ElementEvent
	Event isTestStreamPayload_Event_Event `protobuf_oneof:"event"`
}

func (x *TestStreamPayload_Event) Reset() {
	*x = TestStreamPayload_Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestStreamPayload_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestStreamPayload_Event) ProtoMessage() {}

func (x *TestStreamPayload_Event) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestStreamPayload_Event.ProtoReflect.Descriptor instead.
func (*TestStreamPayload_Event) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{20, 0}
}

func (m *TestStreamPayload_Event) GetEvent() isTestStreamPayload_Event_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *TestStreamPayload_Event) GetWatermarkEvent() *TestStreamPayload_Event_AdvanceWatermark {
	if x, ok := x.GetEvent().(*TestStreamPayload_Event_WatermarkEvent); ok {
		return x.WatermarkEvent
	}
	return nil
}

func (x *TestStreamPayload_Event) GetProcessingTimeEvent() *TestStreamPayload_Event_AdvanceProcessingTime {
	if x, ok := x.GetEvent().(*TestStreamPayload_Event_ProcessingTimeEvent); ok {
		return x.ProcessingTimeEvent
	}
	return nil
}

func (x *TestStreamPayload_Event) GetElementEvent() *TestStreamPayload_Event_AddElements {
	if x, ok := x.GetEvent().(*TestStreamPayload_Event_ElementEvent); ok {
		return x.ElementEvent
	}
	return nil
}

type isTestStreamPayload_Event_Event interface {
	isTestStreamPayload_Event_Event()
}

type TestStreamPayload_Event_WatermarkEvent struct {
	WatermarkEvent *TestStreamPayload_Event_AdvanceWatermark `protobuf:"bytes,1,opt,name=watermark_event,json=watermarkEvent,proto3,oneof"`
}

type TestStreamPayload_Event_ProcessingTimeEvent struct {
	ProcessingTimeEvent *TestStreamPayload_Event_AdvanceProcessingTime `protobuf:"bytes,2,opt,name=processing_time_event,json=processingTimeEvent,proto3,oneof"`
}

type TestStreamPayload_Event_ElementEvent struct {
	ElementEvent *TestStreamPayload_Event_AddElements `protobuf:"bytes,3,opt,name=element_event,json=elementEvent,proto3,oneof"`
}

func (*TestStreamPayload_Event_WatermarkEvent) isTestStreamPayload_Event_Event() {}

func (*TestStreamPayload_Event_ProcessingTimeEvent) isTestStreamPayload_Event_Event() {}

func (*TestStreamPayload_Event_ElementEvent) isTestStreamPayload_Event_Event() {}

// A single element inside of the TestStream.
type TestStreamPayload_TimestampedElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The element encoded. Currently the TestStream only supports
	// encoding primitives.
	EncodedElement []byte `protobuf:"bytes,1,opt,name=encoded_element,json=encodedElement,proto3" json:"encoded_element,omitempty"`
	// (Required) The event timestamp in millisecond of this element.
	Timestamp int64 `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *TestStreamPayload_TimestampedElement) Reset() {
	*x = TestStreamPayload_TimestampedElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestStreamPayload_TimestampedElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestStreamPayload_TimestampedElement) ProtoMessage() {}

func (x *TestStreamPayload_TimestampedElement) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestStreamPayload_TimestampedElement.ProtoReflect.Descriptor instead.
func (*TestStreamPayload_TimestampedElement) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{20, 1}
}

func (x *TestStreamPayload_TimestampedElement) GetEncodedElement() []byte {
	if x != nil {
		return x.EncodedElement
	}
	return nil
}

func (x *TestStreamPayload_TimestampedElement) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

// Advances the watermark to the specified timestamp.
type TestStreamPayload_Event_AdvanceWatermark struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The watermark in millisecond to advance to.
	NewWatermark int64 `protobuf:"varint,1,opt,name=new_watermark,json=newWatermark,proto3" json:"new_watermark,omitempty"`
	// (Optional) The output watermark tag for a PCollection. If unspecified
	// or with an empty string, this will default to the Main PCollection
	// Output
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *TestStreamPayload_Event_AdvanceWatermark) Reset() {
	*x = TestStreamPayload_Event_AdvanceWatermark{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestStreamPayload_Event_AdvanceWatermark) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestStreamPayload_Event_AdvanceWatermark) ProtoMessage() {}

func (x *TestStreamPayload_Event_AdvanceWatermark) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestStreamPayload_Event_AdvanceWatermark.ProtoReflect.Descriptor instead.
func (*TestStreamPayload_Event_AdvanceWatermark) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{20, 0, 0}
}

func (x *TestStreamPayload_Event_AdvanceWatermark) GetNewWatermark() int64 {
	if x != nil {
		return x.NewWatermark
	}
	return 0
}

func (x *TestStreamPayload_Event_AdvanceWatermark) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// Advances the processing time clock by the specified amount.
type TestStreamPayload_Event_AdvanceProcessingTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The duration in millisecond to advance by.
	AdvanceDuration int64 `protobuf:"varint,1,opt,name=advance_duration,json=advanceDuration,proto3" json:"advance_duration,omitempty"`
}

func (x *TestStreamPayload_Event_AdvanceProcessingTime) Reset() {
	*x = TestStreamPayload_Event_AdvanceProcessingTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestStreamPayload_Event_AdvanceProcessingTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestStreamPayload_Event_AdvanceProcessingTime) ProtoMessage() {}

func (x *TestStreamPayload_Event_AdvanceProcessingTime) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestStreamPayload_Event_AdvanceProcessingTime.ProtoReflect.Descriptor instead.
func (*TestStreamPayload_Event_AdvanceProcessingTime) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{20, 0, 1}
}

func (x *TestStreamPayload_Event_AdvanceProcessingTime) GetAdvanceDuration() int64 {
	if x != nil {
		return x.AdvanceDuration
	}
	return 0
}

// Adds elements to the stream to be emitted.
type TestStreamPayload_Event_AddElements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The elements to add to the TestStream.
	Elements []*TestStreamPayload_TimestampedElement `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	// (Optional) The output PCollection tag to add these elements to. If
	// unspecified or with an empty string, this will default to the Main
	// PCollection Output.
	Tag string `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *TestStreamPayload_Event_AddElements) Reset() {
	*x = TestStreamPayload_Event_AddElements{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestStreamPayload_Event_AddElements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestStreamPayload_Event_AddElements) ProtoMessage() {}

func (x *TestStreamPayload_Event_AddElements) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestStreamPayload_Event_AddElements.ProtoReflect.Descriptor instead.
func (*TestStreamPayload_Event_AddElements) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{20, 0, 2}
}

func (x *TestStreamPayload_Event_AddElements) GetElements() []*TestStreamPayload_TimestampedElement {
	if x != nil {
		return x.Elements
	}
	return nil
}

func (x *TestStreamPayload_Event_AddElements) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// Ready when all subtriggers are ready.
type Trigger_AfterAll struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subtriggers []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
}

func (x *Trigger_AfterAll) Reset() {
	*x = Trigger_AfterAll{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_AfterAll) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_AfterAll) ProtoMessage() {}

func (x *Trigger_AfterAll) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_AfterAll.ProtoReflect.Descriptor instead.
func (*Trigger_AfterAll) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 0}
}

func (x *Trigger_AfterAll) GetSubtriggers() []*Trigger {
	if x != nil {
		return x.Subtriggers
	}
	return nil
}

// Ready when any subtrigger is ready.
type Trigger_AfterAny struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subtriggers []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
}

func (x *Trigger_AfterAny) Reset() {
	*x = Trigger_AfterAny{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_AfterAny) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_AfterAny) ProtoMessage() {}

func (x *Trigger_AfterAny) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_AfterAny.ProtoReflect.Descriptor instead.
func (*Trigger_AfterAny) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 1}
}

func (x *Trigger_AfterAny) GetSubtriggers() []*Trigger {
	if x != nil {
		return x.Subtriggers
	}
	return nil
}

// Starting with the first subtrigger, ready when the _current_ subtrigger
// is ready. After output, advances the current trigger by one.
type Trigger_AfterEach struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Subtriggers []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
}

func (x *Trigger_AfterEach) Reset() {
	*x = Trigger_AfterEach{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_AfterEach) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_AfterEach) ProtoMessage() {}

func (x *Trigger_AfterEach) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_AfterEach.ProtoReflect.Descriptor instead.
func (*Trigger_AfterEach) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 2}
}

func (x *Trigger_AfterEach) GetSubtriggers() []*Trigger {
	if x != nil {
		return x.Subtriggers
	}
	return nil
}

// Ready after the input watermark is past the end of the window.
//
// May have implicitly-repeated subtriggers for early and late firings.
// When the end of the window is reached, the trigger transitions between
// the subtriggers.
type Trigger_AfterEndOfWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Optional) A trigger governing output prior to the end of the window.
	EarlyFirings *Trigger `protobuf:"bytes,1,opt,name=early_firings,json=earlyFirings,proto3" json:"early_firings,omitempty"`
	// (Optional) A trigger governing output after the end of the window.
	LateFirings *Trigger `protobuf:"bytes,2,opt,name=late_firings,json=lateFirings,proto3" json:"late_firings,omitempty"`
}

func (x *Trigger_AfterEndOfWindow) Reset() {
	*x = Trigger_AfterEndOfWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_AfterEndOfWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_AfterEndOfWindow) ProtoMessage() {}

func (x *Trigger_AfterEndOfWindow) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_AfterEndOfWindow.ProtoReflect.Descriptor instead.
func (*Trigger_AfterEndOfWindow) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 3}
}

func (x *Trigger_AfterEndOfWindow) GetEarlyFirings() *Trigger {
	if x != nil {
		return x.EarlyFirings
	}
	return nil
}

func (x *Trigger_AfterEndOfWindow) GetLateFirings() *Trigger {
	if x != nil {
		return x.LateFirings
	}
	return nil
}

// After input arrives, ready when the specified delay has passed.
type Trigger_AfterProcessingTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The transforms to apply to an arriving element's timestamp,
	// in order
	TimestampTransforms []*TimestampTransform `protobuf:"bytes,1,rep,name=timestamp_transforms,json=timestampTransforms,proto3" json:"timestamp_transforms,omitempty"`
}

func (x *Trigger_AfterProcessingTime) Reset() {
	*x = Trigger_AfterProcessingTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_AfterProcessingTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_AfterProcessingTime) ProtoMessage() {}

func (x *Trigger_AfterProcessingTime) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_AfterProcessingTime.ProtoReflect.Descriptor instead.
func (*Trigger_AfterProcessingTime) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 4}
}

func (x *Trigger_AfterProcessingTime) GetTimestampTransforms() []*TimestampTransform {
	if x != nil {
		return x.TimestampTransforms
	}
	return nil
}

// Ready whenever upstream processing time has all caught up with
// the arrival time of an input element
type Trigger_AfterSynchronizedProcessingTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Trigger_AfterSynchronizedProcessingTime) Reset() {
	*x = Trigger_AfterSynchronizedProcessingTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_AfterSynchronizedProcessingTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_AfterSynchronizedProcessingTime) ProtoMessage() {}

func (x *Trigger_AfterSynchronizedProcessingTime) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_AfterSynchronizedProcessingTime.ProtoReflect.Descriptor instead.
func (*Trigger_AfterSynchronizedProcessingTime) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 5}
}

// The default trigger. Equivalent to Repeat { AfterEndOfWindow } but
// specially denoted to indicate the user did not alter the triggering.
type Trigger_Default struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Trigger_Default) Reset() {
	*x = Trigger_Default{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_Default) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_Default) ProtoMessage() {}

func (x *Trigger_Default) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_Default.ProtoReflect.Descriptor instead.
func (*Trigger_Default) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 6}
}

// Ready whenever the requisite number of input elements have arrived
type Trigger_ElementCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ElementCount int32 `protobuf:"varint,1,opt,name=element_count,json=elementCount,proto3" json:"element_count,omitempty"`
}

func (x *Trigger_ElementCount) Reset() {
	*x = Trigger_ElementCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_ElementCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_ElementCount) ProtoMessage() {}

func (x *Trigger_ElementCount) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_ElementCount.ProtoReflect.Descriptor instead.
func (*Trigger_ElementCount) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 7}
}

func (x *Trigger_ElementCount) GetElementCount() int32 {
	if x != nil {
		return x.ElementCount
	}
	return 0
}

// Never ready. There will only be an ON_TIME output and a final
// output at window expiration.
type Trigger_Never struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Trigger_Never) Reset() {
	*x = Trigger_Never{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_Never) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_Never) ProtoMessage() {}

func (x *Trigger_Never) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_Never.ProtoReflect.Descriptor instead.
func (*Trigger_Never) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 8}
}

// Always ready. This can also be expressed as ElementCount(1) but
// is more explicit.
type Trigger_Always struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Trigger_Always) Reset() {
	*x = Trigger_Always{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_Always) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_Always) ProtoMessage() {}

func (x *Trigger_Always) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_Always.ProtoReflect.Descriptor instead.
func (*Trigger_Always) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 9}
}

// Ready whenever either of its subtriggers are ready, but finishes output
// when the finally subtrigger fires.
type Trigger_OrFinally struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) Trigger governing main output; may fire repeatedly.
	Main *Trigger `protobuf:"bytes,1,opt,name=main,proto3" json:"main,omitempty"`
	// (Required) Trigger governing termination of output.
	Finally *Trigger `protobuf:"bytes,2,opt,name=finally,proto3" json:"finally,omitempty"`
}

func (x *Trigger_OrFinally) Reset() {
	*x = Trigger_OrFinally{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_OrFinally) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_OrFinally) ProtoMessage() {}

func (x *Trigger_OrFinally) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_OrFinally.ProtoReflect.Descriptor instead.
func (*Trigger_OrFinally) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 10}
}

func (x *Trigger_OrFinally) GetMain() *Trigger {
	if x != nil {
		return x.Main
	}
	return nil
}

func (x *Trigger_OrFinally) GetFinally() *Trigger {
	if x != nil {
		return x.Finally
	}
	return nil
}

// Ready whenever the subtrigger is ready; resets state when the subtrigger
// completes.
type Trigger_Repeat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Require) Trigger that is run repeatedly.
	Subtrigger *Trigger `protobuf:"bytes,1,opt,name=subtrigger,proto3" json:"subtrigger,omitempty"`
}

func (x *Trigger_Repeat) Reset() {
	*x = Trigger_Repeat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger_Repeat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger_Repeat) ProtoMessage() {}

func (x *Trigger_Repeat) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger_Repeat.ProtoReflect.Descriptor instead.
func (*Trigger_Repeat) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{35, 11}
}

func (x *Trigger_Repeat) GetSubtrigger() *Trigger {
	if x != nil {
		return x.Subtrigger
	}
	return nil
}

type TimestampTransform_Delay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The delay, in milliseconds.
	DelayMillis int64 `protobuf:"varint,1,opt,name=delay_millis,json=delayMillis,proto3" json:"delay_millis,omitempty"`
}

func (x *TimestampTransform_Delay) Reset() {
	*x = TimestampTransform_Delay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampTransform_Delay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampTransform_Delay) ProtoMessage() {}

func (x *TimestampTransform_Delay) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampTransform_Delay.ProtoReflect.Descriptor instead.
func (*TimestampTransform_Delay) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{36, 0}
}

func (x *TimestampTransform_Delay) GetDelayMillis() int64 {
	if x != nil {
		return x.DelayMillis
	}
	return 0
}

type TimestampTransform_AlignTo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A duration to which delays should be quantized
	// in milliseconds.
	Period int64 `protobuf:"varint,3,opt,name=period,proto3" json:"period,omitempty"`
	// (Required) An offset from 0 for the quantization specified by
	// alignment_size, in milliseconds
	Offset int64 `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *TimestampTransform_AlignTo) Reset() {
	*x = TimestampTransform_AlignTo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampTransform_AlignTo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampTransform_AlignTo) ProtoMessage() {}

func (x *TimestampTransform_AlignTo) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampTransform_AlignTo.ProtoReflect.Descriptor instead.
func (*TimestampTransform_AlignTo) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{36, 1}
}

func (x *TimestampTransform_AlignTo) GetPeriod() int64 {
	if x != nil {
		return x.Period
	}
	return 0
}

func (x *TimestampTransform_AlignTo) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// A reference to a side input. Side inputs are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_SideInputId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The id of the PTransform that references this side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this side input from the PTransform that references it.
	LocalName string `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
}

func (x *ExecutableStagePayload_SideInputId) Reset() {
	*x = ExecutableStagePayload_SideInputId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutableStagePayload_SideInputId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableStagePayload_SideInputId) ProtoMessage() {}

func (x *ExecutableStagePayload_SideInputId) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableStagePayload_SideInputId.ProtoReflect.Descriptor instead.
func (*ExecutableStagePayload_SideInputId) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{60, 0}
}

func (x *ExecutableStagePayload_SideInputId) GetTransformId() string {
	if x != nil {
		return x.TransformId
	}
	return ""
}

func (x *ExecutableStagePayload_SideInputId) GetLocalName() string {
	if x != nil {
		return x.LocalName
	}
	return ""
}

// A reference to user state. User states are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_UserStateId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The id of the PTransform that references this user state.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this user state for the PTransform that references it.
	LocalName string `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
}

func (x *ExecutableStagePayload_UserStateId) Reset() {
	*x = ExecutableStagePayload_UserStateId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutableStagePayload_UserStateId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableStagePayload_UserStateId) ProtoMessage() {}

func (x *ExecutableStagePayload_UserStateId) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableStagePayload_UserStateId.ProtoReflect.Descriptor instead.
func (*ExecutableStagePayload_UserStateId) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{60, 1}
}

func (x *ExecutableStagePayload_UserStateId) GetTransformId() string {
	if x != nil {
		return x.TransformId
	}
	return ""
}

func (x *ExecutableStagePayload_UserStateId) GetLocalName() string {
	if x != nil {
		return x.LocalName
	}
	return ""
}

// A reference to a timer. Timers are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_TimerId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The id of the PTransform that references this timer.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this timer for the PTransform that references it.
	LocalName string `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
}

func (x *ExecutableStagePayload_TimerId) Reset() {
	*x = ExecutableStagePayload_TimerId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutableStagePayload_TimerId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableStagePayload_TimerId) ProtoMessage() {}

func (x *ExecutableStagePayload_TimerId) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableStagePayload_TimerId.ProtoReflect.Descriptor instead.
func (*ExecutableStagePayload_TimerId) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{60, 2}
}

func (x *ExecutableStagePayload_TimerId) GetTransformId() string {
	if x != nil {
		return x.TransformId
	}
	return ""
}

func (x *ExecutableStagePayload_TimerId) GetLocalName() string {
	if x != nil {
		return x.LocalName
	}
	return ""
}

// A reference to a timer. Timers are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_TimerFamilyId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The id of the PTransform that references this timer family.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this timer family for the PTransform that references it.
	LocalName string `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
}

func (x *ExecutableStagePayload_TimerFamilyId) Reset() {
	*x = ExecutableStagePayload_TimerFamilyId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutableStagePayload_TimerFamilyId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableStagePayload_TimerFamilyId) ProtoMessage() {}

func (x *ExecutableStagePayload_TimerFamilyId) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableStagePayload_TimerFamilyId.ProtoReflect.Descriptor instead.
func (*ExecutableStagePayload_TimerFamilyId) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{60, 3}
}

func (x *ExecutableStagePayload_TimerFamilyId) GetTransformId() string {
	if x != nil {
		return x.TransformId
	}
	return ""
}

func (x *ExecutableStagePayload_TimerFamilyId) GetLocalName() string {
	if x != nil {
		return x.LocalName
	}
	return ""
}

// Settings that decide the coder type of wire coder.
type ExecutableStagePayload_WireCoderSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The URN of the wire coder.
	// Note that only windowed value coder or parameterized windowed value coder are supported.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN is beam:coder:windowed_value:v1, this may be omitted. If the URN is
	// beam:coder:param_windowed_value:v1, the payload is an encoded windowed
	// value using the beam:coder:windowed_value:v1 coder parameterized by
	// a beam:coder:bytes:v1 element coder and the window coder that this
	// param_windowed_value coder uses.
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// (Required) The target(PCollection or Timer) this setting applies to.
	//
	// Types that are assignable to Target:
	//	*ExecutableStagePayload_WireCoderSetting_InputOrOutputId
	//	*ExecutableStagePayload_WireCoderSetting_Timer
	Target isExecutableStagePayload_WireCoderSetting_Target `protobuf_oneof:"target"`
}

func (x *ExecutableStagePayload_WireCoderSetting) Reset() {
	*x = ExecutableStagePayload_WireCoderSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_runner_api_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutableStagePayload_WireCoderSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutableStagePayload_WireCoderSetting) ProtoMessage() {}

func (x *ExecutableStagePayload_WireCoderSetting) ProtoReflect() protoreflect.Message {
	mi := &file_beam_runner_api_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutableStagePayload_WireCoderSetting.ProtoReflect.Descriptor instead.
func (*ExecutableStagePayload_WireCoderSetting) Descriptor() ([]byte, []int) {
	return file_beam_runner_api_proto_rawDescGZIP(), []int{60, 4}
}

func (x *ExecutableStagePayload_WireCoderSetting) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *ExecutableStagePayload_WireCoderSetting) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (m *ExecutableStagePayload_WireCoderSetting) GetTarget() isExecutableStagePayload_WireCoderSetting_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *ExecutableStagePayload_WireCoderSetting) GetInputOrOutputId() string {
	if x, ok := x.GetTarget().(*ExecutableStagePayload_WireCoderSetting_InputOrOutputId); ok {
		return x.InputOrOutputId
	}
	return ""
}

func (x *ExecutableStagePayload_WireCoderSetting) GetTimer() *ExecutableStagePayload_TimerId {
	if x, ok := x.GetTarget().(*ExecutableStagePayload_WireCoderSetting_Timer); ok {
		return x.Timer
	}
	return nil
}

type isExecutableStagePayload_WireCoderSetting_Target interface {
	isExecutableStagePayload_WireCoderSetting_Target()
}

type ExecutableStagePayload_WireCoderSetting_InputOrOutputId struct {
	// The input or output PCollection id this setting applies to.
	InputOrOutputId string `protobuf:"bytes,3,opt,name=input_or_output_id,json=inputOrOutputId,proto3,oneof"`
}

type ExecutableStagePayload_WireCoderSetting_Timer struct {
	// The timer id this setting applies to.
	Timer *ExecutableStagePayload_TimerId `protobuf:"bytes,4,opt,name=timer,proto3,oneof"`
}

func (*ExecutableStagePayload_WireCoderSetting_InputOrOutputId) isExecutableStagePayload_WireCoderSetting_Target() {
}

func (*ExecutableStagePayload_WireCoderSetting_Timer) isExecutableStagePayload_WireCoderSetting_Target() {
}

var file_beam_runner_api_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*descriptorpb.EnumValueOptions)(nil),
		ExtensionType: (*string)(nil),
		Field:         185324356,
		Name:          "org.apache.beam.model.pipeline.v1.beam_urn",
		Tag:           "bytes,185324356,opt,name=beam_urn",
		Filename:      "beam_runner_api.proto",
	},
	{
		ExtendedType:  (*descriptorpb.EnumValueOptions)(nil),
		ExtensionType: (*string)(nil),
		Field:         185324357,
		Name:          "org.apache.beam.model.pipeline.v1.beam_constant",
		Tag:           "bytes,185324357,opt,name=beam_constant",
		Filename:      "beam_runner_api.proto",
	},
}

// Extension fields to descriptorpb.EnumValueOptions.
var (
	// An extension to be used for specifying the standard URN of various
	// pipeline entities, e.g. transforms, functions, coders etc.
	// Code should refer to the URNs of those entities by extracting
	// it from the (beam_urn) extension, rather than by hard-coding
	// the URN.
	//
	// The recommended pattern for declaring it is (exemplified by coders):
	//
	// message StandardCoders {
	//   enum Enum {
	//     BYTES = 0 [(beam_urn) = "beam:coder:bytes:v1"];
	//     ...
	//   }
	// }
	//
	// If there are multiple categories of entities of this type, use the
	// following pattern (exemplified by PTransforms):
	//
	// message StandardPTransforms {
	//   enum Primitives {
	//     ...
	//   }
	//   enum Composites {
	//     ...
	//   }
	// }
	//
	// optional string beam_urn = 185324356;
	E_BeamUrn = &file_beam_runner_api_proto_extTypes[0]
	// A value to store other constants
	//
	// optional string beam_constant = 185324357;
	E_BeamConstant = &file_beam_runner_api_proto_extTypes[1]
)

var File_beam_runner_api_proto protoreflect.FileDescriptor

var file_beam_runner_api_proto_rawDesc = []byte{
	0x0a, 0x15, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x61, 0x70,
	0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x0f, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc2, 0x01,
	0x0a, 0x0d, 0x42, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x22,
	0xb0, 0x01, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x31, 0x0a,
	0x14, 0x4d, 0x49, 0x4e, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x5f, 0x4d,
	0x49, 0x4c, 0x4c, 0x49, 0x53, 0x10, 0x00, 0x1a, 0x17, 0xaa, 0xb4, 0xfa, 0xc2, 0x05, 0x11, 0x2d,
	0x39, 0x32, 0x32, 0x33, 0x33, 0x37, 0x32, 0x30, 0x33, 0x36, 0x38, 0x35, 0x34, 0x37, 0x37, 0x35,
	0x12, 0x30, 0x0a, 0x14, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d,
	0x50, 0x5f, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53, 0x10, 0x01, 0x1a, 0x16, 0xaa, 0xb4, 0xfa, 0xc2,
	0x05, 0x10, 0x39, 0x32, 0x32, 0x33, 0x33, 0x37, 0x32, 0x30, 0x33, 0x36, 0x38, 0x35, 0x34, 0x37,
	0x37, 0x35, 0x12, 0x3e, 0x0a, 0x22, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x5f, 0x57, 0x49, 0x4e,
	0x44, 0x4f, 0x57, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d,
	0x50, 0x5f, 0x4d, 0x49, 0x4c, 0x4c, 0x49, 0x53, 0x10, 0x02, 0x1a, 0x16, 0xaa, 0xb4, 0xfa, 0xc2,
	0x05, 0x10, 0x39, 0x32, 0x32, 0x33, 0x33, 0x37, 0x31, 0x39, 0x35, 0x30, 0x34, 0x35, 0x34, 0x37,
	0x37, 0x35, 0x22, 0xb6, 0x08, 0x0a, 0x0a, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x5d, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73,
	0x12, 0x63, 0x0a, 0x0c, 0x70, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x50, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x70, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x79, 0x0a, 0x14, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x73, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x13, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x69, 0x65, 0x73,
	0x12, 0x51, 0x0a, 0x06, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e,
	0x43, 0x6f, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x63, 0x6f, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x63, 0x0a, 0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x6c, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x43, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6f, 0x0a, 0x11, 0x50, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x44, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7c, 0x0a, 0x18, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x63, 0x0a, 0x0b, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6f, 0x0a, 0x11, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x44, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfe, 0x01, 0x0a, 0x08,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x4d, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x0a, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x72, 0x6f, 0x6f, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x49, 0x64, 0x73, 0x12, 0x51, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12, 0x22, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xd4, 0x05, 0x0a,
	0x0a, 0x50, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x1f, 0x0a, 0x0b, 0x75,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x04,
	0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65,
	0x63, 0x12, 0x24, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x12, 0x51, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x54, 0x0a, 0x07, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x12, 0x51, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3a, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x8a, 0x10, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64,
	0x50, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x22, 0xdb, 0x03, 0x0a, 0x0a,
	0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x06, 0x50, 0x41,
	0x52, 0x5f, 0x44, 0x4f, 0x10, 0x00, 0x1a, 0x1d, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x17, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x70, 0x61, 0x72,
	0x64, 0x6f, 0x3a, 0x76, 0x31, 0x12, 0x2c, 0x0a, 0x07, 0x46, 0x4c, 0x41, 0x54, 0x54, 0x45, 0x4e,
	0x10, 0x01, 0x1a, 0x1f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x19, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x66, 0x6c, 0x61, 0x74, 0x74, 0x65, 0x6e,
	0x3a, 0x76, 0x31, 0x12, 0x36, 0x0a, 0x0c, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x42, 0x59, 0x5f,
	0x4b, 0x45, 0x59, 0x10, 0x02, 0x1a, 0x24, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1e, 0x62, 0x65, 0x61,
	0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x62, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x3a, 0x76, 0x31, 0x12, 0x2c, 0x0a, 0x07, 0x49,
	0x4d, 0x50, 0x55, 0x4c, 0x53, 0x45, 0x10, 0x03, 0x1a, 0x1f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x19,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x69,
	0x6d, 0x70, 0x75, 0x6c, 0x73, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x37, 0x0a, 0x0e, 0x41, 0x53, 0x53,
	0x49, 0x47, 0x4e, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x10, 0x04, 0x1a, 0x23, 0xa2,
	0xb4, 0xfa, 0xc2, 0x05, 0x1d, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x3a, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x74, 0x6f, 0x3a,
	0x76, 0x31, 0x12, 0x33, 0x0a, 0x0b, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41,
	0x4d, 0x10, 0x05, 0x1a, 0x22, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1c, 0x62, 0x65, 0x61, 0x6d, 0x3a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x3a, 0x76, 0x31, 0x12, 0x34, 0x0a, 0x0b, 0x4d, 0x41, 0x50, 0x5f, 0x57,
	0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x10, 0x06, 0x1a, 0x23, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1d,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x6d,
	0x61, 0x70, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x38, 0x0a,
	0x0d, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x10, 0x07,
	0x1a, 0x25, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1f, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x5f, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x30, 0x0a, 0x09, 0x54, 0x4f, 0x5f, 0x53, 0x54,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x1a, 0x21, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1b, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x74, 0x6f, 0x5f,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x76, 0x31, 0x22, 0x74, 0x0a, 0x14, 0x44, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x04, 0x52, 0x45, 0x41, 0x44, 0x10, 0x00, 0x1a, 0x1c, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x16, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x3a, 0x76, 0x31, 0x12, 0x34, 0x0a, 0x0b, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x01, 0x1a, 0x23, 0xa2, 0xb4, 0xfa, 0xc2,
	0x05, 0x1d, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x3a, 0x76, 0x31, 0x22,
	0xc6, 0x03, 0x0a, 0x0a, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x73, 0x12, 0x3c,
	0x0a, 0x0f, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x4b, 0x45,
	0x59, 0x10, 0x00, 0x1a, 0x27, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x21, 0x62, 0x65, 0x61, 0x6d, 0x3a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x3a, 0x76, 0x31, 0x12, 0x3e, 0x0a, 0x10,
	0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x5f, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x4c, 0x59,
	0x10, 0x01, 0x1a, 0x28, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x22, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x6c, 0x79, 0x3a, 0x76, 0x31, 0x12, 0x30, 0x0a, 0x09,
	0x52, 0x45, 0x53, 0x48, 0x55, 0x46, 0x46, 0x4c, 0x45, 0x10, 0x02, 0x1a, 0x21, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x72, 0x65, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x34,
	0x0a, 0x0b, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x10, 0x03, 0x1a,
	0x23, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1d, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x3a, 0x76, 0x31, 0x12, 0x34, 0x0a, 0x0b, 0x50, 0x55, 0x42, 0x53, 0x55, 0x42, 0x5f, 0x52,
	0x45, 0x41, 0x44, 0x10, 0x04, 0x1a, 0x23, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1d, 0x62, 0x65, 0x61,
	0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x3a, 0x76, 0x31, 0x12, 0x36, 0x0a, 0x0c, 0x50, 0x55,
	0x42, 0x53, 0x55, 0x42, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x05, 0x1a, 0x24, 0xa2, 0xb4,
	0xfa, 0xc2, 0x05, 0x1e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x3a, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x3a,
	0x76, 0x31, 0x12, 0x64, 0x0a, 0x23, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x49, 0x4e, 0x54, 0x4f,
	0x5f, 0x42, 0x41, 0x54, 0x43, 0x48, 0x45, 0x53, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x53, 0x48,
	0x41, 0x52, 0x44, 0x45, 0x44, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x06, 0x1a, 0x3b, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x35, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x74, 0x6f, 0x5f, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x65,
	0x64, 0x5f, 0x6b, 0x65, 0x79, 0x3a, 0x76, 0x31, 0x22, 0xe3, 0x03, 0x0a, 0x11, 0x43, 0x6f, 0x6d,
	0x62, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x52,
	0x0a, 0x1a, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x4b, 0x45,
	0x59, 0x5f, 0x50, 0x52, 0x45, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x10, 0x00, 0x1a, 0x32,
	0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x2c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x3a,
	0x76, 0x31, 0x12, 0x62, 0x0a, 0x22, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x45,
	0x52, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x55,
	0x4d, 0x55, 0x4c, 0x41, 0x54, 0x4f, 0x52, 0x53, 0x10, 0x01, 0x1a, 0x3a, 0xa2, 0xb4, 0xfa, 0xc2,
	0x05, 0x34, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x6f, 0x72, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x5c, 0x0a, 0x1f, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e,
	0x45, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x45, 0x58, 0x54, 0x52, 0x41, 0x43,
	0x54, 0x5f, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x53, 0x10, 0x02, 0x1a, 0x37, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x31, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x3a, 0x76, 0x31, 0x12, 0x4a, 0x0a, 0x16, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x5f,
	0x47, 0x52, 0x4f, 0x55, 0x50, 0x45, 0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x10, 0x03,
	0x1a, 0x2e, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x28, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x3a, 0x76, 0x31,
	0x12, 0x6c, 0x0a, 0x27, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x5f,
	0x4b, 0x45, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x54, 0x4f, 0x5f, 0x41,
	0x43, 0x43, 0x55, 0x4d, 0x55, 0x4c, 0x41, 0x54, 0x4f, 0x52, 0x53, 0x10, 0x04, 0x1a, 0x3f, 0xa2,
	0xb4, 0xfa, 0xc2, 0x05, 0x39, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x3a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x61,
	0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x3a, 0x76, 0x31, 0x22, 0x8d,
	0x03, 0x0a, 0x19, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x72,
	0x44, 0x6f, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x15,
	0x50, 0x41, 0x49, 0x52, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x00, 0x1a, 0x31, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x2b, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x73, 0x64,
	0x66, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x76, 0x31, 0x12, 0x58, 0x0a, 0x1b, 0x53, 0x50,
	0x4c, 0x49, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x52, 0x45, 0x53,
	0x54, 0x52, 0x49, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x01, 0x1a, 0x37, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x31, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x73, 0x64, 0x66, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x61, 0x6e, 0x64, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x3a, 0x76, 0x31, 0x12, 0x6f, 0x0a, 0x27, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x5f,
	0x53, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x5f, 0x41,
	0x4e, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10,
	0x02, 0x1a, 0x42, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x3c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x73, 0x64, 0x66, 0x5f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x57, 0x0a, 0x1a, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54,
	0x45, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x03, 0x1a, 0x37, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x31, 0x62, 0x65, 0x61,
	0x6d, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x73, 0x64, 0x66, 0x5f,
	0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x76, 0x31, 0x22, 0x60,
	0x0a, 0x1a, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x6f, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x12,
	0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x49, 0x4e, 0x54, 0x4f, 0x5f, 0x42, 0x41, 0x54, 0x43, 0x48,
	0x45, 0x53, 0x10, 0x00, 0x1a, 0x2a, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x24, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x6e, 0x74, 0x6f, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x3a, 0x76, 0x31,
	0x22, 0x82, 0x01, 0x0a, 0x16, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x53, 0x69, 0x64,
	0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x68, 0x0a, 0x04, 0x45,
	0x6e, 0x75, 0x6d, 0x12, 0x2f, 0x0a, 0x08, 0x49, 0x54, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x00, 0x1a, 0x21, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x73, 0x69,
	0x64, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x3a, 0x69, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x3a, 0x76, 0x31, 0x12, 0x2f, 0x0a, 0x08, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x4d, 0x41, 0x50,
	0x10, 0x01, 0x1a, 0x21, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x73,
	0x69, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x3a, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x6d,
	0x61, 0x70, 0x3a, 0x76, 0x31, 0x22, 0xa2, 0x02, 0x0a, 0x0b, 0x50, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x50, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x65, 0x64, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x09, 0x69, 0x73, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x49, 0x64, 0x12, 0x51, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x22, 0xbe, 0x07, 0x0a, 0x0c, 0x50,
	0x61, 0x72, 0x44, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x44, 0x0a, 0x05, 0x64,
	0x6f, 0x5f, 0x66, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x64, 0x6f, 0x46,
	0x6e, 0x12, 0x60, 0x0a, 0x0b, 0x73, 0x69, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x44, 0x6f,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x73, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x60, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x44, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x73, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x5f, 0x66,
	0x61, 0x6d, 0x69, 0x6c, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x44, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x53, 0x70,
	0x65, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x46,
	0x61, 0x6d, 0x69, 0x6c, 0x79, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3b, 0x0a, 0x1a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x73, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x32,
	0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x53, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x1a, 0x6b, 0x0a, 0x0f, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x64, 0x65, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x6b, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x77, 0x0a, 0x15,
	0x54, 0x69, 0x6d, 0x65, 0x72, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x53, 0x70, 0x65, 0x63, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x72,
	0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07, 0x22, 0xb8, 0x04, 0x0a, 0x09,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x72, 0x0a, 0x16, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x13, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a,
	0x08, 0x62, 0x61, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x48, 0x00, 0x52, 0x07, 0x62, 0x61, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5e, 0x0a, 0x0e, 0x63,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a, 0x08, 0x6d,
	0x61, 0x70, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00,
	0x52, 0x07, 0x6d, 0x61, 0x70, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a, 0x08, 0x73, 0x65, 0x74,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x07,
	0x73, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x65, 0x0a, 0x11, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x65, 0x64, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0f, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x06,
	0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0x35, 0x0a, 0x18, 0x52, 0x65, 0x61, 0x64, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0x38, 0x0a,
	0x0c, 0x42, 0x61, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a,
	0x10, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0x40, 0x0a, 0x14, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x28, 0x0a, 0x10, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x43, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x30, 0x0a, 0x14, 0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x4e, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x66, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x46, 0x6e, 0x22, 0x56, 0x0a, 0x0c, 0x4d, 0x61, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x65, 0x79, 0x43, 0x6f, 0x64,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0x38, 0x0a, 0x0c, 0x53, 0x65,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64,
	0x65, 0x72, 0x49, 0x64, 0x22, 0x99, 0x01, 0x0a, 0x0f, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x46, 0x61,
	0x6d, 0x69, 0x6c, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x53, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x2e, 0x45, 0x6e, 0x75,
	0x6d, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x31, 0x0a,
	0x15, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x74, 0x69,
	0x6d, 0x65, 0x72, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x49, 0x64,
	0x22, 0x40, 0x0a, 0x09, 0x49, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x33, 0x0a,
	0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x42, 0x4f, 0x55, 0x4e,
	0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x45, 0x44,
	0x10, 0x02, 0x22, 0xa8, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x61, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x12, 0x47, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x69,
	0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x2e, 0x45, 0x6e,
	0x75, 0x6d, 0x52, 0x09, 0x69, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x61, 0x0a,
	0x11, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x49, 0x6e, 0x74, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x12, 0x4c, 0x0a, 0x09, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x66, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x08, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x6e,
	0x22, 0x92, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x4e, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x66,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x46, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f,
	0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0xcd, 0x07, 0x0a, 0x11, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x1a,
	0x96, 0x05, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x76, 0x0a, 0x0f, 0x77, 0x61, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x48,
	0x00, 0x52, 0x0e, 0x77, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x86, 0x01, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54,
	0x69, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x6d, 0x0a, 0x0d, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64,
	0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x1a, 0x49, 0x0a, 0x10, 0x41, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x57, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x23, 0x0a,
	0x0d, 0x6e, 0x65, 0x77, 0x5f, 0x77, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6e, 0x65, 0x77, 0x57, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61,
	0x72, 0x6b, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x74, 0x61, 0x67, 0x1a, 0x42, 0x0a, 0x15, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a,
	0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x84, 0x01, 0x0a, 0x0b, 0x41, 0x64, 0x64,
	0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x63, 0x0a, 0x08, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x65, 0x73, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x10, 0x0a,
	0x03, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67, 0x42,
	0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x1a, 0x5b, 0x0a, 0x12, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x27,
	0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64,
	0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x2e, 0x0a, 0x0d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x49, 0x64, 0x73, 0x22, 0xed, 0x03, 0x0a, 0x11, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x43, 0x0a, 0x04, 0x73,
	0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x69, 0x6e, 0x6b,
	0x12, 0x58, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x1a, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x44,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x65, 0x0a, 0x0b, 0x73, 0x69, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x53, 0x69, 0x64,
	0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x73, 0x69,
	0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x1a, 0x6b, 0x0a, 0x0f, 0x53, 0x69, 0x64, 0x65,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcc, 0x02, 0x0a, 0x11, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x52, 0x65, 0x61, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x64, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x64,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0e, 0x77, 0x69, 0x74, 0x68, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x12, 0x46, 0x0a, 0x1f,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x64, 0x65, 0x6e, 0x22, 0xb8, 0x01, 0x0a, 0x12, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x12, 0x2f, 0x0a, 0x13, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x64, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x38, 0x0a, 0x18, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x64, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22,
	0xa5, 0x01, 0x0a, 0x17, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x6f, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x69, 0x6c, 0x6c, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x6d, 0x61, 0x78,
	0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x22, 0x7c, 0x0a, 0x05, 0x43, 0x6f, 0x64, 0x65, 0x72,
	0x12, 0x43, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x64,
	0x65, 0x72, 0x49, 0x64, 0x73, 0x22, 0xc9, 0x06, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61,
	0x72, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x73, 0x22, 0xb6, 0x06, 0x0a, 0x04, 0x45, 0x6e, 0x75,
	0x6d, 0x12, 0x24, 0x0a, 0x05, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x00, 0x1a, 0x19, 0xa2, 0xb4,
	0xfa, 0xc2, 0x05, 0x13, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x30, 0x0a, 0x0b, 0x53, 0x54, 0x52, 0x49, 0x4e,
	0x47, 0x5f, 0x55, 0x54, 0x46, 0x38, 0x10, 0x0a, 0x1a, 0x1f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x19,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x75, 0x74, 0x66, 0x38, 0x3a, 0x76, 0x31, 0x12, 0x1e, 0x0a, 0x02, 0x4b, 0x56, 0x10,
	0x01, 0x1a, 0x16, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x10, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x3a, 0x6b, 0x76, 0x3a, 0x76, 0x31, 0x12, 0x22, 0x0a, 0x04, 0x42, 0x4f, 0x4f,
	0x4c, 0x10, 0x0c, 0x1a, 0x18, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x12, 0x62, 0x65, 0x61, 0x6d, 0x3a,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x62, 0x6f, 0x6f, 0x6c, 0x3a, 0x76, 0x31, 0x12, 0x26, 0x0a,
	0x06, 0x56, 0x41, 0x52, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x1a, 0x1a, 0xa2, 0xb4, 0xfa, 0xc2, 0x05,
	0x14, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x76, 0x61, 0x72, 0x69,
	0x6e, 0x74, 0x3a, 0x76, 0x31, 0x12, 0x26, 0x0a, 0x06, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10,
	0x0b, 0x1a, 0x1a, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x14, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x3a, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x2a, 0x0a,
	0x08, 0x49, 0x54, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x1a, 0x1c, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x16, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x24, 0x0a, 0x05, 0x54, 0x49, 0x4d,
	0x45, 0x52, 0x10, 0x04, 0x1a, 0x19, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x13, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x3a, 0x76, 0x31, 0x12,
	0x38, 0x0a, 0x0f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x57, 0x49, 0x4e, 0x44,
	0x4f, 0x57, 0x10, 0x05, 0x1a, 0x23, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1d, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x3a, 0x76, 0x31, 0x12, 0x34, 0x0a, 0x0d, 0x4c, 0x45, 0x4e,
	0x47, 0x54, 0x48, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x49, 0x58, 0x10, 0x06, 0x1a, 0x21, 0xa2, 0xb4,
	0xfa, 0xc2, 0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x3a, 0x76, 0x31, 0x12,
	0x34, 0x0a, 0x0d, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57,
	0x10, 0x07, 0x1a, 0x21, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x3a, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x3a, 0x76, 0x31, 0x12, 0x36, 0x0a, 0x0e, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x45,
	0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x08, 0x1a, 0x22, 0xa2, 0xb4, 0xfa, 0xc2, 0x05,
	0x1c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x42, 0x0a,
	0x14, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x45, 0x44, 0x5f,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x0e, 0x1a, 0x28, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x22, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x76,
	0x31, 0x12, 0x44, 0x0a, 0x15, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45,
	0x44, 0x5f, 0x49, 0x54, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x09, 0x1a, 0x29, 0xa2, 0xb4,
	0xfa, 0xc2, 0x05, 0x23, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x34, 0x0a, 0x0d, 0x43, 0x55, 0x53, 0x54, 0x4f,
	0x4d, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x10, 0x10, 0x1a, 0x21, 0xa2, 0xb4, 0xfa, 0xc2,
	0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x3a, 0x76, 0x31, 0x12, 0x20, 0x0a,
	0x03, 0x52, 0x4f, 0x57, 0x10, 0x0d, 0x1a, 0x17, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x11, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x3a, 0x72, 0x6f, 0x77, 0x3a, 0x76, 0x31, 0x12,
	0x30, 0x0a, 0x0b, 0x53, 0x48, 0x41, 0x52, 0x44, 0x45, 0x44, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x0f,
	0x1a, 0x1f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x19, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x63, 0x6f, 0x64,
	0x65, 0x72, 0x3a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x3a, 0x76,
	0x31, 0x22, 0xac, 0x06, 0x0a, 0x11, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x4c, 0x0a, 0x09, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x5f, 0x66, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x08, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x46, 0x6e, 0x12, 0x56, 0x0a, 0x0c, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x52, 0x0b, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x43, 0x6f,
	0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x65, 0x0a, 0x11, 0x61,
	0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x75, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x52, 0x10, 0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x53, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x0a, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x10, 0x63, 0x6c, 0x6f, 0x73, 0x69,
	0x6e, 0x67, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x69, 0x6e, 0x67, 0x42, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x73,
	0x69, 0x6e, 0x67, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x29, 0x0a, 0x10, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4c, 0x61,
	0x74, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x5e, 0x0a, 0x0e, 0x4f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x0e, 0x4f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x31, 0x0a, 0x15, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6f, 0x6e, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x73, 0x54, 0x6f,
	0x4f, 0x6e, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x22, 0x5c, 0x0a, 0x0b, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x4d, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x4e, 0x5f,
	0x4d, 0x45, 0x52, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x45, 0x45,
	0x44, 0x53, 0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x4c,
	0x52, 0x45, 0x41, 0x44, 0x59, 0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x44, 0x10, 0x03, 0x22, 0x5d,
	0x0a, 0x10, 0x41, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x22, 0x49, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x44,
	0x49, 0x53, 0x43, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x41,
	0x43, 0x43, 0x55, 0x4d, 0x55, 0x4c, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x52, 0x45, 0x54, 0x52, 0x41, 0x43, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x22, 0x51, 0x0a,
	0x0f, 0x43, 0x6c, 0x6f, 0x73, 0x69, 0x6e, 0x67, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x22, 0x3e, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x45, 0x4d, 0x49,
	0x54, 0x5f, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4d,
	0x49, 0x54, 0x5f, 0x49, 0x46, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x4d, 0x50, 0x54, 0x59, 0x10, 0x02,
	0x22, 0x50, 0x0a, 0x0e, 0x4f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x22, 0x3e, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x46,
	0x49, 0x52, 0x45, 0x5f, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10,
	0x46, 0x49, 0x52, 0x45, 0x5f, 0x49, 0x46, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x4d, 0x50, 0x54, 0x59,
	0x10, 0x02, 0x22, 0x62, 0x0a, 0x0a, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x54, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x4e, 0x44,
	0x5f, 0x4f, 0x46, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e,
	0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x41, 0x4e, 0x45, 0x10, 0x02,
	0x12, 0x14, 0x0a, 0x10, 0x45, 0x41, 0x52, 0x4c, 0x49, 0x45, 0x53, 0x54, 0x5f, 0x49, 0x4e, 0x5f,
	0x50, 0x41, 0x4e, 0x45, 0x10, 0x03, 0x22, 0x6e, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x22, 0x60, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x0f, 0x0a, 0x0b,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a,
	0x0a, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x13, 0x0a,
	0x0f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x10, 0x02, 0x22, 0x04, 0x08, 0x03, 0x10, 0x03, 0x2a, 0x1c, 0x53, 0x59, 0x4e, 0x43, 0x48, 0x52,
	0x4f, 0x4e, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x22, 0xa3, 0x10, 0x0a, 0x07, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x12, 0x52, 0x0a, 0x09, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x2e, 0x41, 0x66, 0x74, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x48, 0x00, 0x52, 0x08, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x12, 0x52, 0x0a, 0x09, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f,
	0x61, 0x6e, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x41, 0x66, 0x74, 0x65, 0x72, 0x41, 0x6e, 0x79, 0x48, 0x00,
	0x52, 0x08, 0x61, 0x66, 0x74, 0x65, 0x72, 0x41, 0x6e, 0x79, 0x12, 0x55, 0x0a, 0x0a, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x5f, 0x65, 0x61, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x45, 0x61, 0x63, 0x68, 0x48, 0x00, 0x52, 0x09, 0x61, 0x66, 0x74, 0x65, 0x72, 0x45, 0x61, 0x63,
	0x68, 0x12, 0x6c, 0x0a, 0x13, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x6f,
	0x66, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x45, 0x6e, 0x64, 0x4f, 0x66, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x10, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x4f, 0x66, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12,
	0x74, 0x0a, 0x15, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00,
	0x52, 0x13, 0x61, 0x66, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x99, 0x01, 0x0a, 0x22, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x41,
	0x66, 0x74, 0x65, 0x72, 0x53, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x69, 0x7a, 0x65, 0x64,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00,
	0x52, 0x1f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x53, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x69,
	0x7a, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4b, 0x0a, 0x06, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x41, 0x6c,
	0x77, 0x61, 0x79, 0x73, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x12, 0x4e,
	0x0a, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x5e,
	0x0a, 0x0d, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x2e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x0c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x48,
	0x0a, 0x05, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x4e, 0x65, 0x76, 0x65, 0x72, 0x48,
	0x00, 0x52, 0x05, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0a, 0x6f, 0x72, 0x5f, 0x66,
	0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x4f, 0x72, 0x46, 0x69, 0x6e, 0x61, 0x6c,
	0x6c, 0x79, 0x48, 0x00, 0x52, 0x09, 0x6f, 0x72, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x12,
	0x4b, 0x0a, 0x06, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x70, 0x65,
	0x61, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x1a, 0x58, 0x0a, 0x08,
	0x41, 0x66, 0x74, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x12, 0x4c, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x1a, 0x58, 0x0a, 0x08, 0x41, 0x66, 0x74, 0x65, 0x72, 0x41,
	0x6e, 0x79, 0x12, 0x4c, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73,
	0x1a, 0x59, 0x0a, 0x09, 0x41, 0x66, 0x74, 0x65, 0x72, 0x45, 0x61, 0x63, 0x68, 0x12, 0x4c, 0x0a,
	0x0b, 0x73, 0x75, 0x62, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0b,
	0x73, 0x75, 0x62, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x1a, 0xb2, 0x01, 0x0a, 0x10,
	0x41, 0x66, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x4f, 0x66, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x12, 0x4f, 0x0a, 0x0d, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x66, 0x69, 0x72, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x0c, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x46, 0x69, 0x72, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x72, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x0b, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x73,
	0x1a, 0x7f, 0x0a, 0x13, 0x41, 0x66, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x68, 0x0a, 0x14, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x13, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x73, 0x1a, 0x21, 0x0a, 0x1f, 0x41, 0x66, 0x74, 0x65, 0x72, 0x53, 0x79, 0x6e, 0x63, 0x68, 0x72,
	0x6f, 0x6e, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0x09, 0x0a, 0x07, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x1a,
	0x33, 0x0a, 0x0c, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x07, 0x0a, 0x05, 0x4e, 0x65, 0x76, 0x65, 0x72, 0x1a, 0x08, 0x0a,
	0x06, 0x41, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x1a, 0x91, 0x01, 0x0a, 0x09, 0x4f, 0x72, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x12, 0x3e, 0x0a, 0x04, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52,
	0x04, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x44, 0x0a, 0x07, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x1a, 0x54, 0x0a, 0x06, 0x52,
	0x65, 0x70, 0x65, 0x61, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x42, 0x09, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0xc3, 0x02, 0x0a,
	0x12, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x12, 0x53, 0x0a, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x48,
	0x00, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x5a, 0x0a, 0x08, 0x61, 0x6c, 0x69, 0x67,
	0x6e, 0x5f, 0x74, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x54, 0x6f, 0x48, 0x00, 0x52, 0x07, 0x61, 0x6c, 0x69,
	0x67, 0x6e, 0x54, 0x6f, 0x1a, 0x2a, 0x0a, 0x05, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x73,
	0x1a, 0x39, 0x0a, 0x07, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x54, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x15, 0x0a, 0x13, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x22, 0x8a, 0x02, 0x0a, 0x09, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x56, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x48, 0x0a, 0x07, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x66, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x06, 0x76, 0x69, 0x65, 0x77,
	0x46, 0x6e, 0x12, 0x5b, 0x0a, 0x11, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x46, 0x6e, 0x22,
	0xc5, 0x03, 0x0a, 0x11, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x22, 0x9f, 0x02, 0x0a, 0x05, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12,
	0x2a, 0x0a, 0x04, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x00, 0x1a, 0x20, 0xa2, 0xb4, 0xfa, 0xc2, 0x05,
	0x1a, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x74,
	0x79, 0x70, 0x65, 0x3a, 0x66, 0x69, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x28, 0x0a, 0x03, 0x55,
	0x52, 0x4c, 0x10, 0x01, 0x1a, 0x1f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x19, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x75,
	0x72, 0x6c, 0x3a, 0x76, 0x31, 0x12, 0x32, 0x0a, 0x08, 0x45, 0x4d, 0x42, 0x45, 0x44, 0x44, 0x45,
	0x44, 0x10, 0x02, 0x1a, 0x24, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1e, 0x62, 0x65, 0x61, 0x6d, 0x3a,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x3a, 0x76, 0x31, 0x12, 0x2a, 0x0a, 0x04, 0x50, 0x59, 0x50,
	0x49, 0x10, 0x03, 0x1a, 0x20, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1a, 0x62, 0x65, 0x61, 0x6d, 0x3a,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x70, 0x79,
	0x70, 0x69, 0x3a, 0x76, 0x31, 0x12, 0x2c, 0x0a, 0x05, 0x4d, 0x41, 0x56, 0x45, 0x4e, 0x10, 0x04,
	0x1a, 0x21, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x6d, 0x61, 0x76, 0x65, 0x6e,
	0x3a, 0x76, 0x31, 0x12, 0x32, 0x0a, 0x08, 0x44, 0x45, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x10,
	0x05, 0x1a, 0x24, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x64, 0x65, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x3a, 0x76, 0x31, 0x22, 0x8d, 0x01, 0x0a, 0x05, 0x52, 0x6f, 0x6c, 0x65,
	0x73, 0x12, 0x36, 0x0a, 0x0a, 0x53, 0x54, 0x41, 0x47, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x4f, 0x10,
	0x00, 0x1a, 0x26, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x20, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x72, 0x6f, 0x6c, 0x65, 0x3a, 0x73, 0x74, 0x61, 0x67,
	0x69, 0x6e, 0x67, 0x5f, 0x74, 0x6f, 0x3a, 0x76, 0x31, 0x12, 0x4c, 0x0a, 0x15, 0x50, 0x49, 0x50,
	0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x5f, 0x46, 0x49,
	0x4c, 0x45, 0x10, 0x01, 0x1a, 0x31, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x2b, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3a, 0x72, 0x6f, 0x6c, 0x65, 0x3a, 0x70,
	0x69, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x22, 0x41, 0x0a, 0x13, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0x3e, 0x0a, 0x12, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x55, 0x72, 0x6c, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0x29, 0x0a, 0x13, 0x45, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x48, 0x0a, 0x0b, 0x50, 0x79, 0x50, 0x49, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x51, 0x0a, 0x0c, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x55,
	0x72, 0x6c, 0x22, 0x3f, 0x0a, 0x17, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x3f, 0x0a, 0x1c, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x53,
	0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x52, 0x6f, 0x6c, 0x65, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x67, 0x65, 0x64,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x13, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x74, 0x79, 0x70, 0x65, 0x55, 0x72, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x74,
	0x79, 0x70, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x6f,
	0x6c, 0x65, 0x5f, 0x75, 0x72, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x6f,
	0x6c, 0x65, 0x55, 0x72, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x72, 0x6f, 0x6c,
	0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0xbe, 0x03, 0x0a, 0x0b, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x51, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0c, 0x64,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x68, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69, 0x6e, 0x74,
	0x73, 0x1a, 0x40, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69, 0x6e,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0xc7, 0x01, 0x0a, 0x14, 0x53, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0xae, 0x01, 0x0a, 0x0c, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x24, 0x0a, 0x06, 0x44, 0x4f, 0x43, 0x4b, 0x45, 0x52, 0x10, 0x00, 0x1a,
	0x18, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x12, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x65, 0x6e, 0x76, 0x3a,
	0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x3a, 0x76, 0x31, 0x12, 0x26, 0x0a, 0x07, 0x50, 0x52, 0x4f,
	0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x1a, 0x19, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x13, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x65, 0x6e, 0x76, 0x3a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x3a, 0x76,
	0x31, 0x12, 0x28, 0x0a, 0x08, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x1a,
	0x1a, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x14, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x65, 0x6e, 0x76, 0x3a,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x3a, 0x76, 0x31, 0x12, 0x26, 0x0a, 0x07, 0x44,
	0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x03, 0x1a, 0x19, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x13,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x65, 0x6e, 0x76, 0x3a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x3a, 0x76, 0x31, 0x22, 0x38, 0x0a, 0x0d, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0xd4, 0x01,
	0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x0e, 0x0a, 0x02, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x6f, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x61, 0x72, 0x63, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x4c,
	0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x45,
	0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x1a, 0x36, 0x0a, 0x08,
	0x45, 0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xf9, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x56, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x88, 0x03, 0x0a, 0x11, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x22, 0xf2, 0x02, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12,
	0x48, 0x0a, 0x19, 0x4c, 0x45, 0x47, 0x41, 0x43, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45,
	0x53, 0x53, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x00, 0x1a, 0x29,
	0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x23, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x3a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x3a, 0x76, 0x30, 0x12, 0x41, 0x0a, 0x12, 0x50, 0x52, 0x4f,
	0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x1a, 0x29, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x23, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x3a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x3a, 0x76, 0x31, 0x12, 0x37, 0x0a, 0x0d,
	0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x02, 0x1a,
	0x24, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x3a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x55, 0x0a, 0x1c, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x43,
	0x4f, 0x52, 0x45, 0x5f, 0x42, 0x55, 0x4e, 0x44, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45,
	0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x1a, 0x33, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x2d, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x3a, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x3a, 0x76, 0x31, 0x12, 0x4d, 0x0a, 0x18,
	0x48, 0x41, 0x52, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x49,
	0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x53, 0x10, 0x04, 0x1a, 0x2f, 0xa2, 0xb4, 0xfa, 0xc2,
	0x05, 0x29, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x3a,
	0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x73, 0x3a, 0x76, 0x31, 0x22, 0x72, 0x0a, 0x17, 0x53,
	0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x22, 0x57, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x4f,
	0x0a, 0x19, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x46,
	0x4f, 0x5f, 0x53, 0x48, 0x4f, 0x52, 0x54, 0x5f, 0x49, 0x44, 0x53, 0x10, 0x00, 0x1a, 0x30, 0xa2,
	0xb4, 0xfa, 0xc2, 0x05, 0x2a, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x3a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x5f, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x3a, 0x76, 0x31, 0x22,
	0xa6, 0x03, 0x0a, 0x14, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x8d, 0x03, 0x0a, 0x04, 0x45, 0x6e, 0x75,
	0x6d, 0x12, 0x4a, 0x0a, 0x1c, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x46, 0x55, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x10, 0x00, 0x1a, 0x28, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x22, 0x62, 0x65, 0x61, 0x6d, 0x3a,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x70, 0x61, 0x72, 0x64,
	0x6f, 0x3a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6c, 0x3a, 0x76, 0x31, 0x12, 0x4e, 0x0a,
	0x1c, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x42, 0x55, 0x4e, 0x44, 0x4c, 0x45,
	0x5f, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x1a,
	0x2c, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x26, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x70, 0x61, 0x72, 0x64, 0x6f, 0x3a, 0x66, 0x69,
	0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x76, 0x31, 0x12, 0x47, 0x0a,
	0x15, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x02, 0x1a, 0x2c, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x26,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x3a, 0x70, 0x61, 0x72, 0x64, 0x6f, 0x3a, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x3a, 0x76, 0x31, 0x12, 0x51, 0x0a, 0x1a, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52,
	0x45, 0x53, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x53, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x49,
	0x4e, 0x50, 0x55, 0x54, 0x10, 0x03, 0x1a, 0x31, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x2b, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x70,
	0x61, 0x72, 0x64, 0x6f, 0x3a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x3a, 0x76, 0x31, 0x12, 0x4d, 0x0a, 0x18, 0x52, 0x45, 0x51,
	0x55, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x54, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x44, 0x4f, 0x46, 0x4e, 0x10, 0x04, 0x1a, 0x2f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x29, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a,
	0x70, 0x61, 0x72, 0x64, 0x6f, 0x3a, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x64, 0x6f, 0x66, 0x6e, 0x3a, 0x76, 0x31, 0x22, 0x3a, 0x0a, 0x0c, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x22, 0x57, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x22, 0x40, 0x0a, 0x0b, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x08, 0x4c, 0x41,
	0x42, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x00, 0x1a, 0x23, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1d,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x3a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x3a, 0x76, 0x31, 0x22, 0x9b, 0x01,
	0x0a, 0x0f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a,
	0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a,
	0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x39, 0x0a, 0x0b, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0xd7, 0x07, 0x0a, 0x15, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x57, 0x69, 0x74, 0x68, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x4d, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x40, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x48, 0x00, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52,
	0x0e, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x56, 0x0a, 0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x57, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x5f, 0x64,
	0x6f, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x44, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x48, 0x00, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x44, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x4f, 0x0a, 0x0a, 0x70, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x12, 0x52, 0x0a, 0x0b, 0x70, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0c, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x72,
	0x65, 0x61, 0x64, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x4d, 0x0a, 0x0a, 0x73, 0x69,
	0x64, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x09,
	0x73, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x66, 0x0a, 0x13, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x74, 0x6f, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x49, 0x6e, 0x74, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x11,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x49, 0x6e, 0x74, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x65, 0x0a, 0x12, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x11, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x06, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x74,
	0x22, 0xb6, 0x0a, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x74, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x50, 0x0a, 0x0b, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x7a, 0x0a,
	0x13, 0x77, 0x69, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x57, 0x69, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x11, 0x77, 0x69, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x66, 0x0a, 0x0b, 0x73, 0x69, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e,
	0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x49, 0x64, 0x52, 0x0a, 0x73, 0x69, 0x64,
	0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x12, 0x4d, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x66, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x64, 0x52, 0x0a, 0x75, 0x73,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x06, 0x74, 0x69, 0x6d, 0x65,
	0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x52, 0x06, 0x74, 0x69, 0x6d,
	0x65, 0x72, 0x73, 0x12, 0x6d, 0x0a, 0x0d, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x46, 0x61, 0x6d, 0x69,
	0x6c, 0x69, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x46, 0x61, 0x6d, 0x69, 0x6c,
	0x79, 0x49, 0x64, 0x52, 0x0d, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69,
	0x65, 0x73, 0x1a, 0x4f, 0x0a, 0x0b, 0x53, 0x69, 0x64, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x1a, 0x4f, 0x0a, 0x0b, 0x55, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x4b, 0x0a, 0x07, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x1a, 0x51, 0x0a, 0x0d, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79,
	0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xd2, 0x01, 0x0a, 0x10, 0x57, 0x69, 0x72, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x2d, 0x0a, 0x12, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6f,
	0x72, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4f, 0x72, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x49, 0x64, 0x12, 0x59, 0x0a, 0x05, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x74, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x48, 0x00, 0x52, 0x05, 0x74, 0x69, 0x6d, 0x65, 0x72, 0x42,
	0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x8f, 0x01, 0x0a, 0x15, 0x53, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69,
	0x6e, 0x74, 0x73, 0x22, 0x76, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x34, 0x0a, 0x0b, 0x41,
	0x43, 0x43, 0x45, 0x4c, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x10, 0x00, 0x1a, 0x23, 0xa2, 0xb4,
	0xfa, 0xc2, 0x05, 0x1d, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x3a, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x3a, 0x76,
	0x31, 0x12, 0x38, 0x0a, 0x0d, 0x4d, 0x49, 0x4e, 0x5f, 0x52, 0x41, 0x4d, 0x5f, 0x42, 0x59, 0x54,
	0x45, 0x53, 0x10, 0x01, 0x1a, 0x25, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1f, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3a, 0x6d, 0x69, 0x6e, 0x5f, 0x72,
	0x61, 0x6d, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x3a, 0x76, 0x31, 0x32, 0x8f, 0x01, 0x0a, 0x11,
	0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x7a, 0x0a, 0x06, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x30, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x00, 0x30, 0x01, 0x3a, 0x3f, 0x0a,
	0x08, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x75, 0x72, 0x6e, 0x12, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xc4, 0xa6, 0xaf,
	0x58, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x65, 0x61, 0x6d, 0x55, 0x72, 0x6e, 0x3a, 0x49,
	0x0a, 0x0d, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0xc5, 0xa6, 0xaf, 0x58, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x65, 0x61,
	0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x42, 0x78, 0x0a, 0x21, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x09,
	0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x41, 0x70, 0x69, 0x5a, 0x48, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61,
	0x6d, 0x2f, 0x73, 0x64, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x31, 0x3b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_beam_runner_api_proto_rawDescOnce sync.Once
	file_beam_runner_api_proto_rawDescData = file_beam_runner_api_proto_rawDesc
)

func file_beam_runner_api_proto_rawDescGZIP() []byte {
	file_beam_runner_api_proto_rawDescOnce.Do(func() {
		file_beam_runner_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_beam_runner_api_proto_rawDescData)
	})
	return file_beam_runner_api_proto_rawDescData
}

var file_beam_runner_api_proto_enumTypes = make([]protoimpl.EnumInfo, 24)
var file_beam_runner_api_proto_msgTypes = make([]protoimpl.MessageInfo, 101)
var file_beam_runner_api_proto_goTypes = []interface{}{
	(BeamConstants_Constants)(0),                        // 0: org.apache.beam.model.pipeline.v1.BeamConstants.Constants
	(StandardPTransforms_Primitives)(0),                 // 1: org.apache.beam.model.pipeline.v1.StandardPTransforms.Primitives
	(StandardPTransforms_DeprecatedPrimitives)(0),       // 2: org.apache.beam.model.pipeline.v1.StandardPTransforms.DeprecatedPrimitives
	(StandardPTransforms_Composites)(0),                 // 3: org.apache.beam.model.pipeline.v1.StandardPTransforms.Composites
	(StandardPTransforms_CombineComponents)(0),          // 4: org.apache.beam.model.pipeline.v1.StandardPTransforms.CombineComponents
	(StandardPTransforms_SplittableParDoComponents)(0),  // 5: org.apache.beam.model.pipeline.v1.StandardPTransforms.SplittableParDoComponents
	(StandardPTransforms_GroupIntoBatchesComponents)(0), // 6: org.apache.beam.model.pipeline.v1.StandardPTransforms.GroupIntoBatchesComponents
	(StandardSideInputTypes_Enum)(0),                    // 7: org.apache.beam.model.pipeline.v1.StandardSideInputTypes.Enum
	(IsBounded_Enum)(0),                                 // 8: org.apache.beam.model.pipeline.v1.IsBounded.Enum
	(StandardCoders_Enum)(0),                            // 9: org.apache.beam.model.pipeline.v1.StandardCoders.Enum
	(MergeStatus_Enum)(0),                               // 10: org.apache.beam.model.pipeline.v1.MergeStatus.Enum
	(AccumulationMode_Enum)(0),                          // 11: org.apache.beam.model.pipeline.v1.AccumulationMode.Enum
	(ClosingBehavior_Enum)(0),                           // 12: org.apache.beam.model.pipeline.v1.ClosingBehavior.Enum
	(OnTimeBehavior_Enum)(0),                            // 13: org.apache.beam.model.pipeline.v1.OnTimeBehavior.Enum
	(OutputTime_Enum)(0),                                // 14: org.apache.beam.model.pipeline.v1.OutputTime.Enum
	(TimeDomain_Enum)(0),                                // 15: org.apache.beam.model.pipeline.v1.TimeDomain.Enum
	(StandardArtifacts_Types)(0),                        // 16: org.apache.beam.model.pipeline.v1.StandardArtifacts.Types
	(StandardArtifacts_Roles)(0),                        // 17: org.apache.beam.model.pipeline.v1.StandardArtifacts.Roles
	(StandardEnvironments_Environments)(0),              // 18: org.apache.beam.model.pipeline.v1.StandardEnvironments.Environments
	(StandardProtocols_Enum)(0),                         // 19: org.apache.beam.model.pipeline.v1.StandardProtocols.Enum
	(StandardRunnerProtocols_Enum)(0),                   // 20: org.apache.beam.model.pipeline.v1.StandardRunnerProtocols.Enum
	(StandardRequirements_Enum)(0),                      // 21: org.apache.beam.model.pipeline.v1.StandardRequirements.Enum
	(StandardDisplayData_DisplayData)(0),                // 22: org.apache.beam.model.pipeline.v1.StandardDisplayData.DisplayData
	(StandardResourceHints_Enum)(0),                     // 23: org.apache.beam.model.pipeline.v1.StandardResourceHints.Enum
	(*BeamConstants)(nil),                               // 24: org.apache.beam.model.pipeline.v1.BeamConstants
	(*Components)(nil),                                  // 25: org.apache.beam.model.pipeline.v1.Components
	(*Pipeline)(nil),                                    // 26: org.apache.beam.model.pipeline.v1.Pipeline
	(*PTransform)(nil),                                  // 27: org.apache.beam.model.pipeline.v1.PTransform
	(*StandardPTransforms)(nil),                         // 28: org.apache.beam.model.pipeline.v1.StandardPTransforms
	(*StandardSideInputTypes)(nil),                      // 29: org.apache.beam.model.pipeline.v1.StandardSideInputTypes
	(*PCollection)(nil),                                 // 30: org.apache.beam.model.pipeline.v1.PCollection
	(*ParDoPayload)(nil),                                // 31: org.apache.beam.model.pipeline.v1.ParDoPayload
	(*StateSpec)(nil),                                   // 32: org.apache.beam.model.pipeline.v1.StateSpec
	(*ReadModifyWriteStateSpec)(nil),                    // 33: org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec
	(*BagStateSpec)(nil),                                // 34: org.apache.beam.model.pipeline.v1.BagStateSpec
	(*OrderedListStateSpec)(nil),                        // 35: org.apache.beam.model.pipeline.v1.OrderedListStateSpec
	(*CombiningStateSpec)(nil),                          // 36: org.apache.beam.model.pipeline.v1.CombiningStateSpec
	(*MapStateSpec)(nil),                                // 37: org.apache.beam.model.pipeline.v1.MapStateSpec
	(*SetStateSpec)(nil),                                // 38: org.apache.beam.model.pipeline.v1.SetStateSpec
	(*TimerFamilySpec)(nil),                             // 39: org.apache.beam.model.pipeline.v1.TimerFamilySpec
	(*IsBounded)(nil),                                   // 40: org.apache.beam.model.pipeline.v1.IsBounded
	(*ReadPayload)(nil),                                 // 41: org.apache.beam.model.pipeline.v1.ReadPayload
	(*WindowIntoPayload)(nil),                           // 42: org.apache.beam.model.pipeline.v1.WindowIntoPayload
	(*CombinePayload)(nil),                              // 43: org.apache.beam.model.pipeline.v1.CombinePayload
	(*TestStreamPayload)(nil),                           // 44: org.apache.beam.model.pipeline.v1.TestStreamPayload
	(*EventsRequest)(nil),                               // 45: org.apache.beam.model.pipeline.v1.EventsRequest
	(*WriteFilesPayload)(nil),                           // 46: org.apache.beam.model.pipeline.v1.WriteFilesPayload
	(*PubSubReadPayload)(nil),                           // 47: org.apache.beam.model.pipeline.v1.PubSubReadPayload
	(*PubSubWritePayload)(nil),                          // 48: org.apache.beam.model.pipeline.v1.PubSubWritePayload
	(*GroupIntoBatchesPayload)(nil),                     // 49: org.apache.beam.model.pipeline.v1.GroupIntoBatchesPayload
	(*Coder)(nil),                                       // 50: org.apache.beam.model.pipeline.v1.Coder
	(*StandardCoders)(nil),                              // 51: org.apache.beam.model.pipeline.v1.StandardCoders
	(*WindowingStrategy)(nil),                           // 52: org.apache.beam.model.pipeline.v1.WindowingStrategy
	(*MergeStatus)(nil),                                 // 53: org.apache.beam.model.pipeline.v1.MergeStatus
	(*AccumulationMode)(nil),                            // 54: org.apache.beam.model.pipeline.v1.AccumulationMode
	(*ClosingBehavior)(nil),                             // 55: org.apache.beam.model.pipeline.v1.ClosingBehavior
	(*OnTimeBehavior)(nil),                              // 56: org.apache.beam.model.pipeline.v1.OnTimeBehavior
	(*OutputTime)(nil),                                  // 57: org.apache.beam.model.pipeline.v1.OutputTime
	(*TimeDomain)(nil),                                  // 58: org.apache.beam.model.pipeline.v1.TimeDomain
	(*Trigger)(nil),                                     // 59: org.apache.beam.model.pipeline.v1.Trigger
	(*TimestampTransform)(nil),                          // 60: org.apache.beam.model.pipeline.v1.TimestampTransform
	(*SideInput)(nil),                                   // 61: org.apache.beam.model.pipeline.v1.SideInput
	(*StandardArtifacts)(nil),                           // 62: org.apache.beam.model.pipeline.v1.StandardArtifacts
	(*ArtifactFilePayload)(nil),                         // 63: org.apache.beam.model.pipeline.v1.ArtifactFilePayload
	(*ArtifactUrlPayload)(nil),                          // 64: org.apache.beam.model.pipeline.v1.ArtifactUrlPayload
	(*EmbeddedFilePayload)(nil),                         // 65: org.apache.beam.model.pipeline.v1.EmbeddedFilePayload
	(*PyPIPayload)(nil),                                 // 66: org.apache.beam.model.pipeline.v1.PyPIPayload
	(*MavenPayload)(nil),                                // 67: org.apache.beam.model.pipeline.v1.MavenPayload
	(*DeferredArtifactPayload)(nil),                     // 68: org.apache.beam.model.pipeline.v1.DeferredArtifactPayload
	(*ArtifactStagingToRolePayload)(nil),                // 69: org.apache.beam.model.pipeline.v1.ArtifactStagingToRolePayload
	(*ArtifactInformation)(nil),                         // 70: org.apache.beam.model.pipeline.v1.ArtifactInformation
	(*Environment)(nil),                                 // 71: org.apache.beam.model.pipeline.v1.Environment
	(*StandardEnvironments)(nil),                        // 72: org.apache.beam.model.pipeline.v1.StandardEnvironments
	(*DockerPayload)(nil),                               // 73: org.apache.beam.model.pipeline.v1.DockerPayload
	(*ProcessPayload)(nil),                              // 74: org.apache.beam.model.pipeline.v1.ProcessPayload
	(*ExternalPayload)(nil),                             // 75: org.apache.beam.model.pipeline.v1.ExternalPayload
	(*StandardProtocols)(nil),                           // 76: org.apache.beam.model.pipeline.v1.StandardProtocols
	(*StandardRunnerProtocols)(nil),                     // 77: org.apache.beam.model.pipeline.v1.StandardRunnerProtocols
	(*StandardRequirements)(nil),                        // 78: org.apache.beam.model.pipeline.v1.StandardRequirements
	(*FunctionSpec)(nil),                                // 79: org.apache.beam.model.pipeline.v1.FunctionSpec
	(*StandardDisplayData)(nil),                         // 80: org.apache.beam.model.pipeline.v1.StandardDisplayData
	(*LabelledPayload)(nil),                             // 81: org.apache.beam.model.pipeline.v1.LabelledPayload
	(*DisplayData)(nil),                                 // 82: org.apache.beam.model.pipeline.v1.DisplayData
	(*MessageWithComponents)(nil),                       // 83: org.apache.beam.model.pipeline.v1.MessageWithComponents
	(*ExecutableStagePayload)(nil),                      // 84: org.apache.beam.model.pipeline.v1.ExecutableStagePayload
	(*StandardResourceHints)(nil),                       // 85: org.apache.beam.model.pipeline.v1.StandardResourceHints
	nil,                                                 // 86: org.apache.beam.model.pipeline.v1.Components.TransformsEntry
	nil,                                                 // 87: org.apache.beam.model.pipeline.v1.Components.PcollectionsEntry
	nil,                                                 // 88: org.apache.beam.model.pipeline.v1.Components.WindowingStrategiesEntry
	nil,                                                 // 89: org.apache.beam.model.pipeline.v1.Components.CodersEntry
	nil,                                                 // 90: org.apache.beam.model.pipeline.v1.Components.EnvironmentsEntry
	nil,                                                 // 91: org.apache.beam.model.pipeline.v1.PTransform.InputsEntry
	nil,                                                 // 92: org.apache.beam.model.pipeline.v1.PTransform.OutputsEntry
	nil,                                                 // 93: org.apache.beam.model.pipeline.v1.PTransform.AnnotationsEntry
	nil,                                                 // 94: org.apache.beam.model.pipeline.v1.ParDoPayload.SideInputsEntry
	nil,                                                 // 95: org.apache.beam.model.pipeline.v1.ParDoPayload.StateSpecsEntry
	nil,                                                 // 96: org.apache.beam.model.pipeline.v1.ParDoPayload.TimerFamilySpecsEntry
	(*TestStreamPayload_Event)(nil),                     // 97: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event
	(*TestStreamPayload_TimestampedElement)(nil),        // 98: org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement
	(*TestStreamPayload_Event_AdvanceWatermark)(nil),    // 99: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark
	(*TestStreamPayload_Event_AdvanceProcessingTime)(nil), // 100: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime
	(*TestStreamPayload_Event_AddElements)(nil),           // 101: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements
	nil,                                             // 102: org.apache.beam.model.pipeline.v1.WriteFilesPayload.SideInputsEntry
	(*Trigger_AfterAll)(nil),                        // 103: org.apache.beam.model.pipeline.v1.Trigger.AfterAll
	(*Trigger_AfterAny)(nil),                        // 104: org.apache.beam.model.pipeline.v1.Trigger.AfterAny
	(*Trigger_AfterEach)(nil),                       // 105: org.apache.beam.model.pipeline.v1.Trigger.AfterEach
	(*Trigger_AfterEndOfWindow)(nil),                // 106: org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow
	(*Trigger_AfterProcessingTime)(nil),             // 107: org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime
	(*Trigger_AfterSynchronizedProcessingTime)(nil), // 108: org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime
	(*Trigger_Default)(nil),                         // 109: org.apache.beam.model.pipeline.v1.Trigger.Default
	(*Trigger_ElementCount)(nil),                    // 110: org.apache.beam.model.pipeline.v1.Trigger.ElementCount
	(*Trigger_Never)(nil),                           // 111: org.apache.beam.model.pipeline.v1.Trigger.Never
	(*Trigger_Always)(nil),                          // 112: org.apache.beam.model.pipeline.v1.Trigger.Always
	(*Trigger_OrFinally)(nil),                       // 113: org.apache.beam.model.pipeline.v1.Trigger.OrFinally
	(*Trigger_Repeat)(nil),                          // 114: org.apache.beam.model.pipeline.v1.Trigger.Repeat
	(*TimestampTransform_Delay)(nil),                // 115: org.apache.beam.model.pipeline.v1.TimestampTransform.Delay
	(*TimestampTransform_AlignTo)(nil),              // 116: org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo
	nil,                                             // 117: org.apache.beam.model.pipeline.v1.Environment.ResourceHintsEntry
	nil,                                             // 118: org.apache.beam.model.pipeline.v1.ProcessPayload.EnvEntry
	nil,                                             // 119: org.apache.beam.model.pipeline.v1.ExternalPayload.ParamsEntry
	(*ExecutableStagePayload_SideInputId)(nil),      // 120: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId
	(*ExecutableStagePayload_UserStateId)(nil),      // 121: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId
	(*ExecutableStagePayload_TimerId)(nil),          // 122: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId
	(*ExecutableStagePayload_TimerFamilyId)(nil),    // 123: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId
	(*ExecutableStagePayload_WireCoderSetting)(nil), // 124: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting
	(*ApiServiceDescriptor)(nil),                    // 125: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor
	(*descriptorpb.EnumValueOptions)(nil),           // 126: google.protobuf.EnumValueOptions
}
var file_beam_runner_api_proto_depIdxs = []int32{
	86,  // 0: org.apache.beam.model.pipeline.v1.Components.transforms:type_name -> org.apache.beam.model.pipeline.v1.Components.TransformsEntry
	87,  // 1: org.apache.beam.model.pipeline.v1.Components.pcollections:type_name -> org.apache.beam.model.pipeline.v1.Components.PcollectionsEntry
	88,  // 2: org.apache.beam.model.pipeline.v1.Components.windowing_strategies:type_name -> org.apache.beam.model.pipeline.v1.Components.WindowingStrategiesEntry
	89,  // 3: org.apache.beam.model.pipeline.v1.Components.coders:type_name -> org.apache.beam.model.pipeline.v1.Components.CodersEntry
	90,  // 4: org.apache.beam.model.pipeline.v1.Components.environments:type_name -> org.apache.beam.model.pipeline.v1.Components.EnvironmentsEntry
	25,  // 5: org.apache.beam.model.pipeline.v1.Pipeline.components:type_name -> org.apache.beam.model.pipeline.v1.Components
	82,  // 6: org.apache.beam.model.pipeline.v1.Pipeline.display_data:type_name -> org.apache.beam.model.pipeline.v1.DisplayData
	79,  // 7: org.apache.beam.model.pipeline.v1.PTransform.spec:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	91,  // 8: org.apache.beam.model.pipeline.v1.PTransform.inputs:type_name -> org.apache.beam.model.pipeline.v1.PTransform.InputsEntry
	92,  // 9: org.apache.beam.model.pipeline.v1.PTransform.outputs:type_name -> org.apache.beam.model.pipeline.v1.PTransform.OutputsEntry
	82,  // 10: org.apache.beam.model.pipeline.v1.PTransform.display_data:type_name -> org.apache.beam.model.pipeline.v1.DisplayData
	93,  // 11: org.apache.beam.model.pipeline.v1.PTransform.annotations:type_name -> org.apache.beam.model.pipeline.v1.PTransform.AnnotationsEntry
	8,   // 12: org.apache.beam.model.pipeline.v1.PCollection.is_bounded:type_name -> org.apache.beam.model.pipeline.v1.IsBounded.Enum
	82,  // 13: org.apache.beam.model.pipeline.v1.PCollection.display_data:type_name -> org.apache.beam.model.pipeline.v1.DisplayData
	79,  // 14: org.apache.beam.model.pipeline.v1.ParDoPayload.do_fn:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	94,  // 15: org.apache.beam.model.pipeline.v1.ParDoPayload.side_inputs:type_name -> org.apache.beam.model.pipeline.v1.ParDoPayload.SideInputsEntry
	95,  // 16: org.apache.beam.model.pipeline.v1.ParDoPayload.state_specs:type_name -> org.apache.beam.model.pipeline.v1.ParDoPayload.StateSpecsEntry
	96,  // 17: org.apache.beam.model.pipeline.v1.ParDoPayload.timer_family_specs:type_name -> org.apache.beam.model.pipeline.v1.ParDoPayload.TimerFamilySpecsEntry
	33,  // 18: org.apache.beam.model.pipeline.v1.StateSpec.read_modify_write_spec:type_name -> org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec
	34,  // 19: org.apache.beam.model.pipeline.v1.StateSpec.bag_spec:type_name -> org.apache.beam.model.pipeline.v1.BagStateSpec
	36,  // 20: org.apache.beam.model.pipeline.v1.StateSpec.combining_spec:type_name -> org.apache.beam.model.pipeline.v1.CombiningStateSpec
	37,  // 21: org.apache.beam.model.pipeline.v1.StateSpec.map_spec:type_name -> org.apache.beam.model.pipeline.v1.MapStateSpec
	38,  // 22: org.apache.beam.model.pipeline.v1.StateSpec.set_spec:type_name -> org.apache.beam.model.pipeline.v1.SetStateSpec
	35,  // 23: org.apache.beam.model.pipeline.v1.StateSpec.ordered_list_spec:type_name -> org.apache.beam.model.pipeline.v1.OrderedListStateSpec
	79,  // 24: org.apache.beam.model.pipeline.v1.CombiningStateSpec.combine_fn:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	15,  // 25: org.apache.beam.model.pipeline.v1.TimerFamilySpec.time_domain:type_name -> org.apache.beam.model.pipeline.v1.TimeDomain.Enum
	79,  // 26: org.apache.beam.model.pipeline.v1.ReadPayload.source:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	8,   // 27: org.apache.beam.model.pipeline.v1.ReadPayload.is_bounded:type_name -> org.apache.beam.model.pipeline.v1.IsBounded.Enum
	79,  // 28: org.apache.beam.model.pipeline.v1.WindowIntoPayload.window_fn:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	79,  // 29: org.apache.beam.model.pipeline.v1.CombinePayload.combine_fn:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	97,  // 30: org.apache.beam.model.pipeline.v1.TestStreamPayload.events:type_name -> org.apache.beam.model.pipeline.v1.TestStreamPayload.Event
	125, // 31: org.apache.beam.model.pipeline.v1.TestStreamPayload.endpoint:type_name -> org.apache.beam.model.pipeline.v1.ApiServiceDescriptor
	79,  // 32: org.apache.beam.model.pipeline.v1.WriteFilesPayload.sink:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	79,  // 33: org.apache.beam.model.pipeline.v1.WriteFilesPayload.format_function:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	102, // 34: org.apache.beam.model.pipeline.v1.WriteFilesPayload.side_inputs:type_name -> org.apache.beam.model.pipeline.v1.WriteFilesPayload.SideInputsEntry
	79,  // 35: org.apache.beam.model.pipeline.v1.Coder.spec:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	79,  // 36: org.apache.beam.model.pipeline.v1.WindowingStrategy.window_fn:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	10,  // 37: org.apache.beam.model.pipeline.v1.WindowingStrategy.merge_status:type_name -> org.apache.beam.model.pipeline.v1.MergeStatus.Enum
	59,  // 38: org.apache.beam.model.pipeline.v1.WindowingStrategy.trigger:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	11,  // 39: org.apache.beam.model.pipeline.v1.WindowingStrategy.accumulation_mode:type_name -> org.apache.beam.model.pipeline.v1.AccumulationMode.Enum
	14,  // 40: org.apache.beam.model.pipeline.v1.WindowingStrategy.output_time:type_name -> org.apache.beam.model.pipeline.v1.OutputTime.Enum
	12,  // 41: org.apache.beam.model.pipeline.v1.WindowingStrategy.closing_behavior:type_name -> org.apache.beam.model.pipeline.v1.ClosingBehavior.Enum
	13,  // 42: org.apache.beam.model.pipeline.v1.WindowingStrategy.OnTimeBehavior:type_name -> org.apache.beam.model.pipeline.v1.OnTimeBehavior.Enum
	103, // 43: org.apache.beam.model.pipeline.v1.Trigger.after_all:type_name -> org.apache.beam.model.pipeline.v1.Trigger.AfterAll
	104, // 44: org.apache.beam.model.pipeline.v1.Trigger.after_any:type_name -> org.apache.beam.model.pipeline.v1.Trigger.AfterAny
	105, // 45: org.apache.beam.model.pipeline.v1.Trigger.after_each:type_name -> org.apache.beam.model.pipeline.v1.Trigger.AfterEach
	106, // 46: org.apache.beam.model.pipeline.v1.Trigger.after_end_of_window:type_name -> org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow
	107, // 47: org.apache.beam.model.pipeline.v1.Trigger.after_processing_time:type_name -> org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime
	108, // 48: org.apache.beam.model.pipeline.v1.Trigger.after_synchronized_processing_time:type_name -> org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime
	112, // 49: org.apache.beam.model.pipeline.v1.Trigger.always:type_name -> org.apache.beam.model.pipeline.v1.Trigger.Always
	109, // 50: org.apache.beam.model.pipeline.v1.Trigger.default:type_name -> org.apache.beam.model.pipeline.v1.Trigger.Default
	110, // 51: org.apache.beam.model.pipeline.v1.Trigger.element_count:type_name -> org.apache.beam.model.pipeline.v1.Trigger.ElementCount
	111, // 52: org.apache.beam.model.pipeline.v1.Trigger.never:type_name -> org.apache.beam.model.pipeline.v1.Trigger.Never
	113, // 53: org.apache.beam.model.pipeline.v1.Trigger.or_finally:type_name -> org.apache.beam.model.pipeline.v1.Trigger.OrFinally
	114, // 54: org.apache.beam.model.pipeline.v1.Trigger.repeat:type_name -> org.apache.beam.model.pipeline.v1.Trigger.Repeat
	115, // 55: org.apache.beam.model.pipeline.v1.TimestampTransform.delay:type_name -> org.apache.beam.model.pipeline.v1.TimestampTransform.Delay
	116, // 56: org.apache.beam.model.pipeline.v1.TimestampTransform.align_to:type_name -> org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo
	79,  // 57: org.apache.beam.model.pipeline.v1.SideInput.access_pattern:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	79,  // 58: org.apache.beam.model.pipeline.v1.SideInput.view_fn:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	79,  // 59: org.apache.beam.model.pipeline.v1.SideInput.window_mapping_fn:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	82,  // 60: org.apache.beam.model.pipeline.v1.Environment.display_data:type_name -> org.apache.beam.model.pipeline.v1.DisplayData
	70,  // 61: org.apache.beam.model.pipeline.v1.Environment.dependencies:type_name -> org.apache.beam.model.pipeline.v1.ArtifactInformation
	117, // 62: org.apache.beam.model.pipeline.v1.Environment.resource_hints:type_name -> org.apache.beam.model.pipeline.v1.Environment.ResourceHintsEntry
	118, // 63: org.apache.beam.model.pipeline.v1.ProcessPayload.env:type_name -> org.apache.beam.model.pipeline.v1.ProcessPayload.EnvEntry
	125, // 64: org.apache.beam.model.pipeline.v1.ExternalPayload.endpoint:type_name -> org.apache.beam.model.pipeline.v1.ApiServiceDescriptor
	119, // 65: org.apache.beam.model.pipeline.v1.ExternalPayload.params:type_name -> org.apache.beam.model.pipeline.v1.ExternalPayload.ParamsEntry
	25,  // 66: org.apache.beam.model.pipeline.v1.MessageWithComponents.components:type_name -> org.apache.beam.model.pipeline.v1.Components
	50,  // 67: org.apache.beam.model.pipeline.v1.MessageWithComponents.coder:type_name -> org.apache.beam.model.pipeline.v1.Coder
	43,  // 68: org.apache.beam.model.pipeline.v1.MessageWithComponents.combine_payload:type_name -> org.apache.beam.model.pipeline.v1.CombinePayload
	79,  // 69: org.apache.beam.model.pipeline.v1.MessageWithComponents.function_spec:type_name -> org.apache.beam.model.pipeline.v1.FunctionSpec
	31,  // 70: org.apache.beam.model.pipeline.v1.MessageWithComponents.par_do_payload:type_name -> org.apache.beam.model.pipeline.v1.ParDoPayload
	27,  // 71: org.apache.beam.model.pipeline.v1.MessageWithComponents.ptransform:type_name -> org.apache.beam.model.pipeline.v1.PTransform
	30,  // 72: org.apache.beam.model.pipeline.v1.MessageWithComponents.pcollection:type_name -> org.apache.beam.model.pipeline.v1.PCollection
	41,  // 73: org.apache.beam.model.pipeline.v1.MessageWithComponents.read_payload:type_name -> org.apache.beam.model.pipeline.v1.ReadPayload
	61,  // 74: org.apache.beam.model.pipeline.v1.MessageWithComponents.side_input:type_name -> org.apache.beam.model.pipeline.v1.SideInput
	42,  // 75: org.apache.beam.model.pipeline.v1.MessageWithComponents.window_into_payload:type_name -> org.apache.beam.model.pipeline.v1.WindowIntoPayload
	52,  // 76: org.apache.beam.model.pipeline.v1.MessageWithComponents.windowing_strategy:type_name -> org.apache.beam.model.pipeline.v1.WindowingStrategy
	71,  // 77: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.environment:type_name -> org.apache.beam.model.pipeline.v1.Environment
	124, // 78: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.wire_coder_settings:type_name -> org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting
	120, // 79: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.side_inputs:type_name -> org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId
	25,  // 80: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.components:type_name -> org.apache.beam.model.pipeline.v1.Components
	121, // 81: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.user_states:type_name -> org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId
	122, // 82: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.timers:type_name -> org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId
	123, // 83: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.timerFamilies:type_name -> org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId
	27,  // 84: org.apache.beam.model.pipeline.v1.Components.TransformsEntry.value:type_name -> org.apache.beam.model.pipeline.v1.PTransform
	30,  // 85: org.apache.beam.model.pipeline.v1.Components.PcollectionsEntry.value:type_name -> org.apache.beam.model.pipeline.v1.PCollection
	52,  // 86: org.apache.beam.model.pipeline.v1.Components.WindowingStrategiesEntry.value:type_name -> org.apache.beam.model.pipeline.v1.WindowingStrategy
	50,  // 87: org.apache.beam.model.pipeline.v1.Components.CodersEntry.value:type_name -> org.apache.beam.model.pipeline.v1.Coder
	71,  // 88: org.apache.beam.model.pipeline.v1.Components.EnvironmentsEntry.value:type_name -> org.apache.beam.model.pipeline.v1.Environment
	61,  // 89: org.apache.beam.model.pipeline.v1.ParDoPayload.SideInputsEntry.value:type_name -> org.apache.beam.model.pipeline.v1.SideInput
	32,  // 90: org.apache.beam.model.pipeline.v1.ParDoPayload.StateSpecsEntry.value:type_name -> org.apache.beam.model.pipeline.v1.StateSpec
	39,  // 91: org.apache.beam.model.pipeline.v1.ParDoPayload.TimerFamilySpecsEntry.value:type_name -> org.apache.beam.model.pipeline.v1.TimerFamilySpec
	99,  // 92: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.watermark_event:type_name -> org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark
	100, // 93: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.processing_time_event:type_name -> org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime
	101, // 94: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.element_event:type_name -> org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements
	98,  // 95: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements.elements:type_name -> org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement
	61,  // 96: org.apache.beam.model.pipeline.v1.WriteFilesPayload.SideInputsEntry.value:type_name -> org.apache.beam.model.pipeline.v1.SideInput
	59,  // 97: org.apache.beam.model.pipeline.v1.Trigger.AfterAll.subtriggers:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	59,  // 98: org.apache.beam.model.pipeline.v1.Trigger.AfterAny.subtriggers:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	59,  // 99: org.apache.beam.model.pipeline.v1.Trigger.AfterEach.subtriggers:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	59,  // 100: org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow.early_firings:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	59,  // 101: org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow.late_firings:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	60,  // 102: org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime.timestamp_transforms:type_name -> org.apache.beam.model.pipeline.v1.TimestampTransform
	59,  // 103: org.apache.beam.model.pipeline.v1.Trigger.OrFinally.main:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	59,  // 104: org.apache.beam.model.pipeline.v1.Trigger.OrFinally.finally:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	59,  // 105: org.apache.beam.model.pipeline.v1.Trigger.Repeat.subtrigger:type_name -> org.apache.beam.model.pipeline.v1.Trigger
	122, // 106: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting.timer:type_name -> org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId
	126, // 107: org.apache.beam.model.pipeline.v1.beam_urn:extendee -> google.protobuf.EnumValueOptions
	126, // 108: org.apache.beam.model.pipeline.v1.beam_constant:extendee -> google.protobuf.EnumValueOptions
	45,  // 109: org.apache.beam.model.pipeline.v1.TestStreamService.Events:input_type -> org.apache.beam.model.pipeline.v1.EventsRequest
	97,  // 110: org.apache.beam.model.pipeline.v1.TestStreamService.Events:output_type -> org.apache.beam.model.pipeline.v1.TestStreamPayload.Event
	110, // [110:111] is the sub-list for method output_type
	109, // [109:110] is the sub-list for method input_type
	109, // [109:109] is the sub-list for extension type_name
	107, // [107:109] is the sub-list for extension extendee
	0,   // [0:107] is the sub-list for field type_name
}

func init() { file_beam_runner_api_proto_init() }
func file_beam_runner_api_proto_init() {
	if File_beam_runner_api_proto != nil {
		return
	}
	file_endpoints_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_beam_runner_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeamConstants); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Components); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PTransform); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardPTransforms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardSideInputTypes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PCollection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParDoPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadModifyWriteStateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BagStateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderedListStateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CombiningStateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapStateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetStateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimerFamilySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IsBounded); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowIntoPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CombinePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestStreamPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteFilesPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubSubReadPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubSubWritePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupIntoBatchesPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Coder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardCoders); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowingStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccumulationMode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClosingBehavior); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OnTimeBehavior); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeDomain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampTransform); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SideInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardArtifacts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactFilePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactUrlPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EmbeddedFilePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PyPIPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MavenPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeferredArtifactPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactStagingToRolePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactInformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Environment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardEnvironments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DockerPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardProtocols); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardRunnerProtocols); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardRequirements); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardDisplayData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelledPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisplayData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageWithComponents); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutableStagePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandardResourceHints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestStreamPayload_Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestStreamPayload_TimestampedElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestStreamPayload_Event_AdvanceWatermark); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestStreamPayload_Event_AdvanceProcessingTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestStreamPayload_Event_AddElements); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_AfterAll); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_AfterAny); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_AfterEach); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_AfterEndOfWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_AfterProcessingTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_AfterSynchronizedProcessingTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_Default); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_ElementCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_Never); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_Always); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_OrFinally); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger_Repeat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampTransform_Delay); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampTransform_AlignTo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutableStagePayload_SideInputId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutableStagePayload_UserStateId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutableStagePayload_TimerId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutableStagePayload_TimerFamilyId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_runner_api_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutableStagePayload_WireCoderSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_beam_runner_api_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*StateSpec_ReadModifyWriteSpec)(nil),
		(*StateSpec_BagSpec)(nil),
		(*StateSpec_CombiningSpec)(nil),
		(*StateSpec_MapSpec)(nil),
		(*StateSpec_SetSpec)(nil),
		(*StateSpec_OrderedListSpec)(nil),
	}
	file_beam_runner_api_proto_msgTypes[35].OneofWrappers = []interface{}{
		(*Trigger_AfterAll_)(nil),
		(*Trigger_AfterAny_)(nil),
		(*Trigger_AfterEach_)(nil),
		(*Trigger_AfterEndOfWindow_)(nil),
		(*Trigger_AfterProcessingTime_)(nil),
		(*Trigger_AfterSynchronizedProcessingTime_)(nil),
		(*Trigger_Always_)(nil),
		(*Trigger_Default_)(nil),
		(*Trigger_ElementCount_)(nil),
		(*Trigger_Never_)(nil),
		(*Trigger_OrFinally_)(nil),
		(*Trigger_Repeat_)(nil),
	}
	file_beam_runner_api_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*TimestampTransform_Delay_)(nil),
		(*TimestampTransform_AlignTo_)(nil),
	}
	file_beam_runner_api_proto_msgTypes[57].OneofWrappers = []interface{}{
		(*LabelledPayload_StringValue)(nil),
		(*LabelledPayload_BoolValue)(nil),
		(*LabelledPayload_DoubleValue)(nil),
	}
	file_beam_runner_api_proto_msgTypes[59].OneofWrappers = []interface{}{
		(*MessageWithComponents_Coder)(nil),
		(*MessageWithComponents_CombinePayload)(nil),
		(*MessageWithComponents_FunctionSpec)(nil),
		(*MessageWithComponents_ParDoPayload)(nil),
		(*MessageWithComponents_Ptransform)(nil),
		(*MessageWithComponents_Pcollection)(nil),
		(*MessageWithComponents_ReadPayload)(nil),
		(*MessageWithComponents_SideInput)(nil),
		(*MessageWithComponents_WindowIntoPayload)(nil),
		(*MessageWithComponents_WindowingStrategy)(nil),
	}
	file_beam_runner_api_proto_msgTypes[73].OneofWrappers = []interface{}{
		(*TestStreamPayload_Event_WatermarkEvent)(nil),
		(*TestStreamPayload_Event_ProcessingTimeEvent)(nil),
		(*TestStreamPayload_Event_ElementEvent)(nil),
	}
	file_beam_runner_api_proto_msgTypes[100].OneofWrappers = []interface{}{
		(*ExecutableStagePayload_WireCoderSetting_InputOrOutputId)(nil),
		(*ExecutableStagePayload_WireCoderSetting_Timer)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_beam_runner_api_proto_rawDesc,
			NumEnums:      24,
			NumMessages:   101,
			NumExtensions: 2,
			NumServices:   1,
		},
		GoTypes:           file_beam_runner_api_proto_goTypes,
		DependencyIndexes: file_beam_runner_api_proto_depIdxs,
		EnumInfos:         file_beam_runner_api_proto_enumTypes,
		MessageInfos:      file_beam_runner_api_proto_msgTypes,
		ExtensionInfos:    file_beam_runner_api_proto_extTypes,
	}.Build()
	File_beam_runner_api_proto = out.File
	file_beam_runner_api_proto_rawDesc = nil
	file_beam_runner_api_proto_goTypes = nil
	file_beam_runner_api_proto_depIdxs = nil
}
