// File generated by specialize. Do not edit.

// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package optimized

import (
	"reflect"

	"github.com/apache/beam/sdks/v2/go/pkg/beam/core/typex"
	"github.com/apache/beam/sdks/v2/go/pkg/beam/core/util/reflectx"
)

// This template registers all forms of decoders as general
// reflectx.Func specializations for each X.

func init() {
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) []byte)(nil)).Elem(), decoderMakerByteSlice)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) ([]byte, error))(nil)).Elem(), decoderMakerByteSliceE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) []byte)(nil)).Elem(), decoderMakerTByteSlice)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) ([]byte, error))(nil)).Elem(), decoderMakerTByteSliceE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) bool)(nil)).Elem(), decoderMakerBool)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (bool, error))(nil)).Elem(), decoderMakerBoolE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) bool)(nil)).Elem(), decoderMakerTBool)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (bool, error))(nil)).Elem(), decoderMakerTBoolE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) string)(nil)).Elem(), decoderMakerString)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (string, error))(nil)).Elem(), decoderMakerStringE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) string)(nil)).Elem(), decoderMakerTString)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (string, error))(nil)).Elem(), decoderMakerTStringE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) int)(nil)).Elem(), decoderMakerInt)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (int, error))(nil)).Elem(), decoderMakerIntE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) int)(nil)).Elem(), decoderMakerTInt)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (int, error))(nil)).Elem(), decoderMakerTIntE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) int8)(nil)).Elem(), decoderMakerInt8)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (int8, error))(nil)).Elem(), decoderMakerInt8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) int8)(nil)).Elem(), decoderMakerTInt8)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (int8, error))(nil)).Elem(), decoderMakerTInt8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) int16)(nil)).Elem(), decoderMakerInt16)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (int16, error))(nil)).Elem(), decoderMakerInt16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) int16)(nil)).Elem(), decoderMakerTInt16)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (int16, error))(nil)).Elem(), decoderMakerTInt16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) int32)(nil)).Elem(), decoderMakerInt32)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (int32, error))(nil)).Elem(), decoderMakerInt32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) int32)(nil)).Elem(), decoderMakerTInt32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (int32, error))(nil)).Elem(), decoderMakerTInt32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) int64)(nil)).Elem(), decoderMakerInt64)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (int64, error))(nil)).Elem(), decoderMakerInt64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) int64)(nil)).Elem(), decoderMakerTInt64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (int64, error))(nil)).Elem(), decoderMakerTInt64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) uint)(nil)).Elem(), decoderMakerUint)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (uint, error))(nil)).Elem(), decoderMakerUintE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) uint)(nil)).Elem(), decoderMakerTUint)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (uint, error))(nil)).Elem(), decoderMakerTUintE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) uint8)(nil)).Elem(), decoderMakerUint8)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (uint8, error))(nil)).Elem(), decoderMakerUint8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) uint8)(nil)).Elem(), decoderMakerTUint8)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (uint8, error))(nil)).Elem(), decoderMakerTUint8E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) uint16)(nil)).Elem(), decoderMakerUint16)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (uint16, error))(nil)).Elem(), decoderMakerUint16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) uint16)(nil)).Elem(), decoderMakerTUint16)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (uint16, error))(nil)).Elem(), decoderMakerTUint16E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) uint32)(nil)).Elem(), decoderMakerUint32)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (uint32, error))(nil)).Elem(), decoderMakerUint32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) uint32)(nil)).Elem(), decoderMakerTUint32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (uint32, error))(nil)).Elem(), decoderMakerTUint32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) uint64)(nil)).Elem(), decoderMakerUint64)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (uint64, error))(nil)).Elem(), decoderMakerUint64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) uint64)(nil)).Elem(), decoderMakerTUint64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (uint64, error))(nil)).Elem(), decoderMakerTUint64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) float32)(nil)).Elem(), decoderMakerFloat32)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (float32, error))(nil)).Elem(), decoderMakerFloat32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) float32)(nil)).Elem(), decoderMakerTFloat32)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (float32, error))(nil)).Elem(), decoderMakerTFloat32E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) float64)(nil)).Elem(), decoderMakerFloat64)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (float64, error))(nil)).Elem(), decoderMakerFloat64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) float64)(nil)).Elem(), decoderMakerTFloat64)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (float64, error))(nil)).Elem(), decoderMakerTFloat64E)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) typex.T)(nil)).Elem(), decoderMakerTypex_T)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (typex.T, error))(nil)).Elem(), decoderMakerTypex_TE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) typex.T)(nil)).Elem(), decoderMakerTTypex_T)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (typex.T, error))(nil)).Elem(), decoderMakerTTypex_TE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) typex.U)(nil)).Elem(), decoderMakerTypex_U)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (typex.U, error))(nil)).Elem(), decoderMakerTypex_UE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) typex.U)(nil)).Elem(), decoderMakerTTypex_U)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (typex.U, error))(nil)).Elem(), decoderMakerTTypex_UE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) typex.V)(nil)).Elem(), decoderMakerTypex_V)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (typex.V, error))(nil)).Elem(), decoderMakerTypex_VE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) typex.V)(nil)).Elem(), decoderMakerTTypex_V)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (typex.V, error))(nil)).Elem(), decoderMakerTTypex_VE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) typex.W)(nil)).Elem(), decoderMakerTypex_W)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (typex.W, error))(nil)).Elem(), decoderMakerTypex_WE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) typex.W)(nil)).Elem(), decoderMakerTTypex_W)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (typex.W, error))(nil)).Elem(), decoderMakerTTypex_WE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) typex.X)(nil)).Elem(), decoderMakerTypex_X)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (typex.X, error))(nil)).Elem(), decoderMakerTypex_XE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) typex.X)(nil)).Elem(), decoderMakerTTypex_X)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (typex.X, error))(nil)).Elem(), decoderMakerTTypex_XE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) typex.Y)(nil)).Elem(), decoderMakerTypex_Y)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (typex.Y, error))(nil)).Elem(), decoderMakerTypex_YE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) typex.Y)(nil)).Elem(), decoderMakerTTypex_Y)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (typex.Y, error))(nil)).Elem(), decoderMakerTTypex_YE)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) typex.Z)(nil)).Elem(), decoderMakerTypex_Z)
	reflectx.RegisterFunc(reflect.TypeOf((*func([]byte) (typex.Z, error))(nil)).Elem(), decoderMakerTypex_ZE)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) typex.Z)(nil)).Elem(), decoderMakerTTypex_Z)
	reflectx.RegisterFunc(reflect.TypeOf((*func(reflect.Type, []byte) (typex.Z, error))(nil)).Elem(), decoderMakerTTypex_ZE)
}

type decoderByteSlice struct {
	fn func([]byte) []byte
}

func decoderMakerByteSlice(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) []byte)
	return &decoderByteSlice{fn: f}
}

func (c *decoderByteSlice) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderByteSlice) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderByteSlice) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderByteSlice) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderByteSliceE struct {
	fn func([]byte) ([]byte, error)
}

func decoderMakerByteSliceE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) ([]byte, error))
	return &decoderByteSliceE{fn: f}
}

func (c *decoderByteSliceE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderByteSliceE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderByteSliceE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderByteSliceE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTByteSlice struct {
	fn func(reflect.Type, []byte) []byte
}

func decoderMakerTByteSlice(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) []byte)
	return &decoderTByteSlice{fn: f}
}

func (c *decoderTByteSlice) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTByteSlice) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTByteSlice) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTByteSlice) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTByteSliceE struct {
	fn func(reflect.Type, []byte) ([]byte, error)
}

func decoderMakerTByteSliceE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) ([]byte, error))
	return &decoderTByteSliceE{fn: f}
}

func (c *decoderTByteSliceE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTByteSliceE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTByteSliceE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTByteSliceE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderBool struct {
	fn func([]byte) bool
}

func decoderMakerBool(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) bool)
	return &decoderBool{fn: f}
}

func (c *decoderBool) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderBool) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderBool) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderBool) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderBoolE struct {
	fn func([]byte) (bool, error)
}

func decoderMakerBoolE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (bool, error))
	return &decoderBoolE{fn: f}
}

func (c *decoderBoolE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderBoolE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderBoolE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderBoolE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTBool struct {
	fn func(reflect.Type, []byte) bool
}

func decoderMakerTBool(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) bool)
	return &decoderTBool{fn: f}
}

func (c *decoderTBool) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTBool) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTBool) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTBool) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTBoolE struct {
	fn func(reflect.Type, []byte) (bool, error)
}

func decoderMakerTBoolE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (bool, error))
	return &decoderTBoolE{fn: f}
}

func (c *decoderTBoolE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTBoolE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTBoolE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTBoolE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderString struct {
	fn func([]byte) string
}

func decoderMakerString(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) string)
	return &decoderString{fn: f}
}

func (c *decoderString) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderString) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderString) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderString) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderStringE struct {
	fn func([]byte) (string, error)
}

func decoderMakerStringE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (string, error))
	return &decoderStringE{fn: f}
}

func (c *decoderStringE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderStringE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderStringE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderStringE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTString struct {
	fn func(reflect.Type, []byte) string
}

func decoderMakerTString(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) string)
	return &decoderTString{fn: f}
}

func (c *decoderTString) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTString) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTString) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTString) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTStringE struct {
	fn func(reflect.Type, []byte) (string, error)
}

func decoderMakerTStringE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (string, error))
	return &decoderTStringE{fn: f}
}

func (c *decoderTStringE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTStringE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTStringE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTStringE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderInt struct {
	fn func([]byte) int
}

func decoderMakerInt(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) int)
	return &decoderInt{fn: f}
}

func (c *decoderInt) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderInt) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderIntE struct {
	fn func([]byte) (int, error)
}

func decoderMakerIntE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (int, error))
	return &decoderIntE{fn: f}
}

func (c *decoderIntE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderIntE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderIntE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderIntE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTInt struct {
	fn func(reflect.Type, []byte) int
}

func decoderMakerTInt(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) int)
	return &decoderTInt{fn: f}
}

func (c *decoderTInt) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTInt) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTIntE struct {
	fn func(reflect.Type, []byte) (int, error)
}

func decoderMakerTIntE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (int, error))
	return &decoderTIntE{fn: f}
}

func (c *decoderTIntE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTIntE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTIntE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTIntE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderInt8 struct {
	fn func([]byte) int8
}

func decoderMakerInt8(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) int8)
	return &decoderInt8{fn: f}
}

func (c *decoderInt8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderInt8) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderInt8E struct {
	fn func([]byte) (int8, error)
}

func decoderMakerInt8E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (int8, error))
	return &decoderInt8E{fn: f}
}

func (c *decoderInt8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt8E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderInt8E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTInt8 struct {
	fn func(reflect.Type, []byte) int8
}

func decoderMakerTInt8(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) int8)
	return &decoderTInt8{fn: f}
}

func (c *decoderTInt8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTInt8) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTInt8E struct {
	fn func(reflect.Type, []byte) (int8, error)
}

func decoderMakerTInt8E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (int8, error))
	return &decoderTInt8E{fn: f}
}

func (c *decoderTInt8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt8E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTInt8E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderInt16 struct {
	fn func([]byte) int16
}

func decoderMakerInt16(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) int16)
	return &decoderInt16{fn: f}
}

func (c *decoderInt16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderInt16) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderInt16E struct {
	fn func([]byte) (int16, error)
}

func decoderMakerInt16E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (int16, error))
	return &decoderInt16E{fn: f}
}

func (c *decoderInt16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt16E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderInt16E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTInt16 struct {
	fn func(reflect.Type, []byte) int16
}

func decoderMakerTInt16(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) int16)
	return &decoderTInt16{fn: f}
}

func (c *decoderTInt16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTInt16) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTInt16E struct {
	fn func(reflect.Type, []byte) (int16, error)
}

func decoderMakerTInt16E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (int16, error))
	return &decoderTInt16E{fn: f}
}

func (c *decoderTInt16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt16E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTInt16E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderInt32 struct {
	fn func([]byte) int32
}

func decoderMakerInt32(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) int32)
	return &decoderInt32{fn: f}
}

func (c *decoderInt32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderInt32) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderInt32E struct {
	fn func([]byte) (int32, error)
}

func decoderMakerInt32E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (int32, error))
	return &decoderInt32E{fn: f}
}

func (c *decoderInt32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt32E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderInt32E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTInt32 struct {
	fn func(reflect.Type, []byte) int32
}

func decoderMakerTInt32(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) int32)
	return &decoderTInt32{fn: f}
}

func (c *decoderTInt32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTInt32) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTInt32E struct {
	fn func(reflect.Type, []byte) (int32, error)
}

func decoderMakerTInt32E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (int32, error))
	return &decoderTInt32E{fn: f}
}

func (c *decoderTInt32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt32E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTInt32E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderInt64 struct {
	fn func([]byte) int64
}

func decoderMakerInt64(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) int64)
	return &decoderInt64{fn: f}
}

func (c *decoderInt64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderInt64) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderInt64E struct {
	fn func([]byte) (int64, error)
}

func decoderMakerInt64E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (int64, error))
	return &decoderInt64E{fn: f}
}

func (c *decoderInt64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderInt64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderInt64E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderInt64E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTInt64 struct {
	fn func(reflect.Type, []byte) int64
}

func decoderMakerTInt64(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) int64)
	return &decoderTInt64{fn: f}
}

func (c *decoderTInt64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTInt64) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTInt64E struct {
	fn func(reflect.Type, []byte) (int64, error)
}

func decoderMakerTInt64E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (int64, error))
	return &decoderTInt64E{fn: f}
}

func (c *decoderTInt64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTInt64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTInt64E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTInt64E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderUint struct {
	fn func([]byte) uint
}

func decoderMakerUint(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) uint)
	return &decoderUint{fn: f}
}

func (c *decoderUint) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderUint) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderUintE struct {
	fn func([]byte) (uint, error)
}

func decoderMakerUintE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (uint, error))
	return &decoderUintE{fn: f}
}

func (c *decoderUintE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUintE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUintE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderUintE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTUint struct {
	fn func(reflect.Type, []byte) uint
}

func decoderMakerTUint(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) uint)
	return &decoderTUint{fn: f}
}

func (c *decoderTUint) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTUint) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTUintE struct {
	fn func(reflect.Type, []byte) (uint, error)
}

func decoderMakerTUintE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (uint, error))
	return &decoderTUintE{fn: f}
}

func (c *decoderTUintE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUintE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUintE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTUintE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderUint8 struct {
	fn func([]byte) uint8
}

func decoderMakerUint8(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) uint8)
	return &decoderUint8{fn: f}
}

func (c *decoderUint8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderUint8) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderUint8E struct {
	fn func([]byte) (uint8, error)
}

func decoderMakerUint8E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (uint8, error))
	return &decoderUint8E{fn: f}
}

func (c *decoderUint8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint8E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderUint8E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTUint8 struct {
	fn func(reflect.Type, []byte) uint8
}

func decoderMakerTUint8(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) uint8)
	return &decoderTUint8{fn: f}
}

func (c *decoderTUint8) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint8) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint8) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTUint8) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTUint8E struct {
	fn func(reflect.Type, []byte) (uint8, error)
}

func decoderMakerTUint8E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (uint8, error))
	return &decoderTUint8E{fn: f}
}

func (c *decoderTUint8E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint8E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint8E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTUint8E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderUint16 struct {
	fn func([]byte) uint16
}

func decoderMakerUint16(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) uint16)
	return &decoderUint16{fn: f}
}

func (c *decoderUint16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderUint16) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderUint16E struct {
	fn func([]byte) (uint16, error)
}

func decoderMakerUint16E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (uint16, error))
	return &decoderUint16E{fn: f}
}

func (c *decoderUint16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint16E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderUint16E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTUint16 struct {
	fn func(reflect.Type, []byte) uint16
}

func decoderMakerTUint16(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) uint16)
	return &decoderTUint16{fn: f}
}

func (c *decoderTUint16) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint16) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint16) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTUint16) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTUint16E struct {
	fn func(reflect.Type, []byte) (uint16, error)
}

func decoderMakerTUint16E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (uint16, error))
	return &decoderTUint16E{fn: f}
}

func (c *decoderTUint16E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint16E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint16E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTUint16E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderUint32 struct {
	fn func([]byte) uint32
}

func decoderMakerUint32(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) uint32)
	return &decoderUint32{fn: f}
}

func (c *decoderUint32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderUint32) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderUint32E struct {
	fn func([]byte) (uint32, error)
}

func decoderMakerUint32E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (uint32, error))
	return &decoderUint32E{fn: f}
}

func (c *decoderUint32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint32E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderUint32E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTUint32 struct {
	fn func(reflect.Type, []byte) uint32
}

func decoderMakerTUint32(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) uint32)
	return &decoderTUint32{fn: f}
}

func (c *decoderTUint32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTUint32) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTUint32E struct {
	fn func(reflect.Type, []byte) (uint32, error)
}

func decoderMakerTUint32E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (uint32, error))
	return &decoderTUint32E{fn: f}
}

func (c *decoderTUint32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint32E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTUint32E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderUint64 struct {
	fn func([]byte) uint64
}

func decoderMakerUint64(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) uint64)
	return &decoderUint64{fn: f}
}

func (c *decoderUint64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderUint64) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderUint64E struct {
	fn func([]byte) (uint64, error)
}

func decoderMakerUint64E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (uint64, error))
	return &decoderUint64E{fn: f}
}

func (c *decoderUint64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderUint64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderUint64E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderUint64E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTUint64 struct {
	fn func(reflect.Type, []byte) uint64
}

func decoderMakerTUint64(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) uint64)
	return &decoderTUint64{fn: f}
}

func (c *decoderTUint64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTUint64) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTUint64E struct {
	fn func(reflect.Type, []byte) (uint64, error)
}

func decoderMakerTUint64E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (uint64, error))
	return &decoderTUint64E{fn: f}
}

func (c *decoderTUint64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTUint64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTUint64E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTUint64E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderFloat32 struct {
	fn func([]byte) float32
}

func decoderMakerFloat32(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) float32)
	return &decoderFloat32{fn: f}
}

func (c *decoderFloat32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderFloat32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderFloat32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderFloat32) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderFloat32E struct {
	fn func([]byte) (float32, error)
}

func decoderMakerFloat32E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (float32, error))
	return &decoderFloat32E{fn: f}
}

func (c *decoderFloat32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderFloat32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderFloat32E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderFloat32E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTFloat32 struct {
	fn func(reflect.Type, []byte) float32
}

func decoderMakerTFloat32(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) float32)
	return &decoderTFloat32{fn: f}
}

func (c *decoderTFloat32) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTFloat32) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTFloat32) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTFloat32) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTFloat32E struct {
	fn func(reflect.Type, []byte) (float32, error)
}

func decoderMakerTFloat32E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (float32, error))
	return &decoderTFloat32E{fn: f}
}

func (c *decoderTFloat32E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTFloat32E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTFloat32E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTFloat32E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderFloat64 struct {
	fn func([]byte) float64
}

func decoderMakerFloat64(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) float64)
	return &decoderFloat64{fn: f}
}

func (c *decoderFloat64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderFloat64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderFloat64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderFloat64) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderFloat64E struct {
	fn func([]byte) (float64, error)
}

func decoderMakerFloat64E(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (float64, error))
	return &decoderFloat64E{fn: f}
}

func (c *decoderFloat64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderFloat64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderFloat64E) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderFloat64E) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTFloat64 struct {
	fn func(reflect.Type, []byte) float64
}

func decoderMakerTFloat64(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) float64)
	return &decoderTFloat64{fn: f}
}

func (c *decoderTFloat64) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTFloat64) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTFloat64) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTFloat64) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTFloat64E struct {
	fn func(reflect.Type, []byte) (float64, error)
}

func decoderMakerTFloat64E(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (float64, error))
	return &decoderTFloat64E{fn: f}
}

func (c *decoderTFloat64E) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTFloat64E) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTFloat64E) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTFloat64E) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTypex_T struct {
	fn func([]byte) typex.T
}

func decoderMakerTypex_T(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) typex.T)
	return &decoderTypex_T{fn: f}
}

func (c *decoderTypex_T) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_T) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_T) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderTypex_T) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderTypex_TE struct {
	fn func([]byte) (typex.T, error)
}

func decoderMakerTypex_TE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (typex.T, error))
	return &decoderTypex_TE{fn: f}
}

func (c *decoderTypex_TE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_TE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_TE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderTypex_TE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTTypex_T struct {
	fn func(reflect.Type, []byte) typex.T
}

func decoderMakerTTypex_T(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) typex.T)
	return &decoderTTypex_T{fn: f}
}

func (c *decoderTTypex_T) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_T) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_T) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTTypex_T) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTTypex_TE struct {
	fn func(reflect.Type, []byte) (typex.T, error)
}

func decoderMakerTTypex_TE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (typex.T, error))
	return &decoderTTypex_TE{fn: f}
}

func (c *decoderTTypex_TE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_TE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_TE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTTypex_TE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTypex_U struct {
	fn func([]byte) typex.U
}

func decoderMakerTypex_U(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) typex.U)
	return &decoderTypex_U{fn: f}
}

func (c *decoderTypex_U) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_U) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_U) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderTypex_U) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderTypex_UE struct {
	fn func([]byte) (typex.U, error)
}

func decoderMakerTypex_UE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (typex.U, error))
	return &decoderTypex_UE{fn: f}
}

func (c *decoderTypex_UE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_UE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_UE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderTypex_UE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTTypex_U struct {
	fn func(reflect.Type, []byte) typex.U
}

func decoderMakerTTypex_U(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) typex.U)
	return &decoderTTypex_U{fn: f}
}

func (c *decoderTTypex_U) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_U) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_U) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTTypex_U) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTTypex_UE struct {
	fn func(reflect.Type, []byte) (typex.U, error)
}

func decoderMakerTTypex_UE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (typex.U, error))
	return &decoderTTypex_UE{fn: f}
}

func (c *decoderTTypex_UE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_UE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_UE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTTypex_UE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTypex_V struct {
	fn func([]byte) typex.V
}

func decoderMakerTypex_V(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) typex.V)
	return &decoderTypex_V{fn: f}
}

func (c *decoderTypex_V) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_V) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_V) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderTypex_V) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderTypex_VE struct {
	fn func([]byte) (typex.V, error)
}

func decoderMakerTypex_VE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (typex.V, error))
	return &decoderTypex_VE{fn: f}
}

func (c *decoderTypex_VE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_VE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_VE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderTypex_VE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTTypex_V struct {
	fn func(reflect.Type, []byte) typex.V
}

func decoderMakerTTypex_V(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) typex.V)
	return &decoderTTypex_V{fn: f}
}

func (c *decoderTTypex_V) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_V) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_V) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTTypex_V) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTTypex_VE struct {
	fn func(reflect.Type, []byte) (typex.V, error)
}

func decoderMakerTTypex_VE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (typex.V, error))
	return &decoderTTypex_VE{fn: f}
}

func (c *decoderTTypex_VE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_VE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_VE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTTypex_VE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTypex_W struct {
	fn func([]byte) typex.W
}

func decoderMakerTypex_W(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) typex.W)
	return &decoderTypex_W{fn: f}
}

func (c *decoderTypex_W) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_W) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_W) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderTypex_W) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderTypex_WE struct {
	fn func([]byte) (typex.W, error)
}

func decoderMakerTypex_WE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (typex.W, error))
	return &decoderTypex_WE{fn: f}
}

func (c *decoderTypex_WE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_WE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_WE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderTypex_WE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTTypex_W struct {
	fn func(reflect.Type, []byte) typex.W
}

func decoderMakerTTypex_W(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) typex.W)
	return &decoderTTypex_W{fn: f}
}

func (c *decoderTTypex_W) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_W) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_W) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTTypex_W) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTTypex_WE struct {
	fn func(reflect.Type, []byte) (typex.W, error)
}

func decoderMakerTTypex_WE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (typex.W, error))
	return &decoderTTypex_WE{fn: f}
}

func (c *decoderTTypex_WE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_WE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_WE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTTypex_WE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTypex_X struct {
	fn func([]byte) typex.X
}

func decoderMakerTypex_X(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) typex.X)
	return &decoderTypex_X{fn: f}
}

func (c *decoderTypex_X) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_X) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_X) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderTypex_X) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderTypex_XE struct {
	fn func([]byte) (typex.X, error)
}

func decoderMakerTypex_XE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (typex.X, error))
	return &decoderTypex_XE{fn: f}
}

func (c *decoderTypex_XE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_XE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_XE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderTypex_XE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTTypex_X struct {
	fn func(reflect.Type, []byte) typex.X
}

func decoderMakerTTypex_X(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) typex.X)
	return &decoderTTypex_X{fn: f}
}

func (c *decoderTTypex_X) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_X) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_X) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTTypex_X) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTTypex_XE struct {
	fn func(reflect.Type, []byte) (typex.X, error)
}

func decoderMakerTTypex_XE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (typex.X, error))
	return &decoderTTypex_XE{fn: f}
}

func (c *decoderTTypex_XE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_XE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_XE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTTypex_XE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTypex_Y struct {
	fn func([]byte) typex.Y
}

func decoderMakerTypex_Y(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) typex.Y)
	return &decoderTypex_Y{fn: f}
}

func (c *decoderTypex_Y) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_Y) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_Y) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderTypex_Y) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderTypex_YE struct {
	fn func([]byte) (typex.Y, error)
}

func decoderMakerTypex_YE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (typex.Y, error))
	return &decoderTypex_YE{fn: f}
}

func (c *decoderTypex_YE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_YE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_YE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderTypex_YE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTTypex_Y struct {
	fn func(reflect.Type, []byte) typex.Y
}

func decoderMakerTTypex_Y(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) typex.Y)
	return &decoderTTypex_Y{fn: f}
}

func (c *decoderTTypex_Y) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_Y) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_Y) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTTypex_Y) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTTypex_YE struct {
	fn func(reflect.Type, []byte) (typex.Y, error)
}

func decoderMakerTTypex_YE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (typex.Y, error))
	return &decoderTTypex_YE{fn: f}
}

func (c *decoderTTypex_YE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_YE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_YE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTTypex_YE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTypex_Z struct {
	fn func([]byte) typex.Z
}

func decoderMakerTypex_Z(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) typex.Z)
	return &decoderTypex_Z{fn: f}
}

func (c *decoderTypex_Z) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_Z) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_Z) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].([]byte))
	return []interface{}{out}
}

func (c *decoderTypex_Z) Call1x1(v interface{}) interface{} {
	return c.fn(v.([]byte))
}

type decoderTypex_ZE struct {
	fn func([]byte) (typex.Z, error)
}

func decoderMakerTypex_ZE(fn interface{}) reflectx.Func {
	f := fn.(func([]byte) (typex.Z, error))
	return &decoderTypex_ZE{fn: f}
}

func (c *decoderTypex_ZE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTypex_ZE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTypex_ZE) Call(args []interface{}) []interface{} {
	v, err := c.fn(args[0].([]byte))
	return []interface{}{v, err}
}

func (c *decoderTypex_ZE) Call1x2(v interface{}) (interface{}, interface{}) {
	return c.fn(v.([]byte))
}

type decoderTTypex_Z struct {
	fn func(reflect.Type, []byte) typex.Z
}

func decoderMakerTTypex_Z(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) typex.Z)
	return &decoderTTypex_Z{fn: f}
}

func (c *decoderTTypex_Z) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_Z) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_Z) Call(args []interface{}) []interface{} {
	out := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{out}
}

func (c *decoderTTypex_Z) Call2x1(t, v interface{}) interface{} {
	return c.fn(t.(reflect.Type), v.([]byte))
}

type decoderTTypex_ZE struct {
	fn func(reflect.Type, []byte) (typex.Z, error)
}

func decoderMakerTTypex_ZE(fn interface{}) reflectx.Func {
	f := fn.(func(reflect.Type, []byte) (typex.Z, error))
	return &decoderTTypex_ZE{fn: f}
}

func (c *decoderTTypex_ZE) Name() string {
	return reflectx.FunctionName(c.fn)
}

func (c *decoderTTypex_ZE) Type() reflect.Type {
	return reflect.TypeOf(c.fn)
}

func (c *decoderTTypex_ZE) Call(args []interface{}) []interface{} {
	val, err := c.fn(args[0].(reflect.Type), args[1].([]byte))
	return []interface{}{val, err}
}

func (c *decoderTTypex_ZE) Call2x2(t, v interface{}) (interface{}, interface{}) {
	return c.fn(t.(reflect.Type), v.([]byte))
}
