/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.bigquery;

import com.google.api.services.bigquery.model.ExternalCatalogDatasetOptions;
import com.google.api.services.bigquery.model.ExternalCatalogTableOptions;
import com.google.api.services.bigquery.model.SerDeInfo;
import com.google.api.services.bigquery.model.StorageDescriptor;
import java.util.Map;

public final class BigQueryMetastoreUtils {
    public static final String SERIALIZATION_LIBRARY = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    public static final String FILE_INPUT_FORMAT = "org.apache.hadoop.mapred.FileInputFormat";
    public static final String FILE_OUTPUT_FORMAT = "org.apache.hadoop.mapred.FileOutputFormat";

    private BigQueryMetastoreUtils() {
    }

    public static ExternalCatalogTableOptions createExternalCatalogTableOptions(String locationUri, Map<String, String> parameters) {
        return new ExternalCatalogTableOptions().setStorageDescriptor(BigQueryMetastoreUtils.createStorageDescriptor(locationUri)).setParameters(parameters);
    }

    public static ExternalCatalogDatasetOptions createExternalCatalogDatasetOptions(String defaultStorageLocationUri, Map<String, String> metadataParameters) {
        return new ExternalCatalogDatasetOptions().setDefaultStorageLocationUri(defaultStorageLocationUri).setParameters(metadataParameters);
    }

    private static StorageDescriptor createStorageDescriptor(String locationUri) {
        SerDeInfo serDeInfo = new SerDeInfo().setSerializationLibrary(SERIALIZATION_LIBRARY);
        return new StorageDescriptor().setLocationUri(locationUri).setInputFormat(FILE_INPUT_FORMAT).setOutputFormat(FILE_OUTPUT_FORMAT).setSerdeInfo(serDeInfo);
    }
}

