"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Protocol Buffers describing the Runner API, which is the runner-independent,
SDK-independent definition of the Beam model.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.internal.extension_dict
import google.protobuf.message
import org.apache.beam.model.pipeline.v1.endpoints_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class BeamConstants(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Constants:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ConstantsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BeamConstants._Constants.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MIN_TIMESTAMP_MILLIS: BeamConstants._Constants.ValueType  # 0
        """All timestamps of elements or window boundaries must be within
        the interval [MIN_TIMESTAMP_MILLIS, MAX_TIMESTAMP_MILLIS].
        The smallest representable timestamp of an element or a window boundary.
        """
        MAX_TIMESTAMP_MILLIS: BeamConstants._Constants.ValueType  # 1
        """The largest representable timestamp of an element or a window boundary."""
        GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS: BeamConstants._Constants.ValueType  # 2
        """The maximum timestamp for the global window.
        Triggers use max timestamp to set timers' timestamp. Timers fire when
        the watermark passes their timestamps. So, the timestamp needs to be
        smaller than the MAX_TIMESTAMP_MILLIS.
        One standard day is subtracted from MAX_TIMESTAMP_MILLIS to make sure
        the max timestamp is smaller than MAX_TIMESTAMP_MILLIS even after rounding up
        to seconds or minutes.
        """

    class Constants(_Constants, metaclass=_ConstantsEnumTypeWrapper):
        """All timestamps in milliseconds since Jan 1, 1970."""

    MIN_TIMESTAMP_MILLIS: BeamConstants.Constants.ValueType  # 0
    """All timestamps of elements or window boundaries must be within
    the interval [MIN_TIMESTAMP_MILLIS, MAX_TIMESTAMP_MILLIS].
    The smallest representable timestamp of an element or a window boundary.
    """
    MAX_TIMESTAMP_MILLIS: BeamConstants.Constants.ValueType  # 1
    """The largest representable timestamp of an element or a window boundary."""
    GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS: BeamConstants.Constants.ValueType  # 2
    """The maximum timestamp for the global window.
    Triggers use max timestamp to set timers' timestamp. Timers fire when
    the watermark passes their timestamps. So, the timestamp needs to be
    smaller than the MAX_TIMESTAMP_MILLIS.
    One standard day is subtracted from MAX_TIMESTAMP_MILLIS to make sure
    the max timestamp is smaller than MAX_TIMESTAMP_MILLIS even after rounding up
    to seconds or minutes.
    """

    def __init__(
        self,
    ) -> None: ...

global___BeamConstants = BeamConstants

@typing_extensions.final
class Components(google.protobuf.message.Message):
    """A set of mappings from id to message. This is included as an optional field
    on any proto message that may contain references needing resolution.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class TransformsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___PTransform: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___PTransform | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class PcollectionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___PCollection: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___PCollection | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class WindowingStrategiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___WindowingStrategy: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___WindowingStrategy | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class CodersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Coder: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___Coder | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class EnvironmentsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Environment: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___Environment | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRANSFORMS_FIELD_NUMBER: builtins.int
    PCOLLECTIONS_FIELD_NUMBER: builtins.int
    WINDOWING_STRATEGIES_FIELD_NUMBER: builtins.int
    CODERS_FIELD_NUMBER: builtins.int
    ENVIRONMENTS_FIELD_NUMBER: builtins.int
    @property
    def transforms(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___PTransform]:
        """(Required) A map from pipeline-scoped id to PTransform.

        Keys of the transforms map may be used by runners to identify pipeline
        steps. Hence it's recommended to use strings that are not too long that
        match regex '[A-Za-z0-9-_]+'.
        """
    @property
    def pcollections(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___PCollection]:
        """(Required) A map from pipeline-scoped id to PCollection."""
    @property
    def windowing_strategies(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___WindowingStrategy]:
        """(Required) A map from pipeline-scoped id to WindowingStrategy."""
    @property
    def coders(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Coder]:
        """(Required) A map from pipeline-scoped id to Coder."""
    @property
    def environments(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Environment]:
        """(Required) A map from pipeline-scoped id to Environment."""
    def __init__(
        self,
        *,
        transforms: collections.abc.Mapping[builtins.str, global___PTransform] | None = ...,
        pcollections: collections.abc.Mapping[builtins.str, global___PCollection] | None = ...,
        windowing_strategies: collections.abc.Mapping[builtins.str, global___WindowingStrategy] | None = ...,
        coders: collections.abc.Mapping[builtins.str, global___Coder] | None = ...,
        environments: collections.abc.Mapping[builtins.str, global___Environment] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coders", b"coders", "environments", b"environments", "pcollections", b"pcollections", "transforms", b"transforms", "windowing_strategies", b"windowing_strategies"]) -> None: ...

global___Components = Components

@typing_extensions.final
class Pipeline(google.protobuf.message.Message):
    """A Pipeline is a hierarchical graph of PTransforms, linked
    by PCollections. A typical graph may look like:

      Impulse -> PCollection -> ParDo -> PCollection -> GroupByKey -> ...
                                      \\> PCollection -> ParDo      -> ...
                                                     \\> ParDo      -> ...
      Impulse -> PCollection -> ParDo -> PCollection -> ...

    This is represented by a number of by-reference maps to transforms,
    PCollections, SDK environments, coders, etc., for
    supporting compact reuse and arbitrary graph structure.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENTS_FIELD_NUMBER: builtins.int
    ROOT_TRANSFORM_IDS_FIELD_NUMBER: builtins.int
    DISPLAY_DATA_FIELD_NUMBER: builtins.int
    REQUIREMENTS_FIELD_NUMBER: builtins.int
    @property
    def components(self) -> global___Components:
        """(Required) The coders, UDFs, graph nodes, etc, that make up
        this pipeline.
        """
    @property
    def root_transform_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """(Required) The ids of all PTransforms that are not contained within another
        PTransform. These must be in shallow topological order, so that traversing
        them recursively in this order yields a recursively topological traversal.
        """
    @property
    def display_data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DisplayData]:
        """(Optional) Static display data for the pipeline. If there is none,
        it may be omitted.
        """
    @property
    def requirements(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """(Optional) A set of requirements that the runner MUST understand and be
        able to faithfully provide in order to execute this pipeline. These
        may indicate that a runner must inspect new fields on a component or
        provide additional guarantees when processing specific transforms.
        A runner should reject any pipelines with unknown requirements.
        """
    def __init__(
        self,
        *,
        components: global___Components | None = ...,
        root_transform_ids: collections.abc.Iterable[builtins.str] | None = ...,
        display_data: collections.abc.Iterable[global___DisplayData] | None = ...,
        requirements: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["components", b"components"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "display_data", b"display_data", "requirements", b"requirements", "root_transform_ids", b"root_transform_ids"]) -> None: ...

global___Pipeline = Pipeline

@typing_extensions.final
class PTransform(google.protobuf.message.Message):
    """Transforms are the operations in your pipeline, and provide a generic
    processing framework. You provide processing logic in the form of a function
    object (colloquially referred to as “user code”), and your user code is
    applied to each element of an input PCollection (or more than one
    PCollection). Depending on the pipeline runner and back-end that you choose,
    many different workers across a cluster may execute instances of your user
    code in parallel. The user code running on each worker generates the output
    elements that are ultimately added to the final output PCollection that the
    transform produces.

    The Beam SDKs contain a number of different transforms that you can apply to
    your pipeline’s PCollections. These include general-purpose core transforms,
    such as ParDo or Combine. There are also pre-written composite transforms
    included in the SDKs, which combine one or more of the core transforms in a
    useful processing pattern, such as counting or combining elements in a
    collection. You can also define your own more complex composite transforms to
    fit your pipeline’s exact use case.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class InputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class OutputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnnotationsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    UNIQUE_NAME_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    SUBTRANSFORMS_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    DISPLAY_DATA_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    unique_name: builtins.str
    """(Required) A unique name for the application node.

    Ideally, this should be stable over multiple evolutions of a pipeline
    for the purposes of logging and associating pipeline state with a node,
    etc.

    If it is not stable, then the runner decides what will happen. But, most
    importantly, it must always be here and be unique, even if it is
    autogenerated.
    """
    @property
    def spec(self) -> global___FunctionSpec:
        """(Optional) A URN and payload that, together, fully defined the semantics
        of this transform.

        If absent, this must be an "anonymous" composite transform.

        For primitive transform in the Runner API, this is required, and the
        payloads are well-defined messages. When the URN indicates ParDo it
        is a ParDoPayload, and so on. For some special composite transforms,
        the payload is also officially defined. See StandardPTransforms for
        details.
        """
    @property
    def subtransforms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """(Optional) A list of the ids of transforms that it contains.

        Primitive transforms (see StandardPTransforms.Primitives) are not allowed
        to specify subtransforms.

        Note that a composite transform may have zero subtransforms as long as it
        only outputs PCollections that are in its inputs.
        """
    @property
    def inputs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """(Required) A map from local names of inputs (unique only with this map, and
        likely embedded in the transform payload and serialized user code) to
        PCollection ids.

        The payload for this transform may clarify the relationship of these
        inputs. For example:

         - for a Flatten transform they are merged
         - for a ParDo transform, some may be side inputs

        All inputs are recorded here so that the topological ordering of
        the graph is consistent whether or not the payload is understood.
        """
    @property
    def outputs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """(Required) A map from local names of outputs (unique only within this map,
        and likely embedded in the transform payload and serialized user code)
        to PCollection ids.

        The URN or payload for this transform node may clarify the type and
        relationship of these outputs. For example:

         - for a ParDo transform, these are tags on PCollections, which will be
           embedded in the DoFn.
        """
    @property
    def display_data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DisplayData]:
        """(Optional) Static display data for this PTransform application. If
        there is none, it may be omitted.
        """
    environment_id: builtins.str
    """Environment where the current PTransform should be executed in.

    Transforms that are required to be implemented by a runner must omit this.
    All other transforms are required to specify this.
    """
    @property
    def annotations(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.bytes]:
        """(Optional) A map from URNs designating a type of annotation, to the
        annotation in binary format. For example, an annotation could indicate
        that this PTransform has specific privacy properties.

        A runner MAY ignore types of annotations it doesn't understand. Therefore
        annotations MUST NOT be used for metadata that can affect correct
        execution of the transform.
        """
    def __init__(
        self,
        *,
        unique_name: builtins.str | None = ...,
        spec: global___FunctionSpec | None = ...,
        subtransforms: collections.abc.Iterable[builtins.str] | None = ...,
        inputs: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        outputs: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        display_data: collections.abc.Iterable[global___DisplayData] | None = ...,
        environment_id: builtins.str | None = ...,
        annotations: collections.abc.Mapping[builtins.str, builtins.bytes] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotations", b"annotations", "display_data", b"display_data", "environment_id", b"environment_id", "inputs", b"inputs", "outputs", b"outputs", "spec", b"spec", "subtransforms", b"subtransforms", "unique_name", b"unique_name"]) -> None: ...

global___PTransform = PTransform

@typing_extensions.final
class StandardPTransforms(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Primitives:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PrimitivesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardPTransforms._Primitives.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PAR_DO: StandardPTransforms._Primitives.ValueType  # 0
        """ParDo is a Beam transform for generic parallel processing. The ParDo
        processing paradigm is similar to the “Map” phase of a
        Map/Shuffle/Reduce-style algorithm: a ParDo transform considers each
        element in the input PCollection, performs some processing function
        (your user code) on that element, and emits zero, one, or multiple
        elements to an output PCollection.

        See https://beam.apache.org/documentation/programming-guide/#pardo
        for additional details.

        Payload: ParDoPayload
        """
        FLATTEN: StandardPTransforms._Primitives.ValueType  # 1
        """Flatten is a Beam transform for PCollection objects that store the same
        data type. Flatten merges multiple PCollection objects into a single
        logical PCollection.

        See https://beam.apache.org/documentation/programming-guide/#flatten
        for additional details.

        Payload: None
        """
        GROUP_BY_KEY: StandardPTransforms._Primitives.ValueType  # 2
        """GroupByKey is a Beam transform for processing collections of key/value
        pairs. It’s a parallel reduction operation, analogous to the Shuffle
        phase of a Map/Shuffle/Reduce-style algorithm. The input to GroupByKey is
        a collection of key/value pairs that represents a multimap, where the
        collection contains multiple pairs that have the same key, but different
        values. Given such a collection, you use GroupByKey to collect all of the
        values associated with each unique key.

        See https://beam.apache.org/documentation/programming-guide/#groupbykey
        for additional details.

        Never defines an environment as the runner is required to implement this
        transform.

        Payload: None
        """
        IMPULSE: StandardPTransforms._Primitives.ValueType  # 3
        """A transform which produces a single empty byte array at the minimum
        timestamp in the GlobalWindow.

        Never defines an environment as the runner is required to implement this
        transform.

        Payload: None
        """
        ASSIGN_WINDOWS: StandardPTransforms._Primitives.ValueType  # 4
        """Windowing subdivides a PCollection according to the timestamps of its
        individual elements. Transforms that aggregate multiple elements, such as
        GroupByKey and Combine, work implicitly on a per-window basis — they
        process each PCollection as a succession of multiple, finite windows,
        though the entire collection itself may be of unbounded size.

        See https://beam.apache.org/documentation/programming-guide/#windowing
        for additional details.

        Payload: WindowIntoPayload
        """
        TEST_STREAM: StandardPTransforms._Primitives.ValueType  # 5
        """A testing input that generates an unbounded {@link PCollection} of
        elements, advancing the watermark and processing time as elements are
        emitted. After all of the specified elements are emitted, ceases to
        produce output.

        See https://beam.apache.org/blog/2016/10/20/test-stream.html
        for additional details.

        Payload: TestStreamPayload
        """
        MAP_WINDOWS: StandardPTransforms._Primitives.ValueType  # 6
        """Represents mapping of main input window onto side input window.

        Side input window mapping function:
        Input: KV<nonce, MainInputWindow>
        Output: KV<nonce, SideInputWindow>

        For each main input window, the side input window is returned. The
        nonce is used by a runner to associate each input with its output.
        The nonce is represented as an opaque set of bytes.

        Payload: SideInput#window_mapping_fn FunctionSpec
        """
        MERGE_WINDOWS: StandardPTransforms._Primitives.ValueType  # 7
        """Used to merge windows during a GroupByKey.

        Window merging function:
        Input: KV<nonce, iterable<OriginalWindow>>
        Output: KV<nonce, KV<iterable<UnmergedOriginalWindow>, iterable<KV<MergedWindow, iterable<ConsumedOriginalWindow>>>>

        For each set of original windows, a list of all unmerged windows is
        output alongside a map of merged window to set of consumed windows.
        All original windows must be contained in either the unmerged original
        window set or one of the consumed original window sets. Each original
        window can only be part of one output set. The nonce is used by a runner
        to associate each input with its output. The nonce is represented as an
        opaque set of bytes.

        Payload: WindowingStrategy#window_fn FunctionSpec
        """
        TO_STRING: StandardPTransforms._Primitives.ValueType  # 8
        """A transform that translates a given element to its human-readable
        representation.

        Input: KV<nonce, element>
        Output: KV<nonce, string>

        For each given element, the implementation returns the best-effort
        human-readable representation. When possible, the implementation could
        call a user-overridable method on the type. For example, Java could
        call `toString()`, Python could call `str()`, Golang could call
        `String()`.  The nonce is used by a runner to associate each input with
        its output. The nonce is represented as an opaque set of bytes.

        Payload: none
        """

    class Primitives(_Primitives, metaclass=_PrimitivesEnumTypeWrapper):
        """Primitive transforms may not specify composite sub-transforms."""

    PAR_DO: StandardPTransforms.Primitives.ValueType  # 0
    """ParDo is a Beam transform for generic parallel processing. The ParDo
    processing paradigm is similar to the “Map” phase of a
    Map/Shuffle/Reduce-style algorithm: a ParDo transform considers each
    element in the input PCollection, performs some processing function
    (your user code) on that element, and emits zero, one, or multiple
    elements to an output PCollection.

    See https://beam.apache.org/documentation/programming-guide/#pardo
    for additional details.

    Payload: ParDoPayload
    """
    FLATTEN: StandardPTransforms.Primitives.ValueType  # 1
    """Flatten is a Beam transform for PCollection objects that store the same
    data type. Flatten merges multiple PCollection objects into a single
    logical PCollection.

    See https://beam.apache.org/documentation/programming-guide/#flatten
    for additional details.

    Payload: None
    """
    GROUP_BY_KEY: StandardPTransforms.Primitives.ValueType  # 2
    """GroupByKey is a Beam transform for processing collections of key/value
    pairs. It’s a parallel reduction operation, analogous to the Shuffle
    phase of a Map/Shuffle/Reduce-style algorithm. The input to GroupByKey is
    a collection of key/value pairs that represents a multimap, where the
    collection contains multiple pairs that have the same key, but different
    values. Given such a collection, you use GroupByKey to collect all of the
    values associated with each unique key.

    See https://beam.apache.org/documentation/programming-guide/#groupbykey
    for additional details.

    Never defines an environment as the runner is required to implement this
    transform.

    Payload: None
    """
    IMPULSE: StandardPTransforms.Primitives.ValueType  # 3
    """A transform which produces a single empty byte array at the minimum
    timestamp in the GlobalWindow.

    Never defines an environment as the runner is required to implement this
    transform.

    Payload: None
    """
    ASSIGN_WINDOWS: StandardPTransforms.Primitives.ValueType  # 4
    """Windowing subdivides a PCollection according to the timestamps of its
    individual elements. Transforms that aggregate multiple elements, such as
    GroupByKey and Combine, work implicitly on a per-window basis — they
    process each PCollection as a succession of multiple, finite windows,
    though the entire collection itself may be of unbounded size.

    See https://beam.apache.org/documentation/programming-guide/#windowing
    for additional details.

    Payload: WindowIntoPayload
    """
    TEST_STREAM: StandardPTransforms.Primitives.ValueType  # 5
    """A testing input that generates an unbounded {@link PCollection} of
    elements, advancing the watermark and processing time as elements are
    emitted. After all of the specified elements are emitted, ceases to
    produce output.

    See https://beam.apache.org/blog/2016/10/20/test-stream.html
    for additional details.

    Payload: TestStreamPayload
    """
    MAP_WINDOWS: StandardPTransforms.Primitives.ValueType  # 6
    """Represents mapping of main input window onto side input window.

    Side input window mapping function:
    Input: KV<nonce, MainInputWindow>
    Output: KV<nonce, SideInputWindow>

    For each main input window, the side input window is returned. The
    nonce is used by a runner to associate each input with its output.
    The nonce is represented as an opaque set of bytes.

    Payload: SideInput#window_mapping_fn FunctionSpec
    """
    MERGE_WINDOWS: StandardPTransforms.Primitives.ValueType  # 7
    """Used to merge windows during a GroupByKey.

    Window merging function:
    Input: KV<nonce, iterable<OriginalWindow>>
    Output: KV<nonce, KV<iterable<UnmergedOriginalWindow>, iterable<KV<MergedWindow, iterable<ConsumedOriginalWindow>>>>

    For each set of original windows, a list of all unmerged windows is
    output alongside a map of merged window to set of consumed windows.
    All original windows must be contained in either the unmerged original
    window set or one of the consumed original window sets. Each original
    window can only be part of one output set. The nonce is used by a runner
    to associate each input with its output. The nonce is represented as an
    opaque set of bytes.

    Payload: WindowingStrategy#window_fn FunctionSpec
    """
    TO_STRING: StandardPTransforms.Primitives.ValueType  # 8
    """A transform that translates a given element to its human-readable
    representation.

    Input: KV<nonce, element>
    Output: KV<nonce, string>

    For each given element, the implementation returns the best-effort
    human-readable representation. When possible, the implementation could
    call a user-overridable method on the type. For example, Java could
    call `toString()`, Python could call `str()`, Golang could call
    `String()`.  The nonce is used by a runner to associate each input with
    its output. The nonce is represented as an opaque set of bytes.

    Payload: none
    """

    class _DeprecatedPrimitives:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DeprecatedPrimitivesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardPTransforms._DeprecatedPrimitives.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        READ: StandardPTransforms._DeprecatedPrimitives.ValueType  # 0
        """Represents the operation to read a Bounded or Unbounded source.
        Payload: ReadPayload.
        """
        CREATE_VIEW: StandardPTransforms._DeprecatedPrimitives.ValueType  # 1
        """Runners should move away from translating `CreatePCollectionView` and treat this as
        part of the translation for a `ParDo` side input.
        """

    class DeprecatedPrimitives(_DeprecatedPrimitives, metaclass=_DeprecatedPrimitivesEnumTypeWrapper): ...
    READ: StandardPTransforms.DeprecatedPrimitives.ValueType  # 0
    """Represents the operation to read a Bounded or Unbounded source.
    Payload: ReadPayload.
    """
    CREATE_VIEW: StandardPTransforms.DeprecatedPrimitives.ValueType  # 1
    """Runners should move away from translating `CreatePCollectionView` and treat this as
    part of the translation for a `ParDo` side input.
    """

    class _Composites:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CompositesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardPTransforms._Composites.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        COMBINE_PER_KEY: StandardPTransforms._Composites.ValueType  # 0
        """Represents the Combine.perKey() operation.
        If this is produced by an SDK, it is assumed that the SDK understands
        each of CombineComponents.
        Payload: CombinePayload
        """
        COMBINE_GLOBALLY: StandardPTransforms._Composites.ValueType  # 1
        """Represents the Combine.globally() operation.
        If this is produced by an SDK, it is assumed that the SDK understands
        each of CombineComponents.
        Payload: CombinePayload
        """
        RESHUFFLE: StandardPTransforms._Composites.ValueType  # 2
        """Represents the Reshuffle operation."""
        WRITE_FILES: StandardPTransforms._Composites.ValueType  # 3
        """Less well-known. Payload: WriteFilesPayload."""
        PUBSUB_READ: StandardPTransforms._Composites.ValueType  # 4
        """Payload: PubSubReadPayload."""
        PUBSUB_WRITE: StandardPTransforms._Composites.ValueType  # 5
        """Payload: PubSubWritePayload."""
        PUBSUB_WRITE_V2: StandardPTransforms._Composites.ValueType  # 7
        """Used for pubsub dynamic destinations.
        Payload: PubSubWritePayload.
        """
        GROUP_INTO_BATCHES_WITH_SHARDED_KEY: StandardPTransforms._Composites.ValueType  # 6
        """Represents the GroupIntoBatches.WithShardedKey operation.
        Payload: GroupIntoBatchesPayload
        """

    class Composites(_Composites, metaclass=_CompositesEnumTypeWrapper): ...
    COMBINE_PER_KEY: StandardPTransforms.Composites.ValueType  # 0
    """Represents the Combine.perKey() operation.
    If this is produced by an SDK, it is assumed that the SDK understands
    each of CombineComponents.
    Payload: CombinePayload
    """
    COMBINE_GLOBALLY: StandardPTransforms.Composites.ValueType  # 1
    """Represents the Combine.globally() operation.
    If this is produced by an SDK, it is assumed that the SDK understands
    each of CombineComponents.
    Payload: CombinePayload
    """
    RESHUFFLE: StandardPTransforms.Composites.ValueType  # 2
    """Represents the Reshuffle operation."""
    WRITE_FILES: StandardPTransforms.Composites.ValueType  # 3
    """Less well-known. Payload: WriteFilesPayload."""
    PUBSUB_READ: StandardPTransforms.Composites.ValueType  # 4
    """Payload: PubSubReadPayload."""
    PUBSUB_WRITE: StandardPTransforms.Composites.ValueType  # 5
    """Payload: PubSubWritePayload."""
    PUBSUB_WRITE_V2: StandardPTransforms.Composites.ValueType  # 7
    """Used for pubsub dynamic destinations.
    Payload: PubSubWritePayload.
    """
    GROUP_INTO_BATCHES_WITH_SHARDED_KEY: StandardPTransforms.Composites.ValueType  # 6
    """Represents the GroupIntoBatches.WithShardedKey operation.
    Payload: GroupIntoBatchesPayload
    """

    class _CombineComponents:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CombineComponentsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardPTransforms._CombineComponents.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        COMBINE_PER_KEY_PRECOMBINE: StandardPTransforms._CombineComponents.ValueType  # 0
        """Represents the Pre-Combine part of a lifted Combine Per Key, as described
        in the following document:
        https://s.apache.org/beam-runner-api-combine-model#heading=h.ta0g6ase8z07
        Payload: CombinePayload
        """
        COMBINE_PER_KEY_MERGE_ACCUMULATORS: StandardPTransforms._CombineComponents.ValueType  # 1
        """Represents the Merge Accumulators part of a lifted Combine Per Key, as
        described in the following document:
        https://s.apache.org/beam-runner-api-combine-model#heading=h.jco9rvatld5m
        Payload: CombinePayload
        """
        COMBINE_PER_KEY_EXTRACT_OUTPUTS: StandardPTransforms._CombineComponents.ValueType  # 2
        """Represents the Extract Outputs part of a lifted Combine Per Key, as
        described in the following document:
        https://s.apache.org/beam-runner-api-combine-model#heading=h.i9i6p8gtl6ku
        Payload: CombinePayload
        """
        COMBINE_GROUPED_VALUES: StandardPTransforms._CombineComponents.ValueType  # 3
        """Represents the Combine Grouped Values transform, as described in the
        following document:
        https://s.apache.org/beam-runner-api-combine-model#heading=h.aj86ew4v1wk
        Payload: CombinePayload
        """
        COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS: StandardPTransforms._CombineComponents.ValueType  # 4
        """Represents the Convert To Accumulators transform, as described in the
        following document:
        https://s.apache.org/beam-runner-api-combine-model#heading=h.h5697l1scd9x
        Payload: CombinePayload
        """

    class CombineComponents(_CombineComponents, metaclass=_CombineComponentsEnumTypeWrapper):
        """Payload for all of these: CombinePayload"""

    COMBINE_PER_KEY_PRECOMBINE: StandardPTransforms.CombineComponents.ValueType  # 0
    """Represents the Pre-Combine part of a lifted Combine Per Key, as described
    in the following document:
    https://s.apache.org/beam-runner-api-combine-model#heading=h.ta0g6ase8z07
    Payload: CombinePayload
    """
    COMBINE_PER_KEY_MERGE_ACCUMULATORS: StandardPTransforms.CombineComponents.ValueType  # 1
    """Represents the Merge Accumulators part of a lifted Combine Per Key, as
    described in the following document:
    https://s.apache.org/beam-runner-api-combine-model#heading=h.jco9rvatld5m
    Payload: CombinePayload
    """
    COMBINE_PER_KEY_EXTRACT_OUTPUTS: StandardPTransforms.CombineComponents.ValueType  # 2
    """Represents the Extract Outputs part of a lifted Combine Per Key, as
    described in the following document:
    https://s.apache.org/beam-runner-api-combine-model#heading=h.i9i6p8gtl6ku
    Payload: CombinePayload
    """
    COMBINE_GROUPED_VALUES: StandardPTransforms.CombineComponents.ValueType  # 3
    """Represents the Combine Grouped Values transform, as described in the
    following document:
    https://s.apache.org/beam-runner-api-combine-model#heading=h.aj86ew4v1wk
    Payload: CombinePayload
    """
    COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS: StandardPTransforms.CombineComponents.ValueType  # 4
    """Represents the Convert To Accumulators transform, as described in the
    following document:
    https://s.apache.org/beam-runner-api-combine-model#heading=h.h5697l1scd9x
    Payload: CombinePayload
    """

    class _SplittableParDoComponents:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SplittableParDoComponentsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardPTransforms._SplittableParDoComponents.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PAIR_WITH_RESTRICTION: StandardPTransforms._SplittableParDoComponents.ValueType  # 0
        """Pairs the input element with its initial restriction.
        Input: element; output: KV(element, restriction).
        """
        SPLIT_AND_SIZE_RESTRICTIONS: StandardPTransforms._SplittableParDoComponents.ValueType  # 1
        """Splits the restriction of each element/restriction pair and returns the
        resulting splits, with a corresponding floating point size estimation
        for each.

        A reasonable value for size is the number of bytes expected to be
        produced by this (element, restriction) pair.

        Input: KV(element, restriction)
        Output: KV(KV(element, restriction), size))
        """
        PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS: StandardPTransforms._SplittableParDoComponents.ValueType  # 2
        """Applies the DoFn to every element and restriction.

        All primary and residuals returned from checkpointing or splitting must
        have the same type as the input to this transform.

        Input: KV(KV(element, restriction), size); output: DoFn's output.
        """
        TRUNCATE_SIZED_RESTRICTION: StandardPTransforms._SplittableParDoComponents.ValueType  # 3
        """Truncates the restriction of each element/restriction pair and returns
        the finite restriction which will be processed when a pipeline is
        drained. See
        https://docs.google.com/document/d/1NExwHlj-2q2WUGhSO4jTu8XGhDPmm3cllSN8IMmWci8/edit#.
        for additional details about drain.

        Input: KV(KV(element, restriction), size);
        Output: KV(KV(element, restriction), size).
        """

    class SplittableParDoComponents(_SplittableParDoComponents, metaclass=_SplittableParDoComponentsEnumTypeWrapper):
        """Payload for all of these: ParDoPayload containing the user's SDF"""

    PAIR_WITH_RESTRICTION: StandardPTransforms.SplittableParDoComponents.ValueType  # 0
    """Pairs the input element with its initial restriction.
    Input: element; output: KV(element, restriction).
    """
    SPLIT_AND_SIZE_RESTRICTIONS: StandardPTransforms.SplittableParDoComponents.ValueType  # 1
    """Splits the restriction of each element/restriction pair and returns the
    resulting splits, with a corresponding floating point size estimation
    for each.

    A reasonable value for size is the number of bytes expected to be
    produced by this (element, restriction) pair.

    Input: KV(element, restriction)
    Output: KV(KV(element, restriction), size))
    """
    PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS: StandardPTransforms.SplittableParDoComponents.ValueType  # 2
    """Applies the DoFn to every element and restriction.

    All primary and residuals returned from checkpointing or splitting must
    have the same type as the input to this transform.

    Input: KV(KV(element, restriction), size); output: DoFn's output.
    """
    TRUNCATE_SIZED_RESTRICTION: StandardPTransforms.SplittableParDoComponents.ValueType  # 3
    """Truncates the restriction of each element/restriction pair and returns
    the finite restriction which will be processed when a pipeline is
    drained. See
    https://docs.google.com/document/d/1NExwHlj-2q2WUGhSO4jTu8XGhDPmm3cllSN8IMmWci8/edit#.
    for additional details about drain.

    Input: KV(KV(element, restriction), size);
    Output: KV(KV(element, restriction), size).
    """

    class _GroupIntoBatchesComponents:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _GroupIntoBatchesComponentsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardPTransforms._GroupIntoBatchesComponents.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        GROUP_INTO_BATCHES: StandardPTransforms._GroupIntoBatchesComponents.ValueType  # 0

    class GroupIntoBatchesComponents(_GroupIntoBatchesComponents, metaclass=_GroupIntoBatchesComponentsEnumTypeWrapper):
        """Payload for all of these: GroupIntoBatchesPayload"""

    GROUP_INTO_BATCHES: StandardPTransforms.GroupIntoBatchesComponents.ValueType  # 0

    def __init__(
        self,
    ) -> None: ...

global___StandardPTransforms = StandardPTransforms

@typing_extensions.final
class StandardSideInputTypes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardSideInputTypes._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ITERABLE: StandardSideInputTypes._Enum.ValueType  # 0
        """Represents a view over a PCollection<V>.

        StateGetRequests performed on this side input must use
        StateKey.IterableSideInput.
        """
        MULTIMAP: StandardSideInputTypes._Enum.ValueType  # 1
        """Represents a view over a PCollection<KV<K, V>>.

        StateGetRequests performed on this side input must use
        StateKey.MultimapKeysSideInput or StateKey.MultimapSideInput.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    ITERABLE: StandardSideInputTypes.Enum.ValueType  # 0
    """Represents a view over a PCollection<V>.

    StateGetRequests performed on this side input must use
    StateKey.IterableSideInput.
    """
    MULTIMAP: StandardSideInputTypes.Enum.ValueType  # 1
    """Represents a view over a PCollection<KV<K, V>>.

    StateGetRequests performed on this side input must use
    StateKey.MultimapKeysSideInput or StateKey.MultimapSideInput.
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardSideInputTypes = StandardSideInputTypes

@typing_extensions.final
class StandardUserStateTypes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardUserStateTypes._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        BAG: StandardUserStateTypes._Enum.ValueType  # 0
        """Represents a user state specification that supports a bag.

        StateRequests performed on this user state must use
        StateKey.BagUserState.
        """
        MULTIMAP: StandardUserStateTypes._Enum.ValueType  # 1
        """Represents a user state specification that supports a multimap.

        StateRequests performed on this user state must use
        StateKey.MultimapKeysUserState or StateKey.MultimapUserState.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    BAG: StandardUserStateTypes.Enum.ValueType  # 0
    """Represents a user state specification that supports a bag.

    StateRequests performed on this user state must use
    StateKey.BagUserState.
    """
    MULTIMAP: StandardUserStateTypes.Enum.ValueType  # 1
    """Represents a user state specification that supports a multimap.

    StateRequests performed on this user state must use
    StateKey.MultimapKeysUserState or StateKey.MultimapUserState.
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardUserStateTypes = StandardUserStateTypes

@typing_extensions.final
class PCollection(google.protobuf.message.Message):
    """A PCollection!"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNIQUE_NAME_FIELD_NUMBER: builtins.int
    CODER_ID_FIELD_NUMBER: builtins.int
    IS_BOUNDED_FIELD_NUMBER: builtins.int
    WINDOWING_STRATEGY_ID_FIELD_NUMBER: builtins.int
    DISPLAY_DATA_FIELD_NUMBER: builtins.int
    unique_name: builtins.str
    """(Required) A unique name for the PCollection.

    Ideally, this should be stable over multiple evolutions of a pipeline
    for the purposes of logging and associating pipeline state with a node,
    etc.

    If it is not stable, then the runner decides what will happen. But, most
    importantly, it must always be here, even if it is autogenerated.
    """
    coder_id: builtins.str
    """(Required) The id of the Coder for this PCollection."""
    is_bounded: global___IsBounded.Enum.ValueType
    """(Required) Whether this PCollection is bounded or unbounded"""
    windowing_strategy_id: builtins.str
    """(Required) The id of the windowing strategy for this PCollection."""
    @property
    def display_data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DisplayData]:
        """(Optional) Static display data for the PCollection. If there is none,
        it may be omitted.
        """
    def __init__(
        self,
        *,
        unique_name: builtins.str | None = ...,
        coder_id: builtins.str | None = ...,
        is_bounded: global___IsBounded.Enum.ValueType | None = ...,
        windowing_strategy_id: builtins.str | None = ...,
        display_data: collections.abc.Iterable[global___DisplayData] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coder_id", b"coder_id", "display_data", b"display_data", "is_bounded", b"is_bounded", "unique_name", b"unique_name", "windowing_strategy_id", b"windowing_strategy_id"]) -> None: ...

global___PCollection = PCollection

@typing_extensions.final
class ParDoPayload(google.protobuf.message.Message):
    """The payload for the primitive ParDo transform."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SideInputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SideInput: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___SideInput | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class StateSpecsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___StateSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___StateSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class TimerFamilySpecsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___TimerFamilySpec: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___TimerFamilySpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    DO_FN_FIELD_NUMBER: builtins.int
    SIDE_INPUTS_FIELD_NUMBER: builtins.int
    STATE_SPECS_FIELD_NUMBER: builtins.int
    TIMER_FAMILY_SPECS_FIELD_NUMBER: builtins.int
    RESTRICTION_CODER_ID_FIELD_NUMBER: builtins.int
    REQUESTS_FINALIZATION_FIELD_NUMBER: builtins.int
    REQUIRES_TIME_SORTED_INPUT_FIELD_NUMBER: builtins.int
    REQUIRES_STABLE_INPUT_FIELD_NUMBER: builtins.int
    ON_WINDOW_EXPIRATION_TIMER_FAMILY_SPEC_FIELD_NUMBER: builtins.int
    @property
    def do_fn(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the DoFn."""
    @property
    def side_inputs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SideInput]:
        """(Optional) A mapping of local input names to side inputs, describing
        the expected access pattern.
        """
    @property
    def state_specs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___StateSpec]:
        """(Optional) A mapping of local state names to state specifications.
        If this is set, the stateful processing requirement should also
        be placed in the pipeline requirements.
        """
    @property
    def timer_family_specs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___TimerFamilySpec]:
        """(Optional) A mapping of local timer family names to timer family
        specifications. If this is set, the stateful processing requirement should
        also be placed in the pipeline requirements.
        """
    restriction_coder_id: builtins.str
    """(Optional) Only set when this ParDo contains a splittable DoFn.
    If this is set, the corresponding standard requirement should also
    be placed in the pipeline requirements.
    """
    requests_finalization: builtins.bool
    """(Optional) Only set when this ParDo can request bundle finalization.
    If this is set, the corresponding standard requirement should also
    be placed in the pipeline requirements.
    """
    requires_time_sorted_input: builtins.bool
    """Whether this stage requires time sorted input.
    If this is set, the corresponding standard requirement should also
    be placed in the pipeline requirements.
    """
    requires_stable_input: builtins.bool
    """Whether this stage requires stable input.
    If this is set, the corresponding standard requirement should also
    be placed in the pipeline requirements.
    """
    on_window_expiration_timer_family_spec: builtins.str
    """If populated, the name of the timer family spec which should be notified
    on each window expiry.
    If this is set, the corresponding standard requirement should also
    be placed in the pipeline requirements.
    """
    def __init__(
        self,
        *,
        do_fn: global___FunctionSpec | None = ...,
        side_inputs: collections.abc.Mapping[builtins.str, global___SideInput] | None = ...,
        state_specs: collections.abc.Mapping[builtins.str, global___StateSpec] | None = ...,
        timer_family_specs: collections.abc.Mapping[builtins.str, global___TimerFamilySpec] | None = ...,
        restriction_coder_id: builtins.str | None = ...,
        requests_finalization: builtins.bool | None = ...,
        requires_time_sorted_input: builtins.bool | None = ...,
        requires_stable_input: builtins.bool | None = ...,
        on_window_expiration_timer_family_spec: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["do_fn", b"do_fn"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["do_fn", b"do_fn", "on_window_expiration_timer_family_spec", b"on_window_expiration_timer_family_spec", "requests_finalization", b"requests_finalization", "requires_stable_input", b"requires_stable_input", "requires_time_sorted_input", b"requires_time_sorted_input", "restriction_coder_id", b"restriction_coder_id", "side_inputs", b"side_inputs", "state_specs", b"state_specs", "timer_family_specs", b"timer_family_specs"]) -> None: ...

global___ParDoPayload = ParDoPayload

@typing_extensions.final
class StateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    READ_MODIFY_WRITE_SPEC_FIELD_NUMBER: builtins.int
    BAG_SPEC_FIELD_NUMBER: builtins.int
    COMBINING_SPEC_FIELD_NUMBER: builtins.int
    MAP_SPEC_FIELD_NUMBER: builtins.int
    SET_SPEC_FIELD_NUMBER: builtins.int
    ORDERED_LIST_SPEC_FIELD_NUMBER: builtins.int
    MULTIMAP_SPEC_FIELD_NUMBER: builtins.int
    PROTOCOL_FIELD_NUMBER: builtins.int
    @property
    def read_modify_write_spec(self) -> global___ReadModifyWriteStateSpec: ...
    @property
    def bag_spec(self) -> global___BagStateSpec: ...
    @property
    def combining_spec(self) -> global___CombiningStateSpec: ...
    @property
    def map_spec(self) -> global___MapStateSpec: ...
    @property
    def set_spec(self) -> global___SetStateSpec: ...
    @property
    def ordered_list_spec(self) -> global___OrderedListStateSpec: ...
    @property
    def multimap_spec(self) -> global___MultimapStateSpec: ...
    @property
    def protocol(self) -> global___FunctionSpec:
        """(Required) URN of the protocol required by this state specification to present
        the desired SDK-specific interface to a UDF.

        This protocol defines the SDK harness <-> Runner Harness RPC
        interface for accessing and mutating user state.

        See StandardUserStateTypes for an enumeration of all user state types
        defined.
        """
    def __init__(
        self,
        *,
        read_modify_write_spec: global___ReadModifyWriteStateSpec | None = ...,
        bag_spec: global___BagStateSpec | None = ...,
        combining_spec: global___CombiningStateSpec | None = ...,
        map_spec: global___MapStateSpec | None = ...,
        set_spec: global___SetStateSpec | None = ...,
        ordered_list_spec: global___OrderedListStateSpec | None = ...,
        multimap_spec: global___MultimapStateSpec | None = ...,
        protocol: global___FunctionSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bag_spec", b"bag_spec", "combining_spec", b"combining_spec", "map_spec", b"map_spec", "multimap_spec", b"multimap_spec", "ordered_list_spec", b"ordered_list_spec", "protocol", b"protocol", "read_modify_write_spec", b"read_modify_write_spec", "set_spec", b"set_spec", "spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bag_spec", b"bag_spec", "combining_spec", b"combining_spec", "map_spec", b"map_spec", "multimap_spec", b"multimap_spec", "ordered_list_spec", b"ordered_list_spec", "protocol", b"protocol", "read_modify_write_spec", b"read_modify_write_spec", "set_spec", b"set_spec", "spec", b"spec"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["spec", b"spec"]) -> typing_extensions.Literal["read_modify_write_spec", "bag_spec", "combining_spec", "map_spec", "set_spec", "ordered_list_spec", "multimap_spec"] | None: ...

global___StateSpec = StateSpec

@typing_extensions.final
class ReadModifyWriteStateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODER_ID_FIELD_NUMBER: builtins.int
    coder_id: builtins.str
    def __init__(
        self,
        *,
        coder_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["coder_id", b"coder_id"]) -> None: ...

global___ReadModifyWriteStateSpec = ReadModifyWriteStateSpec

@typing_extensions.final
class BagStateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_CODER_ID_FIELD_NUMBER: builtins.int
    element_coder_id: builtins.str
    def __init__(
        self,
        *,
        element_coder_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element_coder_id", b"element_coder_id"]) -> None: ...

global___BagStateSpec = BagStateSpec

@typing_extensions.final
class OrderedListStateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_CODER_ID_FIELD_NUMBER: builtins.int
    element_coder_id: builtins.str
    def __init__(
        self,
        *,
        element_coder_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element_coder_id", b"element_coder_id"]) -> None: ...

global___OrderedListStateSpec = OrderedListStateSpec

@typing_extensions.final
class CombiningStateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCUMULATOR_CODER_ID_FIELD_NUMBER: builtins.int
    COMBINE_FN_FIELD_NUMBER: builtins.int
    accumulator_coder_id: builtins.str
    @property
    def combine_fn(self) -> global___FunctionSpec: ...
    def __init__(
        self,
        *,
        accumulator_coder_id: builtins.str | None = ...,
        combine_fn: global___FunctionSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["combine_fn", b"combine_fn"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["accumulator_coder_id", b"accumulator_coder_id", "combine_fn", b"combine_fn"]) -> None: ...

global___CombiningStateSpec = CombiningStateSpec

@typing_extensions.final
class MapStateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_CODER_ID_FIELD_NUMBER: builtins.int
    VALUE_CODER_ID_FIELD_NUMBER: builtins.int
    key_coder_id: builtins.str
    value_coder_id: builtins.str
    def __init__(
        self,
        *,
        key_coder_id: builtins.str | None = ...,
        value_coder_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key_coder_id", b"key_coder_id", "value_coder_id", b"value_coder_id"]) -> None: ...

global___MapStateSpec = MapStateSpec

@typing_extensions.final
class MultimapStateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_CODER_ID_FIELD_NUMBER: builtins.int
    VALUE_CODER_ID_FIELD_NUMBER: builtins.int
    key_coder_id: builtins.str
    value_coder_id: builtins.str
    def __init__(
        self,
        *,
        key_coder_id: builtins.str | None = ...,
        value_coder_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key_coder_id", b"key_coder_id", "value_coder_id", b"value_coder_id"]) -> None: ...

global___MultimapStateSpec = MultimapStateSpec

@typing_extensions.final
class SetStateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_CODER_ID_FIELD_NUMBER: builtins.int
    element_coder_id: builtins.str
    def __init__(
        self,
        *,
        element_coder_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element_coder_id", b"element_coder_id"]) -> None: ...

global___SetStateSpec = SetStateSpec

@typing_extensions.final
class TimerFamilySpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_DOMAIN_FIELD_NUMBER: builtins.int
    TIMER_FAMILY_CODER_ID_FIELD_NUMBER: builtins.int
    time_domain: global___TimeDomain.Enum.ValueType
    timer_family_coder_id: builtins.str
    def __init__(
        self,
        *,
        time_domain: global___TimeDomain.Enum.ValueType | None = ...,
        timer_family_coder_id: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["time_domain", b"time_domain", "timer_family_coder_id", b"timer_family_coder_id"]) -> None: ...

global___TimerFamilySpec = TimerFamilySpec

@typing_extensions.final
class IsBounded(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[IsBounded._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: IsBounded._Enum.ValueType  # 0
        UNBOUNDED: IsBounded._Enum.ValueType  # 1
        BOUNDED: IsBounded._Enum.ValueType  # 2

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: IsBounded.Enum.ValueType  # 0
    UNBOUNDED: IsBounded.Enum.ValueType  # 1
    BOUNDED: IsBounded.Enum.ValueType  # 2

    def __init__(
        self,
    ) -> None: ...

global___IsBounded = IsBounded

@typing_extensions.final
class ReadPayload(google.protobuf.message.Message):
    """The payload for the primitive Read transform."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_FIELD_NUMBER: builtins.int
    IS_BOUNDED_FIELD_NUMBER: builtins.int
    @property
    def source(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the source for this Read."""
    is_bounded: global___IsBounded.Enum.ValueType
    """(Required) Whether the source is bounded or unbounded"""
    def __init__(
        self,
        *,
        source: global___FunctionSpec | None = ...,
        is_bounded: global___IsBounded.Enum.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["source", b"source"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_bounded", b"is_bounded", "source", b"source"]) -> None: ...

global___ReadPayload = ReadPayload

@typing_extensions.final
class WindowIntoPayload(google.protobuf.message.Message):
    """The payload for the WindowInto transform."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WINDOW_FN_FIELD_NUMBER: builtins.int
    @property
    def window_fn(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the WindowFn."""
    def __init__(
        self,
        *,
        window_fn: global___FunctionSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["window_fn", b"window_fn"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["window_fn", b"window_fn"]) -> None: ...

global___WindowIntoPayload = WindowIntoPayload

@typing_extensions.final
class CombinePayload(google.protobuf.message.Message):
    """The payload for the special-but-not-primitive Combine transform."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMBINE_FN_FIELD_NUMBER: builtins.int
    ACCUMULATOR_CODER_ID_FIELD_NUMBER: builtins.int
    @property
    def combine_fn(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the CombineFn."""
    accumulator_coder_id: builtins.str
    """(Required) A reference to the Coder to use for accumulators of the CombineFn"""
    def __init__(
        self,
        *,
        combine_fn: global___FunctionSpec | None = ...,
        accumulator_coder_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["combine_fn", b"combine_fn"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["accumulator_coder_id", b"accumulator_coder_id", "combine_fn", b"combine_fn"]) -> None: ...

global___CombinePayload = CombinePayload

@typing_extensions.final
class TestStreamPayload(google.protobuf.message.Message):
    """The payload for the test-only primitive TestStream"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Event(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class AdvanceWatermark(google.protobuf.message.Message):
            """Advances the watermark to the specified timestamp."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            NEW_WATERMARK_FIELD_NUMBER: builtins.int
            TAG_FIELD_NUMBER: builtins.int
            new_watermark: builtins.int
            """(Required) The watermark in millisecond to advance to."""
            tag: builtins.str
            """(Optional) The output watermark tag for a PCollection. If unspecified
            or with an empty string, this will default to the Main PCollection
            Output
            """
            def __init__(
                self,
                *,
                new_watermark: builtins.int | None = ...,
                tag: builtins.str | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["new_watermark", b"new_watermark", "tag", b"tag"]) -> None: ...

        @typing_extensions.final
        class AdvanceProcessingTime(google.protobuf.message.Message):
            """Advances the processing time clock by the specified amount."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            ADVANCE_DURATION_FIELD_NUMBER: builtins.int
            advance_duration: builtins.int
            """(Required) The duration in millisecond to advance by."""
            def __init__(
                self,
                *,
                advance_duration: builtins.int | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["advance_duration", b"advance_duration"]) -> None: ...

        @typing_extensions.final
        class AddElements(google.protobuf.message.Message):
            """Adds elements to the stream to be emitted."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            ELEMENTS_FIELD_NUMBER: builtins.int
            TAG_FIELD_NUMBER: builtins.int
            @property
            def elements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TestStreamPayload.TimestampedElement]:
                """(Required) The elements to add to the TestStream."""
            tag: builtins.str
            """(Optional) The output PCollection tag to add these elements to. If
            unspecified or with an empty string, this will default to the Main
            PCollection Output.
            """
            def __init__(
                self,
                *,
                elements: collections.abc.Iterable[global___TestStreamPayload.TimestampedElement] | None = ...,
                tag: builtins.str | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["elements", b"elements", "tag", b"tag"]) -> None: ...

        WATERMARK_EVENT_FIELD_NUMBER: builtins.int
        PROCESSING_TIME_EVENT_FIELD_NUMBER: builtins.int
        ELEMENT_EVENT_FIELD_NUMBER: builtins.int
        @property
        def watermark_event(self) -> global___TestStreamPayload.Event.AdvanceWatermark: ...
        @property
        def processing_time_event(self) -> global___TestStreamPayload.Event.AdvanceProcessingTime: ...
        @property
        def element_event(self) -> global___TestStreamPayload.Event.AddElements: ...
        def __init__(
            self,
            *,
            watermark_event: global___TestStreamPayload.Event.AdvanceWatermark | None = ...,
            processing_time_event: global___TestStreamPayload.Event.AdvanceProcessingTime | None = ...,
            element_event: global___TestStreamPayload.Event.AddElements | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["element_event", b"element_event", "event", b"event", "processing_time_event", b"processing_time_event", "watermark_event", b"watermark_event"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["element_event", b"element_event", "event", b"event", "processing_time_event", b"processing_time_event", "watermark_event", b"watermark_event"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["event", b"event"]) -> typing_extensions.Literal["watermark_event", "processing_time_event", "element_event"] | None: ...

    @typing_extensions.final
    class TimestampedElement(google.protobuf.message.Message):
        """A single element inside of the TestStream."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENCODED_ELEMENT_FIELD_NUMBER: builtins.int
        TIMESTAMP_FIELD_NUMBER: builtins.int
        encoded_element: builtins.bytes
        """(Required) The element encoded. Currently the TestStream only supports
        encoding primitives.
        """
        timestamp: builtins.int
        """(Required) The event timestamp in millisecond of this element."""
        def __init__(
            self,
            *,
            encoded_element: builtins.bytes | None = ...,
            timestamp: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["encoded_element", b"encoded_element", "timestamp", b"timestamp"]) -> None: ...

    CODER_ID_FIELD_NUMBER: builtins.int
    EVENTS_FIELD_NUMBER: builtins.int
    ENDPOINT_FIELD_NUMBER: builtins.int
    coder_id: builtins.str
    """(Required) the coder for elements in the TestStream events"""
    @property
    def events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TestStreamPayload.Event]:
        """(Optional) If specified, the TestStream will replay these events."""
    @property
    def endpoint(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor:
        """(Optional) If specified, points to a TestStreamService to be
        used to retrieve events.
        """
    def __init__(
        self,
        *,
        coder_id: builtins.str | None = ...,
        events: collections.abc.Iterable[global___TestStreamPayload.Event] | None = ...,
        endpoint: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["endpoint", b"endpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["coder_id", b"coder_id", "endpoint", b"endpoint", "events", b"events"]) -> None: ...

global___TestStreamPayload = TestStreamPayload

@typing_extensions.final
class EventsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUT_IDS_FIELD_NUMBER: builtins.int
    @property
    def output_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The set of PCollections to read from. These are the PTransform outputs
        local names. These are a subset of the TestStream's outputs. This allows
        Interactive Beam to cache many PCollections from a pipeline then replay a
        subset of them.
        """
    def __init__(
        self,
        *,
        output_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["output_ids", b"output_ids"]) -> None: ...

global___EventsRequest = EventsRequest

@typing_extensions.final
class WriteFilesPayload(google.protobuf.message.Message):
    """The payload for the special-but-not-primitive WriteFiles transform."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SideInputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SideInput: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___SideInput | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SINK_FIELD_NUMBER: builtins.int
    FORMAT_FUNCTION_FIELD_NUMBER: builtins.int
    WINDOWED_WRITES_FIELD_NUMBER: builtins.int
    RUNNER_DETERMINED_SHARDING_FIELD_NUMBER: builtins.int
    SIDE_INPUTS_FIELD_NUMBER: builtins.int
    @property
    def sink(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the FileBasedSink."""
    @property
    def format_function(self) -> global___FunctionSpec:
        """(Required) The format function."""
    windowed_writes: builtins.bool
    runner_determined_sharding: builtins.bool
    @property
    def side_inputs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SideInput]: ...
    def __init__(
        self,
        *,
        sink: global___FunctionSpec | None = ...,
        format_function: global___FunctionSpec | None = ...,
        windowed_writes: builtins.bool | None = ...,
        runner_determined_sharding: builtins.bool | None = ...,
        side_inputs: collections.abc.Mapping[builtins.str, global___SideInput] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["format_function", b"format_function", "sink", b"sink"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["format_function", b"format_function", "runner_determined_sharding", b"runner_determined_sharding", "side_inputs", b"side_inputs", "sink", b"sink", "windowed_writes", b"windowed_writes"]) -> None: ...

global___WriteFilesPayload = WriteFilesPayload

@typing_extensions.final
class PubSubReadPayload(google.protobuf.message.Message):
    """Payload used by Google Cloud Pub/Sub read transform.
    This can be used by runners that wish to override Beam Pub/Sub read transform
    with a native implementation.
    The SDK should guarantee that only one of topic, subscription,
    topic_runtime_overridden and subscription_runtime_overridden is set.
    The output of PubSubReadPayload should be bytes of serialized PubsubMessage
    proto if with_attributes == true. Otherwise, the bytes is the raw payload.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPIC_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    TIMESTAMP_ATTRIBUTE_FIELD_NUMBER: builtins.int
    ID_ATTRIBUTE_FIELD_NUMBER: builtins.int
    WITH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    TOPIC_RUNTIME_OVERRIDDEN_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_RUNTIME_OVERRIDDEN_FIELD_NUMBER: builtins.int
    topic: builtins.str
    """Topic to read from. Exactly one of topic or subscription should be set.
    Topic format is: /topics/project_id/subscription_name
    """
    subscription: builtins.str
    """Subscription to read from. Exactly one of topic or subscription should be set.
    Subscription format is: /subscriptions/project_id/subscription_name
    """
    timestamp_attribute: builtins.str
    """Attribute that provides element timestamps."""
    id_attribute: builtins.str
    """Attribute to be used for uniquely identifying messages."""
    with_attributes: builtins.bool
    """If true, reads Pub/Sub payload as well as attributes. If false, reads only the payload."""
    topic_runtime_overridden: builtins.str
    """If set, the topic is expected to be provided during runtime."""
    subscription_runtime_overridden: builtins.str
    """If set, the subscription that is expected to be provided during runtime."""
    def __init__(
        self,
        *,
        topic: builtins.str | None = ...,
        subscription: builtins.str | None = ...,
        timestamp_attribute: builtins.str | None = ...,
        id_attribute: builtins.str | None = ...,
        with_attributes: builtins.bool | None = ...,
        topic_runtime_overridden: builtins.str | None = ...,
        subscription_runtime_overridden: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id_attribute", b"id_attribute", "subscription", b"subscription", "subscription_runtime_overridden", b"subscription_runtime_overridden", "timestamp_attribute", b"timestamp_attribute", "topic", b"topic", "topic_runtime_overridden", b"topic_runtime_overridden", "with_attributes", b"with_attributes"]) -> None: ...

global___PubSubReadPayload = PubSubReadPayload

@typing_extensions.final
class PubSubWritePayload(google.protobuf.message.Message):
    """Payload used by Google Cloud Pub/Sub write transform.
    This can be used by runners that wish to override Beam Pub/Sub write transform
    with a native implementation.
    The SDK should guarantee that only one of topic and topic_runtime_overridden
    is set.
    The output of PubSubWritePayload should be bytes if serialized PubsubMessage
    proto.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPIC_FIELD_NUMBER: builtins.int
    TIMESTAMP_ATTRIBUTE_FIELD_NUMBER: builtins.int
    ID_ATTRIBUTE_FIELD_NUMBER: builtins.int
    TOPIC_RUNTIME_OVERRIDDEN_FIELD_NUMBER: builtins.int
    topic: builtins.str
    """Topic to write to.
    Topic format is: /topics/project_id/subscription_name
    """
    timestamp_attribute: builtins.str
    """Attribute that provides element timestamps."""
    id_attribute: builtins.str
    """Attribute that uniquely identify messages."""
    topic_runtime_overridden: builtins.str
    """If set, the topic is expected to be provided during runtime."""
    def __init__(
        self,
        *,
        topic: builtins.str | None = ...,
        timestamp_attribute: builtins.str | None = ...,
        id_attribute: builtins.str | None = ...,
        topic_runtime_overridden: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id_attribute", b"id_attribute", "timestamp_attribute", b"timestamp_attribute", "topic", b"topic", "topic_runtime_overridden", b"topic_runtime_overridden"]) -> None: ...

global___PubSubWritePayload = PubSubWritePayload

@typing_extensions.final
class GroupIntoBatchesPayload(google.protobuf.message.Message):
    """Payload for GroupIntoBatches composite transform."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BATCH_SIZE_FIELD_NUMBER: builtins.int
    BATCH_SIZE_BYTES_FIELD_NUMBER: builtins.int
    MAX_BUFFERING_DURATION_MILLIS_FIELD_NUMBER: builtins.int
    batch_size: builtins.int
    """Max size of a batch."""
    batch_size_bytes: builtins.int
    """Max byte size of a batch in element."""
    max_buffering_duration_millis: builtins.int
    """(Optional) Max duration a batch is allowed to be cached in states."""
    def __init__(
        self,
        *,
        batch_size: builtins.int | None = ...,
        batch_size_bytes: builtins.int | None = ...,
        max_buffering_duration_millis: builtins.int | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_size", b"batch_size", "batch_size_bytes", b"batch_size_bytes", "max_buffering_duration_millis", b"max_buffering_duration_millis"]) -> None: ...

global___GroupIntoBatchesPayload = GroupIntoBatchesPayload

@typing_extensions.final
class Coder(google.protobuf.message.Message):
    """A coder, the binary format for serialization and deserialization of data in
    a pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEC_FIELD_NUMBER: builtins.int
    COMPONENT_CODER_IDS_FIELD_NUMBER: builtins.int
    @property
    def spec(self) -> global___FunctionSpec:
        """(Required) A specification for the coder, as a URN plus parameters. This
        may be a cross-language agreed-upon format, or it may be a "custom coder"
        that can only be used by a particular SDK. It does not include component
        coders, as it is beneficial for these to be comprehensible to a runner
        regardless of whether the binary format is agreed-upon.
        """
    @property
    def component_coder_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """(Optional) If this coder is parametric, such as ListCoder(VarIntCoder),
        this is a list of the components. In order for encodings to be identical,
        the FunctionSpec and all components must be identical, recursively.
        """
    def __init__(
        self,
        *,
        spec: global___FunctionSpec | None = ...,
        component_coder_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["component_coder_ids", b"component_coder_ids", "spec", b"spec"]) -> None: ...

global___Coder = Coder

@typing_extensions.final
class StandardCoders(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardCoders._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        BYTES: StandardCoders._Enum.ValueType  # 0
        """Components: None"""
        STRING_UTF8: StandardCoders._Enum.ValueType  # 10
        """Components: None"""
        KV: StandardCoders._Enum.ValueType  # 1
        """Components: The key and value coder, in that order."""
        BOOL: StandardCoders._Enum.ValueType  # 12
        """Components: None"""
        VARINT: StandardCoders._Enum.ValueType  # 2
        """Variable length Encodes a 64-bit integer.
        Components: None
        """
        DOUBLE: StandardCoders._Enum.ValueType  # 11
        """Encodes the floating point value as a big-endian 64-bit integer
        according to the IEEE 754 double format bit layout.
        Components: None
        """
        ITERABLE: StandardCoders._Enum.ValueType  # 3
        """Encodes an iterable of elements.

        The encoding for an iterable [e1...eN] of known length N is

           fixed32(N)
           encode(e1) encode(e2) encode(e3) ... encode(eN)

        If the length is unknown, it is batched up into groups of size b1..bM
        and encoded as

            fixed32(-1)
            varInt64(b1) encode(e1) encode(e2) ... encode(e_b1)
            varInt64(b2) encode(e_(b1+1)) encode(e_(b1+2)) ... encode(e_(b1+b2))
            ...
            varInt64(bM) encode(e_(N-bM+1)) encode(e_(N-bM+2)) ... encode(eN)
            varInt64(0)

        Components: Coder for a single element.
        """
        TIMER: StandardCoders._Enum.ValueType  # 4
        """Encodes a timer containing a user key, a dynamic timer tag, a clear bit,
        a fire timestamp, a hold timestamp, the windows and the paneinfo.
        The encoding is represented as:
          user key - user defined key, uses the component coder.
          dynamic timer tag - a string which identifies a timer.
          windows - uses component coders.
          clear bit - a boolean set for clearing the timer.
          fire timestamp - a big endian 8 byte integer representing millis-since-epoch.
            The encoded representation is shifted so that the byte representation of
            negative values are lexicographically ordered before the byte representation
            of positive values. This is typically done by subtracting -9223372036854775808
            from the value and encoding it as a signed big endian integer. Example values:

            -9223372036854775808: 00 00 00 00 00 00 00 00
                            -255: 7F FF FF FF FF FF FF 01
                              -1: 7F FF FF FF FF FF FF FF
                               0: 80 00 00 00 00 00 00 00
                               1: 80 00 00 00 00 00 00 01
                             256: 80 00 00 00 00 00 01 00
             9223372036854775807: FF FF FF FF FF FF FF FF
          hold timestamp - similar to the fire timestamp.
          paneinfo - similar to the paneinfo of the windowed_value.
        Components: Coder for the key and windows.
        """
        INTERVAL_WINDOW: StandardCoders._Enum.ValueType  # 5
        """
        The following coders are typically not specified manually by the user,
        but are used at runtime and must be supported by every SDK.

        Components: None
        """
        LENGTH_PREFIX: StandardCoders._Enum.ValueType  # 6
        """Components: The coder to attach a length prefix to"""
        GLOBAL_WINDOW: StandardCoders._Enum.ValueType  # 7
        """Components: None"""
        WINDOWED_VALUE: StandardCoders._Enum.ValueType  # 8
        """Encodes an element, the windows it is in, the timestamp of the element,
        and the pane of the element. The encoding is represented as:
        timestamp windows pane element
          timestamp - A big endian 8 byte integer representing millis-since-epoch.
            The encoded representation is shifted so that the byte representation
            of negative values are lexicographically ordered before the byte
            representation of positive values. This is typically done by
            subtracting -9223372036854775808 from the value and encoding it as a
            signed big endian integer. Example values:

            -9223372036854775808: 00 00 00 00 00 00 00 00
                            -255: 7F FF FF FF FF FF FF 01
                              -1: 7F FF FF FF FF FF FF FF
                               0: 80 00 00 00 00 00 00 00
                               1: 80 00 00 00 00 00 00 01
                             256: 80 00 00 00 00 00 01 00
             9223372036854775807: FF FF FF FF FF FF FF FF

          windows - The windows are encoded using the beam:coder:iterable:v1
            format, where the windows are encoded using the supplied window
            coder.

          pane - The first byte of the pane info determines which type of
            encoding is used, as well as the is_first, is_last, and timing
            fields. If this byte is bits [0 1 2 3 4 5 6 7], then:
            * bits [0 1 2 3] determine the encoding as follows:
                0000 - The entire pane info is encoded as a single byte.
                       The is_first, is_last, and timing fields are encoded
                       as below, and the index and non-speculative index are
                       both zero (and hence are not encoded here).
                0001 - The pane info is encoded as this byte plus a single
                       VarInt encoed integer representing the pane index. The
                       non-speculative index can be derived as follows:
                         -1 if the pane is early, otherwise equal to index.
                0010 - The pane info is encoded as this byte plus two VarInt
                       encoded integers representing the pane index and
                       non-speculative index respectively.
            * bits [4 5] encode the timing as follows:
                00 - early
                01 - on time
                10 - late
                11 - unknown
            * bit 6 is 1 if this is the first pane, 0 otherwise.
            * bit 7 is 1 if this is the last pane, 0 otherwise.

          element - The element incoded using the supplied element coder.

        Components: The element coder and the window coder, in that order.
        """
        PARAM_WINDOWED_VALUE: StandardCoders._Enum.ValueType  # 14
        """A windowed value coder with parameterized timestamp, windows and pane info.
        Encodes an element with only the value of the windowed value.
        Decodes the value and assigns the parameterized timestamp, windows and pane info to the
        windowed value.
        Components: The element coder and the window coder, in that order
        The payload of this coder is an encoded windowed value using the
        beam:coder:windowed_value:v1 coder parameterized by a beam:coder:bytes:v1
        element coder and the window coder that this param_windowed_value coder uses.
        """
        STATE_BACKED_ITERABLE: StandardCoders._Enum.ValueType  # 9
        """Encodes an iterable of elements, some of which may be stored elsewhere.

        The encoding for a state-backed iterable is the same as that for
        an iterable, but the final varInt64(0) terminating the set of batches
        may instead be replaced by

            varInt64(-1)
            varInt64(len(token))
            token

        where token is an opaque byte string that can be used to fetch the
        remainder of the iterable (e.g. over the state API).

        Components: Coder for a single element.
        """
        CUSTOM_WINDOW: StandardCoders._Enum.ValueType  # 16
        """Encodes an arbitrary user defined window and its max timestamp (inclusive).
        The encoding format is:
          maxTimestamp window

          maxTimestamp - A big endian 8 byte integer representing millis-since-epoch.
            The encoded representation is shifted so that the byte representation
            of negative values are lexicographically ordered before the byte
            representation of positive values. This is typically done by
            subtracting -9223372036854775808 from the value and encoding it as a
            signed big endian integer. Example values:

            -9223372036854775808: 00 00 00 00 00 00 00 00
                            -255: 7F FF FF FF FF FF FF 01
                              -1: 7F FF FF FF FF FF FF FF
                               0: 80 00 00 00 00 00 00 00
                               1: 80 00 00 00 00 00 00 01
                             256: 80 00 00 00 00 00 01 00
             9223372036854775807: FF FF FF FF FF FF FF FF

          window - the window is encoded using the supplied window coder.

        Components: Coder for the custom window type.
        """
        ROW: StandardCoders._Enum.ValueType  # 13
        """Additional Standard Coders
        --------------------------
        The following coders are not required to be implemented for an SDK or
        runner to support the Beam model, but enable users to take advantage of
        schema-aware transforms.

        Encodes a "row", an element with a known schema, defined by an
        instance of Schema from schema.proto.

        A row is encoded as the concatenation of:
          - The number of attributes in the schema, encoded with
            beam:coder:varint:v1. This makes it possible to detect certain
            allowed schema changes (appending or removing columns) in
            long-running streaming pipelines.
          - A byte array representing a packed bitset indicating null fields (a
            1 indicating a null) encoded with beam:coder:bytes:v1. The unused
            bits in the last byte must be set to 0. If there are no nulls an
            empty byte array is encoded.
            The two-byte bitset (not including the lenghth-prefix) for the row
            [NULL, 0, 0, 0, NULL, 0, 0, NULL, 0, NULL] would be
            [0b10010001, 0b00000010]
          - An encoding for each non-null field, concatenated together.

        Schema types are mapped to coders as follows:
          AtomicType:
            BYTE:      not yet a standard coder (https://github.com/apache/beam/issues/19815)
            INT16:     not yet a standard coder (https://github.com/apache/beam/issues/19815)
            INT32:     beam:coder:varint:v1
            INT64:     beam:coder:varint:v1
            FLOAT:     not yet a standard coder (https://github.com/apache/beam/issues/19815)
            DOUBLE:    beam:coder:double:v1
            STRING:    beam:coder:string_utf8:v1
            BOOLEAN:   beam:coder:bool:v1
            BYTES:     beam:coder:bytes:v1
          ArrayType:   beam:coder:iterable:v1 (always has a known length)
          MapType:     not a standard coder, specification defined below.
          RowType:     beam:coder:row:v1
          LogicalType: Uses the coder for its representation.

        The MapType is encoded by:
          - An INT32 representing the size of the map (N)
          - Followed by N interleaved keys and values, encoded with their
            corresponding coder.

        Nullable types in container types (ArrayType, MapType) per the
        encoding described for general Nullable types below.

        Logical types understood by all SDKs should be defined in schema.proto.
        Example of well known logical types:
          beam:logical_type:schema:v1
          - Representation type: BYTES
          - A Beam Schema stored as a serialized proto.

        The payload for RowCoder is an instance of Schema.
        Components: None
        """
        SHARDED_KEY: StandardCoders._Enum.ValueType  # 15
        """Encodes a user key and a shard id which is an opaque byte string.

        The encoding for a sharded key consists of a shard id byte string and the
        encoded user key in the following order:

            - shard id using beam:coder:bytes:v1
            - encoded user key

        Examples:
        user key with an empty shard id
            0x00
            encode(user_key)

        user key with a shard id taking up two bytes.
            0x02
            0x11 0x22
            encode(user_key)

        Components: the user key coder.
        """
        NULLABLE: StandardCoders._Enum.ValueType  # 17
        """Wraps a coder of a potentially null value
        A Nullable Type is encoded by:
          - A one byte null indicator, 0x00 for null values, or 0x01 for present
            values.
          - For present values the null indicator is followed by the value
            encoded with it's corresponding coder.
        Components: single coder for the value
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    BYTES: StandardCoders.Enum.ValueType  # 0
    """Components: None"""
    STRING_UTF8: StandardCoders.Enum.ValueType  # 10
    """Components: None"""
    KV: StandardCoders.Enum.ValueType  # 1
    """Components: The key and value coder, in that order."""
    BOOL: StandardCoders.Enum.ValueType  # 12
    """Components: None"""
    VARINT: StandardCoders.Enum.ValueType  # 2
    """Variable length Encodes a 64-bit integer.
    Components: None
    """
    DOUBLE: StandardCoders.Enum.ValueType  # 11
    """Encodes the floating point value as a big-endian 64-bit integer
    according to the IEEE 754 double format bit layout.
    Components: None
    """
    ITERABLE: StandardCoders.Enum.ValueType  # 3
    """Encodes an iterable of elements.

    The encoding for an iterable [e1...eN] of known length N is

       fixed32(N)
       encode(e1) encode(e2) encode(e3) ... encode(eN)

    If the length is unknown, it is batched up into groups of size b1..bM
    and encoded as

        fixed32(-1)
        varInt64(b1) encode(e1) encode(e2) ... encode(e_b1)
        varInt64(b2) encode(e_(b1+1)) encode(e_(b1+2)) ... encode(e_(b1+b2))
        ...
        varInt64(bM) encode(e_(N-bM+1)) encode(e_(N-bM+2)) ... encode(eN)
        varInt64(0)

    Components: Coder for a single element.
    """
    TIMER: StandardCoders.Enum.ValueType  # 4
    """Encodes a timer containing a user key, a dynamic timer tag, a clear bit,
    a fire timestamp, a hold timestamp, the windows and the paneinfo.
    The encoding is represented as:
      user key - user defined key, uses the component coder.
      dynamic timer tag - a string which identifies a timer.
      windows - uses component coders.
      clear bit - a boolean set for clearing the timer.
      fire timestamp - a big endian 8 byte integer representing millis-since-epoch.
        The encoded representation is shifted so that the byte representation of
        negative values are lexicographically ordered before the byte representation
        of positive values. This is typically done by subtracting -9223372036854775808
        from the value and encoding it as a signed big endian integer. Example values:

        -9223372036854775808: 00 00 00 00 00 00 00 00
                        -255: 7F FF FF FF FF FF FF 01
                          -1: 7F FF FF FF FF FF FF FF
                           0: 80 00 00 00 00 00 00 00
                           1: 80 00 00 00 00 00 00 01
                         256: 80 00 00 00 00 00 01 00
         9223372036854775807: FF FF FF FF FF FF FF FF
      hold timestamp - similar to the fire timestamp.
      paneinfo - similar to the paneinfo of the windowed_value.
    Components: Coder for the key and windows.
    """
    INTERVAL_WINDOW: StandardCoders.Enum.ValueType  # 5
    """
    The following coders are typically not specified manually by the user,
    but are used at runtime and must be supported by every SDK.

    Components: None
    """
    LENGTH_PREFIX: StandardCoders.Enum.ValueType  # 6
    """Components: The coder to attach a length prefix to"""
    GLOBAL_WINDOW: StandardCoders.Enum.ValueType  # 7
    """Components: None"""
    WINDOWED_VALUE: StandardCoders.Enum.ValueType  # 8
    """Encodes an element, the windows it is in, the timestamp of the element,
    and the pane of the element. The encoding is represented as:
    timestamp windows pane element
      timestamp - A big endian 8 byte integer representing millis-since-epoch.
        The encoded representation is shifted so that the byte representation
        of negative values are lexicographically ordered before the byte
        representation of positive values. This is typically done by
        subtracting -9223372036854775808 from the value and encoding it as a
        signed big endian integer. Example values:

        -9223372036854775808: 00 00 00 00 00 00 00 00
                        -255: 7F FF FF FF FF FF FF 01
                          -1: 7F FF FF FF FF FF FF FF
                           0: 80 00 00 00 00 00 00 00
                           1: 80 00 00 00 00 00 00 01
                         256: 80 00 00 00 00 00 01 00
         9223372036854775807: FF FF FF FF FF FF FF FF

      windows - The windows are encoded using the beam:coder:iterable:v1
        format, where the windows are encoded using the supplied window
        coder.

      pane - The first byte of the pane info determines which type of
        encoding is used, as well as the is_first, is_last, and timing
        fields. If this byte is bits [0 1 2 3 4 5 6 7], then:
        * bits [0 1 2 3] determine the encoding as follows:
            0000 - The entire pane info is encoded as a single byte.
                   The is_first, is_last, and timing fields are encoded
                   as below, and the index and non-speculative index are
                   both zero (and hence are not encoded here).
            0001 - The pane info is encoded as this byte plus a single
                   VarInt encoed integer representing the pane index. The
                   non-speculative index can be derived as follows:
                     -1 if the pane is early, otherwise equal to index.
            0010 - The pane info is encoded as this byte plus two VarInt
                   encoded integers representing the pane index and
                   non-speculative index respectively.
        * bits [4 5] encode the timing as follows:
            00 - early
            01 - on time
            10 - late
            11 - unknown
        * bit 6 is 1 if this is the first pane, 0 otherwise.
        * bit 7 is 1 if this is the last pane, 0 otherwise.

      element - The element incoded using the supplied element coder.

    Components: The element coder and the window coder, in that order.
    """
    PARAM_WINDOWED_VALUE: StandardCoders.Enum.ValueType  # 14
    """A windowed value coder with parameterized timestamp, windows and pane info.
    Encodes an element with only the value of the windowed value.
    Decodes the value and assigns the parameterized timestamp, windows and pane info to the
    windowed value.
    Components: The element coder and the window coder, in that order
    The payload of this coder is an encoded windowed value using the
    beam:coder:windowed_value:v1 coder parameterized by a beam:coder:bytes:v1
    element coder and the window coder that this param_windowed_value coder uses.
    """
    STATE_BACKED_ITERABLE: StandardCoders.Enum.ValueType  # 9
    """Encodes an iterable of elements, some of which may be stored elsewhere.

    The encoding for a state-backed iterable is the same as that for
    an iterable, but the final varInt64(0) terminating the set of batches
    may instead be replaced by

        varInt64(-1)
        varInt64(len(token))
        token

    where token is an opaque byte string that can be used to fetch the
    remainder of the iterable (e.g. over the state API).

    Components: Coder for a single element.
    """
    CUSTOM_WINDOW: StandardCoders.Enum.ValueType  # 16
    """Encodes an arbitrary user defined window and its max timestamp (inclusive).
    The encoding format is:
      maxTimestamp window

      maxTimestamp - A big endian 8 byte integer representing millis-since-epoch.
        The encoded representation is shifted so that the byte representation
        of negative values are lexicographically ordered before the byte
        representation of positive values. This is typically done by
        subtracting -9223372036854775808 from the value and encoding it as a
        signed big endian integer. Example values:

        -9223372036854775808: 00 00 00 00 00 00 00 00
                        -255: 7F FF FF FF FF FF FF 01
                          -1: 7F FF FF FF FF FF FF FF
                           0: 80 00 00 00 00 00 00 00
                           1: 80 00 00 00 00 00 00 01
                         256: 80 00 00 00 00 00 01 00
         9223372036854775807: FF FF FF FF FF FF FF FF

      window - the window is encoded using the supplied window coder.

    Components: Coder for the custom window type.
    """
    ROW: StandardCoders.Enum.ValueType  # 13
    """Additional Standard Coders
    --------------------------
    The following coders are not required to be implemented for an SDK or
    runner to support the Beam model, but enable users to take advantage of
    schema-aware transforms.

    Encodes a "row", an element with a known schema, defined by an
    instance of Schema from schema.proto.

    A row is encoded as the concatenation of:
      - The number of attributes in the schema, encoded with
        beam:coder:varint:v1. This makes it possible to detect certain
        allowed schema changes (appending or removing columns) in
        long-running streaming pipelines.
      - A byte array representing a packed bitset indicating null fields (a
        1 indicating a null) encoded with beam:coder:bytes:v1. The unused
        bits in the last byte must be set to 0. If there are no nulls an
        empty byte array is encoded.
        The two-byte bitset (not including the lenghth-prefix) for the row
        [NULL, 0, 0, 0, NULL, 0, 0, NULL, 0, NULL] would be
        [0b10010001, 0b00000010]
      - An encoding for each non-null field, concatenated together.

    Schema types are mapped to coders as follows:
      AtomicType:
        BYTE:      not yet a standard coder (https://github.com/apache/beam/issues/19815)
        INT16:     not yet a standard coder (https://github.com/apache/beam/issues/19815)
        INT32:     beam:coder:varint:v1
        INT64:     beam:coder:varint:v1
        FLOAT:     not yet a standard coder (https://github.com/apache/beam/issues/19815)
        DOUBLE:    beam:coder:double:v1
        STRING:    beam:coder:string_utf8:v1
        BOOLEAN:   beam:coder:bool:v1
        BYTES:     beam:coder:bytes:v1
      ArrayType:   beam:coder:iterable:v1 (always has a known length)
      MapType:     not a standard coder, specification defined below.
      RowType:     beam:coder:row:v1
      LogicalType: Uses the coder for its representation.

    The MapType is encoded by:
      - An INT32 representing the size of the map (N)
      - Followed by N interleaved keys and values, encoded with their
        corresponding coder.

    Nullable types in container types (ArrayType, MapType) per the
    encoding described for general Nullable types below.

    Logical types understood by all SDKs should be defined in schema.proto.
    Example of well known logical types:
      beam:logical_type:schema:v1
      - Representation type: BYTES
      - A Beam Schema stored as a serialized proto.

    The payload for RowCoder is an instance of Schema.
    Components: None
    """
    SHARDED_KEY: StandardCoders.Enum.ValueType  # 15
    """Encodes a user key and a shard id which is an opaque byte string.

    The encoding for a sharded key consists of a shard id byte string and the
    encoded user key in the following order:

        - shard id using beam:coder:bytes:v1
        - encoded user key

    Examples:
    user key with an empty shard id
        0x00
        encode(user_key)

    user key with a shard id taking up two bytes.
        0x02
        0x11 0x22
        encode(user_key)

    Components: the user key coder.
    """
    NULLABLE: StandardCoders.Enum.ValueType  # 17
    """Wraps a coder of a potentially null value
    A Nullable Type is encoded by:
      - A one byte null indicator, 0x00 for null values, or 0x01 for present
        values.
      - For present values the null indicator is followed by the value
        encoded with it's corresponding coder.
    Components: single coder for the value
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardCoders = StandardCoders

@typing_extensions.final
class WindowingStrategy(google.protobuf.message.Message):
    """A windowing strategy describes the window function, triggering, allowed
    lateness, and accumulation mode for a PCollection.

    TODO: consider inlining field on PCollection
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WINDOW_FN_FIELD_NUMBER: builtins.int
    MERGE_STATUS_FIELD_NUMBER: builtins.int
    WINDOW_CODER_ID_FIELD_NUMBER: builtins.int
    TRIGGER_FIELD_NUMBER: builtins.int
    ACCUMULATION_MODE_FIELD_NUMBER: builtins.int
    OUTPUT_TIME_FIELD_NUMBER: builtins.int
    CLOSING_BEHAVIOR_FIELD_NUMBER: builtins.int
    ALLOWED_LATENESS_FIELD_NUMBER: builtins.int
    ON_TIME_BEHAVIOR_FIELD_NUMBER: builtins.int
    ASSIGNS_TO_ONE_WINDOW_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    @property
    def window_fn(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the UDF that assigns windows,
        merges windows, and shifts timestamps before they are
        combined according to the OutputTime.
        """
    merge_status: global___MergeStatus.Enum.ValueType
    """(Required) Whether or not the window fn is merging.

    This knowledge is required for many optimizations.
    """
    window_coder_id: builtins.str
    """(Required) The coder for the windows of this PCollection."""
    @property
    def trigger(self) -> global___Trigger:
        """(Required) The trigger to use when grouping this PCollection."""
    accumulation_mode: global___AccumulationMode.Enum.ValueType
    """(Required) The accumulation mode indicates whether new panes are a full
    replacement for prior panes or whether they are deltas to be combined
    with other panes (the combine should correspond to whatever the upstream
    grouping transform is).
    """
    output_time: global___OutputTime.Enum.ValueType
    """(Required) The OutputTime specifies, for a grouping transform, how to
    compute the aggregate timestamp. The window_fn will first possibly shift
    it later, then the OutputTime takes the max, min, or ignores it and takes
    the end of window.

    This is actually only for input to grouping transforms, but since they
    may be introduced in runner-specific ways, it is carried along with the
    windowing strategy.
    """
    closing_behavior: global___ClosingBehavior.Enum.ValueType
    """(Required) Indicate when output should be omitted upon window expiration."""
    allowed_lateness: builtins.int
    """(Required) The duration, in milliseconds, beyond the end of a window at
    which the window becomes droppable.
    """
    on_time_behavior: global___OnTimeBehavior.Enum.ValueType
    """(Required) Indicate whether empty on-time panes should be omitted."""
    assigns_to_one_window: builtins.bool
    """(Required) Whether or not the window fn assigns inputs to exactly one window

    This knowledge is required for some optimizations
    """
    environment_id: builtins.str
    """(Optional) Environment where the current window_fn should be applied in.
    Runner that executes the pipeline may choose to override this if needed.
    If not specified, environment will be decided by the runner.
    """
    def __init__(
        self,
        *,
        window_fn: global___FunctionSpec | None = ...,
        merge_status: global___MergeStatus.Enum.ValueType | None = ...,
        window_coder_id: builtins.str | None = ...,
        trigger: global___Trigger | None = ...,
        accumulation_mode: global___AccumulationMode.Enum.ValueType | None = ...,
        output_time: global___OutputTime.Enum.ValueType | None = ...,
        closing_behavior: global___ClosingBehavior.Enum.ValueType | None = ...,
        allowed_lateness: builtins.int | None = ...,
        on_time_behavior: global___OnTimeBehavior.Enum.ValueType | None = ...,
        assigns_to_one_window: builtins.bool | None = ...,
        environment_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["trigger", b"trigger", "window_fn", b"window_fn"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["accumulation_mode", b"accumulation_mode", "allowed_lateness", b"allowed_lateness", "assigns_to_one_window", b"assigns_to_one_window", "closing_behavior", b"closing_behavior", "environment_id", b"environment_id", "merge_status", b"merge_status", "on_time_behavior", b"on_time_behavior", "output_time", b"output_time", "trigger", b"trigger", "window_coder_id", b"window_coder_id", "window_fn", b"window_fn"]) -> None: ...

global___WindowingStrategy = WindowingStrategy

@typing_extensions.final
class MergeStatus(google.protobuf.message.Message):
    """Whether or not a PCollection's WindowFn is non-merging, merging, or
    merging-but-already-merged, in which case a subsequent GroupByKey is almost
    always going to do something the user does not want
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MergeStatus._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: MergeStatus._Enum.ValueType  # 0
        NON_MERGING: MergeStatus._Enum.ValueType  # 1
        """The WindowFn does not require merging.
        Examples: global window, FixedWindows, SlidingWindows
        """
        NEEDS_MERGE: MergeStatus._Enum.ValueType  # 2
        """The WindowFn is merging and the PCollection has not had merging
        performed.
        Example: Sessions prior to a GroupByKey
        """
        ALREADY_MERGED: MergeStatus._Enum.ValueType  # 3
        """The WindowFn is merging and the PCollection has had merging occur
        already.
        Example: Sessions after a GroupByKey
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: MergeStatus.Enum.ValueType  # 0
    NON_MERGING: MergeStatus.Enum.ValueType  # 1
    """The WindowFn does not require merging.
    Examples: global window, FixedWindows, SlidingWindows
    """
    NEEDS_MERGE: MergeStatus.Enum.ValueType  # 2
    """The WindowFn is merging and the PCollection has not had merging
    performed.
    Example: Sessions prior to a GroupByKey
    """
    ALREADY_MERGED: MergeStatus.Enum.ValueType  # 3
    """The WindowFn is merging and the PCollection has had merging occur
    already.
    Example: Sessions after a GroupByKey
    """

    def __init__(
        self,
    ) -> None: ...

global___MergeStatus = MergeStatus

@typing_extensions.final
class AccumulationMode(google.protobuf.message.Message):
    """Whether or not subsequent outputs of aggregations should be entire
    replacement values or just the aggregation of inputs received since
    the prior output.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AccumulationMode._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: AccumulationMode._Enum.ValueType  # 0
        DISCARDING: AccumulationMode._Enum.ValueType  # 1
        """The aggregation is discarded when it is output"""
        ACCUMULATING: AccumulationMode._Enum.ValueType  # 2
        """The aggregation is accumulated across outputs"""
        RETRACTING: AccumulationMode._Enum.ValueType  # 3
        """The aggregation emits retractions when it is output"""

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: AccumulationMode.Enum.ValueType  # 0
    DISCARDING: AccumulationMode.Enum.ValueType  # 1
    """The aggregation is discarded when it is output"""
    ACCUMULATING: AccumulationMode.Enum.ValueType  # 2
    """The aggregation is accumulated across outputs"""
    RETRACTING: AccumulationMode.Enum.ValueType  # 3
    """The aggregation emits retractions when it is output"""

    def __init__(
        self,
    ) -> None: ...

global___AccumulationMode = AccumulationMode

@typing_extensions.final
class ClosingBehavior(google.protobuf.message.Message):
    """Controls whether or not an aggregating transform should output data
    when a window expires.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ClosingBehavior._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: ClosingBehavior._Enum.ValueType  # 0
        EMIT_ALWAYS: ClosingBehavior._Enum.ValueType  # 1
        """Emit output when a window expires, whether or not there has been
        any new data since the last output.
        """
        EMIT_IF_NONEMPTY: ClosingBehavior._Enum.ValueType  # 2
        """Only emit output when new data has arrives since the last output"""

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: ClosingBehavior.Enum.ValueType  # 0
    EMIT_ALWAYS: ClosingBehavior.Enum.ValueType  # 1
    """Emit output when a window expires, whether or not there has been
    any new data since the last output.
    """
    EMIT_IF_NONEMPTY: ClosingBehavior.Enum.ValueType  # 2
    """Only emit output when new data has arrives since the last output"""

    def __init__(
        self,
    ) -> None: ...

global___ClosingBehavior = ClosingBehavior

@typing_extensions.final
class OnTimeBehavior(google.protobuf.message.Message):
    """Controls whether or not an aggregating transform should output data
    when an on-time pane is empty.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OnTimeBehavior._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: OnTimeBehavior._Enum.ValueType  # 0
        FIRE_ALWAYS: OnTimeBehavior._Enum.ValueType  # 1
        """Always fire the on-time pane. Even if there is no new data since
        the previous firing, an element will be produced.
        """
        FIRE_IF_NONEMPTY: OnTimeBehavior._Enum.ValueType  # 2
        """Only fire the on-time pane if there is new data since the previous firing."""

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: OnTimeBehavior.Enum.ValueType  # 0
    FIRE_ALWAYS: OnTimeBehavior.Enum.ValueType  # 1
    """Always fire the on-time pane. Even if there is no new data since
    the previous firing, an element will be produced.
    """
    FIRE_IF_NONEMPTY: OnTimeBehavior.Enum.ValueType  # 2
    """Only fire the on-time pane if there is new data since the previous firing."""

    def __init__(
        self,
    ) -> None: ...

global___OnTimeBehavior = OnTimeBehavior

@typing_extensions.final
class OutputTime(google.protobuf.message.Message):
    """When a number of windowed, timestamped inputs are aggregated, the timestamp
    for the resulting output.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OutputTime._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: OutputTime._Enum.ValueType  # 0
        END_OF_WINDOW: OutputTime._Enum.ValueType  # 1
        """The output has the timestamp of the end of the window."""
        LATEST_IN_PANE: OutputTime._Enum.ValueType  # 2
        """The output has the latest timestamp of the input elements since
        the last output.
        """
        EARLIEST_IN_PANE: OutputTime._Enum.ValueType  # 3
        """The output has the earliest timestamp of the input elements since
        the last output.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: OutputTime.Enum.ValueType  # 0
    END_OF_WINDOW: OutputTime.Enum.ValueType  # 1
    """The output has the timestamp of the end of the window."""
    LATEST_IN_PANE: OutputTime.Enum.ValueType  # 2
    """The output has the latest timestamp of the input elements since
    the last output.
    """
    EARLIEST_IN_PANE: OutputTime.Enum.ValueType  # 3
    """The output has the earliest timestamp of the input elements since
    the last output.
    """

    def __init__(
        self,
    ) -> None: ...

global___OutputTime = OutputTime

@typing_extensions.final
class TimeDomain(google.protobuf.message.Message):
    """The different time domains in the Beam model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[TimeDomain._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: TimeDomain._Enum.ValueType  # 0
        EVENT_TIME: TimeDomain._Enum.ValueType  # 1
        """Event time is time from the perspective of the data"""
        PROCESSING_TIME: TimeDomain._Enum.ValueType  # 2
        """Processing time is time from the perspective of the
        execution of your pipeline
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    UNSPECIFIED: TimeDomain.Enum.ValueType  # 0
    EVENT_TIME: TimeDomain.Enum.ValueType  # 1
    """Event time is time from the perspective of the data"""
    PROCESSING_TIME: TimeDomain.Enum.ValueType  # 2
    """Processing time is time from the perspective of the
    execution of your pipeline
    """

    def __init__(
        self,
    ) -> None: ...

global___TimeDomain = TimeDomain

@typing_extensions.final
class Trigger(google.protobuf.message.Message):
    """A small DSL for expressing when to emit new aggregations
    from a GroupByKey or CombinePerKey

    A trigger is described in terms of when it is _ready_ to permit output.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AfterAll(google.protobuf.message.Message):
        """Ready when all subtriggers are ready."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SUBTRIGGERS_FIELD_NUMBER: builtins.int
        @property
        def subtriggers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trigger]: ...
        def __init__(
            self,
            *,
            subtriggers: collections.abc.Iterable[global___Trigger] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["subtriggers", b"subtriggers"]) -> None: ...

    @typing_extensions.final
    class AfterAny(google.protobuf.message.Message):
        """Ready when any subtrigger is ready."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SUBTRIGGERS_FIELD_NUMBER: builtins.int
        @property
        def subtriggers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trigger]: ...
        def __init__(
            self,
            *,
            subtriggers: collections.abc.Iterable[global___Trigger] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["subtriggers", b"subtriggers"]) -> None: ...

    @typing_extensions.final
    class AfterEach(google.protobuf.message.Message):
        """Starting with the first subtrigger, ready when the _current_ subtrigger
        is ready. After output, advances the current trigger by one.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SUBTRIGGERS_FIELD_NUMBER: builtins.int
        @property
        def subtriggers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trigger]: ...
        def __init__(
            self,
            *,
            subtriggers: collections.abc.Iterable[global___Trigger] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["subtriggers", b"subtriggers"]) -> None: ...

    @typing_extensions.final
    class AfterEndOfWindow(google.protobuf.message.Message):
        """Ready after the input watermark is past the end of the window.

        May have implicitly-repeated subtriggers for early and late firings.
        When the end of the window is reached, the trigger transitions between
        the subtriggers.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EARLY_FIRINGS_FIELD_NUMBER: builtins.int
        LATE_FIRINGS_FIELD_NUMBER: builtins.int
        @property
        def early_firings(self) -> global___Trigger:
            """(Optional) A trigger governing output prior to the end of the window."""
        @property
        def late_firings(self) -> global___Trigger:
            """(Optional) A trigger governing output after the end of the window."""
        def __init__(
            self,
            *,
            early_firings: global___Trigger | None = ...,
            late_firings: global___Trigger | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["early_firings", b"early_firings", "late_firings", b"late_firings"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["early_firings", b"early_firings", "late_firings", b"late_firings"]) -> None: ...

    @typing_extensions.final
    class AfterProcessingTime(google.protobuf.message.Message):
        """After input arrives, ready when the specified delay has passed."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TIMESTAMP_TRANSFORMS_FIELD_NUMBER: builtins.int
        @property
        def timestamp_transforms(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TimestampTransform]:
            """(Required) The transforms to apply to an arriving element's timestamp,
            in order
            """
        def __init__(
            self,
            *,
            timestamp_transforms: collections.abc.Iterable[global___TimestampTransform] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["timestamp_transforms", b"timestamp_transforms"]) -> None: ...

    @typing_extensions.final
    class AfterSynchronizedProcessingTime(google.protobuf.message.Message):
        """Ready whenever upstream processing time has all caught up with
        the arrival time of an input element
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing_extensions.final
    class Default(google.protobuf.message.Message):
        """The default trigger. Equivalent to Repeat { AfterEndOfWindow } but
        specially denoted to indicate the user did not alter the triggering.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing_extensions.final
    class ElementCount(google.protobuf.message.Message):
        """Ready whenever the requisite number of input elements have arrived"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ELEMENT_COUNT_FIELD_NUMBER: builtins.int
        element_count: builtins.int
        def __init__(
            self,
            *,
            element_count: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["element_count", b"element_count"]) -> None: ...

    @typing_extensions.final
    class Never(google.protobuf.message.Message):
        """Never ready. There will only be an ON_TIME output and a final
        output at window expiration.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing_extensions.final
    class Always(google.protobuf.message.Message):
        """Always ready. This can also be expressed as ElementCount(1) but
        is more explicit.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing_extensions.final
    class OrFinally(google.protobuf.message.Message):
        """Ready whenever either of its subtriggers are ready, but finishes output
        when the finally subtrigger fires.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAIN_FIELD_NUMBER: builtins.int
        FINALLY_FIELD_NUMBER: builtins.int
        @property
        def main(self) -> global___Trigger:
            """(Required) Trigger governing main output; may fire repeatedly."""
        def __init__(
            self,
            *,
            main: global___Trigger | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["finally", b"finally", "main", b"main"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["finally", b"finally", "main", b"main"]) -> None: ...

    @typing_extensions.final
    class Repeat(google.protobuf.message.Message):
        """Ready whenever the subtrigger is ready; resets state when the subtrigger
        completes.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SUBTRIGGER_FIELD_NUMBER: builtins.int
        @property
        def subtrigger(self) -> global___Trigger:
            """(Require) Trigger that is run repeatedly."""
        def __init__(
            self,
            *,
            subtrigger: global___Trigger | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["subtrigger", b"subtrigger"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["subtrigger", b"subtrigger"]) -> None: ...

    AFTER_ALL_FIELD_NUMBER: builtins.int
    AFTER_ANY_FIELD_NUMBER: builtins.int
    AFTER_EACH_FIELD_NUMBER: builtins.int
    AFTER_END_OF_WINDOW_FIELD_NUMBER: builtins.int
    AFTER_PROCESSING_TIME_FIELD_NUMBER: builtins.int
    AFTER_SYNCHRONIZED_PROCESSING_TIME_FIELD_NUMBER: builtins.int
    ALWAYS_FIELD_NUMBER: builtins.int
    DEFAULT_FIELD_NUMBER: builtins.int
    ELEMENT_COUNT_FIELD_NUMBER: builtins.int
    NEVER_FIELD_NUMBER: builtins.int
    OR_FINALLY_FIELD_NUMBER: builtins.int
    REPEAT_FIELD_NUMBER: builtins.int
    @property
    def after_all(self) -> global___Trigger.AfterAll: ...
    @property
    def after_any(self) -> global___Trigger.AfterAny: ...
    @property
    def after_each(self) -> global___Trigger.AfterEach: ...
    @property
    def after_end_of_window(self) -> global___Trigger.AfterEndOfWindow: ...
    @property
    def after_processing_time(self) -> global___Trigger.AfterProcessingTime: ...
    @property
    def after_synchronized_processing_time(self) -> global___Trigger.AfterSynchronizedProcessingTime: ...
    @property
    def always(self) -> global___Trigger.Always: ...
    @property
    def default(self) -> global___Trigger.Default: ...
    @property
    def element_count(self) -> global___Trigger.ElementCount: ...
    @property
    def never(self) -> global___Trigger.Never: ...
    @property
    def or_finally(self) -> global___Trigger.OrFinally: ...
    @property
    def repeat(self) -> global___Trigger.Repeat: ...
    def __init__(
        self,
        *,
        after_all: global___Trigger.AfterAll | None = ...,
        after_any: global___Trigger.AfterAny | None = ...,
        after_each: global___Trigger.AfterEach | None = ...,
        after_end_of_window: global___Trigger.AfterEndOfWindow | None = ...,
        after_processing_time: global___Trigger.AfterProcessingTime | None = ...,
        after_synchronized_processing_time: global___Trigger.AfterSynchronizedProcessingTime | None = ...,
        always: global___Trigger.Always | None = ...,
        default: global___Trigger.Default | None = ...,
        element_count: global___Trigger.ElementCount | None = ...,
        never: global___Trigger.Never | None = ...,
        or_finally: global___Trigger.OrFinally | None = ...,
        repeat: global___Trigger.Repeat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["after_all", b"after_all", "after_any", b"after_any", "after_each", b"after_each", "after_end_of_window", b"after_end_of_window", "after_processing_time", b"after_processing_time", "after_synchronized_processing_time", b"after_synchronized_processing_time", "always", b"always", "default", b"default", "element_count", b"element_count", "never", b"never", "or_finally", b"or_finally", "repeat", b"repeat", "trigger", b"trigger"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["after_all", b"after_all", "after_any", b"after_any", "after_each", b"after_each", "after_end_of_window", b"after_end_of_window", "after_processing_time", b"after_processing_time", "after_synchronized_processing_time", b"after_synchronized_processing_time", "always", b"always", "default", b"default", "element_count", b"element_count", "never", b"never", "or_finally", b"or_finally", "repeat", b"repeat", "trigger", b"trigger"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["trigger", b"trigger"]) -> typing_extensions.Literal["after_all", "after_any", "after_each", "after_end_of_window", "after_processing_time", "after_synchronized_processing_time", "always", "default", "element_count", "never", "or_finally", "repeat"] | None: ...

global___Trigger = Trigger

@typing_extensions.final
class TimestampTransform(google.protobuf.message.Message):
    """A specification for a transformation on a timestamp.

    Primarily used by AfterProcessingTime triggers to transform
    the arrival time of input to a target time for firing.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Delay(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DELAY_MILLIS_FIELD_NUMBER: builtins.int
        delay_millis: builtins.int
        """(Required) The delay, in milliseconds."""
        def __init__(
            self,
            *,
            delay_millis: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["delay_millis", b"delay_millis"]) -> None: ...

    @typing_extensions.final
    class AlignTo(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PERIOD_FIELD_NUMBER: builtins.int
        OFFSET_FIELD_NUMBER: builtins.int
        period: builtins.int
        """(Required) A duration to which delays should be quantized
        in milliseconds.
        """
        offset: builtins.int
        """(Required) An offset from 0 for the quantization specified by
        alignment_size, in milliseconds
        """
        def __init__(
            self,
            *,
            period: builtins.int | None = ...,
            offset: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["offset", b"offset", "period", b"period"]) -> None: ...

    DELAY_FIELD_NUMBER: builtins.int
    ALIGN_TO_FIELD_NUMBER: builtins.int
    @property
    def delay(self) -> global___TimestampTransform.Delay: ...
    @property
    def align_to(self) -> global___TimestampTransform.AlignTo: ...
    def __init__(
        self,
        *,
        delay: global___TimestampTransform.Delay | None = ...,
        align_to: global___TimestampTransform.AlignTo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["align_to", b"align_to", "delay", b"delay", "timestamp_transform", b"timestamp_transform"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["align_to", b"align_to", "delay", b"delay", "timestamp_transform", b"timestamp_transform"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["timestamp_transform", b"timestamp_transform"]) -> typing_extensions.Literal["delay", "align_to"] | None: ...

global___TimestampTransform = TimestampTransform

@typing_extensions.final
class SideInput(google.protobuf.message.Message):
    """A specification for how to "side input" a PCollection."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_PATTERN_FIELD_NUMBER: builtins.int
    VIEW_FN_FIELD_NUMBER: builtins.int
    WINDOW_MAPPING_FN_FIELD_NUMBER: builtins.int
    @property
    def access_pattern(self) -> global___FunctionSpec:
        """(Required) URN of the access pattern required by the `view_fn` to present
        the desired SDK-specific interface to a UDF.

        This access pattern defines the SDK harness <-> Runner Harness RPC
        interface for accessing a side input.

        See StandardSideInputTypes for an enumeration of all side input types
        defined.
        """
    @property
    def view_fn(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the UDF that adapts a particular
        access_pattern to a user-facing view type.

        For example, View.asSingleton() may include a `view_fn` that adapts a
        specially-designed multimap to a single value per window.
        """
    @property
    def window_mapping_fn(self) -> global___FunctionSpec:
        """(Required) The FunctionSpec of the UDF that maps a main input window
        to a side input window.

        For example, when the main input is in fixed windows of one hour, this
        can specify that the side input should be accessed according to the day
        in which that hour falls.
        """
    def __init__(
        self,
        *,
        access_pattern: global___FunctionSpec | None = ...,
        view_fn: global___FunctionSpec | None = ...,
        window_mapping_fn: global___FunctionSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["access_pattern", b"access_pattern", "view_fn", b"view_fn", "window_mapping_fn", b"window_mapping_fn"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["access_pattern", b"access_pattern", "view_fn", b"view_fn", "window_mapping_fn", b"window_mapping_fn"]) -> None: ...

global___SideInput = SideInput

@typing_extensions.final
class StandardArtifacts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Types:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardArtifacts._Types.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FILE: StandardArtifacts._Types.ValueType  # 0
        """A URN for locally-accessible artifact files.
        payload: ArtifactFilePayload
        """
        URL: StandardArtifacts._Types.ValueType  # 1
        """A URN for artifacts described by URLs.
        payload: ArtifactUrlPayload
        """
        EMBEDDED: StandardArtifacts._Types.ValueType  # 2
        """A URN for artifacts embedded in ArtifactInformation proto.
        payload: EmbeddedFilePayload.
        """
        PYPI: StandardArtifacts._Types.ValueType  # 3
        """A URN for Python artifacts hosted on PYPI.
        payload: PypiPayload
        """
        MAVEN: StandardArtifacts._Types.ValueType  # 4
        """A URN for Java artifacts hosted on a Maven repository.
        payload: MavenPayload
        """
        DEFERRED: StandardArtifacts._Types.ValueType  # 5
        """A URN for deferred artifacts.
        payload: DeferredArtifactPayload
        """

    class Types(_Types, metaclass=_TypesEnumTypeWrapper): ...
    FILE: StandardArtifacts.Types.ValueType  # 0
    """A URN for locally-accessible artifact files.
    payload: ArtifactFilePayload
    """
    URL: StandardArtifacts.Types.ValueType  # 1
    """A URN for artifacts described by URLs.
    payload: ArtifactUrlPayload
    """
    EMBEDDED: StandardArtifacts.Types.ValueType  # 2
    """A URN for artifacts embedded in ArtifactInformation proto.
    payload: EmbeddedFilePayload.
    """
    PYPI: StandardArtifacts.Types.ValueType  # 3
    """A URN for Python artifacts hosted on PYPI.
    payload: PypiPayload
    """
    MAVEN: StandardArtifacts.Types.ValueType  # 4
    """A URN for Java artifacts hosted on a Maven repository.
    payload: MavenPayload
    """
    DEFERRED: StandardArtifacts.Types.ValueType  # 5
    """A URN for deferred artifacts.
    payload: DeferredArtifactPayload
    """

    class _Roles:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RolesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardArtifacts._Roles.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STAGING_TO: StandardArtifacts._Roles.ValueType  # 0
        """A URN for staging-to role.
        payload: ArtifactStagingToRolePayload
        """
        PIP_REQUIREMENTS_FILE: StandardArtifacts._Roles.ValueType  # 1
        """A URN for pip-requirements-file role.
        payload: None
        """
        GO_WORKER_BINARY: StandardArtifacts._Roles.ValueType  # 2
        """A URN for the Go worker binary role.
        This represents the executable for a Go SDK environment.
        A Go environment may have one such artifact with this role.
        payload: None
        """

    class Roles(_Roles, metaclass=_RolesEnumTypeWrapper): ...
    STAGING_TO: StandardArtifacts.Roles.ValueType  # 0
    """A URN for staging-to role.
    payload: ArtifactStagingToRolePayload
    """
    PIP_REQUIREMENTS_FILE: StandardArtifacts.Roles.ValueType  # 1
    """A URN for pip-requirements-file role.
    payload: None
    """
    GO_WORKER_BINARY: StandardArtifacts.Roles.ValueType  # 2
    """A URN for the Go worker binary role.
    This represents the executable for a Go SDK environment.
    A Go environment may have one such artifact with this role.
    payload: None
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardArtifacts = StandardArtifacts

@typing_extensions.final
class ArtifactFilePayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_FIELD_NUMBER: builtins.int
    SHA256_FIELD_NUMBER: builtins.int
    path: builtins.str
    """a string for an artifact file path e.g. "/tmp/foo.jar" """
    sha256: builtins.str
    """The hex-encoded sha256 checksum of the artifact."""
    def __init__(
        self,
        *,
        path: builtins.str | None = ...,
        sha256: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["path", b"path", "sha256", b"sha256"]) -> None: ...

global___ArtifactFilePayload = ArtifactFilePayload

@typing_extensions.final
class ArtifactUrlPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    SHA256_FIELD_NUMBER: builtins.int
    url: builtins.str
    """a string for an artifact URL e.g. "https://.../foo.jar" or "gs://tmp/foo.jar" """
    sha256: builtins.str
    """(Optional) The hex-encoded sha256 checksum of the artifact if available."""
    def __init__(
        self,
        *,
        url: builtins.str | None = ...,
        sha256: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["sha256", b"sha256", "url", b"url"]) -> None: ...

global___ArtifactUrlPayload = ArtifactUrlPayload

@typing_extensions.final
class EmbeddedFilePayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """raw data bytes for an embedded artifact"""
    def __init__(
        self,
        *,
        data: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___EmbeddedFilePayload = EmbeddedFilePayload

@typing_extensions.final
class PyPIPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARTIFACT_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    artifact_id: builtins.str
    """Pypi compatible artifact id e.g. "apache-beam" """
    version: builtins.str
    """Pypi compatible version string."""
    def __init__(
        self,
        *,
        artifact_id: builtins.str | None = ...,
        version: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact_id", b"artifact_id", "version", b"version"]) -> None: ...

global___PyPIPayload = PyPIPayload

@typing_extensions.final
class MavenPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARTIFACT_FIELD_NUMBER: builtins.int
    REPOSITORY_URL_FIELD_NUMBER: builtins.int
    artifact: builtins.str
    """A string specifying Maven artifact.
    The standard format is "groupId:artifactId:version[:packaging[:classifier]]"
    """
    repository_url: builtins.str
    """(Optional) Repository URL. If not specified, Maven central is used by default."""
    def __init__(
        self,
        *,
        artifact: builtins.str | None = ...,
        repository_url: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact", b"artifact", "repository_url", b"repository_url"]) -> None: ...

global___MavenPayload = MavenPayload

@typing_extensions.final
class DeferredArtifactPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    key: builtins.str
    """A unique string identifier assigned by the creator of this payload. The creator may use this key to confirm
    whether they can parse the data.
    """
    data: builtins.bytes
    """Data for deferred artifacts. Interpretation of bytes is delegated to the creator of this payload."""
    def __init__(
        self,
        *,
        key: builtins.str | None = ...,
        data: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "key", b"key"]) -> None: ...

global___DeferredArtifactPayload = DeferredArtifactPayload

@typing_extensions.final
class ArtifactStagingToRolePayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STAGED_NAME_FIELD_NUMBER: builtins.int
    staged_name: builtins.str
    """A generated staged name (relative path under staging directory)."""
    def __init__(
        self,
        *,
        staged_name: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["staged_name", b"staged_name"]) -> None: ...

global___ArtifactStagingToRolePayload = ArtifactStagingToRolePayload

@typing_extensions.final
class ArtifactInformation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_URN_FIELD_NUMBER: builtins.int
    TYPE_PAYLOAD_FIELD_NUMBER: builtins.int
    ROLE_URN_FIELD_NUMBER: builtins.int
    ROLE_PAYLOAD_FIELD_NUMBER: builtins.int
    type_urn: builtins.str
    """A URN that describes the type of artifact"""
    type_payload: builtins.bytes
    role_urn: builtins.str
    """A URN that describes the role of artifact"""
    role_payload: builtins.bytes
    def __init__(
        self,
        *,
        type_urn: builtins.str | None = ...,
        type_payload: builtins.bytes | None = ...,
        role_urn: builtins.str | None = ...,
        role_payload: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["role_payload", b"role_payload", "role_urn", b"role_urn", "type_payload", b"type_payload", "type_urn", b"type_urn"]) -> None: ...

global___ArtifactInformation = ArtifactInformation

@typing_extensions.final
class Environment(google.protobuf.message.Message):
    """An environment for executing UDFs. By default, an SDK container URL, but
    can also be a process forked by a command, or an externally managed process.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ResourceHintsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.bytes
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.bytes | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    URN_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    DISPLAY_DATA_FIELD_NUMBER: builtins.int
    CAPABILITIES_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    RESOURCE_HINTS_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """(Required) The URN of the payload"""
    payload: builtins.bytes
    """(Optional) The data specifying any parameters to the URN. If
    the URN does not require any arguments, this may be omitted.
    """
    @property
    def display_data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DisplayData]:
        """(Optional) Static display data for the environment. If there is none,
        it may be omitted.
        """
    @property
    def capabilities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """(Optional) A set of capabilities this environment supports. This is
        typically a list of common URNs designating coders, transforms, etc. that
        this environment understands (and a runner MAY use) despite not
        appearing in the pipeline proto. This may also be used to indicate
        support of optional protocols not tied to a concrete component.
        """
    @property
    def dependencies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ArtifactInformation]:
        """(Optional) artifact dependency information used for executing UDFs in this environment."""
    @property
    def resource_hints(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.bytes]:
        """(Optional) A mapping of resource URNs to requested values.  The encoding
        of the values is specified by the URN.  Resource hints are advisory;
        a runner is free to ignore resource hints that it does not understand.
        """
    def __init__(
        self,
        *,
        urn: builtins.str | None = ...,
        payload: builtins.bytes | None = ...,
        display_data: collections.abc.Iterable[global___DisplayData] | None = ...,
        capabilities: collections.abc.Iterable[builtins.str] | None = ...,
        dependencies: collections.abc.Iterable[global___ArtifactInformation] | None = ...,
        resource_hints: collections.abc.Mapping[builtins.str, builtins.bytes] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["capabilities", b"capabilities", "dependencies", b"dependencies", "display_data", b"display_data", "payload", b"payload", "resource_hints", b"resource_hints", "urn", b"urn"]) -> None: ...

global___Environment = Environment

@typing_extensions.final
class StandardEnvironments(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Environments:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnvironmentsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardEnvironments._Environments.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DOCKER: StandardEnvironments._Environments.ValueType  # 0
        """A managed docker container to run user code."""
        PROCESS: StandardEnvironments._Environments.ValueType  # 1
        """A managed native process to run user code."""
        EXTERNAL: StandardEnvironments._Environments.ValueType  # 2
        """An external non managed process to run user code."""
        DEFAULT: StandardEnvironments._Environments.ValueType  # 3
        """Used as a stub when context is missing a runner-provided default environment."""

    class Environments(_Environments, metaclass=_EnvironmentsEnumTypeWrapper): ...
    DOCKER: StandardEnvironments.Environments.ValueType  # 0
    """A managed docker container to run user code."""
    PROCESS: StandardEnvironments.Environments.ValueType  # 1
    """A managed native process to run user code."""
    EXTERNAL: StandardEnvironments.Environments.ValueType  # 2
    """An external non managed process to run user code."""
    DEFAULT: StandardEnvironments.Environments.ValueType  # 3
    """Used as a stub when context is missing a runner-provided default environment."""

    def __init__(
        self,
    ) -> None: ...

global___StandardEnvironments = StandardEnvironments

@typing_extensions.final
class DockerPayload(google.protobuf.message.Message):
    """The payload of a Docker image"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_IMAGE_FIELD_NUMBER: builtins.int
    container_image: builtins.str
    """implicitly linux_amd64."""
    def __init__(
        self,
        *,
        container_image: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["container_image", b"container_image"]) -> None: ...

global___DockerPayload = DockerPayload

@typing_extensions.final
class ProcessPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class EnvEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    OS_FIELD_NUMBER: builtins.int
    ARCH_FIELD_NUMBER: builtins.int
    COMMAND_FIELD_NUMBER: builtins.int
    ENV_FIELD_NUMBER: builtins.int
    os: builtins.str
    """"linux", "darwin", .."""
    arch: builtins.str
    """"amd64", .."""
    command: builtins.str
    """process to execute"""
    @property
    def env(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Environment variables"""
    def __init__(
        self,
        *,
        os: builtins.str | None = ...,
        arch: builtins.str | None = ...,
        command: builtins.str | None = ...,
        env: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["arch", b"arch", "command", b"command", "env", b"env", "os", b"os"]) -> None: ...

global___ProcessPayload = ProcessPayload

@typing_extensions.final
class ExternalPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ParamsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENDPOINT_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def endpoint(self) -> org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor: ...
    @property
    def params(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Arbitrary extra parameters to pass"""
    def __init__(
        self,
        *,
        endpoint: org.apache.beam.model.pipeline.v1.endpoints_pb2.ApiServiceDescriptor | None = ...,
        params: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["endpoint", b"endpoint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["endpoint", b"endpoint", "params", b"params"]) -> None: ...

global___ExternalPayload = ExternalPayload

@typing_extensions.final
class StandardProtocols(google.protobuf.message.Message):
    """These URNs are used to indicate capabilities of environments that cannot
    simply be expressed as a component (such as a Coder or PTransform) that this
    environment understands.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardProtocols._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LEGACY_PROGRESS_REPORTING: StandardProtocols._Enum.ValueType  # 0
        """Indicates suport for progress reporting via the legacy Metrics proto."""
        PROGRESS_REPORTING: StandardProtocols._Enum.ValueType  # 1
        """Indicates suport for progress reporting via the new MonitoringInfo proto."""
        WORKER_STATUS: StandardProtocols._Enum.ValueType  # 2
        """Indicates suport for worker status protocol defined at
        https://s.apache.org/beam-fn-api-harness-status.
        """
        MULTI_CORE_BUNDLE_PROCESSING: StandardProtocols._Enum.ValueType  # 3
        """Indicates this SDK can take advantage of multiple cores when processing
        concurrent process bundle requests. (Note that all SDKs must process
        an unbounded number of concurrent process bundle requests; this capability
        simply indicates this SDK can actually parallelize the work across multiple
        cores.
        """
        SIBLING_WORKERS: StandardProtocols._Enum.ValueType  # 5
        """Indicates this SDK can cheaply spawn sibling workers (e.g. within the
        same container) to work around the fact that it cannot take advantage
        of multiple cores (i.e. MULTI_CORE_BUNDLE_PROCESSING is not set).
        """
        HARNESS_MONITORING_INFOS: StandardProtocols._Enum.ValueType  # 4
        """Indicates that this SDK handles the InstructionRequest of type
        HarnessMonitoringInfosRequest.
        A request to provide full MonitoringInfo data associated with
        the entire SDK harness process, not specific to a bundle.
        """
        CONTROL_REQUEST_ELEMENTS_EMBEDDING: StandardProtocols._Enum.ValueType  # 6
        """Indicates that this SDK can process elements embedded in the
        ProcessBundleRequest. See more about the protocol at
        https://s.apache.org/beam-fn-api-control-data-embedding
        """
        STATE_CACHING: StandardProtocols._Enum.ValueType  # 7
        """Indicates that this SDK can cache user state and side inputs across
        bundle boundaries. This is a hint to runners that runners can rely on the
        SDKs ability to store the data in memory reducing the amount of memory
        used overall.
        """
        DATA_SAMPLING: StandardProtocols._Enum.ValueType  # 8
        """Indicates that this SDK can sample in-flight elements. These samples can
        then be queried using the SampleDataRequest. Samples are uniquely associated
        with a PCollection. Meaning, samples are taken for each PCollection
        during bundle processing. This is disabled by default and enabled with the
        `enable_data_sampling` experiment.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    LEGACY_PROGRESS_REPORTING: StandardProtocols.Enum.ValueType  # 0
    """Indicates suport for progress reporting via the legacy Metrics proto."""
    PROGRESS_REPORTING: StandardProtocols.Enum.ValueType  # 1
    """Indicates suport for progress reporting via the new MonitoringInfo proto."""
    WORKER_STATUS: StandardProtocols.Enum.ValueType  # 2
    """Indicates suport for worker status protocol defined at
    https://s.apache.org/beam-fn-api-harness-status.
    """
    MULTI_CORE_BUNDLE_PROCESSING: StandardProtocols.Enum.ValueType  # 3
    """Indicates this SDK can take advantage of multiple cores when processing
    concurrent process bundle requests. (Note that all SDKs must process
    an unbounded number of concurrent process bundle requests; this capability
    simply indicates this SDK can actually parallelize the work across multiple
    cores.
    """
    SIBLING_WORKERS: StandardProtocols.Enum.ValueType  # 5
    """Indicates this SDK can cheaply spawn sibling workers (e.g. within the
    same container) to work around the fact that it cannot take advantage
    of multiple cores (i.e. MULTI_CORE_BUNDLE_PROCESSING is not set).
    """
    HARNESS_MONITORING_INFOS: StandardProtocols.Enum.ValueType  # 4
    """Indicates that this SDK handles the InstructionRequest of type
    HarnessMonitoringInfosRequest.
    A request to provide full MonitoringInfo data associated with
    the entire SDK harness process, not specific to a bundle.
    """
    CONTROL_REQUEST_ELEMENTS_EMBEDDING: StandardProtocols.Enum.ValueType  # 6
    """Indicates that this SDK can process elements embedded in the
    ProcessBundleRequest. See more about the protocol at
    https://s.apache.org/beam-fn-api-control-data-embedding
    """
    STATE_CACHING: StandardProtocols.Enum.ValueType  # 7
    """Indicates that this SDK can cache user state and side inputs across
    bundle boundaries. This is a hint to runners that runners can rely on the
    SDKs ability to store the data in memory reducing the amount of memory
    used overall.
    """
    DATA_SAMPLING: StandardProtocols.Enum.ValueType  # 8
    """Indicates that this SDK can sample in-flight elements. These samples can
    then be queried using the SampleDataRequest. Samples are uniquely associated
    with a PCollection. Meaning, samples are taken for each PCollection
    during bundle processing. This is disabled by default and enabled with the
    `enable_data_sampling` experiment.
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardProtocols = StandardProtocols

@typing_extensions.final
class StandardRunnerProtocols(google.protobuf.message.Message):
    """These URNs are used to indicate capabilities of runner that an environment
    may take advantage of when interacting with this runner.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardRunnerProtocols._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MONITORING_INFO_SHORT_IDS: StandardRunnerProtocols._Enum.ValueType  # 0
        """Indicates suport the MonitoringInfo short id protocol."""
        CONTROL_RESPONSE_ELEMENTS_EMBEDDING: StandardRunnerProtocols._Enum.ValueType  # 6
        """Indicates that this runner can process elements embedded in the
        ProcessBundleResponse. See more about the protocol at
        https://s.apache.org/beam-fn-api-control-data-embedding
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    MONITORING_INFO_SHORT_IDS: StandardRunnerProtocols.Enum.ValueType  # 0
    """Indicates suport the MonitoringInfo short id protocol."""
    CONTROL_RESPONSE_ELEMENTS_EMBEDDING: StandardRunnerProtocols.Enum.ValueType  # 6
    """Indicates that this runner can process elements embedded in the
    ProcessBundleResponse. See more about the protocol at
    https://s.apache.org/beam-fn-api-control-data-embedding
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardRunnerProtocols = StandardRunnerProtocols

@typing_extensions.final
class StandardRequirements(google.protobuf.message.Message):
    """These URNs are used to indicate requirements of a pipeline that cannot
    simply be expressed as a component (such as a Coder or PTransform) that the
    runner must understand. In many cases, this indicates a particular field
    of a transform must be inspected and respected (which allows new fields
    to be added in a forwards-compatible way).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardRequirements._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        REQUIRES_STATEFUL_PROCESSING: StandardRequirements._Enum.ValueType  # 0
        """This requirement indicates the state_specs and timer_family_specs fields of ParDo
        transform payloads must be inspected.
        """
        REQUIRES_BUNDLE_FINALIZATION: StandardRequirements._Enum.ValueType  # 1
        """This requirement indicates the requests_finalization field of ParDo
        transform payloads must be inspected.
        """
        REQUIRES_STABLE_INPUT: StandardRequirements._Enum.ValueType  # 2
        """This requirement indicates the requires_stable_input field of ParDo
        transform payloads must be inspected.
        """
        REQUIRES_TIME_SORTED_INPUT: StandardRequirements._Enum.ValueType  # 3
        """This requirement indicates the requires_time_sorted_input field of ParDo
        transform payloads must be inspected.
        """
        REQUIRES_SPLITTABLE_DOFN: StandardRequirements._Enum.ValueType  # 4
        """This requirement indicates the restriction_coder_id field of ParDo
        transform payloads must be inspected.
        """
        REQUIRES_ON_WINDOW_EXPIRATION: StandardRequirements._Enum.ValueType  # 5
        """This requirement indicates that the on_window_expiration_timer_family_spec field
        of ParDo transform payloads must be inspected.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    REQUIRES_STATEFUL_PROCESSING: StandardRequirements.Enum.ValueType  # 0
    """This requirement indicates the state_specs and timer_family_specs fields of ParDo
    transform payloads must be inspected.
    """
    REQUIRES_BUNDLE_FINALIZATION: StandardRequirements.Enum.ValueType  # 1
    """This requirement indicates the requests_finalization field of ParDo
    transform payloads must be inspected.
    """
    REQUIRES_STABLE_INPUT: StandardRequirements.Enum.ValueType  # 2
    """This requirement indicates the requires_stable_input field of ParDo
    transform payloads must be inspected.
    """
    REQUIRES_TIME_SORTED_INPUT: StandardRequirements.Enum.ValueType  # 3
    """This requirement indicates the requires_time_sorted_input field of ParDo
    transform payloads must be inspected.
    """
    REQUIRES_SPLITTABLE_DOFN: StandardRequirements.Enum.ValueType  # 4
    """This requirement indicates the restriction_coder_id field of ParDo
    transform payloads must be inspected.
    """
    REQUIRES_ON_WINDOW_EXPIRATION: StandardRequirements.Enum.ValueType  # 5
    """This requirement indicates that the on_window_expiration_timer_family_spec field
    of ParDo transform payloads must be inspected.
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardRequirements = StandardRequirements

@typing_extensions.final
class FunctionSpec(google.protobuf.message.Message):
    """A URN along with a parameter object whose schema is determined by the
    URN.

    This structure is reused in two distinct, but compatible, ways:

    1. This can be a specification of the function over PCollections
       that a PTransform computes.
    2. This can be a specification of a user-defined function, possibly
       SDK-specific. (external to this message must be adequate context
       to indicate the environment in which the UDF can be understood).

    Though not explicit in this proto, there are two possibilities
    for the relationship of a runner to this specification that
    one should bear in mind:

    1. The runner understands the URN. For example, it might be
       a well-known URN like "beam:transform:Top" or
       "beam:window_fn:FixedWindows" with
       an agreed-upon payload (e.g. a number or duration,
       respectively).
    2. The runner does not understand the URN. It might be an
       SDK specific URN such as "beam:dofn:javasdk:1.0"
       that indicates to the SDK what the payload is,
       such as a serialized Java DoFn from a particular
       version of the Beam Java SDK. The payload will often
       then be an opaque message such as bytes in a
       language-specific serialization format.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URN_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """(Required) A URN that describes the accompanying payload.
    For any URN that is not recognized (by whomever is inspecting
    it) the parameter payload should be treated as opaque and
    passed as-is.
    """
    payload: builtins.bytes
    """(Optional) The data specifying any parameters to the URN. If
    the URN does not require any arguments, this may be omitted.
    """
    def __init__(
        self,
        *,
        urn: builtins.str | None = ...,
        payload: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["payload", b"payload", "urn", b"urn"]) -> None: ...

global___FunctionSpec = FunctionSpec

@typing_extensions.final
class StandardDisplayData(google.protobuf.message.Message):
    """A set of well known URNs describing display data.

    All descriptions must contain how the value should be classified and how it
    is encoded. Note that some types are logical types which convey contextual
    information about the pipeline in addition to an encoding while others only
    specify the encoding itself.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DisplayData:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DisplayDataEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardDisplayData._DisplayData.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LABELLED: StandardDisplayData._DisplayData.ValueType  # 0
        """A string label and value. Has a payload containing an encoded
        LabelledPayload.
        """

    class DisplayData(_DisplayData, metaclass=_DisplayDataEnumTypeWrapper): ...
    LABELLED: StandardDisplayData.DisplayData.ValueType  # 0
    """A string label and value. Has a payload containing an encoded
    LabelledPayload.
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardDisplayData = StandardDisplayData

@typing_extensions.final
class LabelledPayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LABEL_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    BOOL_VALUE_FIELD_NUMBER: builtins.int
    DOUBLE_VALUE_FIELD_NUMBER: builtins.int
    INT_VALUE_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    label: builtins.str
    """(Required) A human readable label for the value."""
    string_value: builtins.str
    bool_value: builtins.bool
    double_value: builtins.float
    int_value: builtins.int
    key: builtins.str
    """(Required) The key identifies the actual content of the metadata."""
    namespace: builtins.str
    """(Required) The namespace describes the context that specified the key."""
    def __init__(
        self,
        *,
        label: builtins.str | None = ...,
        string_value: builtins.str | None = ...,
        bool_value: builtins.bool | None = ...,
        double_value: builtins.float | None = ...,
        int_value: builtins.int | None = ...,
        key: builtins.str | None = ...,
        namespace: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bool_value", b"bool_value", "double_value", b"double_value", "int_value", b"int_value", "string_value", b"string_value", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bool_value", b"bool_value", "double_value", b"double_value", "int_value", b"int_value", "key", b"key", "label", b"label", "namespace", b"namespace", "string_value", b"string_value", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["string_value", "bool_value", "double_value", "int_value"] | None: ...

global___LabelledPayload = LabelledPayload

@typing_extensions.final
class DisplayData(google.protobuf.message.Message):
    """Static display data associated with a pipeline component. Display data is
    useful for pipeline runners IOs and diagnostic dashboards to display details
    about annotated components.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URN_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """A key used to describe the type of display data. See StandardDisplayData
    for the set of well known urns describing how the payload is meant to be
    interpreted.
    """
    payload: builtins.bytes
    """(Optional) The data specifying any parameters to the URN. If
    the URN does not require any arguments, this may be omitted.
    """
    def __init__(
        self,
        *,
        urn: builtins.str | None = ...,
        payload: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["payload", b"payload", "urn", b"urn"]) -> None: ...

global___DisplayData = DisplayData

@typing_extensions.final
class MessageWithComponents(google.protobuf.message.Message):
    """The following transforms are not part of the RunnerApi specification,
    but may be useful for graph construction and manipulation.

    A disjoint union of all the things that may contain references
    that require Components to resolve.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENTS_FIELD_NUMBER: builtins.int
    CODER_FIELD_NUMBER: builtins.int
    COMBINE_PAYLOAD_FIELD_NUMBER: builtins.int
    FUNCTION_SPEC_FIELD_NUMBER: builtins.int
    PAR_DO_PAYLOAD_FIELD_NUMBER: builtins.int
    PTRANSFORM_FIELD_NUMBER: builtins.int
    PCOLLECTION_FIELD_NUMBER: builtins.int
    READ_PAYLOAD_FIELD_NUMBER: builtins.int
    SIDE_INPUT_FIELD_NUMBER: builtins.int
    WINDOW_INTO_PAYLOAD_FIELD_NUMBER: builtins.int
    WINDOWING_STRATEGY_FIELD_NUMBER: builtins.int
    @property
    def components(self) -> global___Components:
        """(Optional) The by-reference components of the root message,
        enabling a standalone message.

        If this is absent, it is expected that there are no
        references.
        """
    @property
    def coder(self) -> global___Coder: ...
    @property
    def combine_payload(self) -> global___CombinePayload: ...
    @property
    def function_spec(self) -> global___FunctionSpec: ...
    @property
    def par_do_payload(self) -> global___ParDoPayload: ...
    @property
    def ptransform(self) -> global___PTransform: ...
    @property
    def pcollection(self) -> global___PCollection: ...
    @property
    def read_payload(self) -> global___ReadPayload: ...
    @property
    def side_input(self) -> global___SideInput: ...
    @property
    def window_into_payload(self) -> global___WindowIntoPayload: ...
    @property
    def windowing_strategy(self) -> global___WindowingStrategy: ...
    def __init__(
        self,
        *,
        components: global___Components | None = ...,
        coder: global___Coder | None = ...,
        combine_payload: global___CombinePayload | None = ...,
        function_spec: global___FunctionSpec | None = ...,
        par_do_payload: global___ParDoPayload | None = ...,
        ptransform: global___PTransform | None = ...,
        pcollection: global___PCollection | None = ...,
        read_payload: global___ReadPayload | None = ...,
        side_input: global___SideInput | None = ...,
        window_into_payload: global___WindowIntoPayload | None = ...,
        windowing_strategy: global___WindowingStrategy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["coder", b"coder", "combine_payload", b"combine_payload", "components", b"components", "function_spec", b"function_spec", "par_do_payload", b"par_do_payload", "pcollection", b"pcollection", "ptransform", b"ptransform", "read_payload", b"read_payload", "root", b"root", "side_input", b"side_input", "window_into_payload", b"window_into_payload", "windowing_strategy", b"windowing_strategy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["coder", b"coder", "combine_payload", b"combine_payload", "components", b"components", "function_spec", b"function_spec", "par_do_payload", b"par_do_payload", "pcollection", b"pcollection", "ptransform", b"ptransform", "read_payload", b"read_payload", "root", b"root", "side_input", b"side_input", "window_into_payload", b"window_into_payload", "windowing_strategy", b"windowing_strategy"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["root", b"root"]) -> typing_extensions.Literal["coder", "combine_payload", "function_spec", "par_do_payload", "ptransform", "pcollection", "read_payload", "side_input", "window_into_payload", "windowing_strategy"] | None: ...

global___MessageWithComponents = MessageWithComponents

@typing_extensions.final
class ExecutableStagePayload(google.protobuf.message.Message):
    """The payload for an executable stage. This will eventually be passed to an SDK in the form of a
    ProcessBundleDescriptor.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SideInputId(google.protobuf.message.Message):
        """A reference to a side input. Side inputs are uniquely identified by PTransform id and
        local name.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        LOCAL_NAME_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform that references this side input."""
        local_name: builtins.str
        """(Required) The local name of this side input from the PTransform that references it."""
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            local_name: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["local_name", b"local_name", "transform_id", b"transform_id"]) -> None: ...

    @typing_extensions.final
    class UserStateId(google.protobuf.message.Message):
        """A reference to user state. User states are uniquely identified by PTransform id and
        local name.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        LOCAL_NAME_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform that references this user state."""
        local_name: builtins.str
        """(Required) The local name of this user state for the PTransform that references it."""
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            local_name: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["local_name", b"local_name", "transform_id", b"transform_id"]) -> None: ...

    @typing_extensions.final
    class TimerId(google.protobuf.message.Message):
        """A reference to a timer. Timers are uniquely identified by PTransform id and
        local name.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        LOCAL_NAME_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform that references this timer."""
        local_name: builtins.str
        """(Required) The local name of this timer for the PTransform that references it."""
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            local_name: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["local_name", b"local_name", "transform_id", b"transform_id"]) -> None: ...

    @typing_extensions.final
    class TimerFamilyId(google.protobuf.message.Message):
        """A reference to a timer. Timers are uniquely identified by PTransform id and
        local name.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRANSFORM_ID_FIELD_NUMBER: builtins.int
        LOCAL_NAME_FIELD_NUMBER: builtins.int
        transform_id: builtins.str
        """(Required) The id of the PTransform that references this timer family."""
        local_name: builtins.str
        """(Required) The local name of this timer family for the PTransform that references it."""
        def __init__(
            self,
            *,
            transform_id: builtins.str | None = ...,
            local_name: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["local_name", b"local_name", "transform_id", b"transform_id"]) -> None: ...

    @typing_extensions.final
    class WireCoderSetting(google.protobuf.message.Message):
        """Settings that decide the coder type of wire coder."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URN_FIELD_NUMBER: builtins.int
        PAYLOAD_FIELD_NUMBER: builtins.int
        INPUT_OR_OUTPUT_ID_FIELD_NUMBER: builtins.int
        TIMER_FIELD_NUMBER: builtins.int
        urn: builtins.str
        """(Required) The URN of the wire coder.
        Note that only windowed value coder or parameterized windowed value coder are supported.
        """
        payload: builtins.bytes
        """(Optional) The data specifying any parameters to the URN. If
        the URN is beam:coder:windowed_value:v1, this may be omitted. If the URN is
        beam:coder:param_windowed_value:v1, the payload is an encoded windowed
        value using the beam:coder:windowed_value:v1 coder parameterized by
        a beam:coder:bytes:v1 element coder and the window coder that this
        param_windowed_value coder uses.
        """
        input_or_output_id: builtins.str
        """The input or output PCollection id this setting applies to."""
        @property
        def timer(self) -> global___ExecutableStagePayload.TimerId:
            """The timer id this setting applies to."""
        def __init__(
            self,
            *,
            urn: builtins.str | None = ...,
            payload: builtins.bytes | None = ...,
            input_or_output_id: builtins.str | None = ...,
            timer: global___ExecutableStagePayload.TimerId | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["input_or_output_id", b"input_or_output_id", "target", b"target", "timer", b"timer"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["input_or_output_id", b"input_or_output_id", "payload", b"payload", "target", b"target", "timer", b"timer", "urn", b"urn"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["target", b"target"]) -> typing_extensions.Literal["input_or_output_id", "timer"] | None: ...

    ENVIRONMENT_FIELD_NUMBER: builtins.int
    WIRE_CODER_SETTINGS_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    SIDE_INPUTS_FIELD_NUMBER: builtins.int
    TRANSFORMS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    COMPONENTS_FIELD_NUMBER: builtins.int
    USER_STATES_FIELD_NUMBER: builtins.int
    TIMERS_FIELD_NUMBER: builtins.int
    TIMERFAMILIES_FIELD_NUMBER: builtins.int
    @property
    def environment(self) -> global___Environment:
        """(Required) Environment in which this stage executes.

        We use an environment rather than environment id
        because ExecutableStages use environments directly. This may change in the future.
        """
    @property
    def wire_coder_settings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExecutableStagePayload.WireCoderSetting]:
        """The wire coder settings of this executable stage"""
    input: builtins.str
    """(Required) Input PCollection id. This must be present as a value in the inputs of any
    PTransform the ExecutableStagePayload is the payload of.
    """
    @property
    def side_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExecutableStagePayload.SideInputId]:
        """The side inputs required for this executable stage. Each side input of each PTransform within
        this ExecutableStagePayload must be represented within this field.
        """
    @property
    def transforms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """PTransform ids contained within this executable stage. This must contain at least one
        PTransform id.
        """
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Output PCollection ids. This must be equal to the values of the outputs of any
        PTransform the ExecutableStagePayload is the payload of.
        """
    @property
    def components(self) -> global___Components:
        """(Required) The components for the Executable Stage. This must contain all of the Transforms
        in transforms, and the closure of all of the components they recognize.
        """
    @property
    def user_states(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExecutableStagePayload.UserStateId]:
        """The user states required for this executable stage. Each user state of each PTransform within
        this ExecutableStagePayload must be represented within this field.
        """
    @property
    def timers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExecutableStagePayload.TimerId]:
        """The timers required for this executable stage. Each timer of each PTransform within
        this ExecutableStagePayload must be represented within this field.
        """
    @property
    def timerFamilies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExecutableStagePayload.TimerFamilyId]:
        """The timerfamilies required for this executable stage. Each timer familyof each PTransform within
        this ExecutableStagePayload must be represented within this field.
        """
    def __init__(
        self,
        *,
        environment: global___Environment | None = ...,
        wire_coder_settings: collections.abc.Iterable[global___ExecutableStagePayload.WireCoderSetting] | None = ...,
        input: builtins.str | None = ...,
        side_inputs: collections.abc.Iterable[global___ExecutableStagePayload.SideInputId] | None = ...,
        transforms: collections.abc.Iterable[builtins.str] | None = ...,
        outputs: collections.abc.Iterable[builtins.str] | None = ...,
        components: global___Components | None = ...,
        user_states: collections.abc.Iterable[global___ExecutableStagePayload.UserStateId] | None = ...,
        timers: collections.abc.Iterable[global___ExecutableStagePayload.TimerId] | None = ...,
        timerFamilies: collections.abc.Iterable[global___ExecutableStagePayload.TimerFamilyId] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["components", b"components", "environment", b"environment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "environment", b"environment", "input", b"input", "outputs", b"outputs", "side_inputs", b"side_inputs", "timerFamilies", b"timerFamilies", "timers", b"timers", "transforms", b"transforms", "user_states", b"user_states", "wire_coder_settings", b"wire_coder_settings"]) -> None: ...

global___ExecutableStagePayload = ExecutableStagePayload

@typing_extensions.final
class StandardResourceHints(google.protobuf.message.Message):
    """See https://beam.apache.org/documentation/runtime/resource-hints/ for additional documentation
    on the behavior of StandardResourceHint.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Enum:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnumEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StandardResourceHints._Enum.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ACCELERATOR: StandardResourceHints._Enum.ValueType  # 0
        """Describes hardware accelerators that are desired to have in the execution environment.
        Payload: ASCII encoded string with the following format: "type:<type>;count:<n>;<options>" where type
        is an accelerator sku, count is the number of accelerators per worker, and options are
        related options flags.
        """
        MIN_RAM_BYTES: StandardResourceHints._Enum.ValueType  # 1
        """Describes desired minimal available RAM size in transform's execution environment.
        SDKs should convert the size to bytes, but can allow users to specify human-friendly units (e.g. GiB).
        Payload: ASCII encoded string of the base 10 representation of an integer number of bytes.
        """

    class Enum(_Enum, metaclass=_EnumEnumTypeWrapper): ...
    ACCELERATOR: StandardResourceHints.Enum.ValueType  # 0
    """Describes hardware accelerators that are desired to have in the execution environment.
    Payload: ASCII encoded string with the following format: "type:<type>;count:<n>;<options>" where type
    is an accelerator sku, count is the number of accelerators per worker, and options are
    related options flags.
    """
    MIN_RAM_BYTES: StandardResourceHints.Enum.ValueType  # 1
    """Describes desired minimal available RAM size in transform's execution environment.
    SDKs should convert the size to bytes, but can allow users to specify human-friendly units (e.g. GiB).
    Payload: ASCII encoded string of the base 10 representation of an integer number of bytes.
    """

    def __init__(
        self,
    ) -> None: ...

global___StandardResourceHints = StandardResourceHints

BEAM_URN_FIELD_NUMBER: builtins.int
BEAM_CONSTANT_FIELD_NUMBER: builtins.int
beam_urn: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.EnumValueOptions, builtins.str]
"""An extension to be used for specifying the standard URN of various
pipeline entities, e.g. transforms, functions, coders etc.
Code should refer to the URNs of those entities by extracting
it from the (beam_urn) extension, rather than by hard-coding
the URN.

The recommended pattern for declaring it is (exemplified by coders):

message StandardCoders {
  enum Enum {
    BYTES = 0 [(beam_urn) = "beam:coder:bytes:v1"];
    ...
  }
}

If there are multiple categories of entities of this type, use the
following pattern (exemplified by PTransforms):

message StandardPTransforms {
  enum Primitives {
    ...
  }
  enum Composites {
    ...
  }
}
"""
beam_constant: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.EnumValueOptions, builtins.str]
"""A value to store other constants"""
