//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.1.0
// - protoc             v4.24.0--rc1
// source: org/apache/beam/model/job_management/v1/beam_artifact_api.proto

package jobmanagement_v1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// ArtifactRetrievalServiceClient is the client API for ArtifactRetrievalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ArtifactRetrievalServiceClient interface {
	// Resolves the given artifact references into one or more replacement
	// artifact references (e.g. a Maven dependency into a (transitive) set
	// of jars.
	ResolveArtifacts(ctx context.Context, in *ResolveArtifactsRequest, opts ...grpc.CallOption) (*ResolveArtifactsResponse, error)
	// Retrieves the given artifact as a stream of bytes.
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error)
}

type artifactRetrievalServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewArtifactRetrievalServiceClient(cc grpc.ClientConnInterface) ArtifactRetrievalServiceClient {
	return &artifactRetrievalServiceClient{cc}
}

func (c *artifactRetrievalServiceClient) ResolveArtifacts(ctx context.Context, in *ResolveArtifactsRequest, opts ...grpc.CallOption) (*ResolveArtifactsResponse, error) {
	out := new(ResolveArtifactsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/ResolveArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRetrievalServiceClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &ArtifactRetrievalService_ServiceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactRetrievalServiceGetArtifactClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArtifactRetrievalService_GetArtifactClient interface {
	Recv() (*GetArtifactResponse, error)
	grpc.ClientStream
}

type artifactRetrievalServiceGetArtifactClient struct {
	grpc.ClientStream
}

func (x *artifactRetrievalServiceGetArtifactClient) Recv() (*GetArtifactResponse, error) {
	m := new(GetArtifactResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ArtifactRetrievalServiceServer is the server API for ArtifactRetrievalService service.
// All implementations must embed UnimplementedArtifactRetrievalServiceServer
// for forward compatibility
type ArtifactRetrievalServiceServer interface {
	// Resolves the given artifact references into one or more replacement
	// artifact references (e.g. a Maven dependency into a (transitive) set
	// of jars.
	ResolveArtifacts(context.Context, *ResolveArtifactsRequest) (*ResolveArtifactsResponse, error)
	// Retrieves the given artifact as a stream of bytes.
	GetArtifact(*GetArtifactRequest, ArtifactRetrievalService_GetArtifactServer) error
	mustEmbedUnimplementedArtifactRetrievalServiceServer()
}

// UnimplementedArtifactRetrievalServiceServer must be embedded to have forward compatible implementations.
type UnimplementedArtifactRetrievalServiceServer struct {
}

func (UnimplementedArtifactRetrievalServiceServer) ResolveArtifacts(context.Context, *ResolveArtifactsRequest) (*ResolveArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveArtifacts not implemented")
}
func (UnimplementedArtifactRetrievalServiceServer) GetArtifact(*GetArtifactRequest, ArtifactRetrievalService_GetArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}
func (UnimplementedArtifactRetrievalServiceServer) mustEmbedUnimplementedArtifactRetrievalServiceServer() {
}

// UnsafeArtifactRetrievalServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ArtifactRetrievalServiceServer will
// result in compilation errors.
type UnsafeArtifactRetrievalServiceServer interface {
	mustEmbedUnimplementedArtifactRetrievalServiceServer()
}

func RegisterArtifactRetrievalServiceServer(s grpc.ServiceRegistrar, srv ArtifactRetrievalServiceServer) {
	s.RegisterService(&ArtifactRetrievalService_ServiceDesc, srv)
}

func _ArtifactRetrievalService_ResolveArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRetrievalServiceServer).ResolveArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/ResolveArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRetrievalServiceServer).ResolveArtifacts(ctx, req.(*ResolveArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRetrievalService_GetArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetArtifactRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArtifactRetrievalServiceServer).GetArtifact(m, &artifactRetrievalServiceGetArtifactServer{stream})
}

type ArtifactRetrievalService_GetArtifactServer interface {
	Send(*GetArtifactResponse) error
	grpc.ServerStream
}

type artifactRetrievalServiceGetArtifactServer struct {
	grpc.ServerStream
}

func (x *artifactRetrievalServiceGetArtifactServer) Send(m *GetArtifactResponse) error {
	return x.ServerStream.SendMsg(m)
}

// ArtifactRetrievalService_ServiceDesc is the grpc.ServiceDesc for ArtifactRetrievalService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ArtifactRetrievalService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactRetrievalService",
	HandlerType: (*ArtifactRetrievalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ResolveArtifacts",
			Handler:    _ArtifactRetrievalService_ResolveArtifacts_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetArtifact",
			Handler:       _ArtifactRetrievalService_GetArtifact_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/job_management/v1/beam_artifact_api.proto",
}

// ArtifactStagingServiceClient is the client API for ArtifactStagingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ArtifactStagingServiceClient interface {
	ReverseArtifactRetrievalService(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_ReverseArtifactRetrievalServiceClient, error)
}

type artifactStagingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewArtifactStagingServiceClient(cc grpc.ClientConnInterface) ArtifactStagingServiceClient {
	return &artifactStagingServiceClient{cc}
}

func (c *artifactStagingServiceClient) ReverseArtifactRetrievalService(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_ReverseArtifactRetrievalServiceClient, error) {
	stream, err := c.cc.NewStream(ctx, &ArtifactStagingService_ServiceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.ArtifactStagingService/ReverseArtifactRetrievalService", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactStagingServiceReverseArtifactRetrievalServiceClient{stream}
	return x, nil
}

type ArtifactStagingService_ReverseArtifactRetrievalServiceClient interface {
	Send(*ArtifactResponseWrapper) error
	Recv() (*ArtifactRequestWrapper, error)
	grpc.ClientStream
}

type artifactStagingServiceReverseArtifactRetrievalServiceClient struct {
	grpc.ClientStream
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceClient) Send(m *ArtifactResponseWrapper) error {
	return x.ClientStream.SendMsg(m)
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceClient) Recv() (*ArtifactRequestWrapper, error) {
	m := new(ArtifactRequestWrapper)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ArtifactStagingServiceServer is the server API for ArtifactStagingService service.
// All implementations must embed UnimplementedArtifactStagingServiceServer
// for forward compatibility
type ArtifactStagingServiceServer interface {
	ReverseArtifactRetrievalService(ArtifactStagingService_ReverseArtifactRetrievalServiceServer) error
	mustEmbedUnimplementedArtifactStagingServiceServer()
}

// UnimplementedArtifactStagingServiceServer must be embedded to have forward compatible implementations.
type UnimplementedArtifactStagingServiceServer struct {
}

func (UnimplementedArtifactStagingServiceServer) ReverseArtifactRetrievalService(ArtifactStagingService_ReverseArtifactRetrievalServiceServer) error {
	return status.Errorf(codes.Unimplemented, "method ReverseArtifactRetrievalService not implemented")
}
func (UnimplementedArtifactStagingServiceServer) mustEmbedUnimplementedArtifactStagingServiceServer() {
}

// UnsafeArtifactStagingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ArtifactStagingServiceServer will
// result in compilation errors.
type UnsafeArtifactStagingServiceServer interface {
	mustEmbedUnimplementedArtifactStagingServiceServer()
}

func RegisterArtifactStagingServiceServer(s grpc.ServiceRegistrar, srv ArtifactStagingServiceServer) {
	s.RegisterService(&ArtifactStagingService_ServiceDesc, srv)
}

func _ArtifactStagingService_ReverseArtifactRetrievalService_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArtifactStagingServiceServer).ReverseArtifactRetrievalService(&artifactStagingServiceReverseArtifactRetrievalServiceServer{stream})
}

type ArtifactStagingService_ReverseArtifactRetrievalServiceServer interface {
	Send(*ArtifactRequestWrapper) error
	Recv() (*ArtifactResponseWrapper, error)
	grpc.ServerStream
}

type artifactStagingServiceReverseArtifactRetrievalServiceServer struct {
	grpc.ServerStream
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceServer) Send(m *ArtifactRequestWrapper) error {
	return x.ServerStream.SendMsg(m)
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceServer) Recv() (*ArtifactResponseWrapper, error) {
	m := new(ArtifactResponseWrapper)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ArtifactStagingService_ServiceDesc is the grpc.ServiceDesc for ArtifactStagingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ArtifactStagingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactStagingService",
	HandlerType: (*ArtifactStagingServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReverseArtifactRetrievalService",
			Handler:       _ArtifactStagingService_ReverseArtifactRetrievalService_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/job_management/v1/beam_artifact_api.proto",
}

// LegacyArtifactStagingServiceClient is the client API for LegacyArtifactStagingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LegacyArtifactStagingServiceClient interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(ctx context.Context, opts ...grpc.CallOption) (LegacyArtifactStagingService_PutArtifactClient, error)
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error)
}

type legacyArtifactStagingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLegacyArtifactStagingServiceClient(cc grpc.ClientConnInterface) LegacyArtifactStagingServiceClient {
	return &legacyArtifactStagingServiceClient{cc}
}

func (c *legacyArtifactStagingServiceClient) PutArtifact(ctx context.Context, opts ...grpc.CallOption) (LegacyArtifactStagingService_PutArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &LegacyArtifactStagingService_ServiceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.LegacyArtifactStagingService/PutArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &legacyArtifactStagingServicePutArtifactClient{stream}
	return x, nil
}

type LegacyArtifactStagingService_PutArtifactClient interface {
	Send(*PutArtifactRequest) error
	CloseAndRecv() (*PutArtifactResponse, error)
	grpc.ClientStream
}

type legacyArtifactStagingServicePutArtifactClient struct {
	grpc.ClientStream
}

func (x *legacyArtifactStagingServicePutArtifactClient) Send(m *PutArtifactRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *legacyArtifactStagingServicePutArtifactClient) CloseAndRecv() (*PutArtifactResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(PutArtifactResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *legacyArtifactStagingServiceClient) CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error) {
	out := new(CommitManifestResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.LegacyArtifactStagingService/CommitManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LegacyArtifactStagingServiceServer is the server API for LegacyArtifactStagingService service.
// All implementations must embed UnimplementedLegacyArtifactStagingServiceServer
// for forward compatibility
type LegacyArtifactStagingServiceServer interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(LegacyArtifactStagingService_PutArtifactServer) error
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(context.Context, *CommitManifestRequest) (*CommitManifestResponse, error)
	mustEmbedUnimplementedLegacyArtifactStagingServiceServer()
}

// UnimplementedLegacyArtifactStagingServiceServer must be embedded to have forward compatible implementations.
type UnimplementedLegacyArtifactStagingServiceServer struct {
}

func (UnimplementedLegacyArtifactStagingServiceServer) PutArtifact(LegacyArtifactStagingService_PutArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method PutArtifact not implemented")
}
func (UnimplementedLegacyArtifactStagingServiceServer) CommitManifest(context.Context, *CommitManifestRequest) (*CommitManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitManifest not implemented")
}
func (UnimplementedLegacyArtifactStagingServiceServer) mustEmbedUnimplementedLegacyArtifactStagingServiceServer() {
}

// UnsafeLegacyArtifactStagingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LegacyArtifactStagingServiceServer will
// result in compilation errors.
type UnsafeLegacyArtifactStagingServiceServer interface {
	mustEmbedUnimplementedLegacyArtifactStagingServiceServer()
}

func RegisterLegacyArtifactStagingServiceServer(s grpc.ServiceRegistrar, srv LegacyArtifactStagingServiceServer) {
	s.RegisterService(&LegacyArtifactStagingService_ServiceDesc, srv)
}

func _LegacyArtifactStagingService_PutArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LegacyArtifactStagingServiceServer).PutArtifact(&legacyArtifactStagingServicePutArtifactServer{stream})
}

type LegacyArtifactStagingService_PutArtifactServer interface {
	SendAndClose(*PutArtifactResponse) error
	Recv() (*PutArtifactRequest, error)
	grpc.ServerStream
}

type legacyArtifactStagingServicePutArtifactServer struct {
	grpc.ServerStream
}

func (x *legacyArtifactStagingServicePutArtifactServer) SendAndClose(m *PutArtifactResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *legacyArtifactStagingServicePutArtifactServer) Recv() (*PutArtifactRequest, error) {
	m := new(PutArtifactRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _LegacyArtifactStagingService_CommitManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LegacyArtifactStagingServiceServer).CommitManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.LegacyArtifactStagingService/CommitManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LegacyArtifactStagingServiceServer).CommitManifest(ctx, req.(*CommitManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LegacyArtifactStagingService_ServiceDesc is the grpc.ServiceDesc for LegacyArtifactStagingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LegacyArtifactStagingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.LegacyArtifactStagingService",
	HandlerType: (*LegacyArtifactStagingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitManifest",
			Handler:    _LegacyArtifactStagingService_CommitManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PutArtifact",
			Handler:       _LegacyArtifactStagingService_PutArtifact_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/job_management/v1/beam_artifact_api.proto",
}

// LegacyArtifactRetrievalServiceClient is the client API for LegacyArtifactRetrievalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LegacyArtifactRetrievalServiceClient interface {
	// Get the manifest for the job
	GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(ctx context.Context, in *LegacyGetArtifactRequest, opts ...grpc.CallOption) (LegacyArtifactRetrievalService_GetArtifactClient, error)
}

type legacyArtifactRetrievalServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLegacyArtifactRetrievalServiceClient(cc grpc.ClientConnInterface) LegacyArtifactRetrievalServiceClient {
	return &legacyArtifactRetrievalServiceClient{cc}
}

func (c *legacyArtifactRetrievalServiceClient) GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error) {
	out := new(GetManifestResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService/GetManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *legacyArtifactRetrievalServiceClient) GetArtifact(ctx context.Context, in *LegacyGetArtifactRequest, opts ...grpc.CallOption) (LegacyArtifactRetrievalService_GetArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &LegacyArtifactRetrievalService_ServiceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService/GetArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &legacyArtifactRetrievalServiceGetArtifactClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type LegacyArtifactRetrievalService_GetArtifactClient interface {
	Recv() (*ArtifactChunk, error)
	grpc.ClientStream
}

type legacyArtifactRetrievalServiceGetArtifactClient struct {
	grpc.ClientStream
}

func (x *legacyArtifactRetrievalServiceGetArtifactClient) Recv() (*ArtifactChunk, error) {
	m := new(ArtifactChunk)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// LegacyArtifactRetrievalServiceServer is the server API for LegacyArtifactRetrievalService service.
// All implementations must embed UnimplementedLegacyArtifactRetrievalServiceServer
// for forward compatibility
type LegacyArtifactRetrievalServiceServer interface {
	// Get the manifest for the job
	GetManifest(context.Context, *GetManifestRequest) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(*LegacyGetArtifactRequest, LegacyArtifactRetrievalService_GetArtifactServer) error
	mustEmbedUnimplementedLegacyArtifactRetrievalServiceServer()
}

// UnimplementedLegacyArtifactRetrievalServiceServer must be embedded to have forward compatible implementations.
type UnimplementedLegacyArtifactRetrievalServiceServer struct {
}

func (UnimplementedLegacyArtifactRetrievalServiceServer) GetManifest(context.Context, *GetManifestRequest) (*GetManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManifest not implemented")
}
func (UnimplementedLegacyArtifactRetrievalServiceServer) GetArtifact(*LegacyGetArtifactRequest, LegacyArtifactRetrievalService_GetArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}
func (UnimplementedLegacyArtifactRetrievalServiceServer) mustEmbedUnimplementedLegacyArtifactRetrievalServiceServer() {
}

// UnsafeLegacyArtifactRetrievalServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LegacyArtifactRetrievalServiceServer will
// result in compilation errors.
type UnsafeLegacyArtifactRetrievalServiceServer interface {
	mustEmbedUnimplementedLegacyArtifactRetrievalServiceServer()
}

func RegisterLegacyArtifactRetrievalServiceServer(s grpc.ServiceRegistrar, srv LegacyArtifactRetrievalServiceServer) {
	s.RegisterService(&LegacyArtifactRetrievalService_ServiceDesc, srv)
}

func _LegacyArtifactRetrievalService_GetManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LegacyArtifactRetrievalServiceServer).GetManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService/GetManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LegacyArtifactRetrievalServiceServer).GetManifest(ctx, req.(*GetManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LegacyArtifactRetrievalService_GetArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LegacyGetArtifactRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LegacyArtifactRetrievalServiceServer).GetArtifact(m, &legacyArtifactRetrievalServiceGetArtifactServer{stream})
}

type LegacyArtifactRetrievalService_GetArtifactServer interface {
	Send(*ArtifactChunk) error
	grpc.ServerStream
}

type legacyArtifactRetrievalServiceGetArtifactServer struct {
	grpc.ServerStream
}

func (x *legacyArtifactRetrievalServiceGetArtifactServer) Send(m *ArtifactChunk) error {
	return x.ServerStream.SendMsg(m)
}

// LegacyArtifactRetrievalService_ServiceDesc is the grpc.ServiceDesc for LegacyArtifactRetrievalService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LegacyArtifactRetrievalService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService",
	HandlerType: (*LegacyArtifactRetrievalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetManifest",
			Handler:    _LegacyArtifactRetrievalService_GetManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetArtifact",
			Handler:       _LegacyArtifactRetrievalService_GetArtifact_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/job_management/v1/beam_artifact_api.proto",
}
