"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Protocol Buffers describing the Artifact API, for communicating with a runner
for artifact staging and retrieval over GRPC.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import org.apache.beam.model.pipeline.v1.beam_runner_api_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ResolveArtifactsRequest(google.protobuf.message.Message):
    """A request for artifact resolution."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARTIFACTS_FIELD_NUMBER: builtins.int
    PREFERRED_URNS_FIELD_NUMBER: builtins.int
    @property
    def artifacts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.ArtifactInformation]:
        """An (ordered) set of artifacts to (jointly) resolve."""
    @property
    def preferred_urns(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A set of artifact type urns that are understood by the requester.
        An attempt should be made to resolve the artifacts in terms of these URNs,
        but other URNs may be used as well with the understanding that they must
        be fetch-able as bytes via GetArtifact.
        """
    def __init__(
        self,
        *,
        artifacts: collections.abc.Iterable[org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.ArtifactInformation] | None = ...,
        preferred_urns: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifacts", b"artifacts", "preferred_urns", b"preferred_urns"]) -> None: ...

global___ResolveArtifactsRequest = ResolveArtifactsRequest

@typing_extensions.final
class ResolveArtifactsResponse(google.protobuf.message.Message):
    """A response for artifact resolution."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPLACEMENTS_FIELD_NUMBER: builtins.int
    @property
    def replacements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.ArtifactInformation]:
        """A full (ordered) set of replacements for the set of requested artifacts,
        preferably in terms of the requested type URNs.  If there is no better
        resolution, the original list is returned.
        """
    def __init__(
        self,
        *,
        replacements: collections.abc.Iterable[org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.ArtifactInformation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["replacements", b"replacements"]) -> None: ...

global___ResolveArtifactsResponse = ResolveArtifactsResponse

@typing_extensions.final
class GetArtifactRequest(google.protobuf.message.Message):
    """A request to get an artifact."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARTIFACT_FIELD_NUMBER: builtins.int
    @property
    def artifact(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.ArtifactInformation: ...
    def __init__(
        self,
        *,
        artifact: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.ArtifactInformation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["artifact", b"artifact"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact", b"artifact"]) -> None: ...

global___GetArtifactRequest = GetArtifactRequest

@typing_extensions.final
class GetArtifactResponse(google.protobuf.message.Message):
    """Part of a response to getting an artifact."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    def __init__(
        self,
        *,
        data: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___GetArtifactResponse = GetArtifactResponse

@typing_extensions.final
class ArtifactRequestWrapper(google.protobuf.message.Message):
    """Wraps an ArtifactRetrievalService request for use in ReverseArtifactRetrievalService."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOLVE_ARTIFACT_FIELD_NUMBER: builtins.int
    GET_ARTIFACT_FIELD_NUMBER: builtins.int
    @property
    def resolve_artifact(self) -> global___ResolveArtifactsRequest: ...
    @property
    def get_artifact(self) -> global___GetArtifactRequest: ...
    def __init__(
        self,
        *,
        resolve_artifact: global___ResolveArtifactsRequest | None = ...,
        get_artifact: global___GetArtifactRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["get_artifact", b"get_artifact", "request", b"request", "resolve_artifact", b"resolve_artifact"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["get_artifact", b"get_artifact", "request", b"request", "resolve_artifact", b"resolve_artifact"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["request", b"request"]) -> typing_extensions.Literal["resolve_artifact", "get_artifact"] | None: ...

global___ArtifactRequestWrapper = ArtifactRequestWrapper

@typing_extensions.final
class ArtifactResponseWrapper(google.protobuf.message.Message):
    """Wraps an ArtifactRetrievalService response for use in ReverseArtifactRetrievalService."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STAGING_TOKEN_FIELD_NUMBER: builtins.int
    IS_LAST_FIELD_NUMBER: builtins.int
    RESOLVE_ARTIFACT_RESPONSE_FIELD_NUMBER: builtins.int
    GET_ARTIFACT_RESPONSE_FIELD_NUMBER: builtins.int
    staging_token: builtins.str
    """A token indicating which job these artifacts are being staged for."""
    is_last: builtins.bool
    """Whether this is the last response for this request (for those responses that
    would typically be terminated by the end of the response stream.)
    """
    @property
    def resolve_artifact_response(self) -> global___ResolveArtifactsResponse: ...
    @property
    def get_artifact_response(self) -> global___GetArtifactResponse: ...
    def __init__(
        self,
        *,
        staging_token: builtins.str | None = ...,
        is_last: builtins.bool | None = ...,
        resolve_artifact_response: global___ResolveArtifactsResponse | None = ...,
        get_artifact_response: global___GetArtifactResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["get_artifact_response", b"get_artifact_response", "resolve_artifact_response", b"resolve_artifact_response", "response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["get_artifact_response", b"get_artifact_response", "is_last", b"is_last", "resolve_artifact_response", b"resolve_artifact_response", "response", b"response", "staging_token", b"staging_token"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["response", b"response"]) -> typing_extensions.Literal["resolve_artifact_response", "get_artifact_response"] | None: ...

global___ArtifactResponseWrapper = ArtifactResponseWrapper

@typing_extensions.final
class ArtifactMetadata(google.protobuf.message.Message):
    """An artifact identifier and associated metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    SHA256_FIELD_NUMBER: builtins.int
    name: builtins.str
    """(Required) The name of the artifact."""
    permissions: builtins.int
    """(Optional) The Unix-like permissions of the artifact"""
    sha256: builtins.str
    """(Optional) The hex-encoded sha256 checksum of the artifact. Used, among other things, by
    harness boot code to validate the integrity of the artifact.
    """
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        permissions: builtins.int | None = ...,
        sha256: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "permissions", b"permissions", "sha256", b"sha256"]) -> None: ...

global___ArtifactMetadata = ArtifactMetadata

@typing_extensions.final
class Manifest(google.protobuf.message.Message):
    """A collection of artifacts."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARTIFACT_FIELD_NUMBER: builtins.int
    @property
    def artifact(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ArtifactMetadata]: ...
    def __init__(
        self,
        *,
        artifact: collections.abc.Iterable[global___ArtifactMetadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact", b"artifact"]) -> None: ...

global___Manifest = Manifest

@typing_extensions.final
class ProxyManifest(google.protobuf.message.Message):
    """A manifest with location information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Location(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        URI_FIELD_NUMBER: builtins.int
        name: builtins.str
        uri: builtins.str
        def __init__(
            self,
            *,
            name: builtins.str | None = ...,
            uri: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "uri", b"uri"]) -> None: ...

    MANIFEST_FIELD_NUMBER: builtins.int
    LOCATION_FIELD_NUMBER: builtins.int
    @property
    def manifest(self) -> global___Manifest: ...
    @property
    def location(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProxyManifest.Location]: ...
    def __init__(
        self,
        *,
        manifest: global___Manifest | None = ...,
        location: collections.abc.Iterable[global___ProxyManifest.Location] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["manifest", b"manifest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["location", b"location", "manifest", b"manifest"]) -> None: ...

global___ProxyManifest = ProxyManifest

@typing_extensions.final
class GetManifestRequest(google.protobuf.message.Message):
    """A request to get the manifest of a Job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RETRIEVAL_TOKEN_FIELD_NUMBER: builtins.int
    retrieval_token: builtins.str
    """(Required) An opaque token representing the entirety of the staged artifacts.
    Returned in CommitManifestResponse.
    """
    def __init__(
        self,
        *,
        retrieval_token: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["retrieval_token", b"retrieval_token"]) -> None: ...

global___GetManifestRequest = GetManifestRequest

@typing_extensions.final
class GetManifestResponse(google.protobuf.message.Message):
    """A response containing a job manifest."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MANIFEST_FIELD_NUMBER: builtins.int
    @property
    def manifest(self) -> global___Manifest: ...
    def __init__(
        self,
        *,
        manifest: global___Manifest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["manifest", b"manifest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["manifest", b"manifest"]) -> None: ...

global___GetManifestResponse = GetManifestResponse

@typing_extensions.final
class LegacyGetArtifactRequest(google.protobuf.message.Message):
    """A request to get an artifact. The artifact must be present in the manifest for the job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    RETRIEVAL_TOKEN_FIELD_NUMBER: builtins.int
    name: builtins.str
    """(Required) The name of the artifact to retrieve."""
    retrieval_token: builtins.str
    """(Required) An opaque token representing the entirety of the staged artifacts.
    Returned in CommitManifestResponse.
    """
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        retrieval_token: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "retrieval_token", b"retrieval_token"]) -> None: ...

global___LegacyGetArtifactRequest = LegacyGetArtifactRequest

@typing_extensions.final
class ArtifactChunk(google.protobuf.message.Message):
    """Part of an artifact."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    def __init__(
        self,
        *,
        data: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___ArtifactChunk = ArtifactChunk

@typing_extensions.final
class PutArtifactMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STAGING_SESSION_TOKEN_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    staging_session_token: builtins.str
    """(Required) A token for artifact staging session. This token can be obtained
    from PrepareJob request in JobService
    """
    @property
    def metadata(self) -> global___ArtifactMetadata:
        """(Required) The Artifact metadata."""
    def __init__(
        self,
        *,
        staging_session_token: builtins.str | None = ...,
        metadata: global___ArtifactMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "staging_session_token", b"staging_session_token"]) -> None: ...

global___PutArtifactMetadata = PutArtifactMetadata

@typing_extensions.final
class PutArtifactRequest(google.protobuf.message.Message):
    """A request to stage an artifact."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> global___PutArtifactMetadata:
        """The first message in a PutArtifact call must contain this field."""
    @property
    def data(self) -> global___ArtifactChunk:
        """A chunk of the artifact. All messages after the first in a PutArtifact call must contain a
        chunk.
        """
    def __init__(
        self,
        *,
        metadata: global___PutArtifactMetadata | None = ...,
        data: global___ArtifactChunk | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["content", b"content", "data", b"data", "metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "data", b"data", "metadata", b"metadata"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["content", b"content"]) -> typing_extensions.Literal["metadata", "data"] | None: ...

global___PutArtifactRequest = PutArtifactRequest

@typing_extensions.final
class PutArtifactResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PutArtifactResponse = PutArtifactResponse

@typing_extensions.final
class CommitManifestRequest(google.protobuf.message.Message):
    """A request to commit the manifest for a Job. All artifacts must have been successfully uploaded
    before this call is made.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MANIFEST_FIELD_NUMBER: builtins.int
    STAGING_SESSION_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def manifest(self) -> global___Manifest:
        """(Required) The manifest to commit."""
    staging_session_token: builtins.str
    """(Required) A token for artifact staging session. This token can be obtained
    from PrepareJob request in JobService
    """
    def __init__(
        self,
        *,
        manifest: global___Manifest | None = ...,
        staging_session_token: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["manifest", b"manifest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["manifest", b"manifest", "staging_session_token", b"staging_session_token"]) -> None: ...

global___CommitManifestRequest = CommitManifestRequest

@typing_extensions.final
class CommitManifestResponse(google.protobuf.message.Message):
    """The result of committing a manifest."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Constants:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ConstantsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CommitManifestResponse._Constants.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_ARTIFACTS_STAGED_TOKEN: CommitManifestResponse._Constants.ValueType  # 0
        """Token indicating that no artifacts were staged and therefore no retrieval attempt is necessary."""

    class Constants(_Constants, metaclass=_ConstantsEnumTypeWrapper): ...
    NO_ARTIFACTS_STAGED_TOKEN: CommitManifestResponse.Constants.ValueType  # 0
    """Token indicating that no artifacts were staged and therefore no retrieval attempt is necessary."""

    RETRIEVAL_TOKEN_FIELD_NUMBER: builtins.int
    retrieval_token: builtins.str
    """(Required) An opaque token representing the entirety of the staged artifacts.
    This can be used to retrieve the manifest and artifacts from an associated
    LegacyArtifactRetrievalService.
    """
    def __init__(
        self,
        *,
        retrieval_token: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["retrieval_token", b"retrieval_token"]) -> None: ...

global___CommitManifestResponse = CommitManifestResponse
