/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import com.google.common.io.ByteStreams;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.grpc.AvroGrpcUtils;
import org.apache.avro.grpc.AvroInputStream;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;

public class AvroResponseMarshaller
implements MethodDescriptor.Marshaller<Object> {
    private static final EncoderFactory ENCODER_FACTORY = new EncoderFactory();
    private static final DecoderFactory DECODER_FACTORY = new DecoderFactory();
    private final Protocol.Message message;

    public AvroResponseMarshaller(Protocol.Message message) {
        this.message = message;
    }

    public InputStream stream(Object value) {
        return new AvroResponseInputStream(value, this.message);
    }

    public Object parse(InputStream stream) {
        try {
            if (this.message.isOneWay()) {
                Object var2_2 = null;
                return var2_2;
            }
            BinaryDecoder in = DECODER_FACTORY.binaryDecoder(stream, null);
            if (!in.readBoolean()) {
                Object response;
                Object object = response = new SpecificDatumReader(this.message.getResponse()).read(null, (Decoder)in);
                return object;
            }
            Object value = new SpecificDatumReader(this.message.getErrors()).read(null, (Decoder)in);
            if (value instanceof Exception) {
                Object object = value;
                return object;
            }
            AvroRuntimeException avroRuntimeException = new AvroRuntimeException(value.toString());
            return avroRuntimeException;
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription("Error deserializing avro response").asRuntimeException();
        }
        finally {
            AvroGrpcUtils.skipAndCloseQuietly(stream);
        }
    }

    private static class AvroResponseInputStream
    extends AvroInputStream {
        private final Protocol.Message message;
        private Object response;

        AvroResponseInputStream(Object response, Protocol.Message message) {
            this.response = response;
            this.message = message;
        }

        public int drainTo(OutputStream target) throws IOException {
            int written = this.getPartial() != null ? (int)ByteStreams.copy((InputStream)this.getPartial(), (OutputStream)target) : this.writeResponse(target);
            return written;
        }

        private int writeResponse(OutputStream target) throws IOException {
            int written;
            if (this.message.isOneWay()) {
                written = 0;
            } else if (this.response instanceof Exception) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                BinaryEncoder out = ENCODER_FACTORY.binaryEncoder((OutputStream)bao, null);
                try {
                    out.writeBoolean(true);
                    new SpecificDatumWriter(this.message.getErrors()).write(this.response, (Encoder)out);
                }
                catch (Exception e) {
                    bao = new ByteArrayOutputStream();
                    out = ENCODER_FACTORY.binaryEncoder((OutputStream)bao, null);
                    out.writeBoolean(true);
                    new SpecificDatumWriter(Protocol.SYSTEM_ERRORS).write((Object)new Utf8(e.toString()), (Encoder)out);
                }
                out.flush();
                byte[] serializedError = bao.toByteArray();
                target.write(serializedError);
                written = serializedError.length;
            } else {
                AvroInputStream.CountingOutputStream outputStream = new AvroInputStream.CountingOutputStream(target);
                BinaryEncoder out = ENCODER_FACTORY.binaryEncoder((OutputStream)outputStream, null);
                out.writeBoolean(false);
                new SpecificDatumWriter(this.message.getResponse()).write(this.response, (Encoder)out);
                out.flush();
                written = outputStream.getWrittenCount();
            }
            this.response = null;
            return written;
        }
    }
}

